/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.ScaleHeight;
import net.sourceforge.plantuml.ScaleWidth;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;

public class CommandScaleWidthOrHeight
extends SingleLineCommand2<AbstractPSystem> {
    public CommandScaleWidthOrHeight() {
        super(CommandScaleWidthOrHeight.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandScaleWidthOrHeight.class.getName(), RegexLeaf.start(), new RegexLeaf("scale"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("VALUE", "([0-9.]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("WIDTH", "(width|height)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractPSystem diagram, LineLocation location, RegexResult arg) {
        double size = Double.parseDouble(arg.get("VALUE", 0));
        boolean width = "width".equalsIgnoreCase(arg.get("WIDTH", 0));
        if (width) {
            diagram.setScale(new ScaleWidth(size));
        } else {
            diagram.setScale(new ScaleHeight(size));
        }
        return CommandExecutionResult.ok();
    }
}

