/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.prefix.PrefixMapperTable;
import org.protege.editor.owl.ui.prefix.PrefixMapperTables;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;

public class RemovePrefixMappingAction
extends AbstractAction {
    private static final long serialVersionUID = 5507854297099664212L;
    private PrefixMapperTables tables;
    private PrefixMapperTable table;
    private ListSelectionListener tableSelectionListener = e -> this.updateEnabled();
    private PrefixMapperTables.SelectedOntologyListener ontologySelectionListener = new PrefixMapperTables.SelectedOntologyListener(){

        @Override
        public void selectedOntologyChanged() {
            RemovePrefixMappingAction.this.updateEnabled();
            if (RemovePrefixMappingAction.this.table != null) {
                RemovePrefixMappingAction.this.table.getSelectionModel().removeListSelectionListener(RemovePrefixMappingAction.this.tableSelectionListener);
            }
            RemovePrefixMappingAction.this.table = RemovePrefixMappingAction.this.tables.getPrefixMapperTable();
            if (RemovePrefixMappingAction.this.table != null) {
                RemovePrefixMappingAction.this.table.getSelectionModel().addListSelectionListener(RemovePrefixMappingAction.this.tableSelectionListener);
            }
        }
    };

    public RemovePrefixMappingAction(PrefixMapperTables tables) {
        super("Remove prefix", OWLIcons.getIcon("prefix.remove.png"));
        this.tables = tables;
        this.table = tables.getPrefixMapperTable();
        this.table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        this.updateEnabled();
        tables.addListener(this.ontologySelectionListener);
    }

    private void updateEnabled() {
        PrefixMapperTable table = this.tables.getPrefixMapperTable();
        if (table == null) {
            this.setEnabled(false);
            return;
        }
        int row = table.getSelectedRow();
        if (row == -1) {
            this.setEnabled(false);
            return;
        }
        String prefix = (String)table.getModel().getValueAt(row, 0);
        this.setEnabled(!PrefixUtilities.isStandardPrefix(prefix));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrefixMapperTable table = this.tables.getPrefixMapperTable();
        int[] selIndexes = table.getSelectedRows();
        ArrayList<String> prefixesToRemove = new ArrayList<String>();
        for (int selIndex : selIndexes) {
            prefixesToRemove.add(table.getModel().getValueAt(selIndex, 0).toString());
        }
        Object object = prefixesToRemove.iterator();
        while (object.hasNext()) {
            String prefix = (String)object.next();
            table.getModel().removeMapping(prefix);
        }
    }
}

