/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.PageTool;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.SolrVelocityResourceLoader;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.generic.CollectionTool;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.DisplayTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.LocaleConfig;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.ResourceTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityResponseWriter
implements QueryResponseWriter,
SolrCoreAware {
    public static final String TEMPLATE_BASE_DIR = "template.base.dir";
    public static final String PROPERTIES_FILE = "init.properties.file";
    public static final String SOLR_RESOURCE_LOADER_ENABLED = "velocity.resourceloader.solr.enabled";
    public static final String TEMPLATE = "v.template";
    public static final String LAYOUT = "v.layout";
    public static final String LAYOUT_ENABLED = "v.layout.enabled";
    public static final String CONTENT_TYPE = "v.contentType";
    public static final String JSON = "v.json";
    public static final String LOCALE = "v.locale";
    public static final String TEMPLATE_EXTENSION = ".vm";
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String JSON_CONTENT_TYPE = "application/json;charset=UTF-8";
    private File fileResourceLoaderBaseDir;
    private String initPropertiesFileName;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Properties velocityInitProps = new Properties();
    private Map<String, String> customTools = new HashMap<String, String>();
    private static final AccessControlContext VELOCITY_SANDBOX;

    public void init(NamedList args) {
        log.warn("VelocityResponseWriter is deprecated. This may be removed in future Solr releases. Please SOLR-14065.");
        this.fileResourceLoaderBaseDir = null;
        String templateBaseDir = (String)args.get(TEMPLATE_BASE_DIR);
        if (templateBaseDir != null && !templateBaseDir.isEmpty()) {
            this.fileResourceLoaderBaseDir = new File(templateBaseDir).getAbsoluteFile();
            if (!this.fileResourceLoaderBaseDir.exists()) {
                log.warn("{} specified does not exist: {}", (Object)TEMPLATE_BASE_DIR, (Object)this.fileResourceLoaderBaseDir);
                this.fileResourceLoaderBaseDir = null;
            } else if (!this.fileResourceLoaderBaseDir.isDirectory()) {
                log.warn("{} specified is not a directory: {}", (Object)TEMPLATE_BASE_DIR, (Object)this.fileResourceLoaderBaseDir);
                this.fileResourceLoaderBaseDir = null;
            }
        }
        this.initPropertiesFileName = (String)args.get(PROPERTIES_FILE);
        NamedList tools = (NamedList)args.get("tools");
        if (tools != null) {
            for (Object t : tools) {
                Map.Entry tool = (Map.Entry)t;
                this.customTools.put(tool.getKey().toString(), tool.getValue().toString());
            }
        }
    }

    public void inform(SolrCore core) {
        if (this.initPropertiesFileName != null) {
            Object is = null;
            try {
                this.velocityInitProps.load(new InputStreamReader(core.getResourceLoader().openResource(this.initPropertiesFileName), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.warn("Error loading {} specified property file: {}", new Object[]{PROPERTIES_FILE, this.initPropertiesFileName, e});
            }
        }
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        String contentType = request.getParams().get(CONTENT_TYPE);
        return contentType != null ? contentType : (request.getParams().get(JSON) == null ? DEFAULT_CONTENT_TYPE : JSON_CONTENT_TYPE);
    }

    public void write(final Writer writer, final SolrQueryRequest request, final SolrQueryResponse response) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    VelocityResponseWriter.this.doWrite(writer, request, response);
                    return null;
                }
            }, VELOCITY_SANDBOX);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private void doWrite(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        boolean wrapResponse;
        VelocityEngine engine = this.createEngine(request);
        Template template = this.getTemplate(engine, request);
        VelocityContext context = this.createContext(request, response);
        context.put("engine", (Object)engine);
        String layoutTemplate = request.getParams().get(LAYOUT);
        boolean layoutEnabled = request.getParams().getBool(LAYOUT_ENABLED, true) && layoutTemplate != null;
        String jsonWrapper = request.getParams().get(JSON);
        boolean bl = wrapResponse = layoutEnabled || jsonWrapper != null;
        if (!wrapResponse) {
            template.merge((Context)context, writer);
        } else {
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)context, (Writer)stringWriter);
            if (layoutEnabled) {
                context.put("content", (Object)stringWriter.toString());
                stringWriter = new StringWriter();
                try {
                    engine.getTemplate(layoutTemplate + TEMPLATE_EXTENSION).merge((Context)context, (Writer)stringWriter);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (jsonWrapper != null) {
                for (int i = 0; i < jsonWrapper.length(); ++i) {
                    if (Character.isJavaIdentifierPart(jsonWrapper.charAt(i))) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid function name for v.json: '" + jsonWrapper + "'");
                }
                writer.write(jsonWrapper + "(");
                writer.write(this.getJSONWrap(stringWriter.toString()));
                writer.write(41);
            } else {
                writer.write(stringWriter.toString());
            }
        }
    }

    private VelocityContext createContext(SolrQueryRequest request, SolrQueryResponse response) {
        VelocityContext context = new VelocityContext();
        String locale = request.getParams().get(LOCALE);
        HashMap<String, String> toolConfig = new HashMap<String, String>();
        toolConfig.put("locale", locale);
        context.put("log", (Object)log);
        context.put("esc", (Object)new EscapeTool());
        context.put("date", (Object)new ComparisonDateTool());
        context.put("sort", (Object)new CollectionTool());
        MathTool mathTool = new MathTool();
        mathTool.configure(toolConfig);
        context.put("math", (Object)mathTool);
        NumberTool numberTool = new NumberTool();
        numberTool.configure(toolConfig);
        context.put("number", (Object)numberTool);
        DisplayTool displayTool = new DisplayTool();
        displayTool.configure(toolConfig);
        context.put("display", (Object)displayTool);
        SolrVelocityResourceTool resourceTool = new SolrVelocityResourceTool(request.getCore().getSolrConfig().getResourceLoader().getClassLoader());
        resourceTool.configure(toolConfig);
        context.put("resource", (Object)resourceTool);
        if (request.getCore().getCoreDescriptor().isConfigSetTrusted() && request.getCore().getCoreDescriptor().isConfigSetTrusted()) {
            for (Map.Entry<String, String> entry : this.customTools.entrySet()) {
                String name = entry.getKey();
                Object customTool = SolrCore.createInstance((String)entry.getValue(), Object.class, (String)("VrW custom tool: " + name), (SolrCore)request.getCore(), (ResourceLoader)request.getCore().getResourceLoader());
                if (customTool instanceof LocaleConfig) {
                    ((LocaleConfig)customTool).configure(toolConfig);
                }
                context.put(name, customTool);
            }
        }
        QueryResponse rsp = new QueryResponse();
        NamedList parsedResponse = BinaryResponseWriter.getParsedResponse((SolrQueryRequest)request, (SolrQueryResponse)response);
        try {
            rsp.setResponse(parsedResponse);
            context.put("page", (Object)new PageTool(request, response));
            context.put("debug", (Object)rsp.getDebugMap());
        }
        catch (ClassCastException e) {
            rsp = new SolrResponseBase();
            rsp.setResponse(parsedResponse);
        }
        context.put("request", (Object)request);
        context.put("response", (Object)rsp);
        return context;
    }

    private VelocityEngine createEngine(SolrQueryRequest request) {
        boolean trustedMode = request.getCore().getCoreDescriptor().isConfigSetTrusted();
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("velocimacro.library", (Object)"_macros.vm,VM_global_library.vm,macros.vm");
        engine.setProperty("velocimacro.library.autoreload", (Object)"true");
        ArrayList<String> loaders = new ArrayList<String>();
        if (this.fileResourceLoaderBaseDir != null && trustedMode) {
            loaders.add("file");
            engine.setProperty("file.resource.loader.path", (Object)this.fileResourceLoaderBaseDir.getAbsolutePath());
        }
        if (trustedMode) {
            loaders.add("solr");
            engine.setProperty("solr.resource.loader.instance", (Object)new SolrVelocityResourceLoader(request.getCore().getSolrConfig().getResourceLoader()));
        }
        loaders.add("builtin");
        engine.setProperty("builtin.resource.loader.instance", (Object)new ClasspathResourceLoader());
        engine.setProperty("resource.loader", (Object)String.join((CharSequence)",", loaders));
        engine.setProperty("input.encoding", (Object)"UTF-8");
        engine.setProperty("space.gobbling", (Object)RuntimeConstants.SpaceGobbling.LINES.toString());
        engine.setProperty("runtime.introspector.uberspect", (Object)"org.apache.velocity.util.introspection.SecureUberspector");
        engine.addProperty("introspector.restrict.packages", (Object)"java.lang.reflect");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Class");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.ClassLoader");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Compiler");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.InheritableThreadLocal");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Package");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Process");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Runtime");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.RuntimePermission");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.SecurityManager");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.System");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.Thread");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.ThreadGroup");
        engine.addProperty("introspector.restrict.classes", (Object)"java.lang.ThreadLocal");
        engine.addProperty("introspector.restrict.classes", (Object)"org.apache.solr.core.SolrResourceLoader");
        engine.addProperty("introspector.restrict.classes", (Object)"org.apache.solr.core.CoreContainer");
        if (trustedMode) {
            Object spaceGobblingInitProperty = this.velocityInitProps.get("space.gobbling");
            if (spaceGobblingInitProperty != null) {
                this.velocityInitProps.put("space.gobbling", String.valueOf(spaceGobblingInitProperty).toUpperCase(Locale.ROOT));
            }
            engine.setProperties(this.velocityInitProps);
        }
        engine.init();
        return engine;
    }

    private Template getTemplate(VelocityEngine engine, SolrQueryRequest request) throws IOException {
        Template template;
        String templateName = request.getParams().get(TEMPLATE);
        String qt = request.getParams().get("qt");
        String path = (String)request.getContext().get("path");
        if (templateName == null && path != null) {
            templateName = path;
        }
        if (templateName == null && qt != null) {
            templateName = qt;
        }
        if (templateName == null) {
            templateName = "index";
        }
        try {
            template = engine.getTemplate(templateName + TEMPLATE_EXTENSION);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return template;
    }

    private String getJSONWrap(String xmlResult) {
        String replace1 = xmlResult.replaceAll("\\\\", "\\\\\\\\");
        replace1 = replace1.replaceAll("\\n", "\\\\n");
        replace1 = replace1.replaceAll("\\r", "\\\\r");
        String replaced = replace1.replaceAll("\"", "\\\\\"");
        return "{\"result\":\"" + replaced + "\"}";
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new FilePermission("<<ALL FILES>>", "read,readlink"));
        permissions.add(new PropertyPermission("jetty.testMode", "read"));
        permissions.add(new PropertyPermission("solr.allow.unsafe.resourceloading", "read"));
        permissions.add(new PropertyPermission("java.version", "read"));
        permissions.add(new RuntimePermission("accessDeclaredMembers"));
        permissions.setReadOnly();
        VELOCITY_SANDBOX = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static class SolrVelocityResourceTool
    extends ResourceTool {
        private ClassLoader solrClassLoader;

        public SolrVelocityResourceTool(ClassLoader cl) {
            this.solrClassLoader = cl;
        }

        protected ResourceBundle getBundle(String baseName, Object loc) {
            return ResourceBundle.getBundle("velocity." + baseName, loc == null ? this.getLocale() : this.toLocale(loc), this.solrClassLoader);
        }
    }
}

