/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.carrot2.util.StringUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="parameterized-url-resource")
public class URLResourceWithParams
implements IResource {
    private URL url;
    @Attribute(name="url")
    private String info;

    URLResourceWithParams() {
    }

    public URLResourceWithParams(URL url) {
        this.url = url;
        this.info = url.toExternalForm();
    }

    @Override
    public InputStream open() throws IOException {
        return this.url.openStream();
    }

    public InputStream open(Map<String, Object> attributes) throws IOException {
        String urlString = this.url.toExternalForm();
        urlString = URLResourceWithParams.substituteAttributes(urlString, attributes);
        return new URL(urlString).openStream();
    }

    public static String substituteAttributes(String parameterizedURL, Map<String, Object> attributes) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Pattern pattern = Pattern.compile(URLResourceWithParams.formatAttributePlaceholder(entry.getKey()), 16);
            parameterizedURL = pattern.matcher(parameterizedURL).replaceAll(StringUtils.urlEncodeWrapException(entry.getValue().toString(), "UTF-8"));
        }
        return parameterizedURL;
    }

    public static boolean containsAttributePlaceholder(String urlTemplate, String attributePlaceholderName) {
        return urlTemplate.contains(URLResourceWithParams.formatAttributePlaceholder(attributePlaceholderName));
    }

    public static String formatAttributePlaceholder(String attributePlaceholderName) {
        return "${" + attributePlaceholderName + "}";
    }

    public String toString() {
        return this.info;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URLResourceWithParams) {
            return ((URLResourceWithParams)obj).info.equals(this.info);
        }
        return false;
    }

    public final int hashCode() {
        return this.info.hashCode();
    }

    public URL getUrl() {
        return this.url;
    }

    @Commit
    void afterDeserialization() throws MalformedURLException {
        this.url = new URL(this.info);
    }

    public static URLResourceWithParams valueOf(String string) {
        try {
            return new URLResourceWithParams(new URL(string));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

