/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.VoidParameter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    private static Preferences root = Preferences.userRoot().node("TigerVNC");
    static LogWriter vlog = new LogWriter("UserPreferences");

    public static void set(String string, String string2, String string3) {
        Preferences preferences = root.node(string);
        preferences.put(string2, string3);
    }

    public static void set(String string, String string2, int n) {
        Preferences preferences = root.node(string);
        preferences.putInt(string2, n);
    }

    public static void set(String string, String string2, boolean bl) {
        Preferences preferences = root.node(string);
        preferences.putBoolean(string2, bl);
    }

    public static String get(String string, String string2) {
        Preferences preferences = root.node(string);
        VoidParameter voidParameter = Configuration.getParam(string2);
        if (voidParameter != null) {
            return preferences.get(string2, voidParameter.getDefaultStr());
        }
        return preferences.get(string2, null);
    }

    public static boolean getBool(String string, String string2, boolean bl) {
        Preferences preferences = root.node(string);
        VoidParameter voidParameter = Configuration.getParam(string2);
        if (voidParameter != null && voidParameter.isBool()) {
            return preferences.getBoolean(string2, voidParameter.getDefaultStr() == "1");
        }
        return preferences.getBoolean(string2, bl);
    }

    public static boolean getBool(String string, String string2) {
        return UserPreferences.getBool(string, string2, false);
    }

    public static int getInt(String string, String string2) {
        Preferences preferences = root.node(string);
        VoidParameter voidParameter = Configuration.getParam(string2);
        if (voidParameter != null && !voidParameter.isBool()) {
            return preferences.getInt(string2, Integer.parseInt(voidParameter.getDefaultStr()));
        }
        return -1;
    }

    public static void save() {
        try {
            root.sync();
            String[] stringArray = root.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                vlog.debug(stringArray[i] + " = " + root.get(stringArray[i], null), new Object[0]);
            }
        }
        catch (BackingStoreException backingStoreException) {
            vlog.error(backingStoreException.getMessage(), new Object[0]);
        }
    }

    public static void save(String string) {
        try {
            Preferences preferences = root.node(string);
            preferences.sync();
            String[] stringArray = root.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                vlog.debug(stringArray[i] + " = " + preferences.get(stringArray[i], null), new Object[0]);
            }
        }
        catch (BackingStoreException backingStoreException) {
            vlog.error(backingStoreException.getMessage(), new Object[0]);
        }
    }

    public static void clear() {
        try {
            root.clear();
            String[] stringArray = root.childrenNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Preferences preferences = root.node(stringArray[i]);
                preferences.removeNode();
            }
            root.sync();
        }
        catch (BackingStoreException backingStoreException) {
            vlog.error(backingStoreException.getMessage(), new Object[0]);
        }
    }

    public static void clear(String string) {
        try {
            Preferences preferences = root.node(string);
            preferences.clear();
            preferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            vlog.error(backingStoreException.getMessage(), new Object[0]);
        }
    }

    public static void load(String string) {
        try {
            Preferences preferences = root.node(string);
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                VoidParameter voidParameter = Configuration.getParam(string2);
                if (voidParameter == null) continue;
                String string3 = preferences.get(string2, null);
                if (string3 == null) {
                    string3 = voidParameter.getDefaultStr();
                }
                Configuration.setParam(string2, string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            vlog.error(backingStoreException.getMessage(), new Object[0]);
        }
    }
}

