#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2020 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_firewall_vip_realservers
short_description: Select the real servers that this server load balancing VIP will distribute traffic to.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.10"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    bypass_validation:
        description: only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    state:
        description: the directive to create, update or delete an object
        type: str
        required: true
        choices:
          - present
          - absent
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    vip:
        description: the parameter (vip) in requested url
        type: str
        required: true
    firewall_vip_realservers:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            client-ip:
                description: no description
                type: str
            healthcheck:
                type: str
                description: 'Enable to check the responsiveness of the real server before forwarding traffic.'
                choices:
                    - 'disable'
                    - 'enable'
                    - 'vip'
            holddown-interval:
                type: int
                description: 'Time in seconds that the health check monitor continues to monitor and unresponsive server that should be active.'
            http-host:
                type: str
                description: 'HTTP server domain name in HTTP header.'
            ip:
                type: str
                description: 'IP address of the real server.'
            max-connections:
                type: int
                description: 'Max number of active connections that can be directed to the real server. When reached, sessions are sent to other real servers.'
            monitor:
                type: str
                description: 'Name of the health check monitor to use when polling to determine a virtual servers connectivity status.'
            port:
                type: int
                description: 'Port for communicating with the real server. Required if port forwarding is enabled.'
            seq:
                type: int
                description: no description
            status:
                type: str
                description: 'Set the status of the real server to active so that it can accept traffic, or on standby or disabled so no traffic is sent.'
                choices:
                    - 'active'
                    - 'standby'
                    - 'disable'
            weight:
                type: int
                description: 'Weight of the real server. If weighted load balancing is enabled, the server with the highest weight gets more connections.'

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: Select the real servers that this server load balancing VIP will distribute traffic to.
      fmgr_firewall_vip_realservers:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         adom: <your own value>
         vip: <your own value>
         state: <value in [present, absent]>
         firewall_vip_realservers:
            client-ip: <value of string>
            healthcheck: <value in [disable, enable, vip]>
            holddown-interval: <value of integer>
            http-host: <value of string>
            ip: <value of string>
            max-connections: <value of integer>
            monitor: <value of string>
            port: <value of integer>
            seq: <value of integer>
            status: <value in [active, standby, disable]>
            weight: <value of integer>

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/realservers',
        '/pm/config/global/obj/firewall/vip/{vip}/realservers'
    ]

    perobject_jrpc_urls = [
        '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/realservers/{realservers}',
        '/pm/config/global/obj/firewall/vip/{vip}/realservers/{realservers}'
    ]

    url_params = ['adom', 'vip']
    module_primary_key = 'seq'
    module_arg_spec = {
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'state': {
            'type': 'str',
            'required': True,
            'choices': [
                'present',
                'absent'
            ]
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'vip': {
            'required': True,
            'type': 'str'
        },
        'firewall_vip_realservers': {
            'required': False,
            'type': 'dict',
            'options': {
                'client-ip': {
                    'required': False,
                    'type': 'str'
                },
                'healthcheck': {
                    'required': False,
                    'choices': [
                        'disable',
                        'enable',
                        'vip'
                    ],
                    'type': 'str'
                },
                'holddown-interval': {
                    'required': False,
                    'type': 'int'
                },
                'http-host': {
                    'required': False,
                    'type': 'str'
                },
                'ip': {
                    'required': False,
                    'type': 'str'
                },
                'max-connections': {
                    'required': False,
                    'type': 'int'
                },
                'monitor': {
                    'required': False,
                    'type': 'str'
                },
                'port': {
                    'required': False,
                    'type': 'int'
                },
                'seq': {
                    'required': True,
                    'type': 'int'
                },
                'status': {
                    'required': False,
                    'choices': [
                        'active',
                        'standby',
                        'disable'
                    ],
                    'type': 'str'
                },
                'weight': {
                    'required': False,
                    'type': 'int'
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'firewall_vip_realservers'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_curd()
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
