/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProgressUtils {
    private static final RunOffEDTProvider PROVIDER = ProgressUtils.getProvider();
    private static final int DISPLAY_DIALOG_MS = 9450;
    private static final int DISPLAY_WAIT_CURSOR_MS = 50;

    private ProgressUtils() {
    }

    private static RunOffEDTProvider getProvider() {
        RunOffEDTProvider runOffEDTProvider = (RunOffEDTProvider)Lookup.getDefault().lookup(RunOffEDTProvider.class);
        return runOffEDTProvider != null ? runOffEDTProvider : new Trivial();
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl) {
        BaseProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)string, (AtomicBoolean)atomicBoolean, (boolean)bl, (int)50, (int)9450);
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        BaseProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)string, (AtomicBoolean)atomicBoolean, (boolean)bl, (int)n, (int)n2);
    }

    public static void showProgressDialogAndRun(Runnable runnable, ProgressHandle progressHandle, boolean bl) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runnable, (ProgressHandle)progressHandle, (boolean)bl);
    }

    public static void runOffEventThreadWithProgressDialog(Runnable runnable, String string, ProgressHandle progressHandle, boolean bl, int n, int n2) {
        BaseProgressUtils.runOffEventThreadWithProgressDialog((Runnable)runnable, (String)string, (ProgressHandle)progressHandle, (boolean)bl, (int)n, (int)n2);
    }

    public static void runOffEventThreadWithCustomDialogContent(Runnable runnable, String string, JPanel jPanel, int n, int n2) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress2) {
            RunOffEDTProvider.Progress2 progress2 = (RunOffEDTProvider.Progress2)PROVIDER;
            progress2.runOffEventThreadWithCustomDialogContent(runnable, string, jPanel, n, n2);
        } else {
            BaseProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)string, (AtomicBoolean)new AtomicBoolean(false), (boolean)true, (int)50, (int)9450);
        }
    }

    public static <T> T showProgressDialogAndRun(ProgressRunnable<T> progressRunnable, String string, boolean bl) {
        return (T)BaseProgressUtils.showProgressDialogAndRun(progressRunnable, (String)string, (boolean)bl);
    }

    public static void showProgressDialogAndRun(Runnable runnable, String string) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runnable, (String)string);
    }

    public static <T> Future<T> showProgressDialogAndRunLater(ProgressRunnable<T> progressRunnable, ProgressHandle progressHandle, boolean bl) {
        return BaseProgressUtils.showProgressDialogAndRunLater(progressRunnable, (ProgressHandle)progressHandle, (boolean)bl);
    }

    private static class Trivial
    implements RunOffEDTProvider {
        private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());

        private Trivial() {
        }

        public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.Task task = WORKER.post(runnable);
                task.waitFinished();
            } else {
                runnable.run();
            }
        }
    }
}

