/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QPERSIANCALENDAR_DATA_P_H
#define QPERSIANCALENDAR_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>
#include <QtCore/private/qcalendarbackend_p.h>

QT_BEGIN_NAMESPACE

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2020-10-30 from the
    Common Locale Data Repository v38

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static const QCalendarLocale locale_data[] = {
     // lang   script terr  sLong  long sShrt short sNarw narow Sizes...
      {     1,     0,     0,    0,    0,   83,   83,  130,  153, 83, 83, 47, 47, 23, 26 },// C/AnyScript/AnyCountry
      {     3,    66,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Afar/Latin/Ethiopia
      {     4,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Afrikaans/Latin/South Africa
      {     4,    66,   162,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Afrikaans/Latin/Namibia
      {     5,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Aghem/Latin/Cameroon
      {     6,    66,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Akan/Latin/Ghana
      {     8,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Akoose/Latin/Cameroon
      {     9,    66,     3,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Albanian/Latin/Albania
      {     9,    66,   126,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Albanian/Latin/Kosovo
      {     9,    66,   140,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Albanian/Latin/Macedonia
      {    11,    33,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Amharic/Ethiopic/Ethiopia
      {    14,     4,    71,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Egypt
      {    14,     4,     4,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Algeria
      {    14,     4,    19,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Bahrain
      {    14,     4,    48,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Chad
      {    14,     4,    55,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Comoros
      {    14,     4,    67,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Djibouti
      {    14,     4,    74,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Eritrea
      {    14,     4,   113,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Iraq
      {    14,     4,   116,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Israel
      {    14,     4,   122,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Jordan
      {    14,     4,   127,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Kuwait
      {    14,     4,   132,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Lebanon
      {    14,     4,   135,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Libya
      {    14,     4,   149,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Mauritania
      {    14,     4,   159,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Morocco
      {    14,     4,   176,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Oman
      {    14,     4,   180,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Palestinian Territories
      {    14,     4,   190,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Qatar
      {    14,     4,   205,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Saudi Arabia
      {    14,     4,   215,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Somalia
      {    14,     4,   219,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/South Sudan
      {    14,     4,   222,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Sudan
      {    14,     4,   227,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Syria
      {    14,     4,   238,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Tunisia
      {    14,     4,   245,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/United Arab Emirates
      {    14,     4,   257,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Western Sahara
      {    14,     4,   258,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/World
      {    14,     4,   259,  179,  179,  179,  179,  153,  153, 67, 67, 67, 67, 26, 26 },// Arabic/Arabic/Yemen
      {    15,    66,   220,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Aragonese/Latin/Spain
      {    17,     5,    12,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Armenian/Armenian/Armenia
      {    18,     9,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Assamese/Bangla/India
      {    19,    66,   220,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Asturian/Latin/Spain
      {    20,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Asu/Latin/Tanzania
      {    21,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Atsam/Latin/Nigeria
      {    25,    66,    17,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Azerbaijani/Latin/Azerbaijan
      {    25,     4,   112,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Azerbaijani/Arabic/Iran
      {    25,    27,    17,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Azerbaijani/Cyrillic/Azerbaijan
      {    26,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bafia/Latin/Cameroon
      {    28,    66,   145,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bambara/Latin/Mali
      {    28,    90,   145,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bambara/Nko/Mali
      {    30,     9,    20,  246,  246,  334,  334,  421,  421, 88, 88, 87, 87, 26, 26 },// Bangla/Bangla/Bangladesh
      {    30,     9,   110,  246,  246,  334,  334,  421,  421, 88, 88, 87, 87, 26, 26 },// Bangla/Bangla/India
      {    31,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Basaa/Latin/Cameroon
      {    32,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bashkir/Cyrillic/Russia
      {    33,    66,   220,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Basque/Latin/Spain
      {    35,    27,    22,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Belarusian/Cyrillic/Belarus
      {    36,    66,   260,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bemba/Latin/Zambia
      {    37,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bena/Latin/Tanzania
      {    40,    33,    74,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Blin/Ethiopic/Eritrea
      {    41,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bodo/Devanagari/India
      {    42,    66,    29,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bosnian/Latin/Bosnia And Herzegovina
      {    42,    27,    29,  447,  447,  447,  447,  153,  153, 80, 80, 80, 80, 26, 26 },// Bosnian/Cyrillic/Bosnia And Herzegovina
      {    43,    66,    84,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Breton/Latin/France
      {    45,    27,    36,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Bulgarian/Cyrillic/Bulgaria
      {    46,    86,   161,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Burmese/Myanmar/Myanmar
      {    47,   137,   107,  527,  527,  527,  527,  153,  153, 38, 38, 38, 38, 26, 26 },// Cantonese/Traditional Han/Hong Kong
      {    47,   118,    50,  527,  527,  527,  527,  153,  153, 38, 38, 38, 38, 26, 26 },// Cantonese/Simplified Han/China
      {    48,    66,   220,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Catalan/Latin/Spain
      {    48,    66,     6,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Catalan/Latin/Andorra
      {    48,    66,    84,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Catalan/Latin/France
      {    48,    66,   117,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Catalan/Latin/Italy
      {    49,    66,   185,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Cebuano/Latin/Philippines
      {    50,    66,   159,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Central Atlas Tamazight/Latin/Morocco
      {    51,     4,   113,  565,  565,  565,  565,  153,  153,101,101,101,101, 26, 26 },// Central Kurdish/Arabic/Iraq
      {    51,     4,   112,  565,  565,  565,  565,  153,  153,101,101,101,101, 26, 26 },// Central Kurdish/Arabic/Iran
      {    52,    21,    20,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chakma/Chakma/Bangladesh
      {    52,    21,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chakma/Chakma/India
      {    54,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chechen/Cyrillic/Russia
      {    55,    23,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Cherokee/Cherokee/United States
      {    56,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chickasaw/Latin/United States
      {    57,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chiga/Latin/Uganda
      {    58,   118,    50,  666,  666,  527,  527,  153,  153, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/China
      {    58,   118,   107,  666,  666,  527,  527,  153,  153, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Hong Kong
      {    58,   118,   139,  666,  666,  527,  527,  153,  153, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Macao
      {    58,   118,   210,  666,  666,  527,  527,  153,  153, 37, 37, 38, 38, 26, 26 },// Chinese/Simplified Han/Singapore
      {    58,   137,   107,  527,  527,  527,  527,  153,  153, 38, 38, 38, 38, 26, 26 },// Chinese/Traditional Han/Hong Kong
      {    58,   137,   139,  527,  527,  527,  527,  153,  153, 38, 38, 38, 38, 26, 26 },// Chinese/Traditional Han/Macao
      {    58,   137,   228,  527,  527,  527,  527,  153,  153, 38, 38, 38, 38, 26, 26 },// Chinese/Traditional Han/Taiwan
      {    59,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Church/Cyrillic/Russia
      {    60,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Chuvash/Cyrillic/Russia
      {    61,    66,    91,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Colognian/Latin/Germany
      {    63,    66,   246,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Cornish/Latin/United Kingdom
      {    64,    66,    84,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Corsican/Latin/France
      {    66,    66,    60,    0,    0,    0,    0,  703,  703, 83, 83, 83, 83, 38, 38 },// Croatian/Latin/Croatia
      {    66,    66,    29,    0,    0,    0,    0,  703,  703, 83, 83, 83, 83, 38, 38 },// Croatian/Latin/Bosnia And Herzegovina
      {    67,    66,    64,  741,  741,  741,  741,  153,  153, 81, 81, 81, 81, 26, 26 },// Czech/Latin/Czechia
      {    68,    66,    65,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Danish/Latin/Denmark
      {    68,    66,    95,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Danish/Latin/Greenland
      {    69,   132,   144,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Divehi/Thaana/Maldives
      {    70,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dogri/Devanagari/India
      {    71,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Duala/Latin/Cameroon
      {    72,    66,   165,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Netherlands
      {    72,    66,    13,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Aruba
      {    72,    66,    23,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Belgium
      {    72,    66,    44,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Caribbean Netherlands
      {    72,    66,    62,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Curacao
      {    72,    66,   211,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Sint Maarten
      {    72,    66,   223,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dutch/Latin/Suriname
      {    73,   134,    27,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Dzongkha/Tibetan/Bhutan
      {    74,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Embu/Latin/Kenya
      {    75,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/United States
      {    75,    28,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Deseret/United States
      {    75,    66,     5,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/American Samoa
      {    75,    66,     8,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Anguilla
      {    75,    66,    10,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Antigua And Barbuda
      {    75,    66,    15,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Australia
      {    75,    66,    16,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Austria
      {    75,    66,    18,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Bahamas
      {    75,    66,    21,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Barbados
      {    75,    66,    23,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Belgium
      {    75,    66,    24,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Belize
      {    75,    66,    26,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Bermuda
      {    75,    66,    30,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Botswana
      {    75,    66,    33,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/British Indian Ocean Territory
      {    75,    66,    34,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/British Virgin Islands
      {    75,    66,    38,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Burundi
      {    75,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Cameroon
      {    75,    66,    41,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Canada
      {    75,    66,    45,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Cayman Islands
      {    75,    66,    51,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Christmas Island
      {    75,    66,    53,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Cocos Islands
      {    75,    66,    58,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Cook Islands
      {    75,    66,    63,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Cyprus
      {    75,    66,    65,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Denmark
      {    75,    66,    66,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Diego Garcia
      {    75,    66,    68,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Dominica
      {    75,    66,    74,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Eritrea
      {    75,    66,    76,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Eswatini
      {    75,    66,    78,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Europe
      {    75,    66,    80,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Falkland Islands
      {    75,    66,    82,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Fiji
      {    75,    66,    83,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Finland
      {    75,    66,    89,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Gambia
      {    75,    66,    91,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Germany
      {    75,    66,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Ghana
      {    75,    66,    93,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Gibraltar
      {    75,    66,    96,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Grenada
      {    75,    66,    98,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Guam
      {    75,    66,   100,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Guernsey
      {    75,    66,   103,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Guyana
      {    75,    66,   107,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Hong Kong
      {    75,    66,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/India
      {    75,    66,   114,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Ireland
      {    75,    66,   115,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Isle Of Man
      {    75,    66,   116,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Israel
      {    75,    66,   119,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Jamaica
      {    75,    66,   121,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Jersey
      {    75,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Kenya
      {    75,    66,   125,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Kiribati
      {    75,    66,   133,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Lesotho
      {    75,    66,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Liberia
      {    75,    66,   139,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Macao
      {    75,    66,   141,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Madagascar
      {    75,    66,   142,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Malawi
      {    75,    66,   143,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Malaysia
      {    75,    66,   146,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Malta
      {    75,    66,   147,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Marshall Islands
      {    75,    66,   150,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Mauritius
      {    75,    66,   153,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Micronesia
      {    75,    66,   158,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Montserrat
      {    75,    66,   162,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Namibia
      {    75,    66,   163,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Nauru
      {    75,    66,   165,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Netherlands
      {    75,    66,   167,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/New Zealand
      {    75,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Nigeria
      {    75,    66,   171,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Niue
      {    75,    66,   172,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Norfolk Island
      {    75,    66,   173,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Northern Mariana Islands
      {    75,    66,   178,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Pakistan
      {    75,    66,   179,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Palau
      {    75,    66,   182,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Papua New Guinea
      {    75,    66,   185,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Philippines
      {    75,    66,   186,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Pitcairn
      {    75,    66,   189,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Puerto Rico
      {    75,    66,   194,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Rwanda
      {    75,    66,   196,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Saint Helena
      {    75,    66,   197,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Saint Kitts And Nevis
      {    75,    66,   198,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Saint Lucia
      {    75,    66,   201,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Saint Vincent And Grenadines
      {    75,    66,   202,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Samoa
      {    75,    66,   208,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Seychelles
      {    75,    66,   209,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Sierra Leone
      {    75,    66,   210,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Singapore
      {    75,    66,   211,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Sint Maarten
      {    75,    66,   213,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Slovenia
      {    75,    66,   214,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Solomon Islands
      {    75,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/South Africa
      {    75,    66,   219,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/South Sudan
      {    75,    66,   222,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Sudan
      {    75,    66,   225,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Sweden
      {    75,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Switzerland
      {    75,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Tanzania
      {    75,    66,   234,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Tokelau
      {    75,    66,   235,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Tonga
      {    75,    66,   236,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Trinidad And Tobago
      {    75,    66,   241,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Turks And Caicos Islands
      {    75,    66,   242,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Tuvalu
      {    75,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Uganda
      {    75,    66,   245,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/United Arab Emirates
      {    75,    66,   246,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/United Kingdom
      {    75,    66,   247,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/United States Outlying Islands
      {    75,    66,   249,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/United States Virgin Islands
      {    75,    66,   252,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Vanuatu
      {    75,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/World
      {    75,    66,   260,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Zambia
      {    75,    66,   261,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// English/Latin/Zimbabwe
      {    76,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Erzya/Cyrillic/Russia
      {    77,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Esperanto/Latin/World
      {    78,    66,    75,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Estonian/Latin/Estonia
      {    79,    66,    92,  905,  905,  991,  991,  153,  153, 86, 86, 47, 47, 26, 26 },// Ewe/Latin/Ghana
      {    79,    66,   233,  905,  905,  991,  991,  153,  153, 86, 86, 47, 47, 26, 26 },// Ewe/Latin/Togo
      {    80,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ewondo/Latin/Cameroon
      {    81,    66,    81,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Faroese/Latin/Faroe Islands
      {    81,    66,    65,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Faroese/Latin/Denmark
      {    83,    66,   185,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Filipino/Latin/Philippines
      {    84,    66,    83, 1038, 1155, 1296, 1155,  153,  153,117,141, 81,141, 26, 26 },// Finnish/Latin/Finland
      {    85,    66,    84, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/France
      {    85,    66,     4, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Algeria
      {    85,    66,    23, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Belgium
      {    85,    66,    25, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Benin
      {    85,    66,    37, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Burkina Faso
      {    85,    66,    38, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Burundi
      {    85,    66,    40, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Cameroon
      {    85,    66,    41, 1515, 1515, 1596, 1596,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Canada
      {    85,    66,    46, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Central African Republic
      {    85,    66,    48, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Chad
      {    85,    66,    55, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Comoros
      {    85,    66,    56, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Congo Brazzaville
      {    85,    66,    57, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Congo Kinshasa
      {    85,    66,    67, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Djibouti
      {    85,    66,    73, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Equatorial Guinea
      {    85,    66,    85, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/French Guiana
      {    85,    66,    86, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/French Polynesia
      {    85,    66,    88, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Gabon
      {    85,    66,    97, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Guadeloupe
      {    85,    66,   102, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Guinea
      {    85,    66,   104, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Haiti
      {    85,    66,   118, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Ivory Coast
      {    85,    66,   138, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Luxembourg
      {    85,    66,   141, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Madagascar
      {    85,    66,   145, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Mali
      {    85,    66,   148, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Martinique
      {    85,    66,   149, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Mauritania
      {    85,    66,   150, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Mauritius
      {    85,    66,   151, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Mayotte
      {    85,    66,   155, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Monaco
      {    85,    66,   159, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Morocco
      {    85,    66,   166, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/New Caledonia
      {    85,    66,   170, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Niger
      {    85,    66,   191, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Reunion
      {    85,    66,   194, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Rwanda
      {    85,    66,   195, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Saint Barthelemy
      {    85,    66,   199, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Saint Martin
      {    85,    66,   200, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Saint Pierre And Miquelon
      {    85,    66,   206, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Senegal
      {    85,    66,   208, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Seychelles
      {    85,    66,   226, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Switzerland
      {    85,    66,   227, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Syria
      {    85,    66,   233, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Togo
      {    85,    66,   238, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Tunisia
      {    85,    66,   252, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Vanuatu
      {    85,    66,   256, 1377, 1377, 1458, 1458,  153,  153, 81, 81, 57, 57, 26, 26 },// French/Latin/Wallis And Futuna
      {    86,    66,   117,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Friulian/Latin/Italy
      {    87,    66,   206,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Senegal
      {    87,     1,    37,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Burkina Faso
      {    87,     1,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Cameroon
      {    87,     1,    89,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Gambia
      {    87,     1,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Ghana
      {    87,     1,   101,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Guinea Bissau
      {    87,     1,   102,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Guinea
      {    87,     1,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Liberia
      {    87,     1,   149,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Mauritania
      {    87,     1,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Nigeria
      {    87,     1,   170,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Niger
      {    87,     1,   206,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Senegal
      {    87,     1,   209,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Adlam/Sierra Leone
      {    87,    66,    37,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Burkina Faso
      {    87,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Cameroon
      {    87,    66,    89,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Gambia
      {    87,    66,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Ghana
      {    87,    66,   101,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Guinea Bissau
      {    87,    66,   102,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Guinea
      {    87,    66,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Liberia
      {    87,    66,   149,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Mauritania
      {    87,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Nigeria
      {    87,    66,   170,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Niger
      {    87,    66,   209,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Fulah/Latin/Sierra Leone
      {    88,    66,   246,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Gaelic/Latin/United Kingdom
      {    89,    66,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ga/Latin/Ghana
      {    90,    66,   220,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Galician/Latin/Spain
      {    91,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ganda/Latin/Uganda
      {    92,    33,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Geez/Ethiopic/Ethiopia
      {    93,    35,    90, 1653, 1653, 1653, 1653,  153,  153, 91, 91, 91, 91, 26, 26 },// Georgian/Georgian/Georgia
      {    94,    66,    91, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Germany
      {    94,    66,    16, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Austria
      {    94,    66,    23, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Belgium
      {    94,    66,   117, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Italy
      {    94,    66,   136, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Liechtenstein
      {    94,    66,   138, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Luxembourg
      {    94,    66,   226, 1744, 1744, 1744, 1744,  153,  153, 86, 86, 86, 86, 26, 26 },// German/Latin/Switzerland
      {    96,    39,    94,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Greek/Greek/Greece
      {    96,    39,    63,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Greek/Greek/Cyprus
      {    97,    66,   183,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Guarani/Latin/Paraguay
      {    98,    40,   110, 1830, 1830, 1830, 1830,  153,  153, 85, 85, 85, 85, 26, 26 },// Gujarati/Gujarati/India
      {    99,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Gusii/Latin/Kenya
      {   101,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hausa/Latin/Nigeria
      {   101,     4,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hausa/Arabic/Nigeria
      {   101,    66,    92,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hausa/Latin/Ghana
      {   101,    66,   170,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hausa/Latin/Niger
      {   102,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hawaiian/Latin/United States
      {   103,    47,   116, 1915, 1915, 1915, 1915,  153,  153, 68, 68, 68, 68, 26, 26 },// Hebrew/Hebrew/Israel
      {   105,    29,   110, 1983, 1983, 1983, 1983,  153,  153, 81, 81, 81, 81, 26, 26 },// Hindi/Devanagari/India
      {   105,    66,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Hindi/Latin/India
      {   107,    66,   108,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Hungarian/Latin/Hungary
      {   108,    66,   109,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Icelandic/Latin/Iceland
      {   109,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ido/Latin/World
      {   110,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Igbo/Latin/Nigeria
      {   111,    66,    83,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Inari Sami/Latin/Finland
      {   112,    66,   111,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Indonesian/Latin/Indonesia
      {   114,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Interlingua/Latin/World
      {   116,    18,    41,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Inuktitut/Canadian Aboriginal/Canada
      {   116,    66,    41,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Inuktitut/Latin/Canada
      {   118,    66,   114,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Irish/Latin/Ireland
      {   118,    66,   246,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Irish/Latin/United Kingdom
      {   119,    66,   117,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Italian/Latin/Italy
      {   119,    66,   203,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Italian/Latin/San Marino
      {   119,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Italian/Latin/Switzerland
      {   119,    66,   253,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Italian/Latin/Vatican City
      {   120,    53,   120, 2064, 2064, 2064, 2064,  153,  153, 77, 77, 77, 77, 26, 26 },// Japanese/Japanese/Japan
      {   121,    66,   111,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Javanese/Latin/Indonesia
      {   122,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Jju/Latin/Nigeria
      {   123,    66,   206,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Jola Fonyi/Latin/Senegal
      {   124,    66,    43,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kabuverdianu/Latin/Cape Verde
      {   125,    66,     4,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kabyle/Latin/Algeria
      {   126,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kako/Latin/Cameroon
      {   127,    66,    95,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kalaallisut/Latin/Greenland
      {   128,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kalenjin/Latin/Kenya
      {   129,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kamba/Latin/Kenya
      {   130,    56,   110, 2141, 2141, 2141, 2141,  153,  153, 92, 92, 92, 92, 26, 26 },// Kannada/Kannada/India
      {   132,     4,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kashmiri/Arabic/India
      {   132,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kashmiri/Devanagari/India
      {   133,    27,   123,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kazakh/Cyrillic/Kazakhstan
      {   134,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kenyang/Latin/Cameroon
      {   135,    60,    39,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Khmer/Khmer/Cambodia
      {   136,    66,    99,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kiche/Latin/Guatemala
      {   137,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kikuyu/Latin/Kenya
      {   138,    66,   194,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kinyarwanda/Latin/Rwanda
      {   141,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Konkani/Devanagari/India
      {   142,    63,   218, 2233, 2233, 2233, 2233,  153,  153, 54, 54, 54, 54, 26, 26 },// Korean/Korean/South Korea
      {   142,    63,   174, 2233, 2233, 2233, 2233,  153,  153, 54, 54, 54, 54, 26, 26 },// Korean/Korean/North Korea
      {   144,    66,   145,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Koyraboro Senni/Latin/Mali
      {   145,    66,   145,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Koyra Chiini/Latin/Mali
      {   146,    66,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kpelle/Latin/Liberia
      {   148,    66,   239,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kurdish/Latin/Turkey
      {   149,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kwasio/Latin/Cameroon
      {   150,    27,   128,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Kyrgyz/Cyrillic/Kyrgyzstan
      {   151,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lakota/Latin/United States
      {   152,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Langi/Latin/Tanzania
      {   153,    65,   129, 2287, 2287, 2367, 2446,  153,  153, 80, 80, 79, 79, 26, 26 },// Lao/Lao/Laos
      {   154,    66,   253,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Latin/Latin/Vatican City
      {   155,    66,   131, 2525, 2525, 2525, 2525,  153,  153, 92, 92, 92, 92, 26, 26 },// Latvian/Latin/Latvia
      {   158,    66,    57,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lingala/Latin/Congo Kinshasa
      {   158,    66,     7,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lingala/Latin/Angola
      {   158,    66,    46,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lingala/Latin/Central African Republic
      {   158,    66,    56,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lingala/Latin/Congo Brazzaville
      {   160,    66,   137,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lithuanian/Latin/Lithuania
      {   161,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lojban/Latin/World
      {   162,    66,    91,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lower Sorbian/Latin/Germany
      {   163,    66,    91,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Low German/Latin/Germany
      {   163,    66,   165,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Low German/Latin/Netherlands
      {   164,    66,    57,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Luba Katanga/Latin/Congo Kinshasa
      {   165,    66,   225,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Lule Sami/Latin/Sweden
      {   166,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Luo/Latin/Kenya
      {   167,    66,   138,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Luxembourgish/Latin/Luxembourg
      {   168,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Luyia/Latin/Kenya
      {   169,    27,   140, 2617, 2617, 2617, 2617,  153,  153, 79, 79, 79, 79, 26, 26 },// Macedonian/Cyrillic/Macedonia
      {   170,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Machame/Latin/Tanzania
      {   171,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Maithili/Devanagari/India
      {   172,    66,   160,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Makhuwa Meetto/Latin/Mozambique
      {   173,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Makonde/Latin/Tanzania
      {   174,    66,   141,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malagasy/Latin/Madagascar
      {   175,    74,   110, 2696, 2696, 2696, 2696, 2787, 2787, 91, 91, 91, 91, 39, 39 },// Malayalam/Malayalam/India
      {   176,    66,   143,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malay/Latin/Malaysia
      {   176,     4,   143,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malay/Arabic/Malaysia
      {   176,    66,    35,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malay/Latin/Brunei
      {   176,    66,   111,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malay/Latin/Indonesia
      {   176,    66,   210,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Malay/Latin/Singapore
      {   177,    66,   146,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Maltese/Latin/Malta
      {   179,     9,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Manipuri/Bangla/India
      {   179,    78,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Manipuri/Meitei Mayek/India
      {   180,    66,   115,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Manx/Latin/Isle Of Man
      {   181,    66,   167,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Maori/Latin/New Zealand
      {   182,    66,    49,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mapuche/Latin/Chile
      {   183,    29,   110, 2826, 2826, 2826, 2826, 2906, 2906, 80, 80, 80, 80, 26, 26 },// Marathi/Devanagari/India
      {   185,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Masai/Latin/Kenya
      {   185,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Masai/Latin/Tanzania
      {   186,     4,   112,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mazanderani/Arabic/Iran
      {   188,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Meru/Latin/Kenya
      {   189,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Meta/Latin/Cameroon
      {   190,    66,    41,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mohawk/Latin/Canada
      {   191,    27,   156,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mongolian/Cyrillic/Mongolia
      {   191,    83,    50,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mongolian/Mongolian/China
      {   192,    66,   150,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Morisyen/Latin/Mauritius
      {   193,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Mundang/Latin/Cameroon
      {   194,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Muscogee/Latin/United States
      {   195,    66,   162,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nama/Latin/Namibia
      {   197,    66,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Navajo/Latin/United States
      {   199,    29,   164,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nepali/Devanagari/Nepal
      {   199,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nepali/Devanagari/India
      {   201,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ngiemboon/Latin/Cameroon
      {   202,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ngomba/Latin/Cameroon
      {   203,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nigerian Pidgin/Latin/Nigeria
      {   204,    90,   102,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nko/Nko/Guinea
      {   205,     4,   112,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Luri/Arabic/Iran
      {   205,     4,   113,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Luri/Arabic/Iraq
      {   206,    66,   175,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Sami/Latin/Norway
      {   206,    66,    83,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Sami/Latin/Finland
      {   206,    66,   225,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Sami/Latin/Sweden
      {   207,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Northern Sotho/Latin/South Africa
      {   208,    66,   261,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// North Ndebele/Latin/Zimbabwe
      {   209,    66,   175,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Norwegian Bokmal/Latin/Norway
      {   209,    66,   224,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Norwegian Bokmal/Latin/Svalbard And Jan Mayen
      {   210,    66,   175,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Norwegian Nynorsk/Latin/Norway
      {   211,    66,   219,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nuer/Latin/South Sudan
      {   212,    66,   142,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nyanja/Latin/Malawi
      {   213,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Nyankole/Latin/Uganda
      {   214,    66,    84,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Occitan/Latin/France
      {   215,    91,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Odia/Odia/India
      {   220,    66,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Oromo/Latin/Ethiopia
      {   220,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Oromo/Latin/Kenya
      {   221,   101,   248,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Osage/Osage/United States
      {   222,    27,    90,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ossetic/Cyrillic/Georgia
      {   222,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Ossetic/Cyrillic/Russia
      {   227,     4,     1, 2932, 2932, 2932, 2932, 2994, 2994, 62, 62, 62, 62, 26, 26 },// Pashto/Arabic/Afghanistan
      {   227,     4,   178, 2932, 2932, 2932, 2932, 2994, 2994, 62, 62, 62, 62, 26, 26 },// Pashto/Arabic/Pakistan
      {   228,     4,   112, 3020, 3020, 3020, 3020, 3086, 3086, 66, 66, 66, 66, 23, 23 },// Persian/Arabic/Iran
      {   228,     4,     1, 3020, 3109, 3020, 3020, 3165, 3086, 66, 56, 66, 66, 23, 23 },// Persian/Arabic/Afghanistan
      {   230,    66,   187, 3188, 3188, 3188, 3188,  153,  153, 83, 83, 83, 83, 26, 26 },// Polish/Latin/Poland
      {   231,    66,    32,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Brazil
      {   231,    66,     7,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Angola
      {   231,    66,    43,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Cape Verde
      {   231,    66,    73,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Equatorial Guinea
      {   231,    66,   101,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Guinea Bissau
      {   231,    66,   138,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Luxembourg
      {   231,    66,   139,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Macao
      {   231,    66,   160,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Mozambique
      {   231,    66,   188,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Portugal
      {   231,    66,   204,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Sao Tome And Principe
      {   231,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Switzerland
      {   231,    66,   232,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Portuguese/Latin/Timor-Leste
      {   232,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Prussian/Latin/World
      {   233,    41,   110, 3271, 3271, 3271, 3271,  153,  153, 77, 77, 77, 77, 26, 26 },// Punjabi/Gurmukhi/India
      {   233,     4,   178,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Punjabi/Arabic/Pakistan
      {   234,    66,   184,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Quechua/Latin/Peru
      {   234,    66,    28,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Quechua/Latin/Bolivia
      {   234,    66,    70,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Quechua/Latin/Ecuador
      {   235,    66,   192, 3348, 3348, 3348, 3348,  153,  153, 85, 85, 85, 85, 26, 26 },// Romanian/Latin/Romania
      {   235,    66,   154, 3348, 3348, 3348, 3348,  153,  153, 85, 85, 85, 85, 26, 26 },// Romanian/Latin/Moldova
      {   236,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Romansh/Latin/Switzerland
      {   237,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Rombo/Latin/Tanzania
      {   238,    66,    38,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Rundi/Latin/Burundi
      {   239,    27,   193, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Russia
      {   239,    27,    22, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Belarus
      {   239,    27,   123, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Kazakhstan
      {   239,    27,   128, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Kyrgyzstan
      {   239,    27,   154, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Moldova
      {   239,    27,   244, 3433, 3433, 3433, 3433,  153,  153, 80, 80, 80, 80, 26, 26 },// Russian/Cyrillic/Ukraine
      {   240,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Rwa/Latin/Tanzania
      {   241,    66,    74,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Saho/Latin/Eritrea
      {   242,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sakha/Cyrillic/Russia
      {   243,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Samburu/Latin/Kenya
      {   245,    66,    46,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sango/Latin/Central African Republic
      {   246,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sangu/Latin/Tanzania
      {   247,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sanskrit/Devanagari/India
      {   248,    93,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Santali/Ol Chiki/India
      {   248,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Santali/Devanagari/India
      {   249,    66,   117,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sardinian/Latin/Italy
      {   251,    66,   160,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sena/Latin/Mozambique
      {   252,    27,   207,  447,  447,  447,  447,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Cyrillic/Serbia
      {   252,    66,    29, 3513, 3513, 3513, 3513,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Latin/Bosnia And Herzegovina
      {   252,    66,   207, 3513, 3513, 3513, 3513,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Latin/Serbia
      {   252,    27,    29,  447,  447,  447,  447,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Cyrillic/Bosnia And Herzegovina
      {   252,    27,   126,  447,  447,  447,  447,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Cyrillic/Kosovo
      {   252,    27,   157,  447,  447,  447,  447,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Cyrillic/Montenegro
      {   252,    66,   126, 3513, 3513, 3513, 3513,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Latin/Kosovo
      {   252,    66,   157, 3513, 3513, 3513, 3513,  153,  153, 80, 80, 80, 80, 26, 26 },// Serbian/Latin/Montenegro
      {   253,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Shambala/Latin/Tanzania
      {   254,    66,   261,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Shona/Latin/Zimbabwe
      {   255,   141,    50,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sichuan Yi/Yi/China
      {   256,    66,   117,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sicilian/Latin/Italy
      {   257,    66,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sidamo/Latin/Ethiopia
      {   258,    66,   187,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Silesian/Latin/Poland
      {   259,     4,   178,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sindhi/Arabic/Pakistan
      {   259,    29,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sindhi/Devanagari/India
      {   260,   119,   221,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sinhala/Sinhala/Sri Lanka
      {   261,    66,    83,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Skolt Sami/Latin/Finland
      {   262,    66,   212,  741,  741,  741,  741,  153,  153, 81, 81, 81, 81, 26, 26 },// Slovak/Latin/Slovakia
      {   263,    66,   213,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Slovenian/Latin/Slovenia
      {   264,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Soga/Latin/Uganda
      {   265,    66,   215, 3593, 3593, 3593, 3593,  153,  153, 99, 99, 99, 99, 26, 26 },// Somali/Latin/Somalia
      {   265,    66,    67, 3593, 3593, 3593, 3593,  153,  153, 99, 99, 99, 99, 26, 26 },// Somali/Latin/Djibouti
      {   265,    66,    77, 3593, 3593, 3593, 3593,  153,  153, 99, 99, 99, 99, 26, 26 },// Somali/Latin/Ethiopia
      {   265,    66,   124, 3593, 3593, 3593, 3593,  153,  153, 99, 99, 99, 99, 26, 26 },// Somali/Latin/Kenya
      {   266,     4,   112,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Southern Kurdish/Arabic/Iran
      {   267,    66,   225,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Southern Sami/Latin/Sweden
      {   268,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Southern Sotho/Latin/South Africa
      {   269,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// South Ndebele/Latin/South Africa
      {   270,    66,   220,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Spain
      {   270,    66,    11,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Argentina
      {   270,    66,    24,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Belize
      {   270,    66,    28,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Bolivia
      {   270,    66,    32,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Brazil
      {   270,    66,    42,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Canary Islands
      {   270,    66,    47,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Ceuta And Melilla
      {   270,    66,    49,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Chile
      {   270,    66,    54,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Colombia
      {   270,    66,    59,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Costa Rica
      {   270,    66,    61,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Cuba
      {   270,    66,    69,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Dominican Republic
      {   270,    66,    70,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Ecuador
      {   270,    66,    72,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/El Salvador
      {   270,    66,    73,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Equatorial Guinea
      {   270,    66,    99,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Guatemala
      {   270,    66,   106,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Honduras
      {   270,    66,   130,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Latin America
      {   270,    66,   152,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Mexico
      {   270,    66,   168,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Nicaragua
      {   270,    66,   181,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Panama
      {   270,    66,   183,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Paraguay
      {   270,    66,   184,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Peru
      {   270,    66,   185,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Philippines
      {   270,    66,   189,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Puerto Rico
      {   270,    66,   248,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/United States
      {   270,    66,   250,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Uruguay
      {   270,    66,   254,  822,  822,  822,  822,  153,  153, 83, 83, 83, 83, 26, 26 },// Spanish/Latin/Venezuela
      {   271,   135,   159,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Standard Moroccan Tamazight/Tifinagh/Morocco
      {   272,    66,   111,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Sundanese/Latin/Indonesia
      {   273,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swahili/Latin/Tanzania
      {   273,    66,    57,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swahili/Latin/Congo Kinshasa
      {   273,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swahili/Latin/Kenya
      {   273,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swahili/Latin/Uganda
      {   274,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swati/Latin/South Africa
      {   275,    66,   225, 3692, 3775, 3692, 3775,  153,  153, 83, 83, 83, 83, 26, 26 },// Swedish/Latin/Sweden
      {   275,    66,     2, 3692, 3775, 3692, 3775,  153,  153, 83, 83, 83, 83, 26, 26 },// Swedish/Latin/Aland Islands
      {   275,    66,    83, 3692, 3775, 3692, 3775,  153,  153, 83, 83, 83, 83, 26, 26 },// Swedish/Latin/Finland
      {   276,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swiss German/Latin/Switzerland
      {   276,    66,    84,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swiss German/Latin/France
      {   276,    66,   136,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Swiss German/Latin/Liechtenstein
      {   277,   123,   113,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Syriac/Syriac/Iraq
      {   278,   135,   159,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tachelhit/Tifinagh/Morocco
      {   278,    66,   159,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tachelhit/Latin/Morocco
      {   280,   127,   255,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tai Dam/Tai Viet/Vietnam
      {   281,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Taita/Latin/Kenya
      {   282,    27,   229, 3858, 3858, 3858, 3858,  153,  153, 80, 80, 80, 80, 26, 26 },// Tajik/Cyrillic/Tajikistan
      {   283,   129,   110, 3938, 3938, 4031, 4031,  153,  153, 93, 93, 63, 63, 26, 26 },// Tamil/Tamil/India
      {   283,   129,   143, 3938, 3938, 4031, 4031,  153,  153, 93, 93, 63, 63, 26, 26 },// Tamil/Tamil/Malaysia
      {   283,   129,   210, 3938, 3938, 4031, 4031,  153,  153, 93, 93, 63, 63, 26, 26 },// Tamil/Tamil/Singapore
      {   283,   129,   221, 3938, 3938, 4031, 4031,  153,  153, 93, 93, 63, 63, 26, 26 },// Tamil/Tamil/Sri Lanka
      {   284,    66,   228,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Taroko/Latin/Taiwan
      {   285,    66,   170,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tasawaq/Latin/Niger
      {   286,    27,   193,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tatar/Cyrillic/Russia
      {   287,   131,   110, 4094, 4094, 4094, 4094,  153,  153, 88, 88, 88, 88, 26, 26 },// Telugu/Telugu/India
      {   288,    66,   243,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Teso/Latin/Uganda
      {   288,    66,   124,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Teso/Latin/Kenya
      {   289,   133,   231, 4182, 4182, 4182, 4182,  153,  153, 98, 98, 98, 98, 26, 26 },// Thai/Thai/Thailand
      {   290,   134,    50,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tibetan/Tibetan/China
      {   290,   134,   110,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tibetan/Tibetan/India
      {   291,    33,    74,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tigre/Ethiopic/Eritrea
      {   292,    33,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tigrinya/Ethiopic/Ethiopia
      {   292,    33,    74,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tigrinya/Ethiopic/Eritrea
      {   295,    66,   235,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tongan/Latin/Tonga
      {   296,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tsonga/Latin/South Africa
      {   297,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tswana/Latin/South Africa
      {   298,    66,   239, 4280, 4280, 4280, 4280,  153,  153, 80, 80, 80, 80, 26, 26 },// Turkish/Latin/Turkey
      {   298,    66,    63, 4280, 4280, 4280, 4280,  153,  153, 80, 80, 80, 80, 26, 26 },// Turkish/Latin/Cyprus
      {   299,    66,   240,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Turkmen/Latin/Turkmenistan
      {   301,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Tyap/Latin/Nigeria
      {   303,    27,   244, 4360, 4360, 4440, 4489,  153,  153, 80, 80, 49, 57, 26, 26 },// Ukrainian/Cyrillic/Ukraine
      {   304,    66,    91,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Upper Sorbian/Latin/Germany
      {   305,     4,   178, 4546, 4546, 4546, 4546,  153,  153, 66, 66, 66, 66, 26, 26 },// Urdu/Arabic/Pakistan
      {   305,     4,   110, 4546, 4546, 4546, 4546,  153,  153, 66, 66, 66, 66, 26, 26 },// Urdu/Arabic/India
      {   306,     4,    50,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Uyghur/Arabic/China
      {   307,    66,   251,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Uzbek/Latin/Uzbekistan
      {   307,     4,     1,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Uzbek/Arabic/Afghanistan
      {   307,    27,   251,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Uzbek/Cyrillic/Uzbekistan
      {   308,   139,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Vai/Vai/Liberia
      {   308,    66,   134,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Vai/Latin/Liberia
      {   309,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Venda/Latin/South Africa
      {   310,    66,   255,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Vietnamese/Latin/Vietnam
      {   311,    66,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Volapuk/Latin/World
      {   312,    66,   230,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Vunjo/Latin/Tanzania
      {   313,    66,    23,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Walloon/Latin/Belgium
      {   314,    66,   226,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Walser/Latin/Switzerland
      {   315,    66,    15,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Warlpiri/Latin/Australia
      {   316,    66,   246,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Welsh/Latin/United Kingdom
      {   317,     4,   178,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Western Balochi/Arabic/Pakistan
      {   318,    66,   165,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Western Frisian/Latin/Netherlands
      {   319,    33,    77,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Wolaytta/Ethiopic/Ethiopia
      {   320,    66,   206,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Wolof/Latin/Senegal
      {   321,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Xhosa/Latin/South Africa
      {   322,    66,    40,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Yangben/Latin/Cameroon
      {   323,    47,   258,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Yiddish/Hebrew/World
      {   324,    66,   169,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Yoruba/Latin/Nigeria
      {   324,    66,    25,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Yoruba/Latin/Benin
      {   325,    66,   170,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Zarma/Latin/Niger
      {   327,    66,   216,    0,    0,    0,    0,  153,  153, 83, 83, 83, 83, 26, 26 },// Zulu/Latin/South Africa
      {     0,     0,     0,    0,    0,    0,    0,    0,    0,  0,  0,  0,  0,  0,  0 },// trailing zeros
};

static const char16_t months_data[] = {
0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68,
0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64,
0x3b, 0x53, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e,
0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66,
0x61, 0x6e, 0x64, 0x46, 0x61, 0x72, 0x3b, 0x4f, 0x72, 0x64, 0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d,
0x6f, 0x72, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x41, 0x62, 0x61, 0x3b, 0x41, 0x7a, 0x61, 0x3b, 0x44,
0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x3b, 0x45, 0x73, 0x66, 0x46, 0x3b, 0x4f, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x4d, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x45, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34,
0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x641,
0x631, 0x641, 0x631, 0x62f, 0x646, 0x3b, 0x623, 0x630, 0x631, 0x628, 0x64a, 0x647, 0x634, 0x62a, 0x3b, 0x62e, 0x631, 0x62f, 0x627, 0x62f,
0x3b, 0x62a, 0x627, 0x631, 0x3b, 0x645, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x647, 0x631, 0x641, 0x627, 0x631, 0x3b, 0x645, 0x647,
0x631, 0x3b, 0x622, 0x64a, 0x627, 0x646, 0x3b, 0x622, 0x630, 0x631, 0x3b, 0x62f, 0x64a, 0x3b, 0x628, 0x647, 0x645, 0x646, 0x3b, 0x627,
0x633, 0x641, 0x646, 0x62f, 0x627, 0x631, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9ad, 0x9be, 0x9b0, 0x9cd, 0x9a1, 0x9bf, 0x9a8, 0x3b, 0x985, 0x9b0,
0x9a1, 0x9bf, 0x9ac, 0x9c7, 0x9b9, 0x9c7, 0x9b6, 0x9cd, 0x9a4, 0x3b, 0x996, 0x9cb, 0x9b0, 0x9cd, 0x9a6, 0x9cd, 0x9a6, 0x3b, 0x9a4, 0x9c0,
0x9b0, 0x3b, 0x9ae, 0x9b0, 0x9cd, 0x9af, 0x9be, 0x9a6, 0x3b, 0x9b6, 0x9be, 0x9b9, 0x9b0, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x9c7,
0x9b9, 0x9c7, 0x9b0, 0x3b, 0x986, 0x9ac, 0x9be, 0x9a8, 0x3b, 0x9ac, 0x9be, 0x99c, 0x9be, 0x9b0, 0x3b, 0x9a6, 0x9c7, 0x3b, 0x9ac, 0x9be,
0x9b9, 0x9ae, 0x9be, 0x9a8, 0x3b, 0x98f, 0x9b8, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9a8, 0x9cd, 0x9a1, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9ad, 0x9be,
0x9b0, 0x9cd, 0x9a1, 0x9bf, 0x9a8, 0x3b, 0x985, 0x9b0, 0x9a1, 0x9bf, 0x9ac, 0x9c7, 0x9b9, 0x9c7, 0x9b6, 0x9cd, 0x9a4, 0x3b, 0x996, 0x9cb,
0x9b0, 0x9cd, 0x9a6, 0x9cd, 0x9a6, 0x3b, 0x9a4, 0x9c0, 0x9b0, 0x3b, 0x9ae, 0x9b0, 0x9cd, 0x9af, 0x9be, 0x9a6, 0x3b, 0x9b6, 0x9be, 0x9b9,
0x9b0, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x9c7, 0x9b9, 0x9c7, 0x9b0, 0x3b, 0x986, 0x9ac, 0x9be, 0x9a8, 0x3b, 0x986, 0x99c, 0x9be,
0x9b0, 0x3b, 0x9a6, 0x9c7, 0x3b, 0x9ac, 0x9be, 0x9b9, 0x9ae, 0x9be, 0x9a8, 0x3b, 0x98f, 0x9b8, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9a8, 0x9cd,
0x9a1, 0x9e7, 0x3b, 0x9e8, 0x3b, 0x9e9, 0x3b, 0x9ea, 0x3b, 0x9eb, 0x3b, 0x9ec, 0x3b, 0x9ed, 0x3b, 0x9ee, 0x3b, 0x9ef, 0x3b, 0x9e7,
0x9e6, 0x3b, 0x9e7, 0x9e7, 0x3b, 0x9e7, 0x9e8, 0x424, 0x430, 0x440, 0x430, 0x432, 0x430, 0x434, 0x438, 0x43d, 0x3b, 0x41e, 0x440, 0x434,
0x438, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442, 0x3b, 0x41a, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x422, 0x438, 0x440, 0x3b, 0x41c,
0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x428, 0x430, 0x445, 0x440, 0x438, 0x432, 0x430, 0x440, 0x3b, 0x41c, 0x435, 0x445, 0x440, 0x3b,
0x410, 0x431, 0x430, 0x43d, 0x3b, 0x410, 0x437, 0x430, 0x440, 0x3b, 0x414, 0x435, 0x458, 0x3b, 0x411, 0x430, 0x445, 0x43c, 0x430, 0x43d,
0x3b, 0x415, 0x441, 0x444, 0x430, 0x43d, 0x434, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35,
0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31,
0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x62e, 0x627, 0x6a9, 0x6d5, 0x644, 0x6ce, 0x648, 0x6d5, 0x3b, 0x628, 0x627, 0x646, 0x6d5, 0x645, 0x6d5,
0x695, 0x3b, 0x62c, 0x6c6, 0x632, 0x6d5, 0x631, 0x62f, 0x627, 0x646, 0x3b, 0x67e, 0x648, 0x648, 0x634, 0x67e, 0x6d5, 0x695, 0x3b, 0x6af,
0x6d5, 0x644, 0x627, 0x648, 0x6ce, 0x698, 0x3b, 0x62e, 0x6d5, 0x631, 0x645, 0x627, 0x646, 0x627, 0x646, 0x3b, 0x695, 0x6d5, 0x632, 0x628,
0x6d5, 0x631, 0x3b, 0x62e, 0x6d5, 0x632, 0x6d5, 0x6b5, 0x648, 0x6d5, 0x631, 0x3b, 0x633, 0x6d5, 0x631, 0x645, 0x627, 0x648, 0x6d5, 0x632,
0x3b, 0x628, 0x6d5, 0x641, 0x631, 0x627, 0x646, 0x628, 0x627, 0x631, 0x3b, 0x695, 0x6ce, 0x628, 0x6d5, 0x646, 0x62f, 0x627, 0x646, 0x3b,
0x631, 0x6d5, 0x634, 0x6d5, 0x645, 0x6ce, 0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708,
0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b,
0x5341, 0x4e8c, 0x6708, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e,
0x3b, 0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32,
0x2e, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161,
0x74, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x64, 0xe1, 0x64, 0x3b, 0x74, 0xed, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0xe1, 0x64,
0x3b, 0x161, 0x61, 0x68, 0x72, 0xed, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0xe1, 0x62, 0xe1, 0x6e, 0x3b,
0xe1, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x69, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73, 0x66, 0x61,
0x6e, 0x64, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65,
0x73, 0x68, 0x74, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64,
0x61, 0x64, 0x3b, 0x73, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0x61, 0x62,
0x61, 0x6e, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65,
0x73, 0x66, 0x61, 0x6e, 0x64, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65,
0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x69, 0x1ebd, 0x3b, 0x64, 0x61, 0x6d, 0x25b, 0x3b, 0x6d, 0x61, 0x73,
0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65,
0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65,
0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74,
0x65, 0x64, 0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64,
0x65, 0x61, 0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x66, 0x61,
0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x6b, 0x75, 0x75, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161,
0x74, 0x6b, 0x75, 0x75, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x3b, 0x74, 0x69, 0x72, 0x6b,
0x75, 0x75, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61,
0x72, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x6b, 0x75, 0x75, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x6b, 0x75, 0x75,
0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6b, 0x75, 0x75, 0x3b, 0x64, 0x65, 0x79, 0x6b, 0x75, 0x75, 0x3b, 0x62, 0x61, 0x68, 0x6d,
0x61, 0x6e, 0x6b, 0x75, 0x75, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x6b, 0x75, 0x75, 0x66, 0x61, 0x72, 0x76, 0x61,
0x72, 0x64, 0x69, 0x6e, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74,
0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x74,
0x69, 0x72, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b,
0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x64, 0x65, 0x79, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x6b,
0x75, 0x75, 0x74, 0x61, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x66, 0x61, 0x72, 0x76,
0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x6b, 0x68, 0x6f,
0x72, 0x64, 0x61, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x161, 0x61, 0x68, 0x72,
0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x3b,
0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x66, 0x61, 0x72,
0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x6b, 0x68,
0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x161, 0x61, 0x68,
0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0xe2, 0x62, 0xe2, 0x6e, 0x3b, 0xe2, 0x7a, 0x61, 0x72,
0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x66, 0x61,
0x72, 0x2e, 0x3b, 0x6f, 0x72, 0x64, 0x2e, 0x3b, 0x6b, 0x68, 0x6f, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72,
0x2e, 0x3b, 0x161, 0x61, 0x68, 0x2e, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0xe2, 0x62, 0xe2, 0x6e, 0x3b, 0xe2, 0x7a, 0x61,
0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x2e, 0x3b, 0x65, 0x73, 0x66, 0x2e, 0x46, 0x61, 0x72, 0x76, 0x61,
0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72,
0x64, 0xe2, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x160, 0x61, 0x68, 0x72, 0x69,
0x76, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0xc2, 0x62, 0xe2, 0x6e, 0x3b, 0xc2, 0x7a, 0x61, 0x72, 0x3b, 0x44,
0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x46, 0x61, 0x72, 0x2e,
0x3b, 0x4f, 0x72, 0x64, 0x2e, 0x3b, 0x4b, 0x68, 0x6f, 0x2e, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x2e, 0x3b,
0x160, 0x61, 0x68, 0x2e, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0xc2, 0x62, 0xe2, 0x2e, 0x3b, 0xc2, 0x7a, 0x61, 0x72, 0x3b,
0x44, 0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x2e, 0x3b, 0x45, 0x73, 0x66, 0x2e, 0x10e4, 0x10d0, 0x10e0, 0x10d5, 0x10d0, 0x10e0, 0x10d3,
0x10d8, 0x10dc, 0x10d8, 0x3b, 0x10dd, 0x10e0, 0x10d3, 0x10d8, 0x10d1, 0x10d4, 0x10f0, 0x10d4, 0x10e8, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10dd, 0x10e0, 0x10d3,
0x10d0, 0x10d3, 0x10d8, 0x3b, 0x10d7, 0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10db, 0x10dd, 0x10e0, 0x10d3, 0x10d0, 0x10d3, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10f0,
0x10e0, 0x10d8, 0x10d5, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10db, 0x10d4, 0x10f0, 0x10e0, 0x10d8, 0x3b, 0x10d0, 0x10d1, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10d0,
0x10d6, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10d3, 0x10d4, 0x10d8, 0x3b, 0x10d1, 0x10d0, 0x10f0, 0x10db, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10d4, 0x10e1, 0x10e4,
0x10d0, 0x10dc, 0x10d3, 0x10d8, 0x46, 0x61, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65,
0x68, 0x65, 0x73, 0x63, 0x68, 0x74, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d,
0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x53, 0x63, 0x68, 0x61, 0x68, 0x72, 0x69, 0x77, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68,
0x72, 0x3b, 0x100, 0x62, 0x101, 0x6e, 0x3b, 0x100, 0x73, 0x61, 0x72, 0x3b, 0x44, 0xe9, 0x69, 0x3b, 0x42, 0x61, 0x68, 0x6d,
0x61, 0x6e, 0x3b, 0x45, 0x73, 0x73, 0x66, 0x61, 0x6e, 0x64, 0xaab, 0xabe, 0xab0, 0xacd, 0xab5, 0xabe, 0xab0, 0xacd, 0xaa6, 0xabf,
0xaa8, 0x3b, 0xa93, 0xab0, 0xaa1, 0xac0, 0xaac, 0xac7, 0xab9, 0xac7, 0xab6, 0xacd, 0xa9f, 0x3b, 0xa96, 0xacb, 0xab0, 0xaa6, 0xabe, 0xaa6,
0x3b, 0xaa4, 0xabf, 0xab0, 0x3b, 0xaae, 0xacb, 0xab0, 0xacd, 0xaa6, 0xabe, 0xaa6, 0x3b, 0xab6, 0xabe, 0xab9, 0xab0, 0xabf, 0xab5, 0xab0,
0x3b, 0xaae, 0xac7, 0xab9, 0xab0, 0x3b, 0xa85, 0xaac, 0xabe, 0xaa8, 0x3b, 0xa85, 0xa9d, 0xabe, 0xab0, 0x3b, 0xaa1, 0xac7, 0xaaf, 0x3b,
0xaac, 0xabe, 0xab9, 0xaae, 0xac7, 0xaa8, 0x3b, 0xa8f, 0xab8, 0xacd, 0xaab, 0xabe, 0xaa8, 0xacd, 0xaa1, 0x5e4, 0x5e8, 0x5d5, 0x5e8, 0x5d3,
0x5d9, 0x5df, 0x3b, 0x5d0, 0x5e8, 0x5d3, 0x5d9, 0x5d1, 0x5d4, 0x5e9, 0x5ea, 0x3b, 0x5d7, 0x5f3, 0x5e8, 0x5d3, 0x5d0, 0x5d3, 0x3b, 0x5ea,
0x5d9, 0x5e8, 0x3b, 0x5de, 0x5e8, 0x5d3, 0x5d0, 0x5d3, 0x3b, 0x5e9, 0x5d4, 0x5e8, 0x5d9, 0x5d5, 0x5e8, 0x3b, 0x5de, 0x5d4, 0x5e8, 0x3b,
0x5d0, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5d0, 0x5d3, 0x5f3, 0x5e8, 0x3b, 0x5d3, 0x5d9, 0x3b, 0x5d1, 0x5d4, 0x5de, 0x5df, 0x3b, 0x5d0, 0x5e1,
0x5e4, 0x5e0, 0x5d3, 0x92b, 0x930, 0x94d, 0x935, 0x93e, 0x926, 0x93f, 0x928, 0x3b, 0x913, 0x930, 0x94d, 0x926, 0x93f, 0x935, 0x947, 0x939,
0x947, 0x938, 0x94d, 0x91f, 0x3b, 0x916, 0x94b, 0x930, 0x930, 0x94d, 0x926, 0x93e, 0x926, 0x3b, 0x91f, 0x93f, 0x930, 0x3b, 0x92e, 0x94b,
0x930, 0x926, 0x93e, 0x926, 0x3b, 0x936, 0x93e, 0x939, 0x930, 0x940, 0x935, 0x930, 0x94d, 0x3b, 0x92e, 0x947, 0x939, 0x930, 0x3b, 0x905,
0x935, 0x928, 0x3b, 0x905, 0x91c, 0x93c, 0x930, 0x3b, 0x921, 0x947, 0x3b, 0x92c, 0x939, 0x92e, 0x928, 0x3b, 0x908, 0x938, 0x94d, 0x92b,
0x928, 0x94d, 0x926, 0x94d, 0x30d5, 0x30a1, 0x30eb, 0x30f4, 0x30a1, 0x30eb, 0x30c7, 0x30a3, 0x30fc, 0x30f3, 0x3b, 0x30aa, 0x30eb, 0x30c7, 0x30a3, 0x30fc,
0x30d9, 0x30d8, 0x30b7, 0x30e5, 0x30c8, 0x3b, 0x30db, 0x30eb, 0x30c0, 0x30fc, 0x30c9, 0x3b, 0x30c6, 0x30a3, 0x30fc, 0x30eb, 0x3b, 0x30e2, 0x30eb, 0x30c0,
0x30fc, 0x30c9, 0x3b, 0x30b7, 0x30e3, 0x30cf, 0x30ea, 0x30fc, 0x30f4, 0x30a1, 0x30eb, 0x3b, 0x30e1, 0x30d5, 0x30eb, 0x3b, 0x30a2, 0x30fc, 0x30d0, 0x30fc,
0x30f3, 0x3b, 0x30a2, 0x30fc, 0x30b6, 0x30eb, 0x3b, 0x30c7, 0x30a4, 0x3b, 0x30d0, 0x30d5, 0x30de, 0x30f3, 0x3b, 0x30a8, 0x30b9, 0x30d5, 0x30a1, 0x30f3,
0x30c9, 0xcab, 0xcb0, 0xccd, 0xcb5, 0xcb0, 0xccd, 0xca6, 0xcbf, 0xca8, 0xccd, 0x3b, 0xc93, 0xcb0, 0xccd, 0xca6, 0xcbf, 0xcac, 0xcc6, 0xcb9,
0xcc6, 0xcb6, 0xccd, 0xc9f, 0xccd, 0x3b, 0xc96, 0xccb, 0xcb0, 0xccd, 0xca1, 0xcbe, 0xca6, 0xccd, 0x3b, 0xc9f, 0xcbf, 0xcb0, 0xccd, 0x3b,
0xcae, 0xcca, 0xcb0, 0xccd, 0xca6, 0xcbe, 0xca6, 0xccd, 0x3b, 0xcb6, 0xcb9, 0xcb0, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0xccd, 0x3b, 0xcae, 0xcc6,
0xcb9, 0xccd, 0xcb0, 0xccd, 0x3b, 0xc85, 0xcac, 0xca8, 0xccd, 0x3b, 0xc85, 0xc9d, 0xcb0, 0xccd, 0x3b, 0xca1, 0xcc7, 0x3b, 0xcac, 0xcb9,
0xccd, 0xcae, 0xca8, 0xccd, 0x3b, 0xc8e, 0xcb8, 0xccd, 0xcab, 0xcbe, 0xc82, 0xca1, 0xccd, 0xd654, 0xb974, 0xbc14, 0xb518, 0x3b, 0xc624, 0xb974,
0xb514, 0xbca0, 0xd5e4, 0xc26c, 0xd2b8, 0x3b, 0xd638, 0xb974, 0xb2e4, 0xb4dc, 0x3b, 0xd2f0, 0xb974, 0x3b, 0xbaa8, 0xb974, 0xb2e4, 0xb4dc, 0x3b, 0xc0e4,
0xd750, 0xb9ac, 0xbc14, 0xb974, 0x3b, 0xba54, 0xd750, 0xb974, 0x3b, 0xc544, 0xbc18, 0x3b, 0xc544, 0xc790, 0xb974, 0x3b, 0xb2e4, 0xc774, 0x3b, 0xbc14,
0xd750, 0xb9cc, 0x3b, 0xc5d0, 0xc2a4, 0xd310, 0xb4dc, 0xe9f, 0xea3, 0xeb2, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b, 0xead, 0xecd, 0xea3, 0xe94,
0xeb5, 0xe9a, 0xeb5, 0xec0, 0xeab, 0xea3, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1, 0xe95, 0xea3, 0x3b, 0xea1,
0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xeab, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeb5, 0x3b, 0xead, 0xeb2,
0xe9a, 0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0xea3, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2, 0xec1, 0xea1, 0xe99,
0x3b, 0xec0, 0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0xe9f, 0xea3, 0xeb2, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b, 0xead, 0xecd, 0xea3, 0xe94,
0xeb5, 0xe9a, 0xeb5, 0xec0, 0xeab, 0xeae, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1, 0xe95, 0xea3, 0x3b, 0xea1,
0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xea5, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeb5, 0x3b, 0xead, 0xeb2,
0xe9a, 0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2, 0xea1, 0xeb2, 0xe99, 0x3b,
0xec0, 0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0xe9f, 0xeb2, 0xea3, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b, 0xead, 0xecd, 0xea3, 0xe94, 0xeb5,
0xe9a, 0xeb5, 0xec0, 0xeab, 0xea3, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1, 0xe95, 0xea3, 0x3b, 0xea1, 0xecd,
0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xeab, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeb5, 0x3b, 0xead, 0xeb2, 0xe9a,
0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2, 0xea1, 0xeb2, 0xe99, 0x3b, 0xec0,
0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x12b, 0x6e, 0x73, 0x3b, 0x6f, 0x72, 0x64, 0x69,
0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x73, 0x3b, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x73, 0x3b, 0x74, 0x12b, 0x72, 0x73,
0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x73, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x113, 0x72, 0x73, 0x3b, 0x6d,
0x65, 0x68, 0x72, 0x73, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x73, 0x3b, 0x61, 0x7a, 0x65, 0x72, 0x73, 0x3b, 0x64, 0x65, 0x6a,
0x73, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x73, 0x444, 0x430, 0x440,
0x432, 0x430, 0x440, 0x434, 0x438, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x438, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442, 0x3b, 0x43a, 0x43e,
0x440, 0x434, 0x430, 0x434, 0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x448, 0x430, 0x445, 0x440,
0x438, 0x432, 0x430, 0x440, 0x3b, 0x43c, 0x435, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x434,
0x435, 0x458, 0x3b, 0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x435, 0x441, 0x444, 0x430, 0x43d, 0x434, 0xd2b, 0xd7c, 0xd35, 0xd3e,
0xd7c, 0xd26, 0xd3f, 0xd7b, 0x3b, 0xd13, 0xd7c, 0xd21, 0xd3f, 0xd2c, 0xd46, 0xd39, 0xd46, 0xd37, 0xd4d, 0x200c, 0xd31, 0xd4d, 0xd31, 0xd4d,
0x3b, 0xd16, 0xd4b, 0xd7c, 0xd26, 0xd3e, 0xd26, 0xd4d, 0x3b, 0xd1f, 0xd3f, 0xd7c, 0x3b, 0xd2e, 0xd4b, 0xd7c, 0xd26, 0xd3e, 0xd26, 0xd4d,
0x3b, 0xd37, 0xd39, 0xd4d, 0x200c, 0xd30, 0xd3f, 0xd35, 0xd3e, 0xd7c, 0x3b, 0xd2e, 0xd46, 0xd39, 0xd7c, 0x3b, 0xd05, 0xd2c, 0xd3e, 0xd7b,
0x3b, 0xd05, 0xd38, 0xd7c, 0x3b, 0xd21, 0xd46, 0xd2f, 0xd4d, 0x3b, 0xd2c, 0xd39, 0xd4d, 0x200c, 0xd2e, 0xd3e, 0xd7b, 0x3b, 0xd0e, 0xd38,
0xd4d, 0x200c, 0xd2b, 0xd3e, 0xd7b, 0xd21, 0xd4d, 0xd2b, 0x2e, 0x3b, 0xd13, 0x2e, 0x3b, 0xd16, 0xd4b, 0x3b, 0xd1f, 0xd3f, 0x2e, 0x3b,
0xd2e, 0xd4b, 0x2e, 0x3b, 0xd37, 0x2e, 0x3b, 0xd2e, 0xd46, 0x2e, 0x3b, 0xd05, 0x2e, 0x3b, 0xd05, 0x2e, 0x3b, 0xd21, 0xd46, 0x2e,
0x3b, 0xd2c, 0x2e, 0x3b, 0xd0e, 0x2e, 0x92b, 0x930, 0x935, 0x930, 0x926, 0x93f, 0x928, 0x3b, 0x913, 0x930, 0x94d, 0x926, 0x93f, 0x92c,
0x947, 0x939, 0x947, 0x936, 0x94d, 0x924, 0x3b, 0x916, 0x94b, 0x930, 0x926, 0x93e, 0x926, 0x3b, 0x924, 0x93f, 0x930, 0x3b, 0x92e, 0x94b,
0x930, 0x926, 0x93e, 0x926, 0x3b, 0x936, 0x93e, 0x939, 0x930, 0x940, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x947, 0x939, 0x947, 0x930, 0x3b,
0x905, 0x92c, 0x93e, 0x928, 0x3b, 0x905, 0x91d, 0x93e, 0x930, 0x3b, 0x926, 0x947, 0x3b, 0x92c, 0x93e, 0x939, 0x92e, 0x93e, 0x928, 0x3b,
0x90f, 0x938, 0x92b, 0x93e, 0x902, 0x926, 0x967, 0x3b, 0x968, 0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d, 0x3b,
0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967, 0x3b, 0x967, 0x968, 0x648, 0x631, 0x6cc, 0x3b, 0x63a, 0x648, 0x6cc, 0x6cc,
0x3b, 0x63a, 0x628, 0x631, 0x6af, 0x648, 0x644, 0x6cc, 0x3b, 0x686, 0x646, 0x6af, 0x627, 0x69a, 0x3b, 0x632, 0x645, 0x631, 0x6cc, 0x3b,
0x648, 0x696, 0x6cc, 0x3b, 0x62a, 0x644, 0x647, 0x3b, 0x644, 0x693, 0x645, 0x3b, 0x644, 0x6cc, 0x646, 0x62f, 0x6cd, 0x3b, 0x645, 0x631,
0x63a, 0x648, 0x645, 0x6cc, 0x3b, 0x633, 0x644, 0x648, 0x627, 0x63a, 0x647, 0x3b, 0x6a9, 0x628, 0x6f1, 0x3b, 0x6f2, 0x3b, 0x6f3, 0x3b,
0x6f4, 0x3b, 0x6f5, 0x3b, 0x6f6, 0x3b, 0x6f7, 0x3b, 0x6f8, 0x3b, 0x6f9, 0x3b, 0x6f1, 0x6f0, 0x3b, 0x6f1, 0x6f1, 0x3b, 0x6f1, 0x6f2,
0x641, 0x631, 0x648, 0x631, 0x62f, 0x6cc, 0x646, 0x3b, 0x627, 0x631, 0x62f, 0x6cc, 0x628, 0x647, 0x634, 0x62a, 0x3b, 0x62e, 0x631, 0x62f,
0x627, 0x62f, 0x3b, 0x62a, 0x6cc, 0x631, 0x3b, 0x645, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x647, 0x631, 0x6cc, 0x648, 0x631, 0x3b,
0x645, 0x647, 0x631, 0x3b, 0x622, 0x628, 0x627, 0x646, 0x3b, 0x622, 0x630, 0x631, 0x3b, 0x62f, 0x6cc, 0x3b, 0x628, 0x647, 0x645, 0x646,
0x3b, 0x627, 0x633, 0x641, 0x646, 0x62f, 0x641, 0x3b, 0x627, 0x3b, 0x62e, 0x3b, 0x62a, 0x3b, 0x645, 0x3b, 0x634, 0x3b, 0x645, 0x3b,
0x622, 0x3b, 0x622, 0x3b, 0x62f, 0x3b, 0x628, 0x3b, 0x627, 0x62d, 0x645, 0x644, 0x3b, 0x62b, 0x648, 0x631, 0x3b, 0x62c, 0x648, 0x632,
0x627, 0x3b, 0x633, 0x631, 0x637, 0x627, 0x646, 0x3b, 0x627, 0x633, 0x62f, 0x3b, 0x633, 0x646, 0x628, 0x644, 0x647, 0x654, 0x3b, 0x645,
0x6cc, 0x632, 0x627, 0x646, 0x3b, 0x639, 0x642, 0x631, 0x628, 0x3b, 0x642, 0x648, 0x633, 0x3b, 0x62c, 0x62f, 0x6cc, 0x3b, 0x62f, 0x644,
0x648, 0x3b, 0x62d, 0x648, 0x62a, 0x62d, 0x3b, 0x62b, 0x3b, 0x62c, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x645, 0x3b, 0x639,
0x3b, 0x642, 0x3b, 0x62c, 0x3b, 0x62f, 0x3b, 0x62d, 0x46, 0x61, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72,
0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x7a, 0x74, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x54, 0x69,
0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x53, 0x7a, 0x61, 0x68, 0x72, 0x69, 0x77, 0x61, 0x72, 0x3b, 0x4d,
0x65, 0x68, 0x72, 0x3b, 0x100, 0x62, 0x101, 0x6e, 0x3b, 0x100, 0x73, 0x61, 0x72, 0x3b, 0x44, 0xe9, 0x69, 0x3b, 0x42, 0x61,
0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0xa2b, 0xa3e, 0xa30, 0xa35, 0xa30, 0xa21, 0xa40, 0xa28, 0x3b,
0xa14, 0xa30, 0xa21, 0xa3e, 0xa08, 0xa2c, 0xa39, 0xa48, 0xa38, 0xa3c, 0xa1f, 0x3b, 0xa16, 0xa4b, 0xa21, 0xa30, 0xa21, 0x3b, 0xa1f, 0xa3f,
0xa30, 0x3b, 0xa2e, 0xa4b, 0xa30, 0xa21, 0xa3e, 0xa26, 0x3b, 0xa38, 0xa3c, 0xa30, 0xa3e, 0xa07, 0xa35, 0xa30, 0x3b, 0xa2e, 0xa47, 0xa39,
0xa30, 0x3b, 0xa05, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa05, 0xa1c, 0xa3c, 0xa3e, 0xa30, 0x3b, 0xa21, 0xa47, 0xa05, 0x3b, 0xa2c, 0xa3e, 0xa39,
0xa2e, 0xa28, 0x3b, 0xa10, 0xa38, 0xa2b, 0xa70, 0xa21, 0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72,
0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x54, 0x69,
0x72, 0x3b, 0x41, 0x2d, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72,
0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b,
0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x444, 0x430, 0x440, 0x432, 0x430, 0x440, 0x434,
0x438, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x438, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442, 0x3b, 0x445, 0x43e, 0x440, 0x434, 0x430, 0x434,
0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x448, 0x430, 0x445, 0x440, 0x438, 0x432, 0x435, 0x440,
0x3b, 0x43c, 0x435, 0x445, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b,
0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x44d, 0x441, 0x444, 0x430, 0x43d, 0x434, 0x46, 0x61, 0x72, 0x61, 0x76, 0x61, 0x64,
0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x4b, 0x6f, 0x72, 0x64, 0x61, 0x64,
0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x160, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72,
0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x6a, 0x3b,
0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x4a, 0x61, 0x6e, 0x61, 0x61, 0x79, 0x6f,
0x3b, 0x46, 0x65, 0x65, 0x62, 0x72, 0x61, 0x61, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x73, 0x6f, 0x3b, 0x41, 0x62,
0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4c, 0x75, 0x75, 0x6c, 0x69,
0x79, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x65, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x66, 0x65, 0x65, 0x6d, 0x62, 0x61,
0x72, 0x3b, 0x44, 0x69, 0x69, 0x73, 0x65, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69,
0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0x101,
0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76,
0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x100, 0x62, 0x101, 0x6e, 0x3b, 0x100, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65,
0x79, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x66, 0x61, 0x72, 0x76, 0x61,
0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x6b, 0x68, 0x6f,
0x72, 0x64, 0x101, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x73, 0x68, 0x61, 0x68,
0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0x101, 0x62, 0x101, 0x6e, 0x3b, 0x101, 0x7a, 0x61, 0x72,
0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x444, 0x430,
0x440, 0x432, 0x430, 0x440, 0x434, 0x438, 0x43d, 0x3b, 0x443, 0x440, 0x434, 0x438, 0x431, 0x438, 0x4b3, 0x438, 0x448, 0x442, 0x3b, 0x445,
0x443, 0x440, 0x434, 0x43e, 0x434, 0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x443, 0x440, 0x434, 0x43e, 0x434, 0x3b, 0x448, 0x430, 0x4b3,
0x440, 0x438, 0x432, 0x430, 0x440, 0x3b, 0x43c, 0x435, 0x4b3, 0x440, 0x3b, 0x43e, 0x431, 0x43e, 0x43d, 0x3b, 0x43e, 0x437, 0x430, 0x440,
0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x4b3, 0x43c, 0x430, 0x43d, 0x3b, 0x438, 0x441, 0x444, 0x430, 0x43d, 0x434, 0xb83, 0xbaa,
0xbb0, 0xbcd, 0xbb5, 0xbbe, 0xba4, 0xbbf, 0xba9, 0xbcd, 0x3b, 0xb86, 0xbb0, 0xbcd, 0xb9f, 0xbbf, 0xbaa, 0xbc6, 0xbb9, 0xbc6, 0xbb7, 0xbcd,
0xba4, 0xbcd, 0x3b, 0xb95, 0xbca, 0xbb0, 0xbcd, 0xba4, 0xbbe, 0xba4, 0xbcd, 0x3b, 0xba4, 0xbbf, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbca, 0xbb0,
0xbcd, 0xba4, 0xbbe, 0xba4, 0xbcd, 0x3b, 0xbb7, 0xbbe, 0xbb0, 0xbbf, 0xbb5, 0xbbe, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbc6, 0xbb9, 0xbcd, 0xbb0,
0xbcd, 0x3b, 0xb85, 0xbaa, 0xbbe, 0xba9, 0xbcd, 0x3b, 0xb85, 0xb9a, 0xbbe, 0xbb0, 0xbcd, 0x3b, 0xba4, 0xbc7, 0x3b, 0xbaa, 0xbb9, 0xbcd,
0xbae, 0xbbe, 0xba9, 0xbcd, 0x3b, 0xb8e, 0xb83, 0xbaa, 0xbbe, 0xba9, 0xbcd, 0xb83, 0xbaa, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xb86, 0xbb0, 0xbcd,
0xb9f, 0xbbf, 0x2e, 0x3b, 0xb95, 0xbca, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xba4, 0xbbf, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbca, 0xbb0, 0xbcd, 0x2e,
0x3b, 0xbb7, 0xbbe, 0xbb0, 0xbbf, 0x2e, 0x3b, 0xbae, 0xbc6, 0xbb9, 0xbcd, 0x2e, 0x3b, 0xb85, 0xbaa, 0xbbe, 0x2e, 0x3b, 0xb85, 0xb9a,
0xbbe, 0x2e, 0x3b, 0xba4, 0xbc7, 0x3b, 0xbaa, 0xbb9, 0xbcd, 0x2e, 0x3b, 0xb8e, 0xb83, 0x2e, 0xc2b, 0xc3e, 0xc35, 0xc30, 0xc4d, 0xc21,
0xc3f, 0xc28, 0xc4d, 0x3b, 0xc0a, 0xc21, 0xc3e, 0xc2c, 0xc39, 0xc37, 0xc4d, 0xc1f, 0xc4d, 0x3b, 0xc16, 0xc4b, 0xc30, 0xc4d, 0xc21, 0xc3e,
0xc21, 0xc4d, 0x3b, 0xc1f, 0xc3f, 0xc30, 0xc4d, 0x3b, 0xc2e, 0xc46, 0xc30, 0xc4d, 0xc21, 0xc3e, 0xc21, 0xc4d, 0x3b, 0xc36, 0xc36, 0xc3f,
0xc35, 0xc30, 0xc4d, 0x3b, 0xc2e, 0xc46, 0xc39, 0xc30, 0xc4d, 0x3b, 0xc05, 0xc2c, 0xc28, 0xc4d, 0x3b, 0xc05, 0xc1c, 0xc30, 0xc4d, 0x3b,
0xc21, 0xc47, 0x3b, 0xc2c, 0xc3e, 0xc39, 0xc4d, 0x200c, 0xc2e, 0xc3e, 0xc28, 0xc4d, 0x3b, 0xc0e, 0xc38, 0xc4d, 0x200c, 0xc2b, 0xc3e, 0xc02,
0xc21, 0xc4d, 0xe1f, 0xe32, 0xe23, 0xe4c, 0xe27, 0xe32, 0xe23, 0xe4c, 0xe14, 0xe34, 0xe19, 0x3b, 0xe2d, 0xe2d, 0xe23, 0xe4c, 0xe14, 0xe34,
0xe40, 0xe1a, 0xe40, 0xe2e, 0xe0a, 0xe15, 0xe4c, 0x3b, 0xe04, 0xe2d, 0xe23, 0xe4c, 0xe41, 0xe14, 0xe14, 0x3b, 0xe40, 0xe15, 0xe2d, 0xe23,
0xe4c, 0x3b, 0xe21, 0xe2d, 0xe23, 0xe4c, 0xe41, 0xe14, 0xe14, 0x3b, 0xe0a, 0xe32, 0xe2b, 0xe23, 0xe34, 0xe27, 0xe32, 0xe23, 0xe4c, 0x3b,
0xe40, 0xe21, 0xe2e, 0xe23, 0xe4c, 0x3b, 0xe2d, 0xe30, 0xe1a, 0xe32, 0xe19, 0x3b, 0xe2d, 0xe30, 0xe0b, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe40,
0xe14, 0xe22, 0xe4c, 0x3b, 0xe1a, 0xe32, 0xe2e, 0xe4c, 0xe21, 0xe32, 0xe19, 0x3b, 0xe40, 0xe2d, 0xe2a, 0xe1f, 0xe32, 0xe19, 0xe14, 0xe4c,
0x46, 0x65, 0x72, 0x76, 0x65, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x15f, 0x74,
0x3b, 0x48, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x15e,
0x65, 0x68, 0x72, 0x69, 0x76, 0x65, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a,
0x65, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x65, 0x68, 0x6d, 0x65, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x65, 0x6e, 0x64,
0x444, 0x430, 0x440, 0x432, 0x430, 0x440, 0x434, 0x456, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x456, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442,
0x3b, 0x445, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x442, 0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x448,
0x430, 0x445, 0x440, 0x456, 0x432, 0x435, 0x440, 0x3b, 0x43c, 0x435, 0x445, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437,
0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x435, 0x441, 0x444, 0x430, 0x43d, 0x434,
0x444, 0x430, 0x440, 0x3b, 0x43e, 0x440, 0x434, 0x3b, 0x445, 0x43e, 0x440, 0x3b, 0x442, 0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x3b,
0x448, 0x430, 0x445, 0x3b, 0x43c, 0x435, 0x445, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435,
0x439, 0x3b, 0x431, 0x430, 0x445, 0x3b, 0x435, 0x441, 0x444, 0x444, 0x430, 0x440, 0x2e, 0x3b, 0x43e, 0x440, 0x434, 0x2e, 0x3b, 0x445,
0x43e, 0x440, 0x2e, 0x3b, 0x442, 0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x2e, 0x3b, 0x448, 0x430, 0x445, 0x2e, 0x3b, 0x43c, 0x435,
0x445, 0x2e, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x445,
0x2e, 0x3b, 0x435, 0x441, 0x444, 0x2e, 0x641, 0x631, 0x648, 0x631, 0x62f, 0x646, 0x3b, 0x622, 0x631, 0x688, 0x628, 0x627, 0x626, 0x634,
0x3b, 0x62e, 0x62f, 0x627, 0x62f, 0x627, 0x62f, 0x3b, 0x62a, 0x6cc, 0x631, 0x3b, 0x645, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x6c1,
0x631, 0x6cc, 0x648, 0x627, 0x631, 0x3b, 0x645, 0x6c1, 0x631, 0x3b, 0x627, 0x628, 0x627, 0x646, 0x3b, 0x622, 0x632, 0x631, 0x3b, 0x688,
0x6d2, 0x3b, 0x628, 0x6c1, 0x645, 0x646, 0x3b, 0x627, 0x633, 0x641, 0x646, 0x62f
};
// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
