/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ProfilerStorageProvider {
    public abstract FileObject getGlobalFolder(boolean var1) throws IOException;

    public abstract void loadGlobalProperties(Properties var1, String var2) throws IOException;

    public abstract void saveGlobalProperties(Properties var1, String var2) throws IOException;

    public abstract void deleteGlobalProperties(String var1) throws IOException;

    public abstract FileObject getProjectFolder(Lookup.Provider var1, boolean var2) throws IOException;

    public abstract Lookup.Provider getProjectFromFolder(FileObject var1);

    public abstract void loadProjectProperties(Properties var1, Lookup.Provider var2, String var3) throws IOException;

    public abstract void saveProjectProperties(Properties var1, Lookup.Provider var2, String var3) throws IOException;

    public abstract void deleteProjectProperties(Lookup.Provider var1, String var2) throws IOException;

    public static abstract class Abstract
    extends ProfilerStorageProvider {
        protected String EXT = "xml";

        @Override
        public void loadGlobalProperties(Properties properties, String string) throws IOException {
            FileObject fileObject = this.getGlobalFolder(false);
            if (fileObject == null) {
                return;
            }
            FileObject fileObject2 = fileObject.getFileObject(string, this.EXT);
            if (fileObject2 == null) {
                return;
            }
            this.loadProperties(properties, fileObject2);
        }

        @Override
        public void saveGlobalProperties(Properties properties, String string) throws IOException {
            FileObject fileObject = this.getGlobalFolder(true);
            FileObject fileObject2 = fileObject.getFileObject(string, this.EXT);
            if (fileObject2 == null) {
                fileObject2 = fileObject.createData(string, this.EXT);
            }
            this.saveProperties(properties, fileObject2);
        }

        @Override
        public void deleteGlobalProperties(String string) throws IOException {
            FileObject fileObject;
            FileObject fileObject2 = this.getGlobalFolder(false);
            FileObject fileObject3 = fileObject = fileObject2 == null ? null : fileObject2.getFileObject(string, this.EXT);
            if (fileObject != null) {
                this.deleteProperties(fileObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadProjectProperties(Properties properties, Lookup.Provider provider, String string) throws IOException {
            FileObject fileObject = this.getProjectFolder(provider, false);
            if (fileObject == null) {
                return;
            }
            FileObject fileObject2 = fileObject.getFileObject(string, this.EXT);
            if (fileObject2 == null && (fileObject2 = fileObject.getFileObject(string, "pp")) != null) {
                FileLock fileLock = fileObject2.lock();
                try {
                    fileObject2.rename(fileLock, string, this.EXT);
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            if (fileObject2 == null) {
                return;
            }
            this.loadProperties(properties, fileObject2);
        }

        @Override
        public void saveProjectProperties(Properties properties, Lookup.Provider provider, String string) throws IOException {
            FileObject fileObject = this.getProjectFolder(provider, true);
            FileObject fileObject2 = fileObject.getFileObject(string, this.EXT);
            if (fileObject2 == null) {
                fileObject2 = fileObject.createData(string, this.EXT);
            }
            this.saveProperties(properties, fileObject2);
        }

        @Override
        public void deleteProjectProperties(Lookup.Provider provider, String string) throws IOException {
            FileObject fileObject;
            FileObject fileObject2 = this.getProjectFolder(provider, false);
            FileObject fileObject3 = fileObject = fileObject2 == null ? null : fileObject2.getFileObject(string, this.EXT);
            if (fileObject != null) {
                this.deleteProperties(fileObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadProperties(Properties properties, FileObject fileObject) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                InputStream inputStream = fileObject.getInputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    properties.loadFromXML(bufferedInputStream);
                }
                finally {
                    bufferedInputStream.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveProperties(Properties properties, FileObject fileObject) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                OutputStream outputStream = fileObject.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                try {
                    properties.storeToXML(bufferedOutputStream, "");
                }
                finally {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteProperties(FileObject fileObject) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                fileObject.delete();
            }
        }
    }
}

