/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DefaultViewerPopup
extends JPopupMenu {
    private final ImageViewer viewer;
    private static JFileChooser saveChooser;
    private static JButton saveChooserHelpButton;
    private static JLabel saveChooserHelpLabel;

    public DefaultViewerPopup(ImageViewer imageViewer) {
        this.viewer = imageViewer;
        final JCheckBoxMenuItem toggleStatusBarItem = new JCheckBoxMenuItem("Status bar");
        toggleStatusBarItem.setState(this.viewer.isStatusBarVisible());
        this.viewer.addPropertyChangeListener("statusBarVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                toggleStatusBarItem.setState(DefaultViewerPopup.this.viewer.isStatusBarVisible());
            }
        });
        toggleStatusBarItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultViewerPopup.this.viewer.setStatusBarVisible(!DefaultViewerPopup.this.viewer.isStatusBarVisible());
            }
        });
        JMenu zoomMenu = new JMenu("Zoom");
        final JRadioButtonMenuItem zoomOriginalSize = new JRadioButtonMenuItem("Original size", this.viewer.getResizeStrategy() == ResizeStrategy.NO_RESIZE);
        zoomOriginalSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultViewerPopup.this.viewer.setResizeStrategy(ResizeStrategy.NO_RESIZE);
            }
        });
        final JRadioButtonMenuItem zoomShrinkToFit = new JRadioButtonMenuItem("Shrink to fit", this.viewer.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT);
        zoomShrinkToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultViewerPopup.this.viewer.setResizeStrategy(ResizeStrategy.SHRINK_TO_FIT);
            }
        });
        final JRadioButtonMenuItem zoomResizeToFit = new JRadioButtonMenuItem("Resize to fit", this.viewer.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT);
        zoomResizeToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultViewerPopup.this.viewer.setResizeStrategy(ResizeStrategy.RESIZE_TO_FIT);
            }
        });
        class CustomZoomEntry {
            String label;
            double value;
            JRadioButtonMenuItem menuItem;

            CustomZoomEntry(String label, double value) {
                this.label = label;
                this.value = value;
                this.menuItem = new JRadioButtonMenuItem(label, DefaultViewerPopup.this.viewer.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM && DefaultViewerPopup.this.viewer.getZoomFactor() == value);
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultViewerPopup.this.viewer.setResizeStrategy(ResizeStrategy.CUSTOM_ZOOM);
                        DefaultViewerPopup.this.viewer.setZoomFactor(value);
                    }
                });
            }
        }
        final CustomZoomEntry[] customZoomEntries = new CustomZoomEntry[]{new CustomZoomEntry("25%", 0.25), new CustomZoomEntry("50%", 0.5), new CustomZoomEntry("75%", 0.75), new CustomZoomEntry("100%", 1.0), new CustomZoomEntry("150%", 1.5), new CustomZoomEntry("200%", 2.0), new CustomZoomEntry("300%", 3.0), new CustomZoomEntry("500%", 5.0), new CustomZoomEntry("1000%", 10.0), new CustomZoomEntry("2000%", 20.0), new CustomZoomEntry("5000%", 50.0)};
        final ButtonGroup group = new ButtonGroup();
        group.add(zoomOriginalSize);
        group.add(zoomShrinkToFit);
        group.add(zoomResizeToFit);
        zoomMenu.add(zoomOriginalSize);
        zoomMenu.add(zoomShrinkToFit);
        zoomMenu.add(zoomResizeToFit);
        zoomMenu.add(new JSeparator());
        for (CustomZoomEntry cze : customZoomEntries) {
            zoomMenu.add(cze.menuItem);
            group.add(cze.menuItem);
        }
        this.viewer.addPropertyChangeListener("resizeStrategy", new PropertyChangeListener(){
            {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block0 : switch ((ResizeStrategy)((Object)evt.getNewValue())) {
                    case NO_RESIZE: {
                        zoomOriginalSize.setSelected(true);
                        break;
                    }
                    case RESIZE_TO_FIT: {
                        zoomResizeToFit.setSelected(true);
                        break;
                    }
                    case SHRINK_TO_FIT: {
                        zoomShrinkToFit.setSelected(true);
                        break;
                    }
                    case CUSTOM_ZOOM: {
                        group.clearSelection();
                        for (CustomZoomEntry cze : customZoomEntries) {
                            if (cze.value != DefaultViewerPopup.this.viewer.getZoomFactor()) continue;
                            cze.menuItem.setSelected(true);
                            break block0;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown resize strategy: " + evt.getNewValue()));
                    }
                }
            }
        });
        this.viewer.addPropertyChangeListener("zoomFactor", new PropertyChangeListener(){
            {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DefaultViewerPopup.this.viewer.getResizeStrategy() == ResizeStrategy.CUSTOM_ZOOM) {
                    group.clearSelection();
                    for (CustomZoomEntry cze : customZoomEntries) {
                        if (cze.value != DefaultViewerPopup.this.viewer.getZoomFactor()) continue;
                        cze.menuItem.setSelected(true);
                        break;
                    }
                }
            }
        });
        JMenuItem saveImageMenuItem = new JMenuItem("Save image...");
        saveImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (saveChooser == null) {
                    saveChooser = new JFileChooser();
                    saveChooserHelpLabel = new JLabel();
                    saveChooserHelpLabel.setText("<html>If the file name ends<br>with '.png' or '.jpg',<br>then the appropriate<br>format is used.<br>Otherwise '.png' is<br>appended to the name.");
                    saveChooserHelpLabel.setFont(saveChooserHelpLabel.getFont().deriveFont(10.0f));
                    saveChooserHelpButton = new JButton("?");
                    saveChooserHelpButton.setMargin(new Insets(0, 2, 0, 2));
                    saveChooserHelpButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            saveChooser.getAccessory().removeAll();
                            saveChooser.getAccessory().add(saveChooserHelpLabel);
                            saveChooser.revalidate();
                            saveChooser.repaint();
                        }
                    });
                    saveChooserHelpLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            saveChooser.getAccessory().removeAll();
                            saveChooser.getAccessory().add(saveChooserHelpButton);
                            saveChooser.revalidate();
                            saveChooser.repaint();
                        }
                    });
                    saveChooser.setAccessory(new JPanel());
                    saveChooser.setDialogTitle("Save image...");
                    saveChooser.setFileFilter(new FileNameExtensionFilter("JPG and PNG images", "jpg", "png"));
                }
                saveChooser.getAccessory().removeAll();
                saveChooser.getAccessory().add(saveChooserHelpButton);
                if (0 == saveChooser.showSaveDialog(DefaultViewerPopup.this.viewer.getComponent())) {
                    File f = saveChooser.getSelectedFile();
                    BufferedImage image = DefaultViewerPopup.this.viewer.getImage();
                    if (image == null) {
                        JOptionPane.showMessageDialog(DefaultViewerPopup.this.viewer.getComponent(), "No image", "Error", 0);
                    } else {
                        String name = f.getName().toLowerCase();
                        try {
                            if (name.endsWith(".jpg")) {
                                ImageIO.write((RenderedImage)image, "jpg", f);
                            } else if (name.endsWith(".png")) {
                                ImageIO.write((RenderedImage)image, "png", f);
                            } else {
                                f = new File(f.getPath() + ".png");
                                ImageIO.write((RenderedImage)image, "png", f);
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(DefaultViewerPopup.this.viewer.getComponent(), "<html>Cannot write image to " + f.getAbsolutePath() + ":<br>" + ex.getMessage(), "Error", 0);
                        }
                    }
                }
            }
        });
        final JCheckBoxMenuItem togglePixelatedZoomItem = new JCheckBoxMenuItem("Pixelated zoom");
        togglePixelatedZoomItem.setState(this.viewer.isPixelatedZoom());
        this.viewer.addPropertyChangeListener("pixelatedZoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                togglePixelatedZoomItem.setState(DefaultViewerPopup.this.viewer.isPixelatedZoom());
            }
        });
        togglePixelatedZoomItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultViewerPopup.this.viewer.setPixelatedZoom(!DefaultViewerPopup.this.viewer.isPixelatedZoom());
            }
        });
        this.add(toggleStatusBarItem);
        this.add(zoomMenu);
        this.add(togglePixelatedZoomItem);
        this.add(saveImageMenuItem);
    }
}

