/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

public class NiceScale {
    private double min;
    private double max;
    private double maxTicks = 10.0;
    private double tickSpacing;
    private double range;
    private double niceMin;
    private double niceMax;

    public NiceScale(double MIN, double MAX) {
        this.min = MIN;
        this.max = MAX;
        this.calculate();
    }

    private void calculate() {
        this.range = this.niceNum(this.max - this.min, false);
        this.tickSpacing = this.niceNum(this.range / (this.maxTicks - 1.0), true);
        this.niceMin = Math.floor(this.min / this.tickSpacing) * this.tickSpacing;
        this.niceMax = Math.ceil(this.max / this.tickSpacing) * this.tickSpacing;
    }

    private double niceNum(double RANGE, boolean ROUND) {
        double exponent = Math.floor(Math.log10(RANGE));
        double fraction = RANGE / Math.pow(10.0, exponent);
        double niceFraction = ROUND ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public void setMinMax(double MIN, double MAX) {
        this.min = MIN;
        this.max = MAX;
        this.calculate();
    }

    public void setMaxTicks(double MAX_TICKS) {
        this.maxTicks = MAX_TICKS;
        this.calculate();
    }

    public double getTickSpacing() {
        return this.tickSpacing;
    }

    public double getNiceMin() {
        return this.niceMin;
    }

    public double getNiceMax() {
        return this.niceMax;
    }
}

