/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete.workarounds;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class MacOSXPopupLocationFix {
    private final JComboBox comboBox;
    private final JPopupMenu popupMenu;
    private final Listener listener = new Listener();

    private MacOSXPopupLocationFix(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.popupMenu = (JPopupMenu)comboBox.getUI().getAccessibleChild(comboBox, 0);
        this.popupMenu.addPopupMenuListener(this.listener);
    }

    public static MacOSXPopupLocationFix install(JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException();
        }
        return new MacOSXPopupLocationFix(comboBox);
    }

    public void uninstall() {
        this.popupMenu.removePopupMenuListener(this.listener);
    }

    private void fixPopupLocation(JComponent popupComponent) {
        if (popupComponent.getClass().getName().indexOf("apple.laf") != 0) {
            return;
        }
        Point comboLocationOnScreen = this.comboBox.getLocationOnScreen();
        int comboHeight = this.comboBox.getHeight();
        int popupY = comboLocationOnScreen.y + comboHeight;
        Rectangle screenBounds = new ScreenGeometry(this.comboBox).getScreenBounds();
        int popupHeight = popupComponent.getPreferredSize().height;
        if (comboLocationOnScreen.y + comboHeight + popupHeight > screenBounds.x + screenBounds.height) {
            popupY = comboLocationOnScreen.y - popupHeight;
        }
        popupComponent.setLocation(comboLocationOnScreen.x, popupY);
    }

    private static final class ScreenGeometry {
        final GraphicsConfiguration graphicsConfiguration;
        final boolean aqua = UIManager.getLookAndFeel().getName().indexOf("Aqua") != -1;

        public ScreenGeometry(JComponent component) {
            this.graphicsConfiguration = this.graphicsConfigurationForComponent(component);
        }

        private GraphicsConfiguration graphicsConfigurationForComponent(Component component) {
            Point point = component.getLocationOnScreen();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gd = ge.getScreenDevices();
            for (int i = 0; i < gd.length; ++i) {
                GraphicsConfiguration defaultGraphicsConfiguration;
                if (gd[i].getType() != 0 || !(defaultGraphicsConfiguration = gd[i].getDefaultConfiguration()).getBounds().contains(point)) continue;
                return defaultGraphicsConfiguration;
            }
            return component.getGraphicsConfiguration();
        }

        public Rectangle getScreenBounds() {
            Rectangle screenSize = this.getScreenSize();
            Insets screenInsets = this.getScreenInsets();
            return new Rectangle(screenSize.x + screenInsets.left, screenSize.y + screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
        }

        public Rectangle getScreenSize() {
            if (this.graphicsConfiguration != null) {
                return this.graphicsConfiguration.getBounds();
            }
            return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }

        public Insets getScreenInsets() {
            Insets screenInsets = this.graphicsConfiguration != null ? Toolkit.getDefaultToolkit().getScreenInsets(this.graphicsConfiguration) : new Insets(0, 0, 0, 0);
            if (this.aqua) {
                int aquaBottomInsets = 21;
                int aquaTopInsets = 22;
                screenInsets.bottom = Math.max(screenInsets.bottom, aquaBottomInsets);
                screenInsets.top = Math.max(screenInsets.top, aquaTopInsets);
            }
            return screenInsets;
        }
    }

    private class Listener
    implements PopupMenuListener {
        private Listener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComponent popupComponent = (JComponent)e.getSource();
            MacOSXPopupLocationFix.this.fixPopupLocation(popupComponent);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

