// Generated by gmmproc 2.66.0 -- DO NOT MODIFY!
#ifndef _GIOMM_MOUNTOPERATION_H
#define _GIOMM_MOUNTOPERATION_H

#include <giommconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <glibmm/arrayhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GMountOperation = struct _GMountOperation;
using GMountOperationClass = struct _GMountOperationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gio
{ class GIOMM_API MountOperation_Class; } // namespace Gio
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/** 
 *  @var AskPasswordFlags ASK_PASSWORD_NEED_PASSWORD
 * Operation requires a password.
 * 
 *  @var AskPasswordFlags ASK_PASSWORD_NEED_USERNAME
 * Operation requires a username.
 * 
 *  @var AskPasswordFlags ASK_PASSWORD_NEED_DOMAIN
 * Operation requires a domain.
 * 
 *  @var AskPasswordFlags ASK_PASSWORD_SAVING_SUPPORTED
 * Operation supports saving settings.
 * 
 *  @var AskPasswordFlags ASK_PASSWORD_ANONYMOUS_SUPPORTED
 * Operation supports anonymous users.
 * 
 *  @var AskPasswordFlags ASK_PASSWORD_TCRYPT
 * Operation takes TCRYPT parameters (Since: 2.58).
 * 
 *  @enum AskPasswordFlags
 * 
 * AskPasswordFlags are used to request specific information from the
 * user, or to notify the user of their choices in an authentication
 * situation.
 *
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%AskPasswordFlags operator|(AskPasswordFlags, AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags operator&(AskPasswordFlags, AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags operator^(AskPasswordFlags, AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags operator~(AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags& operator|=(AskPasswordFlags&, AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags& operator&=(AskPasswordFlags&, AskPasswordFlags)</tt><br>
 * <tt>%AskPasswordFlags& operator^=(AskPasswordFlags&, AskPasswordFlags)</tt><br>
 */
enum AskPasswordFlags
{
  ASK_PASSWORD_NEED_PASSWORD = (1 << 0),
  ASK_PASSWORD_NEED_USERNAME = (1 << 1),
  ASK_PASSWORD_NEED_DOMAIN = (1 << 2),
  ASK_PASSWORD_SAVING_SUPPORTED = (1 << 3),
  ASK_PASSWORD_ANONYMOUS_SUPPORTED = (1 << 4),
  ASK_PASSWORD_TCRYPT = (1 << 5)
};

/** @ingroup giommEnums */
inline AskPasswordFlags operator|(AskPasswordFlags lhs, AskPasswordFlags rhs)
  { return static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AskPasswordFlags operator&(AskPasswordFlags lhs, AskPasswordFlags rhs)
  { return static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AskPasswordFlags operator^(AskPasswordFlags lhs, AskPasswordFlags rhs)
  { return static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AskPasswordFlags operator~(AskPasswordFlags flags)
  { return static_cast<AskPasswordFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline AskPasswordFlags& operator|=(AskPasswordFlags& lhs, AskPasswordFlags rhs)
  { return (lhs = static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline AskPasswordFlags& operator&=(AskPasswordFlags& lhs, AskPasswordFlags rhs)
  { return (lhs = static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline AskPasswordFlags& operator^=(AskPasswordFlags& lhs, AskPasswordFlags rhs)
  { return (lhs = static_cast<AskPasswordFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** 
 *  @var PasswordSave PASSWORD_SAVE_NEVER
 * Never save a password.
 * 
 *  @var PasswordSave PASSWORD_SAVE_FOR_SESSION
 * Save a password for the session.
 * 
 *  @var PasswordSave PASSWORD_SAVE_PERMANENTLY
 * Save a password permanently.
 * 
 *  @enum PasswordSave
 * 
 * PasswordSave is used to indicate the lifespan of a saved password.
 * 
 * #Gvfs stores passwords in the Gnome keyring when this flag allows it
 * to, and later retrieves it again from there.
 *
 * @ingroup giommEnums
 */
enum PasswordSave
{
  PASSWORD_SAVE_NEVER,
  PASSWORD_SAVE_FOR_SESSION,
  PASSWORD_SAVE_PERMANENTLY
};

} // namespace Gio

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GIOMM_API Value<Gio::PasswordSave> : public Glib::Value_Enum<Gio::PasswordSave>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gio
{

/** 
 *  @var MountOperationResult MOUNT_OPERATION_HANDLED
 * The request was fulfilled and the
 * user specified data is now available.
 * 
 *  @var MountOperationResult MOUNT_OPERATION_ABORTED
 * The user requested the mount operation
 * to be aborted.
 * 
 *  @var MountOperationResult MOUNT_OPERATION_UNHANDLED
 * The request was unhandled (i.e. not
 * implemented).
 * 
 *  @enum MountOperationResult
 * 
 * MountOperationResult is returned as a result when a request for
 * information is send by the mounting operation.
 *
 * @ingroup giommEnums
 */
enum MountOperationResult
{
  MOUNT_OPERATION_HANDLED,
  MOUNT_OPERATION_ABORTED,
  MOUNT_OPERATION_UNHANDLED
};


/** Authentication methods for mountable locations.
 *
 * MountOperation provides a mechanism for authenticating mountable operations, such as loop mounting files, hard drive partitions or server locations.
 *
 * Mounting operations are handed a MountOperation that they can use if they require any privileges or authentication for their volumes to be mounted (e.g.
 * a hard disk partition or an encrypted filesystem), or if they are implementing a remote server protocol which requires user credentials such as FTP or
 * WebDAV.
 *
 * Developers should instantiate a subclass of this that implements all the various callbacks to show the required dialogs.
 *
 * @newin{2,16}
 */

class GIOMM_API MountOperation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = MountOperation;
  using CppClassType = MountOperation_Class;
  using BaseObjectType = GMountOperation;
  using BaseClassType = GMountOperationClass;

  // noncopyable
  MountOperation(const MountOperation&) = delete;
  MountOperation& operator=(const MountOperation&) = delete;

private:  friend class MountOperation_Class;
  static CppClassType mountoperation_class_;

protected:
  explicit MountOperation(const Glib::ConstructParams& construct_params);
  explicit MountOperation(GMountOperation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  MountOperation(MountOperation&& src) noexcept;
  MountOperation& operator=(MountOperation&& src) noexcept;

  ~MountOperation() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GMountOperation*       gobj()       { return reinterpret_cast<GMountOperation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GMountOperation* gobj() const { return reinterpret_cast<GMountOperation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GMountOperation* gobj_copy();

private:


protected:
  MountOperation();

public:
  
  static Glib::RefPtr<MountOperation> create();


  /** Get the user name from the mount operation.
   * 
   * @return A string containing the user name.
   */
  Glib::ustring get_username() const;
  
  /** Sets the user name within @a op to @a username.
   * 
   * @param username Input username.
   */
  void set_username(const Glib::ustring& username);
  
  /** Gets a password from the mount operation.
   * 
   * @return A string containing the password within @a op.
   */
  Glib::ustring get_password() const;
  
  /** Sets the mount operation's password to @a password.
   * 
   * @param password Password to set.
   */
  void set_password(const Glib::ustring& password);
  
  /** Check to see whether the mount operation is being used 
   * for an anonymous user.
   * 
   * @return <tt>true</tt> if mount operation is anonymous.
   */
  bool get_anonymous() const;
  
  /** Sets the mount operation to use an anonymous user if @a anonymous is <tt>true</tt>.
   * 
   * @param anonymous Boolean value.
   */
  void set_anonymous(bool anonymous =  true);
  
  /** Gets the domain of the mount operation.
   * 
   * @return A string set to the domain.
   */
  Glib::ustring get_domain() const;
  
  /** Sets the mount operation's domain.
   * 
   * @param domain The domain to set.
   */
  void set_domain(const Glib::ustring& domain);
  
  /** Gets the state of saving passwords for the mount operation.
   * 
   * @return A PasswordSave flag.
   */
  PasswordSave get_password_save() const;
  
  /** Sets the state of saving passwords for the mount operation.
   * 
   * @param save A set of PasswordSave flags.
   */
  void set_password_save(PasswordSave save);
  
  /** Gets a choice from the mount operation.
   * 
   * @return An integer containing an index of the user's choice from 
   * the choice's list, or `0`.
   */
  int get_choice() const;
  
  /** Sets a default choice for the mount operation.
   * 
   * @param choice An integer.
   */
  void set_choice(int choice);
  
  /** Emits the MountOperation::signal_reply() signal.
   * 
   * @param result A MountOperationResult.
   */
  void reply(MountOperationResult result);


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%ask_password(const Glib::ustring& message, const Glib::ustring& default_user, const Glib::ustring& default_domain, AskPasswordFlags flags)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when a mount operation asks the user for a password.
   * 
   * If the message contains a line break, the first line should be
   * presented as a heading. For example, it may be used as the
   * primary text in a Gtk::MessageDialog.
   * 
   * @param message String containing a message to display to the user.
   * @param default_user String containing the default user name.
   * @param default_domain String containing the default domain.
   * @param flags A set of AskPasswordFlags.
   */

  Glib::SignalProxy< void,const Glib::ustring&,const Glib::ustring&,const Glib::ustring&,AskPasswordFlags > signal_ask_password();


  //TODO: We really need some test to make sure that our use of StringArrayHandle is correct. murrayc.
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%ask_question(const Glib::ustring& message, const Glib::StringArrayHandle& choices)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when asking the user a question and gives a list of
   * choices for the user to choose from.
   * 
   * If the message contains a line break, the first line should be
   * presented as a heading. For example, it may be used as the
   * primary text in a Gtk::MessageDialog.
   * 
   * @param message String containing a message to display to the user.
   * @param choices An array of strings for each possible choice.
   */

  Glib::SignalProxy< void,const Glib::ustring&,const Glib::StringArrayHandle& > signal_ask_question();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%reply(MountOperationResult result)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when the user has replied to the mount operation.
   * 
   * @param result A MountOperationResult indicating how the request was handled.
   */

  Glib::SignalProxy< void,MountOperationResult > signal_reply();


  //TODO: Remove no_default_handler when we can break ABI:
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%aborted()</tt>
   *
   * Flags: Run Last
   *
   * Emitted by the backend when e.g.\ a device becomes unavailable
   * while a mount operation is in progress.
   * 
   * Implementations of GMountOperation should handle this signal
   * by dismissing open password dialogs.
   * 
   * @newin{2,20}
   */

  Glib::SignalProxy< void > signal_aborted();


  //TODO: The array of char* is not very pleasant to wrap:
  //_WRAP_SIGNAL( void show_processes(const Glib::ustring& message, GArray* processes, const gchar *choices[]);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%show_unmount_progress(const Glib::ustring& message, gint64 time_left, gint64 bytes_left)</tt>
   *
   * Flags: Run Last
   *
   * Emitted when an unmount operation has been busy for more than some time
   * (typically 1.5 seconds).
   * 
   * When unmounting or ejecting a volume, the kernel might need to flush
   * pending data in its buffers to the volume stable storage, and this operation
   * can take a considerable amount of time. This signal may be emitted several
   * times as long as the unmount operation is outstanding, and then one
   * last time when the operation is completed, with @a bytes_left set to zero.
   * 
   * Implementations of GMountOperation should handle this signal by
   * showing an UI notification, and then dismiss it, or show another notification
   * of completion, when @a bytes_left reaches zero.
   * 
   * If the message contains a line break, the first line should be
   * presented as a heading. For example, it may be used as the
   * primary text in a Gtk::MessageDialog.
   * 
   * @newin{2,34}
   * 
   * @param message String containing a message to display to the user.
   * @param time_left The estimated time left before the operation completes,
   * in microseconds, or -1.
   * @param bytes_left The amount of bytes to be written before the operation
   * completes (or -1 if such amount is not known), or zero if the operation
   * is completed.
   */

  Glib::SignalProxy< void,const Glib::ustring&,gint64,gint64 > signal_show_unmount_progress();


  /** The user name that is used for authentication when carrying out
   * the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_username() ;

/** The user name that is used for authentication when carrying out
   * the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_username() const;

  /** The password that is used for authentication when carrying out
   * the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_password() ;

/** The password that is used for authentication when carrying out
   * the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_password() const;

  /** Whether to use an anonymous user when authenticating.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_anonymous() ;

/** Whether to use an anonymous user when authenticating.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_anonymous() const;

  /** The domain to use for the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_domain() ;

/** The domain to use for the mount operation.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_domain() const;

  /** Determines if and how the password information should be saved.
   *
   * Default value: PASSWORD_SAVE_NEVER
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PasswordSave > property_password_save() ;

/** Determines if and how the password information should be saved.
   *
   * Default value: PASSWORD_SAVE_NEVER
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PasswordSave > property_password_save() const;

  /** The index of the user's choice when a question is asked during the 
   * mount operation. See the MountOperation::signal_ask_question() signal.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_choice() ;

/** The index of the user's choice when a question is asked during the 
   * mount operation. See the MountOperation::signal_ask_question() signal.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_choice() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_ask_password().
  virtual void on_ask_password(const Glib::ustring& message, const Glib::ustring& default_user, const Glib::ustring& default_domain, AskPasswordFlags flags);
  /// This is a default handler for the signal signal_ask_question().
  virtual void on_ask_question(const Glib::ustring& message, const Glib::StringArrayHandle& choices);
  /// This is a default handler for the signal signal_reply().
  virtual void on_reply(MountOperationResult result);


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::MountOperation
   */
  GIOMM_API
  Glib::RefPtr<Gio::MountOperation> wrap(GMountOperation* object, bool take_copy = false);
}


#endif /* _GIOMM_MOUNTOPERATION_H */

