/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.AutoValue_CodingConvention_AssertionFunctionSpec;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@Immutable
public interface CodingConvention
extends Serializable {
    public boolean isConstant(String var1);

    public boolean isConstantKey(String var1);

    public boolean isValidEnumKey(String var1);

    public boolean isOptionalParameter(Node var1);

    public boolean isVarArgsParameter(Node var1);

    public boolean isFunctionCallThatAlwaysThrows(Node var1);

    public boolean isExported(String var1, boolean var2);

    default public boolean isExported(String name) {
        return this.isExported(name, true) || this.isExported(name, false);
    }

    public boolean blockRenamingForProperty(String var1);

    public String getPackageName(StaticSourceFile var1);

    public boolean isPrivate(String var1);

    public boolean hasPrivacyConvention();

    public SubclassRelationship getClassesDefinedByCall(Node var1);

    public boolean isClassFactoryCall(Node var1);

    public boolean isSuperClassReference(String var1);

    public boolean extractIsModuleFile(Node var1, Node var2);

    public String extractClassNameIfProvide(Node var1, Node var2);

    public String extractClassNameIfRequire(Node var1, Node var2);

    public String getExportPropertyFunction();

    public String getExportSymbolFunction();

    public List<String> identifyTypeDeclarationCall(Node var1);

    public void applySubclassRelationship(NominalTypeBuilder var1, NominalTypeBuilder var2, SubclassType var3);

    public String getAbstractMethodName();

    public String getSingletonGetterClassName(Node var1);

    public void applySingletonGetter(NominalTypeBuilder var1, FunctionType var2);

    public boolean isInlinableFunction(Node var1);

    public DelegateRelationship getDelegateRelationship(Node var1);

    public void applyDelegateRelationship(NominalTypeBuilder var1, NominalTypeBuilder var2, NominalTypeBuilder var3, ObjectType var4, FunctionType var5);

    public String getDelegateSuperclassName();

    public void checkForCallingConventionDefinitions(Node var1, Map<String, String> var2);

    public void defineDelegateProxyPrototypeProperties(JSTypeRegistry var1, List<NominalTypeBuilder> var2, Map<String, String> var3);

    public String getGlobalObject();

    public Bind describeFunctionBind(Node var1);

    public Bind describeFunctionBind(Node var1, boolean var2, boolean var3);

    public Cache describeCachingCall(Node var1);

    public boolean isPropertyTestFunction(Node var1);

    public boolean isPrototypeAlias(Node var1);

    public boolean isPropertyRenameFunction(String var1);

    public ObjectLiteralCast getObjectLiteralCast(Node var1);

    public Collection<String> getIndirectlyDeclaredProperties();

    public Collection<AssertionFunctionSpec> getAssertionFunctions();

    @Immutable
    public static final class AssertionFunctionLookup {
        private final ImmutableMap<Object, AssertionFunctionSpec> internal;

        private AssertionFunctionLookup(ImmutableMap<Object, AssertionFunctionSpec> internal) {
            this.internal = internal;
        }

        static AssertionFunctionLookup of(Collection<AssertionFunctionSpec> specs) {
            ImmutableMap<Object, AssertionFunctionSpec> idToSpecMap = specs.stream().collect(ImmutableMap.toImmutableMap(rec$ -> ((AssertionFunctionSpec)rec$).getId(), Function.identity()));
            return new AssertionFunctionLookup(idToSpecMap);
        }

        @Nullable
        AssertionFunctionSpec lookupByCallee(Node callee) {
            AssertionFunctionSpec spec;
            FunctionType fnType = JSType.toMaybeFunctionType(callee.getJSType());
            if (fnType != null && fnType.getClosurePrimitive() != null && (spec = this.internal.get((Object)fnType.getClosurePrimitive())) != null) {
                return spec;
            }
            if (callee.isQualifiedName()) {
                return this.internal.get(callee.getQualifiedName());
            }
            return null;
        }
    }

    @Immutable
    @AutoValue
    public static abstract class AssertionFunctionSpec {
        @Nullable
        abstract String getFunctionName();

        @Nullable
        abstract ClosurePrimitive getClosurePrimitive();

        abstract AssertionKind getAssertionKind();

        abstract int getParamIndex();

        static Builder builder() {
            return new AutoValue_CodingConvention_AssertionFunctionSpec.Builder().setParamIndex(0);
        }

        public static Builder forTruthy() {
            return AssertionFunctionSpec.builder().setAssertionKind(AssertionKind.TRUTHY);
        }

        public static Builder forMatchesReturn() {
            return AssertionFunctionSpec.builder().setAssertionKind(AssertionKind.MATCHES_RETURN_TYPE);
        }

        private Object getId() {
            return this.getClosurePrimitive() != null ? this.getClosurePrimitive() : this.getFunctionName();
        }

        @Nullable
        Node getAssertedArg(Node firstArg) {
            for (int i = 0; i < this.getParamIndex(); ++i) {
                if (firstArg == null) {
                    return null;
                }
                firstArg = firstArg.getNext();
            }
            return firstArg;
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setFunctionName(String var1);

            abstract Builder setClosurePrimitive(ClosurePrimitive var1);

            public abstract Builder setParamIndex(int var1);

            abstract Builder setAssertionKind(AssertionKind var1);

            abstract AssertionFunctionSpec autoBuild();

            public AssertionFunctionSpec build() {
                AssertionFunctionSpec spec = this.autoBuild();
                Preconditions.checkState(spec.getFunctionName() != null || spec.getClosurePrimitive() != null, "Must provide a function name or ClosurePrimitive for each spec");
                return spec;
            }
        }

        public static enum AssertionKind {
            TRUTHY,
            MATCHES_RETURN_TYPE;

        }
    }

    public static class ObjectLiteralCast {
        final String typeName;
        final Node objectNode;
        final DiagnosticType diagnosticType;

        ObjectLiteralCast(String typeName, Node objectNode, DiagnosticType diagnosticType) {
            this.typeName = typeName;
            this.objectNode = objectNode;
            this.diagnosticType = diagnosticType;
        }
    }

    public static class DelegateRelationship {
        final String delegateBase;
        final String delegator;

        DelegateRelationship(String delegateBase, String delegator) {
            this.delegateBase = delegateBase;
            this.delegator = delegator;
        }
    }

    public static class SubclassRelationship {
        final SubclassType type;
        final String subclassName;
        final String superclassName;

        public SubclassRelationship(SubclassType type, Node subclassNode, Node superclassNode) {
            Preconditions.checkArgument(subclassNode.isQualifiedName(), "Expected qualified name, found: %s", (Object)subclassNode);
            Preconditions.checkArgument(superclassNode.isQualifiedName(), "Expected qualified name, found: %s", (Object)superclassNode);
            this.type = type;
            this.subclassName = subclassNode.getQualifiedName();
            this.superclassName = superclassNode.getQualifiedName();
        }
    }

    public static enum SubclassType {
        INHERITS,
        MIXIN;

    }

    public static class Cache {
        final Node cacheObj;
        final Node key;
        final Node valueFn;
        final Node keyFn;

        public Cache(Node cacheObj, Node key, Node valueFn, Node keyFn) {
            this.cacheObj = cacheObj;
            this.key = key;
            this.valueFn = valueFn;
            this.keyFn = keyFn;
        }
    }

    public static class Bind {
        final Node target;
        final Node thisValue;
        final Node parameters;

        public Bind(Node target, Node thisValue, Node parameters) {
            this.target = target;
            this.thisValue = thisValue;
            this.parameters = parameters;
        }

        int getBoundParameterCount() {
            if (this.parameters == null) {
                return 0;
            }
            Node paramParent = this.parameters.getParent();
            return paramParent.getChildCount() - paramParent.getIndexOfChild(this.parameters);
        }
    }
}

