/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.disambiguate.TypeFlattener;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.graph.LowestCommonAncestorFinder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;

final class TypeGraphBuilder {
    private final TypeFlattener flattener;
    private final LowestCommonAncestorFinder<FlatType, Object> lcaFinder;
    private final LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> topNode;
    private LinkedDirectedGraph<FlatType, Object> typeHoldsInstanceGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final ArrayList<TypeMismatch> deferredForcedEdges = new ArrayList();

    TypeGraphBuilder(TypeFlattener flattener, LowestCommonAncestorFinder.Factory<FlatType, Object> lcaFinderFactory) {
        this.flattener = flattener;
        this.lcaFinder = lcaFinderFactory.create(this.typeHoldsInstanceGraph);
        this.topNode = this.typeHoldsInstanceGraph.createNode((Object)this.flattener.flatten(JSTypeNative.ALL_TYPE));
    }

    public void add(FlatType flat) {
        this.addInternal(flat);
    }

    public void addAll(Collection<FlatType> flats) {
        flats.forEach(this::add);
    }

    public void addForcedEdge(TypeMismatch mismatch) {
        this.deferredForcedEdges.add(mismatch);
        this.addInternal(mismatch.getFound());
        this.addInternal(mismatch.getRequired());
    }

    public LinkedDirectedGraph<FlatType, Object> build() {
        this.typeHoldsInstanceGraph.getNodes().forEach(this::connectUnionWithAncestors);
        for (TypeMismatch mismatch : this.deferredForcedEdges) {
            this.connectSourceToDest(this.addInternal(mismatch.getRequired()), EdgeReason.FORCED, this.addInternal(mismatch.getFound()));
        }
        LinkedDirectedGraph<FlatType, Object> temp = this.typeHoldsInstanceGraph;
        this.typeHoldsInstanceGraph = null;
        return temp;
    }

    private void connectUnionWithAncestors(LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> unionNode) {
        FlatType flatUnion = unionNode.getValue();
        if (!flatUnion.hasArity(FlatType.Arity.UNION)) {
            return;
        }
        Preconditions.checkState(!unionNode.getOutEdges().isEmpty());
        for (FlatType lca : this.lcaFinder.findAll(flatUnion.getTypeUnion())) {
            this.connectSourceToDest((LinkedDirectedGraph.LinkedDiGraphNode)Preconditions.checkNotNull(this.typeHoldsInstanceGraph.getNode((Object)lca)), EdgeReason.ALGEBRAIC, unionNode);
        }
    }

    private LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> addInternal(JSType type) {
        return this.addInternal(this.flattener.flatten(type));
    }

    private LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> addInternal(FlatType flat) {
        DiGraph.DiGraphNode flatNode = this.typeHoldsInstanceGraph.getNode((Object)flat);
        if (flatNode != null) {
            return flatNode;
        }
        flatNode = this.typeHoldsInstanceGraph.createNode((Object)flat);
        if (flat.hasArity(FlatType.Arity.UNION)) {
            for (FlatType alt : flat.getTypeUnion()) {
                this.connectSourceToDest((LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object>)flatNode, EdgeReason.ALGEBRAIC, this.addInternal(alt));
            }
            return flatNode;
        }
        if (flat.getTypeSingle().isEnumElementType()) {
            LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> elementNode = this.addInternal(flat.getTypeSingle().getEnumeratedTypeOfEnumElement());
            this.connectSourceToDest(elementNode, EdgeReason.ENUM_ELEMENT, (LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object>)flatNode);
            return flatNode;
        }
        if (flat.getTypeSingle().isObjectType()) {
            FunctionType flatFunctionType;
            FunctionType ownerFunction;
            ObjectType flatObjectType = flat.getTypeSingle().toMaybeObjectType();
            for (ObjectType ifaceType : TypeGraphBuilder.ownAncestorInterfacesOf(flatObjectType)) {
                this.connectSourceToDest(this.addInternal(ifaceType), EdgeReason.INTERFACE, (LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object>)flatNode);
            }
            ObjectType prototypeType = flatObjectType.getImplicitPrototype();
            if (prototypeType == null) {
                this.connectSourceToDest(this.topNode, EdgeReason.ALGEBRAIC, (LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object>)flatNode);
            } else {
                this.connectSourceToDest(this.addInternal(prototypeType), EdgeReason.PROTOTYPE, (LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object>)flatNode);
            }
            if (flatObjectType.isFunctionPrototypeType() && (ownerFunction = flatObjectType.getOwnerFunction()).hasInstanceType()) {
                this.addInternal(ownerFunction.getInstanceType());
            }
            if ((flatFunctionType = flatObjectType.toMaybeFunctionType()) != null && flatFunctionType.hasInstanceType()) {
                this.addInternal(flatFunctionType.getInstanceType());
            }
            return flatNode;
        }
        throw new AssertionError((Object)("Unexpected type: " + flat));
    }

    private static ImmutableList<ObjectType> ownAncestorInterfacesOf(ObjectType type) {
        ImmutableList<ObjectType> ifaceTypes;
        FunctionType ctorType = type.getConstructor();
        if (ctorType == null) {
            return ImmutableList.of();
        }
        if (ctorType.isInterface()) {
            ifaceTypes = ctorType.getExtendedInterfaces();
        } else if (ctorType.isConstructor()) {
            ifaceTypes = ctorType.getOwnImplementedInterfaces();
        } else {
            throw new AssertionError();
        }
        if (ifaceTypes.isEmpty()) {
            return ImmutableList.of();
        }
        return ifaceTypes.stream().filter(t -> t.getConstructor() != null && t.getConstructor().isInterface()).collect(ImmutableList.toImmutableList());
    }

    private void connectSourceToDest(LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> source, EdgeReason reason, LinkedDirectedGraph.LinkedDiGraphNode<FlatType, Object> dest) {
        if (source.equals(dest) || this.typeHoldsInstanceGraph.isConnectedInDirection((FlatType)((Object)source), t -> true, (FlatType)((Object)dest))) {
            return;
        }
        this.typeHoldsInstanceGraph.connect(source, (Object)reason, dest);
    }

    static enum EdgeReason {
        ALGEBRAIC,
        ENUM_ELEMENT,
        FORCED,
        INTERFACE,
        PROTOTYPE;

    }
}

