/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfObjectToIntArray
implements Cloneable {
    public Object[] keyTable;
    public int[][] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfObjectToIntArray() {
        this(13);
    }

    public HashtableOfObjectToIntArray(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2][];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObjectToIntArray hashtableOfObjectToIntArray = (HashtableOfObjectToIntArray)super.clone();
        hashtableOfObjectToIntArray.elementSize = this.elementSize;
        hashtableOfObjectToIntArray.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfObjectToIntArray.keyTable = new Object[n];
        System.arraycopy(this.keyTable, 0, hashtableOfObjectToIntArray.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfObjectToIntArray.valueTable = new int[n][];
        System.arraycopy(this.valueTable, 0, hashtableOfObjectToIntArray.valueTable, 0, n);
        return hashtableOfObjectToIntArray;
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public int[] get(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public void keysToArray(Object[] objectArray) {
        int n = 0;
        int n2 = this.keyTable.length;
        for (int i = 0; i < n2; ++i) {
            if (this.keyTable[i] == null) continue;
            objectArray[n++] = this.keyTable[i];
        }
    }

    public int[] put(Object object, int[] nArray) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                this.valueTable[n2] = nArray;
                return nArray;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = object;
        this.valueTable[n2] = nArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return nArray;
    }

    public int[] removeKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                int[] nArray = this.valueTable[n2];
                --this.elementSize;
                this.keyTable[n2] = null;
                this.rehash();
                return nArray;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        HashtableOfObjectToIntArray hashtableOfObjectToIntArray = new HashtableOfObjectToIntArray(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object object = this.keyTable[n];
            if (object == null) continue;
            hashtableOfObjectToIntArray.put(object, this.valueTable[n]);
        }
        this.keyTable = hashtableOfObjectToIntArray.keyTable;
        this.valueTable = hashtableOfObjectToIntArray.valueTable;
        this.threshold = hashtableOfObjectToIntArray.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.keyTable[i];
            if (object == null) continue;
            stringBuffer.append(object).append(" -> ");
            int[] nArray = this.valueTable[i];
            stringBuffer.append('[');
            if (nArray != null) {
                int n2 = nArray.length;
                for (int j = 0; j < n2; ++j) {
                    if (j > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(nArray[j]);
                }
            }
            stringBuffer.append("]\n");
        }
        return String.valueOf(stringBuffer);
    }
}

