/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.helpers.FileUtils;

public class SketchFile {
    private File file;
    private Sketch sketch;
    private boolean primary;
    private TextStorage storage;

    public SketchFile(Sketch sketch, File file) {
        this.sketch = sketch;
        this.file = file;
        FileUtils.SplitFile split = FileUtils.splitFilename(file);
        this.primary = split.basename.equals(sketch.getFolder().getName()) && Sketch.SKETCH_EXTENSIONS.contains(split.extension);
    }

    public void setStorage(TextStorage text) {
        this.storage = text;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean delete(Path tempBuildFolder) throws IOException {
        if (!this.file.delete()) {
            return false;
        }
        List tempBuildFolders = Stream.of(tempBuildFolder, tempBuildFolder.resolve("sketch")).filter(path -> Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
        for (Path folder : tempBuildFolders) {
            if (this.deleteCompiledFilesFrom(folder)) continue;
            return false;
        }
        this.sketch.removeFile(this);
        return true;
    }

    private boolean deleteCompiledFilesFrom(Path tempBuildFolder) throws IOException {
        List compiledFiles = Files.list(tempBuildFolder).filter(pathname -> pathname.getFileName().toString().startsWith(this.getFileName())).collect(Collectors.toList());
        for (Path compiledFile : compiledFiles) {
            try {
                Files.delete(compiledFile);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public void renameTo(String newName) throws IOException {
        File newFile = new File(this.file.getParentFile(), newName);
        this.sketch.checkNewFilename(newFile);
        if (this.file.exists() && !this.file.renameTo(newFile)) {
            String msg = I18n.format(I18n.tr("Failed to rename \"{0}\" to \"{1}\""), this.file.getName(), newName);
            throw new IOException(msg);
        }
        this.renamedTo(newFile);
    }

    protected void renamedTo(File what) {
        this.file = what;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        if (!PreferencesData.getBoolean("editor.show_always_extensions") && this.isExtension(Sketch.SKETCH_EXTENSIONS)) {
            return this.getBaseName();
        }
        return this.getFileName();
    }

    public String getBaseName() {
        return FileUtils.splitFilename((File)this.file).basename;
    }

    public boolean isExtension(String ... extensions) {
        return this.isExtension(Arrays.asList(extensions));
    }

    public boolean isExtension(List<String> extensions) {
        return FileUtils.hasExtension(this.file, extensions);
    }

    public String getProgram() {
        if (this.storage != null) {
            return this.storage.getText();
        }
        return null;
    }

    public boolean isModified() {
        if (this.storage != null) {
            return this.storage.isModified();
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof SketchFile && this.file.equals(((SketchFile)o).file);
    }

    public String load() throws IOException {
        String text = BaseNoGui.loadFile(this.file);
        if (text == null) {
            throw new IOException();
        }
        if (text.indexOf(65533) != -1) {
            System.err.println(I18n.format(I18n.tr("\"{0}\" contains unrecognized characters. If this code was created with an older version of Arduino, you may need to use Tools -> Fix Encoding & Reload to update the sketch to use UTF-8 encoding. If not, you may need to delete the bad characters to get rid of this warning."), this.file.getName()));
            System.err.println();
        }
        return text;
    }

    public void save() throws IOException {
        if (this.storage == null) {
            return;
        }
        BaseNoGui.saveFile(this.storage.getText(), this.file);
        this.storage.clearModified();
    }

    public void saveAs(File newFile) throws IOException {
        if (this.storage == null) {
            return;
        }
        BaseNoGui.saveFile(this.storage.getText(), newFile);
        this.renamedTo(newFile);
        this.storage.clearModified();
    }

    public static interface TextStorage {
        public String getText();

        public boolean isModified();

        public void clearModified();
    }
}

