/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.CheckResult;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/OperatorModifierChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkSupportsFeature", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "modifier", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class OperatorModifierChecker {
    @NotNull
    public static final OperatorModifierChecker INSTANCE = new OperatorModifierChecker();

    private OperatorModifierChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        String string2;
        PsiElement psiElement;
        Object object;
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        FunctionDescriptor functionDescriptor2 = functionDescriptor = descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor;
        if (!functionDescriptor3.isOperator()) {
            return;
        }
        Object object2 = declaration2.getModifierList();
        Object object3 = object = object2 == null ? null : ((KtModifierList)object2).getModifier(KtTokens.OPERATOR_KEYWORD);
        if (object == null) {
            return;
        }
        PsiElement modifier = psiElement = object;
        CheckResult checkResult = OperatorChecks.INSTANCE.check(functionDescriptor3);
        if (checkResult.isSuccess()) {
            object = functionDescriptor3.getName();
            if (((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains(object)) {
                this.checkSupportsFeature(LanguageFeature.OperatorRem, languageVersionSettings, diagnosticHolder, modifier);
            } else if (Intrinsics.areEqual(object, OperatorNameConventions.PROVIDE_DELEGATE)) {
                this.checkSupportsFeature(LanguageFeature.OperatorProvideDelegate, languageVersionSettings, diagnosticHolder, modifier);
            }
            if (((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.values()).contains(functionDescriptor3.getName()) && languageVersionSettings.supportsFeature(LanguageFeature.OperatorRem)) {
                DiagnosticFactory2<PsiElement, FunctionDescriptor, String> diagnosticFactory = !KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && languageVersionSettings.supportsFeature(LanguageFeature.ProhibitOperatorMod) ? Errors.FORBIDDEN_BINARY_MOD : Errors.DEPRECATED_BINARY_MOD;
                Name newNameConvention = (Name)((ImmutableMap)((Object)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.inverse())).get(functionDescriptor3.getName());
                Intrinsics.checkNotNull(newNameConvention);
                diagnosticHolder.report(diagnosticFactory.on(modifier, functionDescriptor3, newNameConvention.asString()));
            }
            return;
        }
        Object object4 = object2 = checkResult instanceof CheckResult.IllegalSignature ? (CheckResult.IllegalSignature)checkResult : null;
        String errorDescription = object2 == null ? "illegal function name" : ((string2 = ((CheckResult.IllegalSignature)object2).getError()) == null ? "illegal function name" : string2);
        diagnosticHolder.report(Errors.INAPPLICABLE_OPERATOR_MODIFIER.on(modifier, errorDescription));
    }

    private final void checkSupportsFeature(LanguageFeature feature, LanguageVersionSettings languageVersionSettings, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        if (!languageVersionSettings.supportsFeature(feature)) {
            diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(modifier, TuplesKt.to(feature, languageVersionSettings)));
        }
    }
}

