/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.I18n;
import java.util.Locale;

public class WeekRange
extends Element {
    public static final int UNDEFINED_WEEK = Integer.MIN_VALUE;
    public static final int MIN_WEEK = 1;
    public static final int MAX_WEEK = 53;
    int startWeek = Integer.MIN_VALUE;
    int endWeek = Integer.MIN_VALUE;
    int interval = 0;

    public WeekRange() {
    }

    public WeekRange(WeekRange wr) {
        this.startWeek = wr.startWeek;
        this.endWeek = wr.endWeek;
        this.interval = wr.interval;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.format(Locale.US, "%02d", this.startWeek));
        if (this.endWeek != Integer.MIN_VALUE) {
            b.append("-");
            b.append(String.format(Locale.US, "%02d", this.endWeek));
            if (this.interval > 0) {
                b.append("/");
                b.append(this.interval);
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WeekRange) {
            WeekRange o = (WeekRange)other;
            if (this.startWeek == o.startWeek && this.endWeek == o.endWeek && this.interval == o.interval) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + this.startWeek;
        result = 37 * result + this.endWeek;
        result = 37 * result + this.interval;
        return result;
    }

    public int getStartWeek() {
        return this.startWeek;
    }

    public int getEndWeek() {
        return this.endWeek;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setStartWeek(int start) {
        if (start != Integer.MIN_VALUE && (start < 1 || start > 53)) {
            throw new IllegalArgumentException(I18n.tr("invalid_week_number", start));
        }
        this.startWeek = start;
    }

    public void setEndWeek(int end) {
        if (end != Integer.MIN_VALUE && (end < 1 || end > 53)) {
            throw new IllegalArgumentException(I18n.tr("invalid_week_number", end));
        }
        this.endWeek = end;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public WeekRange copy() {
        return new WeekRange(this);
    }
}

