/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PySystemStateRef;
import org.python.core.ThreadState;
import org.python.google.common.collect.MapMaker;

class ThreadStateMapping {
    private static final Map<Thread, ThreadState> globalThreadStates = new MapMaker().weakKeys().makeMap();
    private static final Map<ThreadState, Thread> inverseGlobalThreadStates = new MapMaker().weakValues().makeMap();
    private static final ThreadLocal<Object[]> inCallThreadState = new ThreadLocal<Object[]>(){

        @Override
        protected Object[] initialValue() {
            return new Object[2];
        }
    };
    private static Map.Entry<Thread, ThreadState>[] entriesPrototype = new Map.Entry[0];

    ThreadStateMapping() {
    }

    public ThreadState getThreadState(PySystemState newSystemState) {
        Object[] scoped = inCallThreadState.get();
        if (scoped[0] != null) {
            return (ThreadState)scoped[0];
        }
        Thread currentThread = Thread.currentThread();
        ThreadState ts = globalThreadStates.get(currentThread);
        if (ts != null) {
            return ts;
        }
        if (newSystemState == null) {
            Py.writeDebug("threadstate", "no current system state");
            if (Py.defaultSystemState == null) {
                PySystemState.initialize();
            }
            newSystemState = Py.defaultSystemState;
        }
        PySystemStateRef freedRef = (PySystemStateRef)PySystemStateRef.referenceQueue.poll();
        while (freedRef != null) {
            globalThreadStates.remove(inverseGlobalThreadStates.remove(freedRef.getThreadState()));
            freedRef = (PySystemStateRef)PySystemStateRef.referenceQueue.poll();
        }
        ts = new ThreadState(newSystemState);
        globalThreadStates.put(currentThread, ts);
        inverseGlobalThreadStates.put(ts, currentThread);
        return ts;
    }

    public static void enterCall(ThreadState ts) {
        if (ts.call_depth == 0) {
            Object[] scoped = inCallThreadState.get();
            scoped[0] = ts;
            scoped[1] = ts.getSystemState();
        } else if (ts.call_depth > ts.getSystemState().getrecursionlimit()) {
            throw Py.RuntimeError("maximum recursion depth exceeded");
        }
        ++ts.call_depth;
    }

    public static void exitCall(ThreadState ts) {
        --ts.call_depth;
        if (ts.call_depth == 0) {
            Object[] scoped = inCallThreadState.get();
            scoped[0] = null;
            scoped[1] = null;
        }
    }

    public static PyDictionary _current_frames() {
        Map.Entry<Thread, ThreadState>[] entries = globalThreadStates.entrySet().toArray(entriesPrototype);
        int i = 0;
        for (Map.Entry<Thread, ThreadState> entry : entries) {
            if (entry.getValue().frame == null) continue;
            ++i;
        }
        PyObject[] elements = new PyObject[i * 2];
        i = 0;
        for (Map.Entry<Thread, ThreadState> entry : entries) {
            if (entry.getValue().frame == null) continue;
            elements[i++] = Py.newInteger(entry.getKey().getId());
            elements[i++] = entry.getValue().frame;
        }
        return new PyDictionary(elements);
    }
}

