/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "kotlin-build-common"})
public final class ProtoMapValueExternalizer
implements DataExternalizer<ProtoMapValue> {
    @NotNull
    public static final ProtoMapValueExternalizer INSTANCE = new ProtoMapValueExternalizer();

    private ProtoMapValueExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull ProtoMapValue value2) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(value2, "value");
        output.writeBoolean(value2.isPackageFacade());
        output.writeInt(value2.getBytes().length);
        output.write(value2.getBytes());
        output.writeInt(value2.getStrings().length);
        for (String string2 : value2.getStrings()) {
            output.writeUTF(string2);
        }
    }

    @Override
    @NotNull
    public ProtoMapValue read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        boolean isPackageFacade = input.readBoolean();
        int bytesLength = input.readInt();
        byte[] bytes = new byte[bytesLength];
        input.readFully(bytes, 0, bytesLength);
        int stringsLength = input.readInt();
        int n = 0;
        int n2 = stringsLength;
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            String string2 = input.readUTF();
            Intrinsics.checkNotNullExpressionValue(string2, "input.readUTF()");
            stringArray[n3] = string2;
        }
        String[] strings2 = stringArray;
        return new ProtoMapValue(isPackageFacade, bytes, strings2);
    }
}

