/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fibs.geotag.Settings;
import org.fibs.geotag.dcraw.Dcraw;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.gpsbabel.GPSBabel;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.track.TrackStore;
import org.fibs.geotag.util.BrowserLauncher;
import org.fibs.geotag.util.LocaleUtil;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class WhatNext {
    private static final I18n i18n = I18nFactory.getI18n(WhatNext.class);
    private static final int MAX_LINE_LENGTH = 60;
    private static final String RIGHT_ARROW = "\u2192";

    private WhatNext() {
    }

    public static void helpWhatNext(Component parentComponent, ImagesTableModel tableModel) {
        boolean exiftoolAvailable = Exiftool.isAvailable();
        boolean gpsbabelAvailable = GPSBabel.isAvailable();
        boolean dcrawAvailable = Dcraw.isAvailable();
        boolean imagesAvailable = tableModel.getRowCount() > 0;
        boolean tracksAvailable = TrackStore.getTrackStore().hasTracks();
        boolean imagesWithNewLocationAvailable = false;
        int row = 0;
        while (row < tableModel.getRowCount()) {
            if (tableModel.getImageInfo(row).hasNewLocation()) {
                imagesWithNewLocationAvailable = true;
                break;
            }
            ++row;
        }
        boolean imagesWithLocationAvailable = false;
        int row2 = 0;
        while (row2 < tableModel.getRowCount()) {
            if (tableModel.getImageInfo(row2).hasLocation()) {
                imagesWithLocationAvailable = true;
                break;
            }
            ++row2;
        }
        boolean rawImagesAvailable = false;
        int row3 = 0;
        while (row3 < tableModel.getRowCount()) {
            File file = new File(tableModel.getImageInfo(row3).getPath());
            FileTypes fileType = FileTypes.fileType(file);
            if (fileType == FileTypes.RAW_READ_WRITE || fileType == FileTypes.RAW_READ_ONLY) {
                rawImagesAvailable = true;
                break;
            }
            ++row3;
        }
        boolean gapsAvailable = false;
        if (imagesWithNewLocationAvailable) {
            int row4 = 0;
            while (row4 < tableModel.getRowCount()) {
                if (!tableModel.getImageInfo(row4).hasLocation()) {
                    gapsAvailable = true;
                    break;
                }
                ++row4;
            }
        }
        boolean locationNamesFound = false;
        int row5 = 0;
        while (row5 < tableModel.getRowCount()) {
            if (tableModel.getImageInfo(row5).hasLocationName()) {
                locationNamesFound = true;
                break;
            }
            ++row5;
        }
        boolean translationAvailable = LocaleUtil.translationAvailable(Locale.getDefault());
        ArrayList<String> suggestions = new ArrayList<String>();
        WhatNext.suggestFindingExiftool(exiftoolAvailable, suggestions);
        WhatNext.suggestLoadingImages(imagesAvailable, suggestions);
        WhatNext.suggestLoadingTracks(gpsbabelAvailable, tracksAvailable, suggestions);
        WhatNext.suggestCheckingTimes(imagesAvailable, suggestions);
        WhatNext.suggestShowOnMap(imagesAvailable, suggestions);
        WhatNext.suggestMatchingTracks(imagesAvailable, tracksAvailable, suggestions);
        WhatNext.suggestFillingGaps(gapsAvailable, suggestions);
        WhatNext.suggestSaving(imagesWithNewLocationAvailable, suggestions);
        WhatNext.suggestLocationNames(imagesWithLocationAvailable, locationNamesFound, suggestions);
        WhatNext.suggestFindingGPSBabel(gpsbabelAvailable, suggestions);
        WhatNext.suggestFindingDcraw(dcrawAvailable, rawImagesAvailable, suggestions);
        WhatNext.suggestRemovingImages(imagesAvailable, suggestions);
        WhatNext.suggestTranslation(translationAvailable, suggestions);
        StringBuilder message = new StringBuilder("<html>");
        for (String suggestion : suggestions) {
            List<String> lines = Util.splitHtmlString(suggestion, 60);
            for (String line : lines) {
                message.append(line).append("<br>");
            }
            message.append("<br>");
        }
        message.append("</html");
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setText(message.toString());
        editorPane.setOpaque(false);
        editorPane.setFont(new JLabel().getFont());
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserLauncher.openURL(Settings.get(Settings.SETTING.BROWSER, null), event.getURL().toString());
                }
            }
        });
        JOptionPane.showMessageDialog(parentComponent, editorPane, i18n.tr("What next?"), 1);
    }

    private static void suggestFindingDcraw(boolean dcrawAvailable, boolean rawImagesAvailable, List<String> suggestions) {
        if (!dcrawAvailable && rawImagesAvailable) {
            String text = String.format(i18n.tr("The 'dcraw' program can't be found. It is needed to display previews of your RAW images. Select <b>%s %s %s</b> to find it."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Settings"));
            suggestions.add(text);
        }
    }

    private static void suggestFindingGPSBabel(boolean gpsbabelAvailable, List<String> suggestions) {
        if (!gpsbabelAvailable) {
            String text = String.format(i18n.tr("The 'GPSBabel' program can't be found. It is only needed if you want to load tracks directly from your GPS. Select <b>%s %s %s</b> to find it."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Settings"));
            suggestions.add(text);
        }
    }

    private static void suggestFindingExiftool(boolean exiftoolAvailable, List<String> suggestions) {
        if (!exiftoolAvailable) {
            String text = String.format(i18n.tr("The 'exiftool' program can't be found. It is needed to save coordinates  to your images. Select <b>%s %s %s</b> to find it."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Settings"));
            suggestions.add(text);
        }
    }

    private static void suggestLocationNames(boolean imagesWithLocationAvailable, boolean locationNamesFound, List<String> suggestions) {
        if (imagesWithLocationAvailable && !locationNamesFound) {
            String text = String.format(i18n.tr("Geotag can search for nearby place names for images that already have coordinates by using the <b>%1$s</b> menu."), i18n.tr("Location names"));
            suggestions.add(text);
        }
    }

    private static void suggestSaving(boolean imagesWithNewLocationAvailable, List<String> suggestions) {
        if (imagesWithNewLocationAvailable) {
            String text = String.format(i18n.tr("You can save the locations of images listed in <b>bold</b> by using the <b>%1$s</b> menu. Note that this operation <b>cannot be un-done</b>!"), i18n.tr("Save new locations"));
            suggestions.add(text);
        }
    }

    private static void suggestFillingGaps(boolean gapsAvailable, List<String> suggestions) {
        if (gapsAvailable) {
            String text = String.format(i18n.tr("Some images have coordinates and some don't. You can use the <b>%1$s</b> menu to make %2$s guess where images were taken."), i18n.tr("Fill gaps"), "Geotag");
            suggestions.add(text);
        }
    }

    private static void suggestMatchingTracks(boolean imagesAvailable, boolean tracksAvailable, List<String> suggestions) {
        if (imagesAvailable && tracksAvailable) {
            String text = String.format(i18n.tr("If your happy with the time <b>%1$s</b> values, right click on any image and use the <b>%2$s</b> menu to match the GPS data to images."), i18n.tr("Offset"), i18n.tr("Find locations"));
            suggestions.add(text);
        }
    }

    private static void suggestShowOnMap(boolean imagesAvailable, List<String> suggestions) {
        if (imagesAvailable) {
            String text = String.format(i18n.tr("You can right click on an image and select <b>%1$s</b> to show the image location on a map in your browser and move the marker on the map to adjust the location."), i18n.tr("Show on map"));
            suggestions.add(text);
        }
    }

    private static void suggestCheckingTimes(boolean imagesAvailable, List<String> suggestions) {
        if (imagesAvailable) {
            String text = String.format(i18n.tr("Make sure the time <b>%1$s</b> values are correct. It's best to right click on an image you are sure about (say an image of your GPS display) and choose <b>%2$s</b> from the menu bar, then select the exact time (and time zone) the image was taken."), i18n.tr("Offset"), i18n.tr("Set time of image"));
            suggestions.add(text);
        }
    }

    private static void suggestLoadingTracks(boolean gpsbabelAvailable, boolean tracksAvailable, List<String> suggestions) {
        if (!tracksAvailable) {
            String text = String.format(i18n.tr("Load a GPS track file. Select <b>%s %s %s</b> from the menu bar."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Load tracks from file"));
            suggestions.add(text);
            if (gpsbabelAvailable) {
                text = String.format(i18n.tr("You can also load tracks directly from your GPS. Select <b>%s %s %s</b>."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Load tracks from GPS"));
                suggestions.add(text);
            }
        }
    }

    private static void suggestLoadingImages(boolean imagesAvailable, List<String> suggestions) {
        if (!imagesAvailable) {
            String text = String.format(i18n.tr("Load some image files. Select <b>%s %s %s</b> from the menu or add them by using drag-and-drop."), i18n.tr("File"), RIGHT_ARROW, i18n.tr("Add images from directory"));
            suggestions.add(text);
        }
    }

    private static void suggestRemovingImages(boolean imagesAvailable, List<String> suggestions) {
        if (imagesAvailable) {
            String text = String.format(i18n.tr("If there are too many images displayed, you can remove some of them using the  <b>%1$s</b> menu. They will be removed from the display, but not deleted."), i18n.tr("Remove images"));
            suggestions.add(text);
        }
    }

    private static void suggestTranslation(boolean translationAvailable, List<String> suggestions) {
        if (translationAvailable) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Your language seems to be <b>");
        builder.append(Locale.getDefault().getDisplayName());
        builder.append("</b> and we don't have a translation for it. ");
        builder.append("To find out how to help");
        builder.append(" <a href=\"http://geotag.sourceforge.net/?q=node/24\">click&nbsp;here</a>.");
        suggestions.add(builder.toString());
    }
}

