/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenMediaDB;
import mediathek.daten.DatenMediaPath;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.mediadb.MediaDbStartEvent;
import mediathek.gui.messages.mediadb.MediaDbStopEvent;
import mediathek.tool.Filter;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.models.TModelMediaDB;
import net.engio.mbassy.bus.MBassador;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListeMediaDB
extends LinkedList<DatenMediaDB> {
    public static final String TRENNER = "  |###|  ";
    private boolean makeIndex = false;
    private String[] suffix = new String[]{""};
    private boolean ohneSuffix = true;
    private final Daten daten;
    private static final Logger logger = LogManager.getLogger(ListeMediaDB.class);

    public ListeMediaDB(Daten aDaten) {
        this.daten = aDaten;
    }

    public synchronized void getModelMediaDB(TModelMediaDB modelMediaDB) {
        modelMediaDB.setRowCount(0);
        this.forEach(mdb -> modelMediaDB.addRow(mdb.getRow()));
    }

    public synchronized void searchFilmInDB(TModelMediaDB foundModel, String title) {
        foundModel.setRowCount(0);
        if (!this.makeIndex && !title.isEmpty()) {
            Pattern p = Filter.makePattern(title);
            if (p != null) {
                this.daten.getListeMediaDB().stream().filter(s2 -> p.matcher(s2.arr[0]).matches()).forEach(s2 -> foundModel.addRow(s2.getRow()));
            } else {
                title = title.toLowerCase();
                for (DatenMediaDB s3 : this.daten.getListeMediaDB()) {
                    if (!s3.arr[0].toLowerCase().contains(title)) continue;
                    foundModel.addRow(s3.getRow());
                }
            }
        }
    }

    public synchronized void cleanList() {
        CleanerThread thread2 = new CleanerThread();
        thread2.start();
    }

    private void clean() {
        HashSet hash = new HashSet();
        ListeMediaDB tmp = new ListeMediaDB(this.daten);
        this.forEach(m3 -> {
            String s2 = m3.getEqual();
            if (!hash.contains(s2)) {
                hash.add(s2);
                tmp.add(m3);
            }
        });
        this.clear();
        this.addAll(tmp);
        tmp.clear();
        hash.clear();
        this.exportListe("");
    }

    public synchronized void delList(boolean ohneSave) {
        MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync(new MediaDbStartEvent());
        this.makeIndex = true;
        this.del(ohneSave);
        this.makeIndex = false;
        messageBus.publishAsync(new MediaDbStopEvent());
    }

    private void del(boolean ohneSave) {
        if (ohneSave) {
            this.removeIf(datenMediaDB -> !datenMediaDB.isExtern());
        } else {
            this.clear();
            this.exportListe("");
        }
    }

    public synchronized void createMediaDB(String pfad) {
        MessageBus.getMessageBus().publishAsync(new MediaDbStartEvent());
        this.suffix = MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX).split(",");
        for (int i = 0; i < this.suffix.length; ++i) {
            this.suffix[i] = this.suffix[i].toLowerCase();
            if (this.suffix[i].isEmpty() || this.suffix[i].startsWith(".")) continue;
            this.suffix[i] = "." + this.suffix[i];
        }
        this.ohneSuffix = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX_OHNE));
        this.makeIndex = true;
        if (pfad.isEmpty()) {
            this.del(true);
        }
        this.createIndexThread(new Index(pfad));
    }

    private void createIndexThread(Index runner) {
        Thread starter = new Thread(runner);
        starter.setName("MediaDB Index Thread");
        starter.start();
    }

    public synchronized void loadSavedList() {
        Path urlPath = this.getFilePath();
        try (BufferedReader br = Files.newBufferedReader(urlPath);
             LineNumberReader in = new LineNumberReader(br);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                DatenMediaDB mdb = this.getUrlAusZeile(zeile);
                if (mdb == null) continue;
                this.add(mdb);
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }

    public synchronized void exportListe(String datei) {
        Path logFilePath = null;
        boolean export = false;
        logger.info("MediaDB schreiben ({}) Dateien :", (Object)this.daten.getListeMediaDB().size());
        if (!datei.isEmpty()) {
            export = true;
            try {
                File file = new File(datei);
                File dir = new File(file.getParent());
                if (!dir.exists() && !dir.mkdirs()) {
                    logger.error("Kann den Pfad nicht anlegen: {}", (Object)dir.toString());
                }
                logger.info("   --> Start Schreiben nach: {}", (Object)datei);
                logFilePath = file.toPath();
            }
            catch (Exception ex) {
                logger.error("nach: {}", (Object)datei, (Object)ex);
            }
        } else {
            logger.info("   --> Start Schreiben nach: {}", (Object)this.getFilePath().toString());
            logFilePath = this.getFilePath();
        }
        try (BufferedWriter bw = Files.newBufferedWriter(logFilePath, new OpenOption[0]);){
            bw.newLine();
            bw.newLine();
            for (DatenMediaDB entry : this) {
                if (!datei.isEmpty()) {
                    bw.write(this.getLine(entry, export));
                    bw.newLine();
                    continue;
                }
                if (!entry.isExtern()) continue;
                bw.write(this.getLine(entry, export));
                bw.newLine();
            }
            bw.newLine();
            bw.flush();
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(() -> MVMessageDialog.showMessageDialog(null, "Datei konnte nicht geschrieben werden!", "Fehler beim Schreiben", 0));
        }
        logger.info("   --> geschrieben!");
    }

    private boolean checkSuffix(String[] str, String uurl) {
        if (str.length == 1 && str[0].isEmpty()) {
            return true;
        }
        boolean ret = true;
        String url = uurl.toLowerCase();
        for (String s2 : str) {
            if (this.ohneSuffix) {
                if (!url.endsWith(s2)) continue;
                ret = false;
                break;
            }
            ret = false;
            if (!url.endsWith(s2)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private String minTextLaenge(String text) {
        StringBuilder textBuilder = new StringBuilder(text);
        while (textBuilder.length() < 60) {
            textBuilder.append(' ');
        }
        return textBuilder.toString();
    }

    private String getLine(DatenMediaDB med, boolean export) {
        if (export) {
            return med.arr[0];
        }
        Object ret = "";
        ret = (String)ret + this.minTextLaenge(med.arr[0]) + TRENNER;
        ret = (String)ret + this.minTextLaenge(med.arr[1]) + TRENNER;
        ret = (String)ret + String.valueOf(med.mVMediaDBFileSize.sizeL);
        return ret;
    }

    private Path getFilePath() {
        Path urlPath = null;
        try {
            urlPath = StandardLocations.getSettingsDirectory().resolve("mediadb.txt");
            if (Files.notExists(urlPath, new LinkOption[0])) {
                urlPath = Files.createFile(urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            logger.warn(ex);
        }
        return urlPath;
    }

    private DatenMediaDB getUrlAusZeile(String zeile) {
        if (zeile.isEmpty()) {
            return null;
        }
        String name = "";
        String pfad = "";
        String s2 = "";
        long size = 0L;
        try {
            if (zeile.contains(TRENNER)) {
                name = zeile.substring(0, zeile.indexOf(TRENNER)).trim();
                pfad = zeile.substring(zeile.indexOf(TRENNER) + TRENNER.length(), zeile.lastIndexOf(TRENNER)).trim();
                s2 = zeile.substring(zeile.lastIndexOf(TRENNER) + TRENNER.length()).trim();
            }
            if (!s2.isEmpty()) {
                try {
                    size = Long.parseLong(s2);
                }
                catch (Exception ignore) {
                    size = 0L;
                }
            }
            return new DatenMediaDB(name, pfad, size, true);
        }
        catch (Exception ex) {
            logger.error(ex);
            return null;
        }
    }

    class CleanerThread
    extends Thread {
        public CleanerThread() {
            this.setName("Clean MediaDB");
        }

        @Override
        public void run() {
            logger.info("Clean MediaDB start");
            MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
            messageBus.publishAsync(new MediaDbStartEvent());
            ListeMediaDB.this.makeIndex = true;
            ListeMediaDB.this.clean();
            ListeMediaDB.this.makeIndex = false;
            messageBus.publishAsync(new MediaDbStopEvent());
            logger.info("Clean MediaDB stop");
        }
    }

    private class Index
    implements Runnable {
        String pfad;
        String error = "";
        boolean more = false;

        public Index(String pfad) {
            this.pfad = pfad;
        }

        @Override
        public synchronized void run() {
            logger.debug("Mediensammlung erstellen");
            try {
                if (!this.pfad.isEmpty()) {
                    File f = new File(this.pfad);
                    if (!f.canRead()) {
                        if (!this.error.isEmpty()) {
                            this.error = this.error + "\n";
                        }
                        this.error = this.error + f.getPath();
                    }
                    if (!this.error.isEmpty()) {
                        this.errorMsg();
                    }
                    this.searchFile(new File(this.pfad), true);
                } else if (!ListeMediaDB.this.daten.getListeMediaPath().isEmpty()) {
                    for (DatenMediaPath mp2 : ListeMediaDB.this.daten.getListeMediaPath()) {
                        File f;
                        if (mp2.savePath() || (f = new File(mp2.arr[0])).canRead()) continue;
                        if (!this.error.isEmpty()) {
                            this.error = this.error + "\n";
                            this.more = true;
                        }
                        this.error = this.error + f.getPath();
                    }
                    if (!this.error.isEmpty()) {
                        this.errorMsg();
                    }
                    ListeMediaDB.this.daten.getListeMediaPath().stream().filter(mp -> !mp.savePath()).forEach(mp -> this.searchFile(new File(mp.arr[0]), false));
                }
            }
            catch (Exception ex) {
                logger.error(ex);
            }
            ListeMediaDB.this.daten.getListeMediaDB().exportListe("");
            ListeMediaDB.this.makeIndex = false;
            logger.debug("Ende Mediensammlung erstellen");
            MessageBus.getMessageBus().publishAsync(new MediaDbStopEvent());
        }

        private void errorMsg() {
            MVMessageDialog.showMessageDialog(null, (this.more ? "Die Pfade der Mediensammlung k\u00f6nnen nicht alle gelesen werden:\n" : "Der Pfad der Mediensammlung kann nicht gelesen werden:\n") + this.error, "Fehler beim Erstellen der Mediensammlung", 0);
        }

        private void searchFile(File dir, boolean save) {
            if (dir == null) {
                return;
            }
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.searchFile(file, save);
                        continue;
                    }
                    if (!ListeMediaDB.this.checkSuffix(ListeMediaDB.this.suffix, file.getName())) continue;
                    ListeMediaDB.this.daten.getListeMediaDB().add(new DatenMediaDB(file.getName(), file.getParent(), file.length(), save));
                }
            }
        }
    }
}

