/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Font;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mediathek.config.MVConfig;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmSize;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.ASelectableMVTable;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVFilmTable
extends ASelectableMVTable {
    private static final Logger logger = LogManager.getLogger();
    private MyRowSorter<TableModel> sorter;

    public MVFilmTable() {
        this.setAutoCreateRowSorter(false);
        this.addPropertyChangeListener("model", evt -> {
            if (this.sorter == null) {
                this.sorter = new MyRowSorter<TableModel>(this.getModel());
            }
            this.setRowSorter(this.sorter);
            this.sorter.setModel(this.getModel());
        });
    }

    @Override
    protected void setSelected() {
        boolean found = false;
        if (this.selIndexes != null) {
            this.selectionModel.setValueIsAdjusting(true);
            TModelFilm tModel = (TModelFilm)this.getModel();
            for (int i : this.selIndexes) {
                int r = tModel.getModelRowForFilmNumber(i);
                if (r < 0) continue;
                r = this.convertRowIndexToView(r);
                this.addRowSelectionInterval(r, r);
                found = true;
            }
            if (!found && this.selRow >= 0 && this.getRowCount() > this.selRow) {
                this.setRowSelectionInterval(this.selRow, this.selRow);
            } else if (!found && this.selRow >= 0 && this.getRowCount() > 0) {
                int rowCount = tModel.getRowCount() - 1;
                this.setRowSelectionInterval(rowCount, rowCount);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }
        this.selIndexes = null;
    }

    @Override
    protected void loadDefaultFontSize() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            float fontSize = config.getFloat("tab.film.font_size");
            Font newFont = this.getDefaultFont().deriveFont(fontSize);
            this.setDefaultFont(newFont);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void saveDefaultFontSize() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        float fontSize = this.getDefaultFont().getSize2D();
        config.setProperty("tab.film.font_size", Float.valueOf(fontSize));
    }

    @Override
    protected void setupTableType() {
        this.maxSpalten = 17;
        this.spaltenAnzeigen = this.getSpaltenEinAus(GuiFilme.VISIBLE_COLUMNS, 17);
        this.indexSpalte = 0;
        this.nrDatenSystem = MVConfig.Configs.SYSTEM_EIGENSCHAFTEN_TABELLE_FILME;
        this.iconAnzeigenStr = MVConfig.Configs.SYSTEM_TAB_FILME_ICON_ANZEIGEN;
        this.iconKleinStr = MVConfig.Configs.SYSTEM_TAB_FILME_ICON_KLEIN;
    }

    private void resetFilmeTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        switch (i) {
            case 0: {
                this.breite[i] = 75;
                break;
            }
            case 3: {
                this.breite[i] = 300;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                this.breite[i] = 100;
                break;
            }
            case 14: {
                this.breite[i] = 500;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.breite[i] = 20;
                break;
            }
            case 11: 
            case 12: {
                this.breite[i] = 50;
            }
        }
    }

    @Override
    public void resetTabelle() {
        for (int i = 0; i < this.maxSpalten; ++i) {
            this.resetFilmeTab(i);
        }
        this.getRowSorter().setSortKeys(null);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite, this.spaltenAnzeigen);
        this.setSpalten();
        this.setHeight();
    }

    @Override
    protected void spaltenAusschalten() {
    }

    @Override
    public void getSpalten() {
        int i;
        this.getSelected();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        this.listeSortKeys = rowSorter != null ? rowSorter.getSortKeys() : null;
    }

    @Override
    public void setSpalten() {
        try {
            this.changeColumnWidth();
            TableColumnModel model = this.getColumnModel();
            this.changeColumnWidth2();
            for (int i = 0; i < this.reihe.length && i < this.getColumnCount(); ++i) {
                if (this.reihe[i] == i) continue;
                model.moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
            }
            RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
            List<RowSorter.SortKey> tblSortKeys = rowSorter.getSortKeys();
            if (this.listeSortKeys != null && this.listeSortKeys != tblSortKeys && !this.listeSortKeys.isEmpty()) {
                rowSorter.setSortKeys(this.listeSortKeys);
            }
            this.setSelected();
            this.validate();
        }
        catch (Exception ex) {
            logger.error("setSpalten", (Throwable)ex);
        }
    }

    static class MyRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public MyRowSorter(M model) {
            super(model);
        }

        @Override
        public void setModel(M model) {
            super.setModel(model);
            this.setSortable(4, false);
            this.setSortable(5, false);
            this.setComparator(10, FilmSize::compareTo);
            this.setComparator(1, String::compareTo);
            this.setComparator(8, String::compareTo);
            this.setComparator(14, String::compareTo);
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
            if (sortKeys != null && sortKeys.size() > 1) {
                sortKeys.remove(1);
            }
            super.setSortKeys(sortKeys);
        }
    }
}

