/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import javax.swing.JDialog;
import mediathek.config.Konstanten;
import mediathek.gui.actions.DisposeDialogAction;
import mediathek.gui.dialog.ButtonFlowPanel;
import mediathek.gui.dialog.ButtonPanel;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Version;
import mediathek.update.UpdateNotificationPanel;

public class UpdateNotificationDialog
extends JDialog {
    private final Version version;
    private final UpdateNotificationPanel panel = new UpdateNotificationPanel();
    private WebView browser;
    private WebEngine webEngine;

    public UpdateNotificationDialog(Frame owner, String title, Version version) {
        super(owner, title, true);
        this.version = version;
        this.setDefaultCloseOperation(2);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.setupDialogInformation();
        this.setupFxWebView();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.panel, "Center");
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.add((Component)this.createButtonPanel(), "East");
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        GuiFunktionen.centerOnScreen(this, false);
    }

    private ButtonFlowPanel createButtonPanel() {
        ButtonFlowPanel pnl = new ButtonFlowPanel();
        JButton btn = new JButton(new DisposeDialogAction(this, "Schlie\u00dfen", "Dialog schlie\u00dfen"));
        this.getRootPane().setDefaultButton(btn);
        pnl.add(btn);
        return pnl;
    }

    private void setupFxWebView() {
        Platform.runLater(() -> {
            this.browser = new WebView();
            Scene scene = new Scene(this.browser);
            this.webEngine = this.browser.getEngine();
            this.webEngine.load(Objects.requireNonNull(Konstanten.WEBSITE_BASE_URL.resolve("changelogs")).toString());
            this.panel.getFxPanel().setScene(scene);
        });
    }

    private void setupDialogInformation() {
        String label = "MediathekView " + this.version + " ist verf\u00fcgbar - Sie haben Version " + Konstanten.MVVERSION;
        this.panel.getReleaseInfoLabel().setText(label);
    }
}

