/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class Logger
extends org.apache.felix.resolver.Logger {
    public Logger() {
        super(1);
    }

    public final void log(ServiceReference sr, int level, String msg) {
        this._log(null, sr, level, msg, null);
    }

    public final void log(ServiceReference sr, int level, String msg, Throwable throwable) {
        this._log(null, sr, level, msg, throwable);
    }

    public final void log(Bundle bundle, int level, String msg) {
        this._log(bundle, null, level, msg, null);
    }

    public final void log(Bundle bundle, int level, String msg, Throwable throwable) {
        this._log(bundle, null, level, msg, throwable);
    }

    protected void doLog(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
        String s = "";
        if (sr != null) {
            s = s + "SvcRef " + sr + " ";
        } else if (bundle != null) {
            s = s + "Bundle " + bundle.toString() + " ";
        }
        s = s + msg;
        if (throwable != null) {
            s = s + " (" + throwable + ")";
        }
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (throwable == null) break;
                if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                    throwable = ((BundleException)throwable).getNestedException();
                }
                throwable.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    private void _log(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
        if (this.getLogLevel() >= level) {
            this.doLog(bundle, sr, level, msg, throwable);
        }
    }
}

