from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats = (
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}-{{last_name}}',
        '{{first_name_female}} {{last_name}} {{last_name}}',
        '{{prefix}} {{first_name}} {{last_name}}',
    )

    # extracted from https://www.bfs.admin.ch/bfs/it/home/statistiche/popolazione/nascite-decessi/nomi-svizzera.assetdetail.3243313.html # noqa E501
    first_names_male = (
        'Peter', 'Hans', 'Daniel', 'Thomas', 'Andreas', 'Martin', 'Markus',
        'Michael', 'Christian', 'Stefan', 'Walter', 'Urs', 'Marco', 'Bruno',
        'Patrick', 'Werner', 'René', 'Marcel', 'Beat', 'Roland', 'Kurt',
        'Josef', 'David', 'Simon', 'Rolf', 'Heinz', 'Rudolf', 'Paul', 'Roger',
        'Christoph', 'Ernst', 'Pascal', 'Adrian', 'Lukas', 'Marc', 'Robert',
        'Reto', 'Manuel', 'Fabian', 'Alfred', 'Philipp', 'Jürg', 'Matthias',
        'Stephan', 'Franz', 'Anton', 'André', 'Alexander', 'Samuel', 'Jan',
        'Johann', 'Luca', 'Max', 'Roman', 'Mario', 'Fritz', 'Ulrich', 'Dominik',
        'Karl', 'Tobias', 'Oliver', 'Florian', 'Antonio', 'Benjamin', 'Sandro',
        'Bernhard', 'Jonas', 'Felix', 'Raphael', 'Kevin', 'Erich', 'Fabio',
        'Jakob', 'Sven', 'Dario', 'Giuseppe', 'Remo', 'Nicolas', 'Albert',
        'Erwin', 'Richard', 'Nico', 'Michel', 'José', 'Claudio', 'Tim', 'Noah',
        'Joel', 'Heinrich', 'Jörg', 'Robin', 'Sebastian', 'Armin', 'Guido',
        'Silvan', 'Lars', 'Ivan', 'Julian', 'Alois', 'Francesco', 'Sascha',
        'Dominic', 'Johannes', 'Georg', 'Gabriel', 'Manfred', 'Herbert', 'Otto',
        'Alessandro', 'Gerhard', 'Patrik', 'Gian', 'Mathias', 'Leon', 'Willi',
        'Eduard', 'Nicola', 'Hugo', 'Ali', 'Yves', 'Elias', 'Hermann',
        'Philippe', 'Leo', 'Emil', 'Frank', 'Dieter', 'Friedrich', 'Luis',
        'Giovanni', 'Niklaus', 'Alex', 'Roberto', 'Rafael', 'Hanspeter',
        'Diego', 'Nils', 'Leandro', 'Ramon', 'Severin', 'Salvatore', 'Mike',
        'Alain', 'Timo', 'Carlos', 'Arthur', 'Yannick', 'Eric', 'Angelo', 'Ivo',
        'Wolfgang', 'Matteo', 'Joël', 'Andrin', 'Pius', 'Moritz', 'Valentin',
        'Louis', 'Wilhelm', 'Renato', 'Levin', 'Silvio', 'Willy', 'Andrea',
        'Jonathan', 'Jean', 'Livio', 'Loris', 'Damian', 'Theodor', 'Michele',
        'Vincenzo', 'Elia', 'Ralph', 'Klaus', 'Eugen', 'Mark', 'Konrad',
        'Denis', 'Norbert', 'Lorenz', 'Viktor', 'Mehmet', 'Marko', 'Kilian',
        'Hans-Peter', 'Cédric', 'Ralf', 'Aaron', 'Maximilian', 'Carlo',
        'Alessio', 'Olivier', 'Jürgen', 'Luigi', 'Philip', 'Lucas', 'Mauro',
        'Janis', 'Cyrill', 'Linus', 'Davide', 'Othmar', 'Flavio', 'Nino',
        'Arnold', 'Nick', 'Rainer', 'Domenico', 'Adolf', 'Emanuel', 'Oskar',
        'Ben', 'Joshua', 'Leonardo', 'Franco', 'Pierre', 'John', 'Gregor',
        'Fernando', 'Marius', 'Claude', 'Edwin', 'Colin', 'Mustafa', 'Pedro',
        'Stefano', 'Sergio', 'Dominique', 'Juan', 'Nikola', 'Enrico', 'Jens',
        'Daniele', 'Thierry', 'Jose', 'Liam', 'Francisco', 'Ricardo', 'Rico',
        'Christof', 'Aleksandar', 'Dennis', 'Mohamed', 'Joseph', 'Charles',
        'Noel', 'Miguel', 'Laurin', 'Milan', 'Reinhard', 'Lionel', 'Dragan',
        'Hasan', 'Paulo', 'Edgar', 'Silas', 'Hubert', 'Helmut', 'Ibrahim',
        'Ruben', 'Timon', 'Vincent', 'Christopher', 'Finn', 'Ronny', 'Kaspar',
        'Mattia', 'Lorenzo', 'Pietro', 'Björn', 'Hansruedi', 'Gottfried',
        'Joachim', 'Benno', 'Harald', 'Jorge', 'Cedric', 'Nevio', 'Paolo',
        'Gianluca', 'Boris', 'Kai', 'Maurizio', 'Steven', 'Mischa', 'Patric',
        'Zoran', 'Mirco', 'Marvin', 'Dirk', 'Benedikt', 'Uwe', 'Hans-Rudolf',
        'Maurice', 'Massimo', 'Hansjörg', 'Jeremy', 'Niklas', 'Ahmet',
        'Fridolin', 'Dejan', 'Goran', 'Micha', 'Mohammad', 'Ronald', 'Bernd',
        'Mirko', 'Erik', 'Jason', 'Tiago', 'Riccardo', 'Jérôme', 'Igor',
        'Siegfried', 'Pasquale', 'Andri', 'Tom', 'Ueli', 'Amir', 'Cyril',
        'Adriano', 'Alberto', 'Ferdinand', 'Justin', 'Raffael', 'Julien',
        'Lenny', 'Luka', 'Marcus', 'Pirmin', 'Janik', 'Julius', 'Meinrad',
        'Adam', 'James', 'Hüseyin', 'Alexandre', 'Rocco', 'Luc', 'Victor',
        'João', 'Andres', 'Luan', 'Flurin', 'Filip', 'Ismail', 'Danilo',
        'Laurent', 'Raffaele', 'Ahmed', 'Günter', 'Joao', 'Rui', 'Xaver',
        'Fabrizio', 'William', 'Vito', 'Miroslav', 'Lino', 'Albin', 'Jean-Pierre',
        'Basil', 'Till', 'Horst', 'Romeo', 'Aldo', 'Murat', 'Harry',
        'Alfons', 'Pablo', 'Bernard', 'Noé', 'Luciano', 'August', 'Levi',
        'Nando', 'Fabrice', 'Raymond', 'Jamie', 'Georges', 'Steffen', 'Serge',
        'Cristian', 'Samir', 'António', 'Marlon', 'Omar', 'Lian', 'Oscar',
        'Yanick', 'Armando', 'Nikolaus', 'Dylan', 'Hannes', 'Sacha', 'Nuno',
        'Toni', 'Dino', 'Elmar', 'Arno', 'Joaquim', 'Sasa', 'Henry', 'Vladimir',
        'Arben', 'Ryan', 'Bekim', 'Milos', 'Giorgio', 'Ludwig', 'Leonard',
        'Adnan', 'Gilbert', 'Yannik', 'Aron', 'Iwan', 'Maik', 'Dimitri',
        'Erhard', 'François', 'Gabriele', 'Sami', 'Elio', 'Antonino', 'Fynn',
        'Simone', 'Andrew', 'Alan', 'Nenad', 'Frédéric', 'Etienne', 'Janick',
        'Steve', 'Christophe', 'Gianni', 'Urban', 'Anthony', 'Deniz', 'Jon',
        'Alejandro', 'Axel', 'Ian', 'Theo', 'Andrej', 'Brian', 'Lucien', 'Gino',
        'Clemens', 'Yanik', 'Adem', 'Emir', 'Tino', 'Miro', 'Enis', 'Gregory',
        'Danijel', 'Osman', 'Michal', 'Carmine', 'Orlando', 'Enes', 'Giuliano',
        'Timothy', 'Fredy', 'Besnik', 'Vitor', 'Holger', 'Kim', 'Eduardo',
        'Petar', 'Jacques', 'Karim', 'Darko', 'Gustav', 'Emilio', 'Mateo',
        'Alban', 'Marek', 'Oswald', 'Noël', 'Donato', 'Mohammed', 'Roy', 'Kay',
        'Nathan', 'Enea', 'Silvano', 'Josip', 'Valerio', 'Artur', 'Besim',
        'Mika', 'Torsten', 'Romano', 'Heiko', 'Yusuf', 'Chris', 'Naim', 'Burim',
        'Gaetano', 'Hans-Ulrich', 'Olaf', 'Maurus', 'Volker', 'Jean-Claude',
        'Henri', 'Nik', 'Rodrigo', 'Florin', 'Mael', 'Amar', 'Agron', 'Muhamed',
        'Tristan', 'Valon', 'Ahmad', 'Ilir', 'Javier', 'Lorin', 'Yanis',
        'Fatmir', 'Bajram', 'Carmelo', 'Agim', 'Enzo', 'Moreno', 'Cornel',
        'Andy', 'Jeton', 'Blerim', 'Bojan', 'Federico', 'Attila', 'Juri',
        'Tomas', 'Valentino', 'Ismet', 'Jannik', 'Ruedi', 'Afrim', 'Yannic',
        'Ramadan', 'Alfredo', 'Josua', 'Cosimo', 'Gerardo', 'Bastian',
        'Filippo', 'Raoul', 'Halil', 'Yann', 'Georgios', 'Jannis', 'Nicholas',
        'Sean', 'Wilfried', 'Günther', 'Dusan', 'Beda', 'Gerold', 'Gottlieb',
        'Filipe', 'Ilija', 'Carl', 'Ardian', 'Marcello', 'Enver', 'Dean',
        'Dion', 'Tenzin', 'Zeljko', 'Carsten', 'Diogo', 'Alen', 'Egon', 'Aurel',
        'Yannis', 'Edin', 'Hans-Jörg', 'Tomislav', 'Mohamad', 'Bujar', 'Raul',
        'Slobodan', 'Driton', 'Maxim', 'Francis', 'Hansueli', 'Ivica', 'Nelson',
        'Emanuele', 'Konstantin', 'Fred', 'Naser', 'Gerd', 'Kristian', 'Selim',
        'Corsin', 'Dietmar', 'George', 'Piotr', 'Giacomo', 'Ingo', 'Andre',
        'Malik', 'Lothar', 'Jochen', 'Sinan', 'Thorsten', 'Tiziano', 'Gilles',
        'Avni', 'Jann', 'Lio', 'Niels', 'Emmanuel', 'Leonhard', 'Lorik',
        'Aurelio', 'Gion', 'Liridon', 'Marino', 'Can', 'Kenan', 'Ewald',
        'Stéphane', 'Dalibor', 'Jozef', 'Noe', 'Bryan', 'Dan', 'Santiago',
        'Damiano', 'Arian', 'Rosario', 'Giancarlo', 'Nathanael', 'Emre',
        'Stephen', 'Hassan', 'Jovan', 'Egzon', 'Reinhold', 'Tomasz', 'Vittorio',
        'Patrice', 'Tibor', 'Jost', 'Elvis', 'Lean', 'Henrik', 'Musa', 'Noa',
        'Udo', 'Almir', 'Van', 'Dietrich', 'Mladen', 'Armend', 'Arlind', 'Milo',
        'Arsim', 'Bashkim', 'Dimitrios', 'Matthew', 'Ömer', 'Abdullah', 'Hakan',
        'Gerald', 'Tommaso', 'Joris', 'Damir', 'Vinzenz', 'Marcos', 'Raphaël',
        'Ennio', 'Melvin', 'Leander', 'Kuno', 'Massimiliano', 'Maël', 'Anto',
        'Branko', 'Fadil', 'Kemal', 'Muhammed', 'Hendrik', 'Pawel', 'Jeremias',
        'Léon', 'Leano', 'Rémy', 'Giulio', 'Muhamet', 'Lulzim', 'Konstantinos',
        'Pavel', 'Rinaldo', 'Omer', 'Simeon', 'Gian-Luca', 'Maurin', 'Antoine',
        'Frederik', 'Janic', 'Faton', 'Marcin', 'Sébastien', 'Cem', 'Curdin',
        'Endrit', 'Nemanja', 'Karsten', 'Renzo', 'Jerome', 'Krzysztof',
        'Jeffrey', 'Sebastiano', 'Ernesto', 'Lazar', 'Ramazan', 'Gérard',
        'Ajan', 'Emin', 'Ioannis', 'Jesus', 'Alfonso', 'Yasin', 'Jaron',
        'Alexis', 'Orhan', 'Artan', 'Morris', 'Angel', 'Janosch', 'Rene',
        'Shaban', 'Jakub', 'Loïc', 'Kristijan', 'Enrique', 'Skender',
        'Gianfranco', 'Mathieu', 'Xavier', 'Mathis', 'Didier', 'Arif', 'Hamza',
        'Jacob', 'Leart', 'Laszlo', 'Predrag', 'Mentor', 'Wendelin', 'Luís',
        'Constantin', 'Erion', 'Berat', 'Dardan', 'Melchior', 'Serkan',
        'Dorian', 'Eren', 'Fatih', 'Luzius', 'Nebojsa', 'Metin', 'Diar', 'Rino',
        'Ekrem', 'Isa', 'Jetmir', 'Edward', 'Nikolaos', 'Gazmend', 'Haris',
        'Kian', 'Ensar', 'Mirsad', 'Danny', 'Senad', 'Donat', 'Bilal', 'Ron',
        'Nael', 'Guy', 'Julio', 'Kujtim', 'Kushtrim', 'Lutz', 'Balthasar',
        'Rouven', 'Lias', 'Neil', 'Abraham', 'Magnus', 'Sérgio', 'Hansjürg',
        'Said', 'Ismael', 'Detlef', 'Umberto', 'Admir', 'Jayden', 'Jaime',
        'Karl-Heinz', 'Tomás', 'Florim', 'Achim', 'Devin', 'Maxime', 'Fitim',
        'Jean-Marc', 'Rayan', 'Sadik', 'Tarik', 'Abdul', 'Jack', 'Mergim',
        'Nelio', 'Sam', 'Flamur', 'Ignaz', 'Samuele', 'Tony', 'Petr',
        'Waldemar', 'Arda', 'Ardit', 'Lukasz', 'Milorad', 'Nicolai', 'Ramiz',
        'Aziz', 'Kamil', 'Rinor', 'Safet', 'Piero', 'Erkan', 'Niko', 'Zsolt',
        'Ernest', 'Miodrag', 'Alvaro', 'Astrit', 'Edmund', 'Jules', 'Cristiano',
        'Ivano', 'Kenneth', 'Saverio', 'Semir', 'Burak', 'Theophil', 'Altin',
        'Andrzej', 'Jonah', 'Jiri', 'Salih', 'Zoltán', 'Ferenc', 'Grzegorz',
        'Irfan', 'Johan', 'Kaan', 'Süleyman', 'Hussein', 'Rexhep', 'Besart',
        'Janos', 'Labinot', 'Onur', 'Stjepan', 'Domenic', 'Siro', 'Abel',
        'Florent', 'Christos', 'Swen', 'Branislav', 'Mato', 'Amin', 'Matej',
        'Slavko', 'Jusuf', 'Luke', 'Slavisa', 'Erol', 'Gabor', 'Jasmin',
        'Visar', 'Sinisa', 'Isidor', 'Merlin', 'Claus', 'Marin', 'Zoltan',
        'Muhammad', 'Neo', 'Zeno', 'Istvan', 'Adis', 'Edon', 'Gil', 'Leopold',
        'Hartmut', 'Raimund', 'Ken', 'Csaba', 'Kerim', 'Norman', 'Lucio',
        'László', 'Marjan', 'Damjan', 'Eugenio', 'Domingos', 'Reiner',
        'Augusto', 'Gzim', 'Nazmi', 'Laurenz', 'Zlatko', 'Jaroslav', 'Nevin',
        'Biagio', 'Felice', 'Balz', 'Boban', 'Marcelo', 'Caspar', 'Ledion',
        'Rodolfo', 'Aldin', 'Matti', 'Remzi', 'Ljubisa', 'Til', 'Péter', 'Umut',
        'Baris', 'Lirim', 'Mehdi', 'Edmond', 'Gonçalo', 'Jasin', 'Niclas',
        'Jordan', 'Mahmoud', 'Stanislav', 'Cornelius', 'Jona', 'Khaled',
        'Quentin', 'Gökhan', 'Imer', 'Volkan', 'Harun', 'Miran', 'Damien',
        'Gennaro', 'Jari', 'Marian', 'Rüdiger', 'Albrecht', 'Mile', 'Thiago',
        'Yvan', 'Alwin', 'Gani', 'Mahmut', 'Pero', 'Evan', 'Fisnik', 'Idriz',
        'Sergej', 'Sabri', 'Felipe', 'István', 'Dave', 'Hans-Jürgen', 'Jean-Luc',
        'Kastriot', 'Mariusz', 'Arne', 'Faruk', 'Gebhard', 'German',
        'Tamás', 'Anes', 'Arbnor', 'Mats', 'Drilon', 'Fábio', 'Mihajlo',
        'Sedat', 'Tahir',
    )

    # extracted from https://www.bfs.admin.ch/bfs/it/home/statistiche/popolazione/nascite-decessi/nomi-svizzera.assetdetail.3243318.html # noqa E501
    first_names_female = (
        'Maria', 'Anna', 'Ursula', 'Ruth', 'Elisabeth', 'Sandra', 'Monika',
        'Claudia', 'Verena', 'Nicole', 'Barbara', 'Silvia', 'Andrea', 'Marie',
        'Daniela', 'Christine', 'Karin', 'Marianne', 'Erika', 'Margrit',
        'Brigitte', 'Susanne', 'Rita', 'Laura', 'Sarah', 'Katharina',
        'Rosmarie', 'Esther', 'Heidi', 'Anita', 'Manuela', 'Rosa', 'Doris',
        'Sonja', 'Beatrice', 'Yvonne', 'Gertrud', 'Jacqueline', 'Sara', 'Irene',
        'Ana', 'Franziska', 'Cornelia', 'Fabienne', 'Gabriela', 'Patricia',
        'Martina', 'Julia', 'Edith', 'Eva', 'Isabelle', 'Sabrina', 'Nathalie',
        'Alexandra', 'Corinne', 'Angela', 'Melanie', 'Alice', 'Nadine',
        'Jessica', 'Denise', 'Elena', 'Vanessa', 'Simone', 'Anne', 'Regula',
        'Susanna', 'Carmen', 'Sophie', 'Caroline', 'Emma', 'Nina', 'Tanja',
        'Catherine', 'Sabine', 'Lara', 'Petra', 'Lea', 'Céline', 'Jasmin',
        'Therese', 'Stefanie', 'Johanna', 'Nadia', 'Tamara', 'Chantal',
        'Martha', 'Michelle', 'Christina', 'Marina', 'Adelheid', 'Dora',
        'Monique', 'Rahel', 'Hedwig', 'Lisa', 'Janine', 'Pia', 'Anja',
        'Elsbeth', 'Madeleine', 'Eveline', 'Judith', 'Diana', 'Françoise',
        'Charlotte', 'Maja', 'Eliane', 'Renate', 'Christiane', 'Michèle',
        'Jennifer', 'Bettina', 'Chiara', 'Bernadette', 'Aline', 'Carla',
        'Helena', 'Brigitta', 'Mirjam', 'Theresia', 'Astrid', 'Nadja', 'Jana',
        'Selina', 'Priska', 'Lena', 'Stephanie', 'Lucia', 'Linda', 'Regina',
        'Agnes', 'Olivia', 'Sonia', 'Valérie', 'Klara', 'Ramona', 'Lina',
        'Elsa', 'Helene', 'Monica', 'Iris', 'Hanna', 'Valentina', 'Annemarie',
        'Elisa', 'Margrith', 'Dominique', 'Beatrix', 'Cristina', 'Paula',
        'Magdalena', 'Livia', 'Sofia', 'Patrizia', 'Liliane', 'Nelly', 'Marion',
        'Ida', 'Alina', 'Isabel', 'Vera', 'Stéphanie', 'Giulia', 'Leonie',
        'Jeannette', 'Christa', 'Alessia', 'Véronique', 'Myriam', 'Emilie',
        'Olga', 'Nora', 'Julie', 'Sylvia', 'Margaretha', 'Claudine', 'Marlise',
        'Miriam', 'Sibylle', 'Sylvie', 'Lydia', 'Katja', 'Lorena', 'Jolanda',
        'Rebecca', 'Mia', 'Irma', 'Larissa', 'Luana', 'Martine', 'Deborah',
        'Francesca', 'Veronika', 'Isabella', 'Noemi', 'Ingrid', 'Frieda',
        'Suzanne', 'Liselotte', 'Michaela', 'Florence', 'Evelyne', 'Hildegard',
        'Corina', 'Danielle', 'Laurence', 'Carole', 'Milena', 'Cécile', 'Mara',
        'Luzia', 'Sandrine', 'Gisela', 'Simona', 'Mélanie', 'Béatrice', 'Marta',
        'Antonia', 'Erna', 'Gabriele', 'Katrin', 'Kathrin', 'Melissa',
        'Camille', 'Adriana', 'Fiona', 'Lucie', 'Natalie', 'Teresa', 'Renata',
        'Josiane', 'Sophia', 'Clara', 'Luisa', 'Silvana', 'Jeannine', 'Pascale',
        'Hélène', 'Emilia', 'Joëlle', 'Gabriella', 'Maya', 'Marianna', 'Ines',
        'Léa', 'Claire', 'Marisa', 'Sina', 'Lia', 'Paola', 'Mathilde', 'Sabina',
        'Alessandra', 'Ivana', 'Anne-Marie', 'Elvira', 'Bianca', 'Samira',
        'Cindy', 'Amélie', 'Chloé', 'Kim', 'Victoria', 'Annette', 'Angelina',
        'Dorothea', 'Antoinette', 'Tina', 'Tania', 'Angelika', 'Valeria',
        'Flavia', 'Margaritha', 'Rachel', 'Marguerite', 'Jeanne', 'Yvette',
        'Natalia', 'Alicia', 'Giovanna', 'Mireille', 'Liliana', 'Pauline',
        'Seraina', 'Elodie', 'Ariane', 'Helga', 'Zoé', 'Natascha', 'Muriel',
        'Francine', 'Joana', 'Melina', 'Aurélie', 'Thi', 'Giuseppina',
        'Tatiana', 'Margareta', 'Louise', 'Marija', 'Debora', 'Salome',
        'Viviane', 'Fanny', 'Katia', 'Carolina', 'Irina', 'Bertha', 'Marlene',
        'Noémie', 'Amanda', 'Sarina', 'Marlies', 'Lilian', 'Irène', 'Laetitia',
        'Kristina', 'Jasmine', 'Ella', 'Jenny', 'Gabrielle', 'Carmela', 'Manon',
        'Helen', 'Fatima', 'Stefania', 'Virginie', 'Ladina', 'Jelena', 'Berta',
        'Antonella', 'Rebekka', 'Audrey', 'Anaïs', 'Tatjana', 'Annina',
        'Margot', 'Carina', 'Samantha', 'Evelyn', 'Annamarie', 'Tiziana',
        'Arlette', 'Emily', 'Kerstin', 'Svenja', 'Caterina', 'Christelle',
        'Saskia', 'Elin', 'Lilly', 'Anouk', 'Rose', 'Fatma', 'Lynn', 'Elina',
        'Colette', 'Josette', 'Leila', 'Gerda', 'Susana', 'Geneviève',
        'Désirée', 'Naomi', 'Stella', 'Romina', 'Delphine', 'Aurora', 'Estelle',
        'Juliette', 'Tabea', 'Anina', 'Thérèse', 'Mariana', 'Beatriz', 'Hilda',
        'Lotti', 'Séverine', 'Delia', 'Ronja', 'Gina', 'Mila', 'Antonietta',
        'Veronica', 'Aleksandra', 'Gisèle', 'Lidia', 'Natacha', 'Laure',
        'Pamela', 'Rosemarie', 'Marie-Louise', 'Jael', 'Eleonora', 'Zoe',
        'Franca', 'Hannah', 'Yolanda', 'Birgit', 'Amina', 'Leandra', 'Elise',
        'Alma', 'Anastasia', 'Marlis', 'Fernanda', 'Irmgard', 'Micheline',
        'Elfriede', 'Selma', 'Ilona', 'Danièle', 'Justine', 'Magali',
        'Georgette', 'Graziella', 'Cynthia', 'Cäcilia', 'Loredana', 'Géraldine',
        'Sylviane', 'Heidy', 'Alexia', 'Mary', 'Ingeborg', 'Emine', 'Yara',
        'Ursina', 'Marlène', 'Morgane', 'Michela', 'Katarina', 'Marine',
        'Ulrike', 'Daria', 'Bruna', 'Jasmina', 'Mira', 'Soraya', 'Juliana',
        'Marlyse', 'Agnès', 'Carine', 'Gloria', 'Alena', 'Svetlana', 'Josefina',
        'Annelise', 'Myrta', 'Roberta', 'Pierrette', 'Celine', 'Annika',
        'Mirjana', 'Andrée', 'Célia', 'Serena', 'Christel', 'Susan', 'Jocelyne',
        'Renée', 'Vesna', 'Andreia', 'Elizabeth', 'Cinzia', 'Karen', 'Cecilia',
        'Karine', 'Marlen', 'Ilaria', 'Virginia', 'Suzana', 'Rose-Marie',
        'Jeanine', 'Margarita', 'Joanna', 'Coralie', 'Elif', 'Dina', 'Janina',
        'Josefine', 'Mina', 'Hannelore', 'Gordana', 'Luciana', 'Heike',
        'Aurelia', 'Luna', 'Dagmar', 'Filomena', 'Dolores', 'Raymonde',
        'Prisca', 'Annick', 'Huguette', 'Elisabetha', 'Dragana', 'Leona',
        'Elke', 'Inès', 'Valerie', 'Ayse', 'Amelia', 'Flurina', 'Marie-Thérèse',
        'Roswitha', 'Rosanna', 'Ginette', 'Matilde', 'Mélissa', 'Yolande',
        'Océane', 'Giada', 'Murielle', 'Danijela', 'Sanja', 'Slavica',
        'Adelina', 'Valentine', 'Catarina', 'Raquel', 'Emmanuelle', 'Dana',
        'Erica', 'Marcelle', 'Nancy', 'Germaine', 'Concetta', 'Gianna', 'Jade',
        'Lucienne', 'Letizia', 'Fatime', 'Odette', 'Solange', 'Lily', 'Nada',
        'Lucy', 'Margherita', 'Hana', 'Elisabetta', 'Leana', 'Vivienne',
        'Viola', 'Ljiljana', 'Yasmin', 'Agatha', 'Jutta', 'Anabela', 'Laila',
        'Romana', 'Gaëlle', 'Belinda', 'Aida', 'Federica', 'Giuliana', 'Marie-Claire',
        'Mirella', 'Eliana', 'Paulina', 'Diane', 'Paulette', 'Mona',
        'Milica', 'Corinna', 'Yasmine', 'Annalise', 'Hatice', 'Alyssa', 'Ellen',
        'Kelly', 'Biljana', 'Noelia', 'Alisha', 'Léonie', 'Amandine', 'Amelie',
        'Amy', 'Lilli', 'Nelli', 'Margaux', 'Melisa', 'Anneliese', 'Marie-Claude',
        'Sheila', 'Dragica', 'Xenia', 'Violeta', 'Annie', 'Lou',
        'Meret', 'Ute', 'Irena', 'Catia', 'Giuseppa', 'Sybille', 'Lana',
        'Celina', 'Aylin', 'Zita', 'Karolina', 'Louisa', 'Luise', 'Rosina',
        'Jeanette', 'Sharon', 'Henriette', 'Joy', 'Inge', 'Carola', 'Tiffany',
        'Margarete', 'Marietta', 'Josefa', 'Leyla', 'Nuria', 'Anne-Lise',
        'Gilberte', 'Giorgia', 'Emanuela', 'Daisy', 'Angelica', 'Josephine',
        'Ilse', 'Natasa', 'Andrina', 'Fabiana', 'Flora', 'Maude', 'Melinda',
        'Silke', 'Enya', 'Amira', 'Beate', 'Viktoria', 'Francisca', 'Merita',
        'Odile', 'Snezana', 'Ariana', 'Carol', 'Medina', 'Romy', 'Noëlle',
        'Alissa', 'Elisabete', 'Camilla', 'Miranda', 'Leonora', 'Lejla',
        'Zeynep', 'Maeva', 'Domenica', 'Raffaella', 'Salomé', 'Ornella',
        'Rosaria', 'Alisa', 'Alba', 'Zorica', 'Roxane', 'Raphaela', 'Inês',
        'Hermine', 'Waltraud', 'Aude', 'Selin', 'Claude', 'Arianna',
        'Angélique', 'Leticia', 'Malin', 'Viviana', 'Annelies', 'Damaris',
        'Liv', 'Maëlle', 'Sigrid', 'Jill', 'Karina', 'Liana', 'Eline', 'Lotte',
        'Lise', 'Rina', 'Morena', 'Marilena', 'Leonor', 'Annamaria', 'Albina',
        'Dijana', 'Grazia', 'Ester', 'Vivien', 'Käthi', 'Tara', 'Aurore',
        'Katarzyna', 'Amalia', 'Celia', 'Seline', 'Anisa', 'Azra', 'Adeline',
        'Fabiola', 'Agnieszka', 'Greta', 'Jane', 'Vincenza', 'Rosalia', 'Marie-Christine',
        'Marijana', 'Jara', 'Gudrun', 'Edona', 'Gioia', 'Marcia',
        'Myrtha', 'Ekaterina', 'Lucette', 'Gertrude', 'Ljubica', 'Adrienne',
        'Malika', 'Ava', 'Yael', 'Lola', 'Marinette', 'Teuta', 'Joelle',
        'Beata', 'Line', 'Priscilla', 'Rosalie', 'Mariette', 'Ada', 'Marielle',
        'Juliane', 'Emina', 'Arta', 'Margarida', 'Claire-Lise', 'Gaia', 'Antje',
        'Raffaela', 'Mercedes', 'Vlora', 'Arlinda', 'Nicoletta', 'Alison',
        'Ottilia', 'Clémence', 'Lisbeth', 'Shqipe', 'Adele', 'Maryline',
        'Sónia', 'Ewa', 'Drita', 'Gladys', 'Dilara', 'Malgorzata', 'Eleni',
        'Sandy', 'Marika', 'Marthe', 'Norma', 'Carolin', 'Ina', 'Agathe',
        'Alea', 'Anke', 'Zora', 'Cristiana', 'Marie-José', 'Liridona', 'Romane',
        'Noa', 'Shpresa', 'Esma', 'Assunta', 'Vittoria', 'Blerta', 'Ema',
        'Elma', 'Anika', 'Marie-France', 'Samanta', 'Mariella', 'Meryem',
        'Tânia', 'Ghislaine', 'Marica', 'Desirée', 'Britta', 'Joséphine',
        'Moira', 'Maud', 'Gemma', 'Silja', 'Sladjana', 'Sanela', 'Iva', 'Ann',
        'Nadège', 'Corine', 'Frida', 'Cheyenne', 'Theres', 'Lilia', 'Matilda',
        'Geraldine', 'Lisette', 'Margaret', 'Eloïse', 'Felicia', 'Hulda',
        'Kathleen', 'Erina', 'Jovana', 'Timea', 'Sofie', 'Wanda', 'Anne-Sophie',
        'Zahra', 'Florentina', 'Alexa', 'Ruzica', 'Ganimete', 'Herta', 'Agata',
        'Yasemin', 'Frédérique', 'Nicola', 'Norah', 'Lorenza', 'Ilenia',
        'Khadija', 'Elda', 'Felicitas', 'Charline', 'Ela', 'Eliza', 'Katalin',
        'Rafaela', 'Tanya', 'Theresa', 'Floriane', 'Katherine', 'Asia',
        'Mathilda', 'Fabia', 'Fatmire', 'Imelda', 'Susi', 'Zuzana', 'Cassandra',
        'Donatella', 'Antonina', 'Luz', 'Yasmina', 'Eleonore', 'Bluette',
        'Malea', 'Danica', 'Dunja', 'Kirsten', 'Eileen', 'Mirela', 'Vanesa',
        'Filipa', 'Léna', 'Jaqueline', 'Evelin', 'Violette', 'Vjollca',
        'Mariam', 'Maryam', 'Amela', 'Luigia', 'Noëmi', 'Joyce', 'Pierina',
        'Aferdita', 'Cátia', 'Mandy', 'Regine', 'Branka', 'Radmila', 'Vreneli',
        'Marcella', 'Grace', 'Ludivine', 'Natasha', 'Olena', 'Elea', 'Jil',
        'Anne-Laure', 'Eléonore', 'Ayla', 'Mégane', 'Maddalena', 'Sereina',
        'Tenzin', 'Dafina', 'Eve', 'Leslie', 'Alix', 'Kiara', 'Ardita', 'Aisha',
        'Margit', 'Janet', 'Kira', 'Margreth', 'Amra', 'Marcela', 'Solène',
        'Kristin', 'Fitore', 'Rosalba', 'Edina', 'Mariangela', 'Agnese',
        'Albulena', 'Joanne', 'Ylenia', 'Clarissa', 'Magda', 'Marie-Laure',
        'Anna-Maria', 'Luljeta', 'Marjorie', 'Annalisa', 'Lidija', 'Ajla',
        'Sanije', 'Wendy', 'Wilma', 'Layla', 'Thea', 'Esra', 'Jaël', 'Fernande',
        'Vania', 'Lindita', 'Tessa', 'Mimoza', 'Kata', 'Maryse', 'Dalia',
        'Käthe', 'Blanka', 'Katerina', 'Ophélie', 'Leni', 'Egzona', 'Eugenia',
        'Lavinia', 'Léane', 'Bukurije', 'Cordula', 'Teodora', 'Nikolina',
        'Özlem', 'Lauriane', 'Milka', 'Patrícia', 'Aloisia', 'Lya', 'Derya',
        'Margret', 'Juana', 'Vilma', 'Annabelle', 'Besarta', 'Norina',
        'Cláudia', 'Nives', 'Hanife', 'Blerina', 'Lydie', 'Gerlinde', 'Déborah',
        'Mirlinda', 'Vivian', 'María', 'Shania', 'Romaine', 'Tuana', 'Berthe',
        'Friederike', 'Susann', 'Rosetta', 'Hava', 'Kaltrina', 'Marie-Jeanne',
        'Iryna', 'Mihaela',
    )

    first_names = first_names_male + first_names_female

    last_names = (
        'Ackermann', 'Aebi', 'Albrecht', 'Ammann', 'Amrein', 'Arnold',
        'Bachmann', 'Bader', 'Bär', 'Bättig', 'Bauer', 'Baumann',
        'Baumgartner', 'Baur', 'Beck', 'Benz', 'Berger', 'Bernasconi',
        'Betschart', 'Bianchi', 'Bieri', 'Blaser', 'Blum', 'Bolliger',
        'Bosshard', 'Braun', 'Brun', 'Brunner', 'Bucher', 'Bühler', 'Bühlmann',
        'Burri', 'Christen', 'Egger', 'Egli', 'Eichenberger', 'Erni', 'Ernst',
        'Eugster', 'Fankhauser', 'Favre', 'Fehr', 'Felber', 'Felder',
        'Ferrari', 'Fischer', 'Flückiger', 'Forster', 'Frei', 'Frey', 'Frick',
        'Friedli', 'Fuchs', 'Furrer', 'Gasser', 'Geiger', 'Gerber', 'Gfeller',
        'Giger', 'Gloor', 'Graf', 'Grob', 'Gross', 'Gut', 'Haas', 'Häfliger',
        'Hafner', 'Hartmann', 'Hasler', 'Hauser', 'Hermann', 'Herzog', 'Hess',
        'Hirt', 'Hodel', 'Hofer', 'Hoffmann', 'Hofmann', 'Hofstetter', 'Hotz',
        'Huber', 'Hug', 'Hunziker', 'Hürlimann', 'Imhof', 'Isler', 'Iten',
        'Jäggi', 'Jenni', 'Jost', 'Kägi', 'Kaiser', 'Kälin', 'Käser',
        'Kaufmann', 'Keller', 'Kern', 'Kessler', 'Knecht', 'Koch', 'Kohler',
        'Kuhn', 'Küng', 'Kunz', 'Lang', 'Lanz', 'Lehmann', 'Leu', 'Leunberger',
        'Lüscher', 'Lustenberger', 'Lüthi', 'Lutz', 'Mäder', 'Maier', 'Marti',
        'Martin', 'Maurer', 'Mayer', 'Meier', 'Meili', 'Meister', 'Merz',
        'Mettler', 'Meyer', 'Michel', 'Moser', 'Müller', 'Näf', 'Ott', 'Peter',
        'Pfister', 'Portmann', 'Probst', 'Rey', 'Ritter', 'Roos', 'Roth',
        'Rüegg', 'Schäfer', 'Schaller', 'Schär', 'Schärer', 'Schaub',
        'Scheidegger', 'Schenk', 'Scherrer', 'Schlatter', 'Schmid', 'Schmidt',
        'Schneider', 'Schnyder', 'Schoch', 'Schuler', 'Schumacher', 'Schürch',
        'Schwab', 'Schwarz', 'Schweizer', 'Seiler', 'Senn', 'Sidler',
        'Siegrist', 'Sigrist', 'Spörri', 'Stadelmann', 'Stalder', 'Staub',
        'Stauffer', 'Steffen', 'Steiger', 'Steiner', 'Steinmann', 'Stettler',
        'Stocker', 'Stöckli', 'Stucki', 'Studer', 'Stutz', 'Suter', 'Sutter',
        'Tanner', 'Thommen', 'Tobler', 'Vogel', 'Vogt', 'Wagner', 'Walder',
        'Walter', 'Weber', 'Wegmann', 'Wehrli', 'Weibel', 'Wenger',
        'Wettstein', 'Widmer', 'Winkler', 'Wirth', 'Wirz', 'Wolf', 'Wüthrich',
        'Wyss', 'Zbinden', 'Zehnder', 'Ziegler', 'Zimmermann', 'Zingg',
        'Zollinger', 'Zürcher',
    )

    prefixes = ('Dr.', 'Prof.')
