/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gsw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_PW = "Palau";
        final String metaValue_ar = "Arabisch";
        final String metaValue_bn = "Bengalisch";
        final String metaValue_bo = "Tibeetisch";
        final String metaValue_el = "Griechisch";
        final String metaValue_he = "Hebr\u00e4isch";
        final String metaValue_hy = "Armenisch";
        final String metaValue_ja = "Japanisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_kn = "Kannada";
        final String metaValue_mn = "Mongolisch";
        final String metaValue_si = "Singhalesisch";
        final String metaValue_su = "Sundanesisch";
        final String metaValue_ta = "Tamilisch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_zh = "Chineesisch";
        final String metaValue_ban = "Balinesisch";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_got = "Gotisch";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_ota = "Osmanisch";
        final String metaValue_peo = "Altpersisch";
        final String metaValue_sam = "Samaritanisch";
        final String metaValue_syr = "Syrisch";
        final String metaValue_uga = "Ugaritisch";
        final String metaValue_zbl = "Bliss-Symbool";
        final Object[][] data = new Object[][] {
            { "Ogam", "Ogham" },
            { "mwl", "Mirandesisch" },
            { "cch", "Atsam" },
            { "mwr", "Marwarisch" },
            { "Tagb", "Tagbanwa" },
            { "%%NJIVA", "Njiva-Mundart" },
            { "egy", "Alt\u00e4gyptisch" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Temne" },
            { "rap", "Oschterinsel-Schpraach" },
            { "ter", "Tereno-Schpraach" },
            { "rar", "Rarotonganisch" },
            { "tet", "Tetum-Schpraach" },
            { "AD", "Andorra" },
            { "AE", "Ver\u00e4inigti Arabischi Emirate" },
            { "nl_BE", "Fl\u00e4\u00e4misch" },
            { "AF", "Afganischtan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albaanie" },
            { "AM", "Armeenie" },
            { "Teng", "Tengwar" },
            { "AO", "Angoola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiinie" },
            { "AS", "Amerikaanisch-Samoa" },
            { "AT", "\u00d6\u00f6schtriich" },
            { "AU", "Auschtraalie" },
            { "AW", "Aruba" },
            { "en_US", "Amerikanischs \u00c4nglisch" },
            { "AX", "Aaland-Insle" },
            { "AZ", "Aserb\u00e4idschan" },
            { "%%AREVELA", "Oschtarmeenisch" },
            { "BA", "Bosnie und Herzegowina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesch" },
            { "kum", "Kum\u00fckisch" },
            { "BE", "Belgie" },
            { "gmh", "Mittelhocht\u00fc\u00fctsch" },
            { "BF", "Burkina Faaso" },
            { "BG", "Bulgaarie" },
            { "BH", "Bachr\u00e4in" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemi" },
            { "BM", "Bermuuda" },
            { "kut", "Kutenai-Schpraach" },
            { "myv", "Erzya" },
            { "BN", "Brun\u00e4i Tarussalam" },
            { "BO", "Boliivie" },
            { "BR", "Brasilie" },
            { "BS", "Bahaamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet-Insle" },
            { "BW", "Botswana" },
            { "BY", "Wiissrussland" },
            { "BZ", "Belize" },
            { "Visp", "Sichtbari Schpraach" },
            { "CA", "Kanada" },
            { "CC", "Kokos-Insle" },
            { "CD", "Temokraatischi Republik Kongo" },
            { "CF", "Zentraalafrikaanischi Republik" },
            { "CG", "Kongo" },
            { "CH", "Schwiiz" },
            { "CI", "Elfeb\u00e4ik\u00fcschte" },
            { "CK", "Cook-Insle" },
            { "CL", "Tschile" },
            { "CM", "Kamerun" },
            { "CN", "Chiina" },
            { "CO", "Kolumbie" },
            { "CR", "Coschta Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wienachts-Insle" },
            { "CY", "Zypere" },
            { "CZ", "Tschechischi Republik" },
            { "eka", "Ekajuk" },
            { "DE", "T\u00fc\u00fctschland" },
            { "goh", "Althocht\u00fc\u00fctsch" },
            { "ace", "Aceh" },
            { "DJ", "Tschibuuti" },
            { "DK", "T\u00e4nemark" },
            { "ach", "Acholi" },
            { "gon", "Gondi" },
            { "Brai", "Blind\u00e4schrift" },
            { "Brah", "Brahmi" },
            { "DM", "Tominica" },
            { "DO", "Tominikaanischi Republik" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zuni-Schpraach" },
            { "tig", "Tigre" },
            { "DZ", "Algeerie" },
            { "pag", "Pangasinanisch" },
            { "pal", "Mittelpersisch" },
            { "chb", "Tschibtscha" },
            { "pam", "Pampanggan-Schpraach" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Eestland" },
            { "tiv", "Tiv-Schpraach" },
            { "EG", "\u00c4g\u00fcpte" },
            { "EH", "Weschtsahara" },
            { "chg", "Tschagataisch" },
            { "pau", metaValue_PW },
            { "chk", "Trukesisch" },
            { "chn", "Chinook" },
            { "chm", "Tscheremissisch" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "\u00c4ritreea" },
            { "ES", "Schpanie" },
            { "ET", "\u00c4thiopie" },
            { "EU", "Europ\u00e4\u00e4ischi Unioon" },
            { "elx", "Elamisch" },
            { "type.ca.gregorian", "Gregoriaanisch Kal\u00e4nder" },
            { "chy", "Cheyenne" },
            { "Inds", "Indus-Schrift" },
            { "ady", "Adygai" },
            { "FI", "Finnland" },
            { "FJ", "Fitschi" },
            { "FK", "Falkland-Insle" },
            { "FM", "Mikroneesie" },
            { "FO", "F\u00e4r\u00f6er" },
            { "Taml", metaValue_ta },
            { "FR", "Frankriich" },
            { "tkl", "Tokelauanisch" },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "type.ca.indian", "Indisch Nationaalkal\u00e4nder" },
            { "grc", "Altgriechisch" },
            { "GA", "Gabun" },
            { "vot", "Wotisch" },
            { "GB", "Ver\u00e4inigts Ch\u00f6nigriich" },
            { "GD", "Grenada" },
            { "GE", "Geoorgie" },
            { "GF", "Franz\u00f6sisch-Gu\u00e4jaana" },
            { "GG", "G\u00e4\u00e4rnsi" },
            { "GH", "Gaana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Gr\u00f6\u00f6nland" },
            { "enm", "Mittel\u00e4nglisch" },
            { "GM", "Gambia" },
            { "GN", "Gineea" },
            { "GP", "Guad\u00e4lup" },
            { "GQ", "\u00c4quatoriaalgineea" },
            { "GR", "Griecheland" },
            { "GS", "S\u00fc\u00fcdgeorgie und d\u2019s\u00fc\u00fcdlichi S\u00e4ndwitsch-Insle" },
            { "GT", "Guatemaala" },
            { "GU", "Guam" },
            { "GW", "Gineea-Bissau" },
            { "tli", "Tlingit-Schpraach" },
            { "tlh", "Klingonisch" },
            { "Talu", "Tai Lue" },
            { "GY", "Gu\u00e4jaana" },
            { "zxx", "K\u00e4n schpraachliche Inhalt" },
            { "de_AT", "\u00d6schtriichischs T\u00fc\u00fctsch" },
            { "HK", "Sonderverwaltigszone Hongkong" },
            { "Vaii", "Vai" },
            { "HM", "H\u00f6\u00f6rd- und M\u00e4cDonald-Insle" },
            { "HN", "Honduras" },
            { "HR", "Kroaazie" },
            { "gsw", "Schwiizert\u00fc\u00fctsch" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "tmh", "Tamaseq" },
            { "peo", metaValue_peo },
            { "ID", "Indoneesie" },
            { "IE", "Irland" },
            { "nap", "Neapolitanisch" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Insle vo M\u00e4n" },
            { "IN", "Indie" },
            { "IO", "Britischs Territoorium im Indische Oozean" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Iisland" },
            { "IT", "Itaalie" },
            { "%%POSIX", "Posix" },
            { "JE", "Dsch\u00f6rsi" },
            { "type.ca.islamic", "Islaamisch Kal\u00e4nder" },
            { "Beng", metaValue_bn },
            { "JM", "Dscham\u00e4ika" },
            { "JO", "Jordaanie" },
            { "JP", "Japan" },
            { "%%1606NICT", "Schpaats Mittelfranz\u00f6sisch" },
            { "ain", "Ainu" },
            { "tog", "Tsonga-Schpraach" },
            { "Kali", "Kayah Li" },
            { "de_CH", "Schwiizer Hocht\u00fc\u00fctsch" },
            { "type.ca.buddhist", "Buddhischtisch Kal\u00e4nder" },
            { "KE", "Keenia" },
            { "419", "Latiinameerika" },
            { "KG", "Kirgiisischtan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribaati" },
            { "KM", "Komoore" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts und Niuwis" },
            { "Zinh", "G\u2019eerbt\u00e4 Schriftw\u00e4rt" },
            { "fr_CA", "Kanadischs Franz\u00f6sisch" },
            { "KP", "Demokraatischi Volksrepublik Koreea" },
            { "KR", "Republik Koreea" },
            { "Plrd", "Pollard Phonetisch" },
            { "fr_CH", "Schwiizer Franz\u00f6sisch" },
            { "KW", "Kuw\u00e4it" },
            { "tpi", "Neumelanesisch" },
            { "KY", "K\u00e4im\u00e4n-Insle" },
            { "KZ", "Kasachschtan" },
            { "Cyrl", "Kyrillisch" },
            { "LA", "Laaos" },
            { "LB", "Libanon" },
            { "LC", "St. Lutschiia" },
            { "phn", "Ph\u00f6nikisch" },
            { "Cyrs", "Altchileslawisch" },
            { "gwi", "Kutchinisch" },
            { "nds", "Nidert\u00fc\u00fctsch" },
            { "LI", "Li\u00e4chtescht\u00e4i" },
            { "LK", "Schri Lanka" },
            { "akk", "Akkadisch" },
            { "cop", metaValue_cop },
            { "LR", "Libeeria" },
            { "LS", "Lesooto" },
            { "Phlv", "Pahlavi" },
            { "LT", "Littaue" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "Kana", "Katakana" },
            { "LY", "L\u00fc\u00fcbie" },
            { "lad", "Ladino" },
            { "lah", "Lahndanisch" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "ME", "Monteneegro" },
            { "MF", "St. Martin" },
            { "lam", "Lambanisch" },
            { "MG", "Madagaschkar" },
            { "MH", "Marshallinsle" },
            { "ale", "Aleutisch" },
            { "Thai", "Thai" },
            { "ML", "Maali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolei" },
            { "new", "Newarisch" },
            { "MO", "Sonderverwaltigszone Macao" },
            { "MP", "N\u00f6rdlichi Mariaane" },
            { "MQ", "Martinigg" },
            { "MR", "Mauretaanie" },
            { "MS", "Moos\u00f6rrat" },
            { "MT", "Malta" },
            { "MU", "Mauriizius" },
            { "alt", "S\u00fc\u00fcd-Altaisch" },
            { "MV", "Malediiwe" },
            { "MW", "Malaawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japaanisch Kal\u00e4nder" },
            { "MY", "Mal\u00e4isia" },
            { "MZ", "Mosambik" },
            { "NA", "Namiibia" },
            { "type.ca.hebrew", "Hebr\u00e4\u00e4isch Kal\u00e4nder" },
            { "NC", "N\u00f6ikaledoonie" },
            { "NE", "Niger" },
            { "NF", "Norfolk-Insle" },
            { "NG", "Nigeeria" },
            { "NI", "Nicaraagua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Holland" },
            { "NO", "Norweege" },
            { "NP", "Neepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "Ph\u00f6nizisch" },
            { "tsi", "Tsimshian-Schpraach" },
            { "NZ", "N\u00f6iseeland" },
            { "rom", "Zig\u00fc\u00fcnerschpraach" },
            { "Mero", "Meroitisch" },
            { "crh", "Krimtatarisch" },
            { "ang", "Alt\u00e4nglisch" },
            { "OM", "Omaan" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "B\u00fcrgerlich islaamisch Kal\u00e4nder" },
            { "csb", "Kaschubisch" },
            { "en_GB", "Britischs \u00c4nglisch" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6sisch-Polineesie" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippiine" },
            { "PK", "Pakischtan" },
            { "PL", "Poole" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierr und Miggelo" },
            { "PN", "Pitgg\u00e4\u00e4rn" },
            { "PR", "Puerto Riggo" },
            { "Bali", metaValue_ban },
            { "PS", "Pal\u00e4schtin\u00e4nsischi Gebiet" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "nia", "Nias-Schpraach" },
            { "PY", "Paraguai" },
            { "tum", "Tumbuka-Schpraach" },
            { "Hebr", metaValue_he },
            { "QA", "Ggatar" },
            { "%%SCOTLAND", "Schottischs Schtandard\u00e4nglisch" },
            { "niu", "Niue-Schpraach" },
            { "QO", "\u00dcssers Ozeaanie" },
            { "lez", "Lesgisch" },
            { "%%FONUPA", "Foneetisch (UPA)" },
            { "tvl", "Elliceanisch" },
            { "001", "W\u00e4lt" },
            { "002", "Afrika" },
            { "003", "Nordameerika" },
            { "RE", "Re\u00fcnioon" },
            { "005", "S\u00fc\u00fcdameerika" },
            { "jbo", "Lojbanisch" },
            { "Rjng", "Rejang" },
            { "009", "Ozeaanie" },
            { "RO", "Rum\u00e4\u00e4nie" },
            { "RS", "S\u00e4rbie" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "Manich\u00e4isch" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saudi-Araabie" },
            { "pon", "Ponapeanisch" },
            { "Mand", "Mand\u00e4isch" },
            { "SB", "Salomoone" },
            { "011", "Weschtafrika" },
            { "SC", "Seisch\u00e4lle" },
            { "SD", "Sudan" },
            { "013", "Mittelameerika" },
            { "SE", "Schweede" },
            { "014", "Oschtafrika" },
            { "arc", "Aram\u00e4\u00e4isch" },
            { "015", "Nordafrika" },
            { "SG", "Singapuur" },
            { "SH", "St. Helena" },
            { "017", "Zentraalafrika" },
            { "SI", "Sloweenie" },
            { "018", "S\u00fc\u00fcdlichs Afrika" },
            { "SJ", "Svalbard und Jaan M\u00e4\u00e4ie" },
            { "019", "Nord-, Mittel- und S\u00fc\u00fcdameerika" },
            { "SK", "Slowak\u00e4i" },
            { "SL", "Sierra Leoone" },
            { "SM", "San Mariino" },
            { "SN", "Senegal" },
            { "SO", "Somaalie" },
            { "arn", "Araukanisch" },
            { "arp", "Arapaho" },
            { "SR", "Surinam" },
            { "ST", "Sao Tome und Prinssipe" },
            { "SV", "El Salvador" },
            { "SY", "S\u00fc\u00fcrie" },
            { "yao", "Yao-Schpraach" },
            { "SZ", "Swasiland" },
            { "arw", "Arawak" },
            { "yap", "Yapesisch" },
            { "021", "N\u00f6rdlichs Ameerika" },
            { "TC", "T\u00f6rks- und Gaiggos-Insle" },
            { "TD", "Tschad" },
            { "TF", "Franz\u00f6sischi S\u00fc\u00fcd- und Antarktisgebiet" },
            { "TG", "Toogo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikischtan" },
            { "029", "Karibik" },
            { "TK", "Tokelau" },
            { "TL", "Oschttimor" },
            { "TM", "Turkmeenischtan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tuneesie" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrggei" },
            { "TT", "Trinidad und Tobaago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Aschturianisch" },
            { "Orkh", "Orchon-Run\u00e4" },
            { "TZ", "Tansaniia" },
            { "Zzzz", "Uncodiirti Schrift" },
            { "UA", "Ukraiine" },
            { "rup", "Aromunisch" },
            { "030", "Oschtaasie" },
            { "tyv", "Tuwinisch" },
            { "034", "S\u00fc\u00fcdaasie" },
            { "hai", "Haida" },
            { "035", "S\u00fc\u00fcdoschtaasie" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinyin-Sortiirregle" },
            { "039", "S\u00fc\u00fcdeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "Amerikanisch-Ozeaanie" },
            { "US", "Ver\u00e4inigti Schtaate" },
            { "haw", "Hawaiianisch" },
            { "type.co.gb2312han", "Ver\u00e4ifachts Chineesisch - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Uschbeekischtan" },
            { "type.co.stroke", "Strichfolg" },
            { "VA", "Vatikanstadt" },
            { "pro", "Altprovenzalisch" },
            { "VC", "St. Vincent und d\u2019Gr\u00f6nadiine" },
            { "VE", "Venezueela" },
            { "VG", "Britischi Jungfere-Insle" },
            { "VI", "Amerikaanischi Jungfere-Insle" },
            { "VN", "Wietnam" },
            { "VU", "Wanuatu" },
            { "nog", "Nogaisch" },
            { "non", "Altnordisch" },
            { "053", "Auschtraalie und N\u00f6iseeland" },
            { "%%AREVMDA", "Weschtarmeenisch" },
            { "054", "Melaneesie" },
            { "WF", "Wallis und Futuuna" },
            { "type.co.traditional", "Tradizionelli Sortiir-Regle" },
            { "057", "Mikroneesischs Inselgebiet" },
            { "WS", "Samooa" },
            { "wal", "Walamo-Schpraach" },
            { "was", "Washo-Schpraach" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polineesie" },
            { "Gujr", "Guscharati" },
            { "Zxxx", "Schriftlosi Schpraach" },
            { "Olck", "Ol Chiki" },
            { "Batk", "Battakisch" },
            { "Blis", metaValue_zbl },
            { "YE", "Jeeme" },
            { "nqo", metaValue_nqo },
            { "fan", "Pangwe-Schpraach" },
            { "%%ROZAJ", "Resianisch" },
            { "fat", "Fanti-Schpraach" },
            { "Sgnw", "Geb\u00e4\u00e4rdeschpraach" },
            { "YT", "Majott" },
            { "ZA", "S\u00fc\u00fcdafrika" },
            { "Deva", "T\u00f6vanagaari" },
            { "Hira", "Hiragana" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannti oder ung\u00fcltigi Regioon" },
            { "Runr", "Run\u00e4schrift" },
            { "lol", "Mongo" },
            { "nso", "Nord-Sotho-Schpraach" },
            { "loz", "Rotse-Schpraach" },
            { "hil", "Hiligaynonisch" },
            { "dak", "Takota" },
            { "hit", "Hethitisch" },
            { "dar", "Targiinisch" },
            { "Maya", "Maya-Hieroglyph\u00e4" },
            { "Copt", metaValue_cop },
            { "nwc", "Alt-Newari" },
            { "udm", "Udmurtisch" },
            { "Khmr", "Khmer" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe-Schpraach" },
            { "sah", "Jakutisch" },
            { "sam", metaValue_sam },
            { "%%SCOUSE", "Scouse-Mundart" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "jpr", "J\u00fc\u00fcdisch-Persisch" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno-Schpraach" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi-Schpraach" },
            { "lun", "Lunda-Schpraach" },
            { "nyo", "Nyoro" },
            { "luo", "Luo-Schpraach" },
            { "fil", "Filipino" },
            { "hmn", "Miao" },
            { "del", "Delaware-Schpraach" },
            { "lus", "Lushai-Schpraach" },
            { "bal", "Belutschisch" },
            { "den", "Slavey" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "bas", "Basaa" },
            { "jrb", "J\u00fc\u00fcdisch-Arabisch" },
            { "es_ES", "Ibeerischs Schpanisch" },
            { "nzi", "Nzima" },
            { "sco", "Schottisch" },
            { "scn", "Sizilianisch" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharisch" },
            { "Arab", metaValue_ar },
            { "an", "Aragonesisch" },
            { "%%SOLBA", "Solbica-Mundart" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana oder Hiragana" },
            { "as", "Assamesisch" },
            { "Lina", "Linear A" },
            { "av", "Awarisch" },
            { "Linb", "Linear B" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "%%OSOJS", "Osojane-Mundart" },
            { "ba", "Baschkirisch" },
            { "be", "Wiissrussisch" },
            { "bg", "Bulgaarisch" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Togrib" },
            { "br", "Br\u00f6toonisch" },
            { "bs", "Bosnisch" },
            { "Mymr", "Burmesisch" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkupisch" },
            { "ca", "Katalaanisch" },
            { "ce", "Tschetscheenisch" },
            { "ch", "Chamorro" },
            { "%%REVISED", "N\u00f6\u00f6i R\u00e4chtschriibig" },
            { "co", "Korsisch" },
            { "Orya", "Oriya" },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Chileslawisch" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "Yiii", "Yi" },
            { "da", "T\u00e4nisch" },
            { "pt_PT", "Iberischs Portugiisisch" },
            { "de", "T\u00fc\u00fctsch" },
            { "bej", "Bedauye" },
            { "din", "Tinka" },
            { "Bugi", "Buginesisch" },
            { "bem", "Bemba" },
            { "sga", "Altirisch" },
            { "dv", "Malediivisch" },
            { "es_419", "Latiinamerikanischs Schpanisch" },
            { "dz", "Dschongkha" },
            { "type.ca.chinese", "Chineesisch Kal\u00e4nder" },
            { "ee", "Ewe" },
            { "ro_MD", "Moldawisch" },
            { "el", metaValue_el },
            { "en", "\u00c4nglisch" },
            { "eo", "Eschperanto" },
            { "type.co.big5han", "Tradizionells Chineesisch - Big5" },
            { "es", "Schpanisch" },
            { "et", "Eestnisch" },
            { "eu", "Baskisch" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", metaValue_sam },
            { "Hani", metaValue_zh },
            { "hsb", "Obersorbisch" },
            { "shn", "Schan-Schpraach" },
            { "Hano", "Hanunoo" },
            { "fa", "Persisch" },
            { "Hans", "Ver\u00e4ifachti Chineesischi Schrift" },
            { "Hant", "Tradizionelli Chineesischi Schrift" },
            { "ff", "Ful" },
            { "fi", "Finnisch" },
            { "fj", "Fidschianisch" },
            { "fon", "Fon" },
            { "fo", "F\u00e4r\u00f6isch" },
            { "umb", "Mbundu-Schpraach" },
            { "fr", "Franz\u00f6sisch" },
            { "sid", "Sidamo" },
            { "fy", "Friesisch" },
            { "ga", "Iirisch" },
            { "gd", "Schottisch-G\u00e4\u00e4lisch" },
            { "gl", "Galizisch" },
            { "gn", "Guarani" },
            { "bho", "Bhodschpuri" },
            { "und", "Unbeschtimmti Schpraach" },
            { "gu", "Gujarati" },
            { "gv", "Manx-G\u00e4\u00e4lisch" },
            { "ha", "Haussa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikolisch" },
            { "bin", "Bini" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroazisch" },
            { "ht", "Haitisch" },
            { "hu", "Ungarisch" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "%%FONIPA", "Foneetisch (IPA)" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sezuanischs Yi" },
            { "frm", "Mittelfranz\u00f6sisch" },
            { "ik", "Inupiak" },
            { "fro", "Altfranz\u00f6sisch" },
            { "io", "Ido" },
            { "frs", "Oschtfriesisch" },
            { "frr", "Nordfriesisch" },
            { "is", "Iisl\u00e4ndisch" },
            { "it", "Itali\u00e4nisch" },
            { "iu", "Inukitut" },
            { "ja", metaValue_ja },
            { "Mlym", "Malaysisch" },
            { "Sara", "Sarati" },
            { "doi", "Togri" },
            { "sma", "S\u00fc\u00fcd-Samisch" },
            { "jv", "Javanisch" },
            { "Shaw", "Shaw-Alphabet" },
            { "mad", "Maduresisch" },
            { "smj", "Lule-Samisch" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "smn", "Inari-Samisch" },
            { "ka", metaValue_ka },
            { "bla", "Blackfoot-Schpraach" },
            { "mak", "Makassarisch" },
            { "sms", "Skolt-Samisch" },
            { "man", "Manding-Schpraach" },
            { "kg", "Kongolesisch" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu-Schpraach" },
            { "mas", "Massai-Schpraach" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gr\u00f6\u00f6nl\u00e4ndisch" },
            { "km", "Kambodschanisch" },
            { "kn", metaValue_kn },
            { "ko", "Koreaanisch" },
            { "kr", "Kanuri-Schpraach" },
            { "ks", "Kaschmirisch" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", "Aveschtisch" },
            { "ku", "Kurdisch" },
            { "kv", "Komi-Schpraach" },
            { "kw", "Kornisch" },
            { "ky", "Kirgiisisch" },
            { "snk", "Soninke-Schpraach" },
            { "la", "Latiin" },
            { "lb", "Luxemburgisch" },
            { "lg", "Ganda-Schpraach" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgisch" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulisch" },
            { "lo", "Laozisch" },
            { "lt", "Litauisch" },
            { "lu", "Luba" },
            { "lv", "Lettisch" },
            { "sog", "Sogdisch" },
            { "mg", "Madagassisch" },
            { "mh", "Marschallesisch" },
            { "mi", "Maori" },
            { "mk", "Mazedonisch" },
            { "ml", "Malayalam" },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", "Birmanisch" },
            { "Saur", "Saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "Mokschamordwinisch" },
            { "dsb", "Nidersorbisch" },
            { "na", "Nauruisch" },
            { "nb", "Norwegisch Bokm\u00e5l" },
            { "nd", "Nord-Ndebele-Schpraach" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "mdr", "Mandaresisch" },
            { "nl", "Niderl\u00e4ndisch" },
            { "nn", "Norwegisch Nynorsk" },
            { "no", "Norwegisch" },
            { "nr", "S\u00fc\u00fcd-Ndebele-Schpraach" },
            { "nv", "Navajo-Schpraach" },
            { "kaa", "Karakalpakisch" },
            { "ny", "Chewa-Schpraach" },
            { "kac", "Kachin-Schpraach" },
            { "kab", "Kabylisch" },
            { "%%POLYTON", "Politonisch" },
            { "oc", "Okzitanisch" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende-Schpraach" },
            { "oj", "Ojibwa-Schpraach" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "or", "Orija" },
            { "os", "Ossezisch" },
            { "kbd", "Kabardinisch" },
            { "srn", "Srananisch" },
            { "pa", "Pandschabisch" },
            { "dua", "Tuala" },
            { "srr", "Serer-Schpraach" },
            { "%%LIPAW", "Lipowaz-Mundart" },
            { "pi", "Pali" },
            { "pl", "Polnisch" },
            { "dum", "Mittelniderl\u00e4ndisch" },
            { "ps", "Paschtu" },
            { "pt", "Portugiisisch" },
            { "mga", "Mittelirisch" },
            { "key.co", "Sortiirig" },
            { "pt_BR", "Brasilianischs Portugiisisch" },
            { "kcg", "Tyap" },
            { "bra", "Braj-Bhakha" },
            { "key.ca", "Kal\u00e4nder" },
            { "Laoo", "Laotisch" },
            { "qu", "Quechua" },
            { "zap", "Zapotekisch" },
            { "Lana", "Lanna" },
            { "Ethi", "\u00c4zioopisch" },
            { "rm", "R\u00e4toromanisch" },
            { "rn", "Rundi-Schpraach" },
            { "key.cu", "W\u00e4\u00e4hrig" },
            { "ro", "Rum\u00e4nisch" },
            { "%%SAAHO", "Saho" },
            { "ru", "Russisch" },
            { "zbl", metaValue_zbl },
            { "rw", "Ruandisch" },
            { "mic", "Micmac-Schpraach" },
            { "suk", "Sukuma-Schpraach" },
            { "en_AU", "Auschtralischs \u00c4nglisch" },
            { "sa", "Sanschkrit" },
            { "sc", "Sardisch" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Nord-Samisch" },
            { "min", "Minangkabau-Schpraach" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "si", metaValue_si },
            { "sux", "Sumerisch" },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "sm", "Samoanisch" },
            { "sn", "Schhona" },
            { "so", "Somali" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "st", "S\u00fc\u00fcd-Sotho-Schpraach" },
            { "Java", "Javanesisch" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-Mundart" },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "iba", "Ibanisch" },
            { "ta", metaValue_ta },
            { "142", "Aasie" },
            { "bua", "Burjatisch" },
            { "143", "Zentraalaasie" },
            { "te", metaValue_te },
            { "145", "Weschtaasie" },
            { "tg", "Tadschikisch" },
            { "th", "Thail\u00e4ndisch" },
            { "ti", "Tigrinja" },
            { "bug", "Bugineesisch" },
            { "kfo", "Koro" },
            { "en_CA", "Kanadischs \u00c4nglisch" },
            { "tk", "Turkmenisch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana-Schpraach" },
            { "to", "Tongaisch" },
            { "tr", "T\u00fcrkisch" },
            { "ts", "Tsonga" },
            { "tt", "Tatarisch" },
            { "dyu", "Tiula" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "%%BISKE", "Bela-Tial\u00e4kt" },
            { "150", "Euroopa" },
            { "151", "Oschteuroopa" },
            { "154", "Nordeuroopa" },
            { "155", "Weschteuroopa" },
            { "ug", "Uigurisch" },
            { "Ital", "Altitalisch" },
            { "Kore", "Koreanisch" },
            { "Zyyy", "Unbeschtimmt" },
            { "uk", "Ukrainisch" },
            { "ur", "Urdu" },
            { "%%1994", "Schtandardisierti Resianischi R\u00e4chtschriibig" },
            { "xal", "Kalm\u00fcckisch" },
            { "zen", "Zenaga" },
            { "uz", "Usbekisch" },
            { "kha", "Khasisch" },
            { "%%1996", "N\u00f6\u00f6i t\u00fc\u00fctschi R\u00e4chtschriibig" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda-Schpraach" },
            { "type.ca.roc", "Kal\u00e4nder vor Republik Chiina" },
            { "vi", "Vietnamesisch" },
            { "kho", "Sakisch" },
            { "%%TARASK", "Taraskievica-R\u00e4chtschriibig" },
            { "vo", "Volap\u00fck" },
            { "syc", "Altsyrisch" },
            { "Osma", metaValue_ota },
            { "gaa", "Ga" },
            { "wa", "Wallonisch" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "Lydisch" },
            { "Xsux", "Sumerisch-akkadischi Keilschrift" },
            { "wo", "Wolof" },
            { "Cans", "UCAS" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mandschurisch" },
            { "Latf", "Latiinisch - Fraktur-Variante" },
            { "gba", "Gbaya" },
            { "mni", "Meithei-Schpraach" },
            { "Latn", "Latiinisch" },
            { "Latg", "Latiinisch - G\u00e4\u00e4lischi Variante" },
            { "xh", "Xhosa" },
            { "byn", "Blin" },
            { "Lyci", "Lykisch" },
            { "osa", "Osage-Schpraach" },
            { "Moon", "Moon" },
            { "moh", "Mohawk-Schpraach" },
            { "Syrc", metaValue_syr },
            { "yi", "Jiddisch" },
            { "mos", "Mossi-Schpraach" },
            { "Dsrt", "Teseret" },
            { "yo", "Yoruba" },
            { "Syrj", "Weschtsyrisch" },
            { "ota", metaValue_ota },
            { "Syre", "Syrisch - Eschtrangelo-Variante" },
            { "vai", "Vai-Schpraach" },
            { "za", "Zhuang" },
            { "Cari", "Karisch" },
            { "zh", metaValue_zh },
            { "Bopo", "Bopomofo" },
            { "Perm", "Altpermisch" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Telifonbuech-Sortiirregle" },
            { "%%MONOTON", "Monotonisch" },
            { "Geor", metaValue_ka },
            { "kmb", "Kimbundu-Schpraach" },
            { "gez", "Geez" },
            { "Syrn", "Oschtsyrisch" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Temozisch-\u00c4g\u00fcptisch" },
            { "Egyh", "Hiraazisch-\u00c4g\u00fcptisch" },
            { "Egyp", "\u00c4g\u00fcptischi Hirogl\u00fc\u00fcfe" },
            { "Geok", "Ghutsuri" },
            { "zh_Hans", "Ver\u00e4ifachts Chineesisch" },
            { "Hung", "Altungarisch" },
            { "kok", "Konkani" },
            { "%%1901", "Alti t\u00fc\u00fctschi R\u00e4chtschriibig" },
            { "kos", "Kosraeanisch" },
            { "zh_Hant", "Tradizionells Chineesisch" },
            { "Sund", metaValue_su },
            { "kpe", "Kpelle-Schpraach" },
            { "ilo", "Ilokano" },
            { "Cprt", "Zypriotisch" },
            { "%%BAKU1926", "\u00c4inheitlichs T\u00fcrggischs Alfabeet" },
            { "mul", "Mehrschpraachig" },
            { "cad", "Caddo" },
            { "mus", "Muskogee-Schpraach" },
            { "Glag", "Glagolitisch" },
            { "gil", "Gilbertesisch" },
            { "Cher", metaValue_chr },
            { "car", "Kariibisch" },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "inh", "Inguschisch" },
            { "krl", "Karelisch" },
            { "efi", "Efikisch" },
            { "kru", "Oraon-Schpraach" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
