/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_en extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ae = "Avestan";
        final String metaValue_ar = "Arabic";
        final String metaValue_bn = "Bengali";
        final String metaValue_bo = "Tibetan";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_hy = "Armenian";
        final String metaValue_ja = "Japanese";
        final String metaValue_jv = "Javanese";
        final String metaValue_ka = "Georgian";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_la = "Latin";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sundanese";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Balinese";
        final String metaValue_bug = "Buginese";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptic";
        final String metaValue_got = "Gothic";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_peo = "Old Persian";
        final String metaValue_phn = "Phoenician";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_syr = "Syriac";
        final String metaValue_uga = "Ugaritic";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbols";
        final Object[][] data = new Object[][] {
            { "ksh", "Colognian" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandese" },
            { "key.colStrength", "Sorting Strength" },
            { "Zsym", "Symbols" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "type.nu.lanatham", "Tai Tham Tham Digits" },
            { "egl", "Emilian" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Gniva/Njiva dialect" },
            { "xmf", "Mingrelian" },
            { "key.ss", "Sentence Break Suppressions Type" },
            { "egy", "Ancient Egyptian" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "key.sd", "Region Subdivision" },
            { "type.nu.sind", "Khudawadi Digits" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension Island" },
            { "rar", "Rarotongan" },
            { "tet", "Tetum" },
            { "%%BARLA", "Barlavento dialect group of Kabuverdianu" },
            { "type.nu.sinh", "Sinhala Lith Digits" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "type.nu.mroo", "Mro Digits" },
            { "type.ca.ethiopic", "Ethiopic Calendar" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Time Zone" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "Prti", "Inscriptional Parthian" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "American English" },
            { "AX", "\u00c5land Islands" },
            { "key.colNormalization", "Normalized Sorting" },
            { "mye", "Myene" },
            { "AZ", "Azerbaijan" },
            { "%%AREVELA", "Eastern Armenian" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgium" },
            { "gmh", "Middle High German" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Visible Speech" },
            { "type.ca.persian", "Persian Calendar" },
            { "type.nu.hebr", "Hebrew Numerals" },
            { "CA", "Canada" },
            { "CC", "Cocos (Keeling) Islands" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "type.ss.standard", "Suppress Sentence Breaks After Standard Abbreviations" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "Kthi", "Kaithi" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "type.nu.bali", "Balinese Digits" },
            { "CZ", "Czech Republic" },
            { "key.rg", "Region For Supplemental Data" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "West Flemish" },
            { "%%RIGIK", "Classic Volap\u00fck" },
            { "DE", "Germany" },
            { "goh", "Old High German" },
            { "ace", "Achinese" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goan Konkani" },
            { "type.nu.deva", "Devanagari Digits" },
            { "DJ", "Djibouti" },
            { "type.colNumeric.no", "Sort Digits Individually" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenian Lowercase Numerals" },
            { "DO", "Dominican Republic" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-Franconian" },
            { "Mtei", "Meitei Mayek" },
            { "key.variableTop", "Sort As Symbols" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algeria" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta & Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estonia" },
            { "tiv", "Tiv" },
            { "EG", "Egypt" },
            { "EH", "Western Sahara" },
            { "chg", "Chagatai" },
            { "pau", "Palauan" },
            { "key.colReorder", "Script/Block Reordering" },
            { "type.colNormalization.yes", "Sort Unicode Normalized" },
            { "chk", "Chuukese" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "Mathematical Bold Digits" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "elx", "Elamite" },
            { "type.ca.gregorian", "Gregorian Calendar" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Gujarati Digits" },
            { "Inds", "Indus" },
            { "ady", "Adyghe" },
            { "aeb", "Tunisian Arabic" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "key.va", "Locale Variant" },
            { "FO", "Faroe Islands" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picard" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "%%DAJNKO", "Dajnko alphabet" },
            { "type.ca.indian", "Indian National Calendar" },
            { "rgn", "Romagnol" },
            { "grc", "Ancient Greek" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "vot", "Votic" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Greenland" },
            { "enm", "Middle English" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvania German" },
            { "type.nu.mathmono", "Mathematical Monospace Digits" },
            { "GW", "Guinea-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "New Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Central Kurdish" },
            { "zxx", "No linguistic content" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Austrian German" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Aghem" },
            { "gsw", "Swiss German" },
            { "type.ca.islamic-umalqura", "Islamic Calendar (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "rif", "Riffian" },
            { "tmh", "Tamashek" },
            { "IC", "Canary Islands" },
            { "nan", "Min Nan Chinese" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "type.nu.kali", "Kayah Li Digits" },
            { "IE", "Ireland" },
            { "nap", "Neapolitan" },
            { "%%NDYUKA", "Ndyuka dialect" },
            { "naq", "Nama" },
            { "type.nu.sora", "Sora Sompeng Digits" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Israel" },
            { "Nbat", "Nabataean" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "European Ordering Rules" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "Zmth", "Mathematical Notation" },
            { "type.nu.thai", "Thai Digits" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Computer" },
            { "type.nu.beng", "Bengali Digits" },
            { "pfl", "Palatine German" },
            { "type.fw.thu", "First Day of Week Is Thursday" },
            { "type.nu.cyrl", "Cyrillic Numerals" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamic Calendar" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "Serbian with Ekavian pronunciation" },
            { "JO", "Jordan" },
            { "gur", "Frafra" },
            { "JP", "Japan" },
            { "%%1606NICT", "Late Middle French to 1606" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Kannada Digits" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Swiss High German" },
            { "type.co.phonetic", "Phonetic Sort Order" },
            { "izh", "Ingrian" },
            { "type.ca.buddhist", "Buddhist Calendar" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts & Nevis" },
            { "Zinh", "Inherited" },
            { "fr_CA", "Canadian French" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "Plrd", "Pollard Phonetic" },
            { "fr_CH", "Swiss French" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Cyrillic" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Low German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadian" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "Central Yupik" },
            { "LS", "Lesotho" },
            { "Phlv", "Book Pahlavi" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall Islands" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Vai Digits" },
            { "MK", "Macedonia" },
            { "type.nu.mathdbl", "Mathematical Double-Struck Digits" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Newari" },
            { "MO", "Macau SAR China" },
            { "aln", "Gheg Albanian" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "Sort Symbols" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Mauritius" },
            { "alt", "Southern Altai" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Japanese Calendar" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "Phli", "Inscriptional Pahlavi" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "Hebrew Calendar" },
            { "type.co.dictionary", "Dictionary Sort Order" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Unified Revised Orthography" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalter Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "tsd", "Tsakonian" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "New Zealand" },
            { "Merc", "Meroitic Cursive" },
            { "%%COLB1945", "Portuguese-Brazilian Orthographic Convention of 1945" },
            { "rom", "Romany" },
            { "Mero", "Meroitic" },
            { "crh", "Crimean Turkish" },
            { "type.colAlternate.shifted", "Sort Ignoring Symbols" },
            { "ang", "Old English" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "Pahawh Hmong Digits" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamic Calendar (tabular, civil epoch)" },
            { "csb", "Kashubian" },
            { "en_GB", "British English" },
            { "PE", "Peru" },
            { "ttt", "Muslim Tat" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "type.colBackwards.yes", "Sort Accents Reversed" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Greek Lowercase Numerals" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Scottish Standard English" },
            { "jam", "Jamaican Creole English" },
            { "pms", "Piedmontese" },
            { "niu", "Niuean" },
            { "QO", "Outlying Oceania" },
            { "ext", "Extremaduran" },
            { "lez", "Lezghian" },
            { "type.nu.ahom", "Ahom Digits" },
            { "%%FONUPA", "UPA Phonetics" },
            { "type.nu.takr", "Takri Digits" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Sotavento dialect group of Kabuverdianu" },
            { "001", "World" },
            { "002", "Africa" },
            { "njo", "Ao Naga" },
            { "003", "North America" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "Sort Without Normalization" },
            { "005", "South America" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontic" },
            { "Rjng", "Rejang" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "Mroo", "Mro" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "type.nu.talu", "New Tai Lue Digits" },
            { "%%METELKO", "Metelko alphabet" },
            { "Ugar", metaValue_uga },
            { "Mani", "Manichaean" },
            { "key.colAlternate", "Ignore Symbols Sorting" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saudi Arabia" },
            { "pon", "Pohnpeian" },
            { "Mand", "Mandaean" },
            { "SB", "Solomon Islands" },
            { "twq", "Tasawaq" },
            { "011", "Western Africa" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "Central America" },
            { "SE", "Sweden" },
            { "014", "Eastern Africa" },
            { "arc", "Aramaic" },
            { "Loma", "Loma" },
            { "015", "Northern Africa" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "Strict Line Break Style" },
            { "017", "Middle Africa" },
            { "SI", "Slovenia" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing Digits" },
            { "018", "Southern Africa" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovakia" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Traditional Tamil Numerals" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "arq", "Algerian Arabic" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "Yao" },
            { "SZ", "Swaziland" },
            { "arw", "Arawak" },
            { "arz", "Egyptian Arabic" },
            { "ary", "Moroccan Arabic" },
            { "yap", "Yapese" },
            { "rtm", "Rotuman" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "US Measurement System" },
            { "021", "Northern America" },
            { "TC", "Turks & Caicos Islands" },
            { "yav", "Yangben" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "ase", "American Sign Language" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", metaValue_TK },
            { "029", "Caribbean" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Search By Hangul Initial Consonant" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "type.em.emoji", "Prefer Emoji Presentation For Emoji Characters" },
            { "TR", "Turkey" },
            { "TT", "Trinidad & Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturian" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Unknown Script" },
            { "Sind", "Khudawadi" },
            { "UA", "Ukraine" },
            { "lij", "Ligurian" },
            { "rup", "Aromanian" },
            { "030", "Eastern Asia" },
            { "tyv", "Tuvinian" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Southern Asia" },
            { "hai", "Haida" },
            { "035", "Southeast Asia" },
            { "UG", "Uganda" },
            { "hak", "Hakka Chinese" },
            { "type.co.pinyin", "Pinyin Sort Order" },
            { "type.colHiraganaQuaternary.yes", "Sort Kana Differently" },
            { "039", "Southern Europe" },
            { "Sinh", metaValue_si },
            { "UM", "U.S. Outlying Islands" },
            { "liv", "Livonian" },
            { "US", "United States" },
            { "haw", "Hawaiian" },
            { "%%1959ACAD", "Academic" },
            { "type.co.gb2312han", "Simplified Chinese Sort Order - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prussian" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Central Atlas Tamazight" },
            { "type.co.stroke", "Stroke Sort Order" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatican City" },
            { "pro", "Old Proven\u00e7al" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "Sort Accents Normally" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Old Norse" },
            { "type.fw.sun", "First Day of Week Is Sunday" },
            { "053", "Australasia" },
            { "%%AREVMDA", "Western Armenian" },
            { "054", "Melanesia" },
            { "WF", "Wallis & Futuna" },
            { "type.co.traditional", "Traditional Sort Order" },
            { "057", "Micronesian Region" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "nov", "Novial" },
            { "type.nu.finance", "Financial Numerals" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "Hepburn romanization" },
            { "type.co.compat", "Previous Sort Order, for compatibility" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Meetei Mayek Digits" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "Standard Orthography" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Brahmi Digits" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Unwritten" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Standard Sort Order" },
            { "lmo", "Lombard" },
            { "fan", "Fang" },
            { "%%BALANKA", "Balanka dialect of Anii" },
            { "%%ROZAJ", "Resian" },
            { "fat", "Fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cham Digits" },
            { "ZA", "South Africa" },
            { "type.nu.sund", "Sundanese Digits" },
            { "type.lb.loose", "Loose Line Break Style" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgian Numerals" },
            { "type.co.zhuyin", "Zhuyin Sort Order" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unknown Region" },
            { "Runr", "Runic" },
            { "type.ms.metric", "Metric System" },
            { "type.ca.iso8601", "ISO-8601 Calendar" },
            { "lol", "Mongo" },
            { "nso", "Northern Sotho" },
            { "type.nu.telu", "Telugu Digits" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "type.lw.normal", "Normal Line Breaks For Words" },
            { "type.colHiraganaQuaternary.no", "Sort Kana Separately" },
            { "jmc", "Machame" },
            { "hif", "Fiji Hindi" },
            { "type.nu.hansfin", "Simplified Chinese Financial Numerals" },
            { "type.colStrength.secondary", "Sort Accents" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Extended Arabic-Indic Digits" },
            { "type.fw.mon", "First Day of Week Is Monday" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Full-Width Digits" },
            { "hit", "Hittite" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Mayan hieroglyphs" },
            { "lrc", "Northern Luri" },
            { "type.co.emoji", "Emoji Sort Order" },
            { "Copt", metaValue_cop },
            { "nwc", "Classical Newari" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "type.ss.none", "Sentence Breaks Without Abbreviation Handling" },
            { "type.ca.islamic-rgsa", "Islamic Calendar (Saudi Arabia, sighting)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Roman Numerals" },
            { "sah", "Sakha" },
            { "type.nu.shrd", "Sharada Digits" },
            { "ltg", "Latgalian" },
            { "sam", "Samaritan Aramaic" },
            { "Aghb", "Caucasian Albanian" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Judeo-Persian" },
            { "type.nu.native", "Native Digits" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aluku dialect" },
            { "lua", "Luba-Lulua" },
            { "type.nu.tirh", "Tirhuta Digits" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipino" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "type.nu.wara", "Warang Citi Digits" },
            { "fit", "Tornedalen Finnish" },
            { "luy", "Luyia" },
            { "bar", "Bavarian" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "%%ABL1943", "Orthographic formulation of 1943" },
            { "jrb", "Judeo-Arabic" },
            { "es_ES", "European Spanish" },
            { "nzi", "Nzima" },
            { "sco", "Scots" },
            { "scn", "Sicilian" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "bbc", "Batak Toba" },
            { "key.colCaseFirst", "Uppercase/Lowercase Ordering" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Chakma Digits" },
            { "bbj", "Ghomala" },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "an", "Aragonese" },
            { "%%SOLBA", "Stolvizza/Solbica dialect" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Japanese syllabaries" },
            { "as", "Assamese" },
            { "sdc", "Sassarese Sardinian" },
            { "Lina", "Linear A" },
            { "av", "Avaric" },
            { "Linb", "Linear B" },
            { "sdh", "Southern Kurdish" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "type.va.posix", "POSIX Compliant Locale" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco/Osojane dialect" },
            { "%%UNIFON", "Unifon phonetic alphabet" },
            { "ba", "Bashkir" },
            { "type.co.unihan", "Radical-Stroke Sort Order" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "type.nu.java", "Javanese Digits" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "see", "Seneca" },
            { "type.fw.sat", "First Day of Week Is Saturday" },
            { "Mymr", "Myanmar" },
            { "sei", "Seri" },
            { "type.nu.laoo", "Lao Digits" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkup" },
            { "ca", "Catalan" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Revised Orthography" },
            { "co", "Corsican" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "yrl", "Nheengatu" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "type.nu.ethi", "Ethiopic Numerals" },
            { "Yiii", "Yi" },
            { "da", "Danish" },
            { "pt_PT", "European Portuguese" },
            { "de", "German" },
            { "type.cf.standard", "Standard Currency Format" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "jut", "Jutish" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Old Irish" },
            { "type.nu.mong", "Mongolian Digits" },
            { "dv", "Divehi" },
            { "es_419", "Latin American Spanish" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Chinese Calendar" },
            { "lzh", "Literary Chinese" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogitian" },
            { "type.nu.grek", "Greek Numerals" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Normal Line Break Style" },
            { "ro_MD", "Moldavian" },
            { "el", metaValue_el },
            { "en", "English" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Laz" },
            { "type.co.big5han", "Traditional Chinese Sort Order - Big5" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritan" },
            { "shi", "Tachelhit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Persian" },
            { "Hans", "Simplified" },
            { "type.nu.latn", "Western Digits" },
            { "Hant", "Traditional" },
            { "ff", "Fulah" },
            { "shu", "Chadian Arabic" },
            { "hsn", "Xiang Chinese" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fon", "Fon" },
            { "bgn", "Western Balochi" },
            { "yue", "Cantonese" },
            { "fo", "Faroese" },
            { "umb", "Umbundu" },
            { "fr", "French" },
            { "sid", "Sidamo" },
            { "fy", "Western Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "key.colCaseLevel", "Case Sensitive Sorting" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Unknown Language" },
            { "type.ca.ethiopic-amete-alem", "Ethiopic Amete Alem Calendar" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Islamic Calendar (tabular, astronomical epoch)" },
            { "gv", "Manx" },
            { "type.nu.osma", "Osmanya Digits" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Croatian" },
            { "ht", "Haitian Creole" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun French" },
            { "%%FONIPA", "IPA Phonetics" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "type.nu.tibt", "Tibetan Digits" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Middle French" },
            { "%%AO1990", "Portuguese Language Orthographic Agreement of 1990" },
            { "ik", "Inupiaq" },
            { "fro", "Old French" },
            { "frp", "Arpitan" },
            { "io", "Ido" },
            { "frs", "Eastern Frisian" },
            { "bjn", "Banjar" },
            { "frr", "Northern Frisian" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "sli", "Lower Silesian" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Old South Arabian" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "Lepcha Digits" },
            { "bkm", "Kom" },
            { "sma", "Southern Sami" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "mad", "Madurese" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Wu Chinese" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "Sort All" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kyrgyz" },
            { "snk", "Soninke" },
            { "type.colStrength.primary", "Sort Base Letters Only" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Hatran" },
            { "lb", "Luxembourgish" },
            { "type.nu.mlym", "Malayalam Digits" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "type.colCaseLevel.no", "Sort Case Insensitive" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Imperial Measurement System" },
            { "type.colStrength.tertiary", "Sort Accents/Case/Width" },
            { "type.nu.lana", "Tai Tham Hora Digits" },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "sog", "Sogdien" },
            { "type.lw.keepall", "Prevent Line Breaks In All Words" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "type.fw.fri", "First Day of Week Is Friday" },
            { "type.co.ducet", "Default Unicode Sort Order" },
            { "mi", "Maori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "type.nu.hanidays", "Chinese Calendar Day-of-Month Numerals" },
            { "Saur", metaValue_saz },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Lower Sorbian" },
            { "Armi", "Imperial Aramaic" },
            { "na", metaValue_NR },
            { "type.co.search", "General-Purpose Search" },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "type.nu.modi", "Modi Digits" },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Polytonic" },
            { "type.colCaseFirst.lower", "Sort Lowercase First" },
            { "oc", "Occitan" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Early Modern English" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "Armenian Numerals" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Central Dusun" },
            { "or", metaValue_or },
            { "Modi", "Modi" },
            { "os", "Ossetic" },
            { "%%ALALC97", "ALA-LC Romanization, 1997 edition" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardian" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "The Lipovaz dialect of Resian" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "Polish" },
            { "dum", "Middle Dutch" },
            { "type.nu.saur", "Saurashtra Digits" },
            { "type.ca.dangi", "Dangi Calendar" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "mga", "Middle Irish" },
            { "key.co", "Sort Order" },
            { "pt_BR", "Brazilian Portuguese" },
            { "%%BOHORIC", "Bohori\u010d alphabet" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Currency Format" },
            { "type.nu.nkoo", "N\u2019Ko Digits" },
            { "bra", "Braj" },
            { "key.ca", "Calendar" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u02bc" },
            { "type.hc.h23", "24 Hour System (0\u201323)" },
            { "type.hc.h24", "24 Hour System (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Myanmar Digits" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "stq", "Saterland Frisian" },
            { "Ethi", "Ethiopic" },
            { "type.hc.h12", "12 Hour System (1\u201312)" },
            { "type.hc.h11", "12 Hour System (0\u201311)" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Currency" },
            { "ro", "Romanian" },
            { "type.em.text", "Prefer Text Presentation For Emoji Characters" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Oriya Digits" },
            { "type.nu.hanidec", "Chinese Decimal Numerals" },
            { "ru", "Russian" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Australian English" },
            { "Dupl", "Duployan shorthand" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Unified Orthography" },
            { "sc", "Sardinian" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Northern Sami" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Sumerian" },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "Gran", "Grantha" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Arabic-Indic Digits" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "type.cf.account", "Accounting Currency Format" },
            { "Java", metaValue_jv },
            { "st", "Southern Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone dialect" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Traditional Chinese Financial Numerals" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "type.lw.breakall", "Allow Line Breaks In All Words" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "Buriat" },
            { "143", "Central Asia" },
            { "te", metaValue_te },
            { "145", "Western Asia" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "type.colNumeric.yes", "Sort Digits Numerically" },
            { "en_CA", "Canadian English" },
            { "tk", "Turkmen" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japanese Numerals" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "swb", "Comorian" },
            { "Cakm", "Chakma" },
            { "tt", "Tatar" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "%%BISKE", "San Giorgio/Bila dialect" },
            { "150", "Europe" },
            { "key.colHiraganaQuaternary", "Kana Sorting" },
            { "151", "Eastern Europe" },
            { "type.nu.mathsanb", "Mathematical Sans-Serif Bold Digits" },
            { "154", "Northern Europe" },
            { "dzg", "Dazaga" },
            { "155", "Western Europe" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Ital", "Old Italic" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Common" },
            { "uk", "Ukrainian" },
            { "zea", "Zeelandic" },
            { "type.colCaseFirst.no", "Sort Normal Case Order" },
            { "type.colStrength.quaternary", "Sort Accents/Case/Width/Kana" },
            { "type.ca.coptic", "Coptic Calendar" },
            { "ur", "Urdu" },
            { "key.fw", "First day of week" },
            { "%%1994", "Standardized Resian orthography" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Uzbek" },
            { "kha", "Khasi" },
            { "%%1996", "German orthography of 1996" },
            { "nds_NL", "Low Saxon" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Minguo Calendar" },
            { "vi", "Vietnamese" },
            { "kho", "Khotanese" },
            { "type.fw.tue", "First Day of Week Is Tuesday" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Hour Cycle (12 vs 24)" },
            { "%%TARASK", "Taraskievica orthography" },
            { "vo", "Volap\u00fck" },
            { "key.x", "Private-Use" },
            { "khw", "Khowar" },
            { "syc", "Classical Syriac" },
            { "type.nu.mathsans", "Mathematical Sans-Serif Digits" },
            { "Osma", "Osmanya" },
            { "quc", "K\u02bciche\u02bc" },
            { "qug", "Chimborazo Highland Quichua" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "key.em", "Emoji Presentation Style" },
            { "gag", "Gagauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "Gan Chinese" },
            { "kiu", "Kirmanjki" },
            { "Lydi", "Lydian" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "wo", "Wolof" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Modern Standard Arabic" },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "gay", "Gayo" },
            { "key.colNumeric", "Numeric Sorting" },
            { "Mong", metaValue_mn },
            { "mnc", "Manchu" },
            { "Latf", "Fraktur Latin" },
            { "szl", "Silesian" },
            { "Hluw", "Anatolian Hieroglyphs" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "Gaelic Latin" },
            { "type.nu.hans", "Simplified Chinese Numerals" },
            { "type.nu.hant", "Traditional Chinese Numerals" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Roman Lowercase Numerals" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Pamaka dialect" },
            { "Lyci", "Lycian" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "key.kv", "Highest Ignored" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Early Modern French" },
            { "Syrc", metaValue_syr },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Traditional Numerals" },
            { "es_MX", "Mexican Spanish" },
            { "Syrj", "Western Syriac" },
            { "ota", "Ottoman Turkish" },
            { "Syre", "Estrangelo Syriac" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "key.lw", "Line Breaks In Words Setting" },
            { "Cari", "Carian" },
            { "kln", "Kalenjin" },
            { "zh", "Chinese" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Old Permic" },
            { "key.lb", "Line Break Style" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Phonebook Sort Order" },
            { "%%MONOTON", "Monotonic" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.colCaseLevel.yes", "Sort Case Sensitive" },
            { "type.em.default", "Use Default Presentation For Emoji Characters" },
            { "type.nu.jpanfin", "Japanese Financial Numerals" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "mrj", "Western Mari" },
            { "Syrn", "Eastern Syriac" },
            { "type.nu.mymrshan", "Myanmar Shan Digits" },
            { "Elba", "Elbasan" },
            { "Narb", "Old North Arabian" },
            { "type.nu.olck", "Ol Chiki Digits" },
            { "type.co.reformed", "Reformed Sort Order" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptian demotic" },
            { "key.colBackwards", "Reversed Accent Sorting" },
            { "Egyh", "Egyptian hieratic" },
            { "Palm", "Palmyrene" },
            { "ebu", "Embu" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Geok", "Georgian Khutsuri" },
            { "zh_Hans", "Simplified Chinese" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Old Hungarian" },
            { "kok", "Konkani" },
            { "%%1901", "Traditional German orthography" },
            { "kos", "Kosraean" },
            { "vec", "Venetian" },
            { "type.nu.limb", "Limbu Digits" },
            { "zh_Hant", "Traditional Chinese" },
            { "Sund", metaValue_su },
            { "vep", "Veps" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "Khmer Digits" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valencian" },
            { "Cprt", "Cypriot" },
            { "%%BAKU1926", "Unified Turkic Latin Alphabet" },
            { "%%IJEKAVSK", "Serbian with Ijekavian pronunciation" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi Digits" },
            { "type.fw.wed", "First Day of Week Is Wednesday" },
            { "mul", "Multiple Languages" },
            { "cad", "Caddo" },
            { "key.ms", "Measurement System" },
            { "mus", "Creek" },
            { "Glag", "Glagolitic" },
            { "gil", "Gilbertese" },
            { "%%KKCOR", "Common Orthography" },
            { "Cher", metaValue_chr },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil Digits" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "fa_AF", "Dari" },
            { "krl", "Karelian" },
            { "%%OXENDICT", "Oxford English Dictionary spelling" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "Numbers" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "type.colCaseFirst.upper", "Sort Uppercase First" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
