/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class NormalBoldGrayRenderer
extends MultiRenderer {
    private static final Color REPLACEABLE_FOREGROUND = new JTable().getForeground();
    private final LabelRenderer normalRenderer;
    private final LabelRenderer boldRenderer;
    private final LabelRenderer grayRenderer;
    private final ProfilerRenderer[] renderers;
    private Color customForeground;
    private Color replaceableForeground = REPLACEABLE_FOREGROUND;

    public NormalBoldGrayRenderer() {
        this.normalRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color color) {
                if (NormalBoldGrayRenderer.this.customForeground != null && Objects.equals(color, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    color = NormalBoldGrayRenderer.this.customForeground;
                }
                super.setForeground(color);
            }
        };
        this.normalRenderer.setMargin(3, 3, 3, 0);
        this.boldRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color color) {
                if (NormalBoldGrayRenderer.this.customForeground != null && Objects.equals(color, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    color = NormalBoldGrayRenderer.this.customForeground;
                }
                super.setForeground(color);
            }
        };
        this.boldRenderer.setMargin(3, 0, 3, 0);
        Font font = this.boldRenderer.getFont();
        this.boldRenderer.setFont(font.deriveFont(1));
        this.grayRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color color) {
                if (Objects.equals(color, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    if (NormalBoldGrayRenderer.this.customForeground != null) {
                        super.setForeground(NormalBoldGrayRenderer.this.customForeground);
                    } else {
                        super.setForeground(UIUtils.getDisabledForeground(color == null ? Color.BLACK : color));
                    }
                } else {
                    super.setForeground(color);
                }
            }
        };
        this.grayRenderer.setMargin(3, 0, 3, 3);
        this.renderers = new ProfilerRenderer[]{this.normalRenderer, this.boldRenderer, this.grayRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(10);
    }

    protected void setCustomForeground(Color color) {
        this.customForeground = color;
    }

    public void setReplaceableForeground(Color color) {
        this.replaceableForeground = color;
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    protected void setNormalValue(String string) {
        this.normalRenderer.setText(string);
    }

    protected final String getNormalValue() {
        return this.normalRenderer.getText();
    }

    protected void setBoldValue(String string) {
        this.boldRenderer.setText(string);
    }

    protected final String getBoldValue() {
        return this.boldRenderer.getText();
    }

    protected void setGrayValue(String string) {
        this.grayRenderer.setText(string);
    }

    protected final String getGrayValue() {
        return this.grayRenderer.getText();
    }

    protected void setIcon(Icon icon) {
        String string = this.normalRenderer.getText();
        if (string == null || string.isEmpty()) {
            this.normalRenderer.setIcon(null);
            string = this.boldRenderer.getText();
            if (string == null || string.isEmpty()) {
                this.boldRenderer.setIcon(null);
                this.grayRenderer.setIcon(icon);
            } else {
                this.boldRenderer.setIcon(icon);
                this.grayRenderer.setIcon(null);
            }
        } else {
            this.normalRenderer.setIcon(icon);
            this.boldRenderer.setIcon(null);
            this.grayRenderer.setIcon(null);
        }
    }

    public Icon getIcon() {
        Icon icon = this.normalRenderer.getIcon();
        if (icon == null) {
            icon = this.boldRenderer.getIcon();
        }
        if (icon == null) {
            icon = this.grayRenderer.getIcon();
        }
        return icon;
    }

    protected void setIconTextGap(int n) {
        String string = this.normalRenderer.getText();
        if (string == null || string.isEmpty()) {
            string = this.boldRenderer.getText();
            if (string == null || string.isEmpty()) {
                this.grayRenderer.setIconTextGap(n);
            } else {
                this.boldRenderer.setIconTextGap(n);
            }
        } else {
            this.normalRenderer.setIconTextGap(n);
        }
    }
}

