/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tomcat.util.descriptor.web.ErrorPage;

public class ErrorPageSupport {
    private ConcurrentMap<String, ErrorPage> exceptionPages = new ConcurrentHashMap<String, ErrorPage>();
    private ConcurrentMap<Integer, ErrorPage> statusPages = new ConcurrentHashMap<Integer, ErrorPage>();

    public void add(ErrorPage errorPage) {
        String string = errorPage.getExceptionType();
        if (string == null) {
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        } else {
            this.exceptionPages.put(string, errorPage);
        }
    }

    public void remove(ErrorPage errorPage) {
        String string = errorPage.getExceptionType();
        if (string == null) {
            this.statusPages.remove(errorPage.getErrorCode(), errorPage);
        } else {
            this.exceptionPages.remove(string, errorPage);
        }
    }

    public ErrorPage find(int n) {
        return (ErrorPage)this.statusPages.get(n);
    }

    @Deprecated
    public ErrorPage find(String string) {
        return (ErrorPage)this.exceptionPages.get(string);
    }

    public ErrorPage find(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = (ErrorPage)this.exceptionPages.get(string);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            string = clazz.getName();
        }
        return null;
    }

    public ErrorPage[] findAll() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.exceptionPages.values());
        hashSet.addAll(this.statusPages.values());
        return hashSet.toArray(new ErrorPage[0]);
    }
}

