/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.FieldAccessor;

abstract class InstanceBuilder<T> {
    public static final InstanceBuilder<String> STRING_BUILDER = new InstanceBuilder<String>(String.class){

        @Override
        public String convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return fieldAccessor.toString(instance);
        }
    };
    public static final InstanceBuilder<int[]> INT_ARRAY_BUILDER = new InstanceBuilder<int[]>(int[].class){

        @Override
        public int[] convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance primitiveArrayInstance = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = primitiveArrayInstance.getValues();
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    nArray[i] = Integer.parseInt((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of int at index %d: %s", i, list.get(i));
                }
            }
            return nArray;
        }
    };
    public static final InstanceBuilder<byte[]> BYTE_ARRAY_BUILDER = new InstanceBuilder<byte[]>(byte[].class){

        @Override
        public byte[] convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance primitiveArrayInstance = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = primitiveArrayInstance.getValues();
            byte[] byArray = new byte[list.size()];
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    byArray[i] = Byte.parseByte((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of byte at index %d: %s", i, list.get(i));
                }
            }
            return byArray;
        }
    };
    public static final InstanceBuilder<short[]> SHORT_ARRAY_BUILDER = new InstanceBuilder<short[]>(short[].class){

        @Override
        public short[] convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance primitiveArrayInstance = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = primitiveArrayInstance.getValues();
            short[] sArray = new short[list.size()];
            for (int i = 0; i < sArray.length; ++i) {
                try {
                    sArray[i] = Short.parseShort((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of short at index %d: %s", i, list.get(i));
                }
            }
            return sArray;
        }
    };
    public static final InstanceBuilder<Instance> IDENTITY_BUILDER = new InstanceBuilder<Instance>(Instance.class){

        @Override
        public Instance convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return instance;
        }
    };
    private final Class<T> type;

    public InstanceBuilder(Class<T> clazz) {
        this.type = clazz;
    }

    Class<T> getType() {
        return this.type;
    }

    public abstract T convert(FieldAccessor var1, Instance var2) throws FieldAccessor.InvalidFieldException;

    public static class ReferringInstanceBuilder<T>
    extends InstanceBuilder<T> {
        private final String[] path;

        public ReferringInstanceBuilder(Class<T> clazz, String ... stringArray) {
            super(clazz);
            this.path = stringArray;
        }

        @Override
        public T convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            for (int i = 0; i < this.path.length - 1 && instance != null; ++i) {
                instance = fieldAccessor.getInstance(instance, this.path[i], false);
            }
            if (instance == null) {
                return null;
            }
            return fieldAccessor.build(instance, this.path[this.path.length - 1], this.getType(), false);
        }
    }
}

