/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOriginKt;
import org.jetbrains.kotlin.library.metadata.DeserializedSourceFile;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\r\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0086\u0010\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\u000b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0011"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isForwardDeclarationModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "isSerializableExpectClass", "sourceByIndex", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "index", "", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findSourceFile", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkNotNullParameter($this$isExpectMember, "<this>");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkNotNullParameter($this$isSerializableExpectClass, "<this>");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && ExpectedActualDeclarationChecker.Companion.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter($this$findPackage, "<this>");
        DeclarationDescriptor declarationDescriptor2 = $this$findPackage;
        while (!((declarationDescriptor = declarationDescriptor2) instanceof PackageFragmentDescriptor)) {
            DeclarationDescriptor declarationDescriptor3;
            DeclarationDescriptor declarationDescriptor4 = declarationDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor4);
            declarationDescriptor2 = declarationDescriptor3 = declarationDescriptor4;
        }
        return (PackageFragmentDescriptor)declarationDescriptor;
    }

    public static final boolean isForwardDeclarationModule(@NotNull ModuleDescriptor $this$isForwardDeclarationModule) {
        Intrinsics.checkNotNullParameter($this$isForwardDeclarationModule, "<this>");
        return Intrinsics.areEqual($this$isForwardDeclarationModule.getName(), Name.special("<forward declarations>"));
    }

    private static final SourceFile sourceByIndex(CallableMemberDescriptor descriptor2, int index2) {
        KlibMetadataDeserializedPackageFragment fragment = (KlibMetadataDeserializedPackageFragment)LegacyDescriptorUtilsKt.findPackage(descriptor2);
        String fileName = (String)fragment.getProto().getStrings().getStringList().get(index2);
        Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
        return new DeserializedSourceFile(fileName, KlibModuleOriginKt.getKotlinLibrary(DescriptorUtilsKt.getModule(descriptor2)));
    }

    @NotNull
    public static final SourceFile findSourceFile(@NotNull CallableMemberDescriptor $this$findSourceFile) {
        SourceFile sourceFile;
        Intrinsics.checkNotNullParameter($this$findSourceFile, "<this>");
        Object object = $this$findSourceFile.getSource().getContainingFile();
        Intrinsics.checkNotNullExpressionValue(object, "this.source.containingFile");
        SourceFile source = object;
        if (!Intrinsics.areEqual(source, SourceFile.NO_SOURCE_FILE)) {
            return source;
        }
        if ($this$findSourceFile instanceof DeserializedSimpleFunctionDescriptor && ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.functionFile)) {
            object = ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.functionFile);
            Intrinsics.checkNotNullExpressionValue(object, "proto.getExtension(KlibMetadataProtoBuf.functionFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)object).intValue());
        } else if ($this$findSourceFile instanceof DeserializedPropertyDescriptor && ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.propertyFile)) {
            object = ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.propertyFile);
            Intrinsics.checkNotNullExpressionValue(object, "proto.getExtension(KlibMetadataProtoBuf.propertyFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)object).intValue());
        } else {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return sourceFile;
    }
}

