/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyWas;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeWas;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketWas;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;

public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private static final short UNIT_LAST_MOVE_DELAY = 300;
    private static final StringTemplate abortTrade = StringTemplate.template("");
    private final FreeColClient freeColClient;
    private final GUI gui;
    private MoveMode moveMode = MoveMode.NEXT_ACTIVE_UNIT;
    private final HashMap<String, Integer> messagesToIgnore = new HashMap();
    private final List<ModelMessage> turnReportMessages = new ArrayList<ModelMessage>();

    public InGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
    }

    private ServerAPI askServer() {
        return this.freeColClient.askServer();
    }

    private void sound(String soundKey) {
        this.freeColClient.getSoundController().playSound(soundKey);
    }

    private Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    private boolean requireOurTurn() {
        if (this.freeColClient.currentPlayerIsMyPlayer()) {
            return true;
        }
        if (this.freeColClient.isInGame()) {
            this.gui.showInformationMessage("info.notYourTurn");
        }
        return false;
    }

    private void colonyPanel(Colony colony, Unit unit) {
        this.gui.showColonyPanel(colony, unit.isCarrier() ? unit : null);
    }

    private Settlement getSettlementAt(Tile tile, Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.hasSettlement() ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.freeColClient.getGame().getUnknownEnemy());
        return player.getNationLabel();
    }

    private void updateGUI(Tile tile) {
        if (!this.displayModelMessages(false, false) && !this.updateActiveUnit(tile)) {
            this.gui.updateMapControls();
            this.gui.updateMenuBar();
        }
    }

    private boolean askAssignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (tradeRoute == unit.getTradeRoute()) {
            return true;
        }
        if (tradeRoute != null && unit.getTradeRoute() != null && !this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        return this.askServer().assignTradeRoute(unit, tradeRoute) && unit.getTradeRoute() == tradeRoute;
    }

    private boolean askClaimTile(Player player, Tile tile, FreeColGameObject claimant, int price) {
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            ClaimAction act = this.gui.getClaimChoice(tile, player, price, owner);
            if (act == null) {
                return false;
            }
            switch (act) {
                case ACCEPT: {
                    break;
                }
                case STEAL: {
                    price = -1;
                    break;
                }
                default: {
                    logger.warning("Claim dialog fail: " + (Object)((Object)act));
                    return false;
                }
            }
        }
        return this.askServer().claimTile(tile, claimant, price) && player.owns(tile);
    }

    private boolean askClearGotoOrders(Unit unit) {
        if (!this.askAssignTradeRoute(unit, null)) {
            return false;
        }
        if (unit.getDestination() == null) {
            return true;
        }
        if (this.askSetDestination(unit, null)) {
            this.gui.clearGotoPath();
            return true;
        }
        return false;
    }

    private boolean askEmbark(Unit unit, Unit carrier) {
        ColonyWas colonyWas = unit.getColony() != null ? new ColonyWas(unit.getColony()) : null;
        EuropeWas europeWas = unit.isInEurope() ? new EuropeWas(unit.getOwner().getEurope()) : null;
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().embark(unit, carrier, null) && unit.getLocation() == carrier) {
            this.sound("sound.event.loadCargo");
            unitWas.fireChanges();
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            if (europeWas != null) {
                europeWas.fireChanges();
            }
            return true;
        }
        return false;
    }

    private Unit askEmigrate(Europe europe, int slot) {
        if (europe == null || !Europe.MigrationType.validMigrantSlot(slot)) {
            return null;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        Unit newUnit = null;
        if (this.askServer().emigrate(slot) && (newUnit = europeWas.getNewUnit()) != null) {
            europeWas.fireChanges();
        }
        return newUnit;
    }

    private void emigration(Player player, int n, boolean fountainOfYouth) {
        Europe europe = player.getEurope();
        if (europe == null) {
            return;
        }
        while (n > 0 || player.checkEmigrate()) {
            if (!CollectionUtils.allSame(europe.getRecruitables())) {
                int nf = n;
                this.gui.showEmigrationDialog(player, fountainOfYouth, value -> this.emigrate(player, Europe.MigrationType.convertToMigrantSlot(value), nf - 1, fountainOfYouth));
                return;
            }
            Unit u = this.askEmigrate(europe, Europe.MigrationType.getDefaultSlot());
            if (u == null) break;
            player.addModelMessage(player.getEmigrationMessage(u));
            --n;
        }
    }

    private boolean askLoadGoods(Location loc, GoodsType type, int amount, Unit carrier) {
        Player player;
        Market market;
        MarketWas marketWas;
        TradeLocation trl = carrier.getTradeLocation();
        if (trl == null) {
            return false;
        }
        int loadable = carrier.getLoadableAmount(type);
        if (amount > loadable) {
            amount = loadable;
        }
        MarketWas marketWas2 = marketWas = (market = (player = carrier.getOwner()).getMarket()) != null ? new MarketWas(player) : null;
        if (carrier.isInEurope()) {
            if (!player.canTrade(type)) {
                return false;
            }
            if (!player.checkGold(market.getBidPrice(type, amount))) {
                this.gui.showInformationMessage("info.notEnoughGold");
                return false;
            }
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        if (this.askServer().loadGoods(loc, type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            if (marketWas != null) {
                marketWas.fireChanges(type, amount);
            }
            return true;
        }
        return false;
    }

    private boolean askSetDestination(Unit unit, Location destination) {
        return this.askServer().setDestination(unit, destination) && unit.getDestination() == destination;
    }

    private boolean askUnloadGoods(GoodsType type, int amount, Unit carrier) {
        Player player = this.freeColClient.getMyPlayer();
        Market market = player.getMarket();
        MarketWas marketWas = market != null ? new MarketWas(player) : null;
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        if (this.askServer().unloadGoods(type, amount, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            if (marketWas != null) {
                marketWas.fireChanges(type, -amount);
            }
            return true;
        }
        return false;
    }

    private String getSaveGameString(Game game) {
        Player player = this.freeColClient.getMyPlayer();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        Turn turn = game.getTurn();
        return (gid + "_" + Messages.message(player.getNationLabel()) + "_" + turn.getSaveGameSuffix() + "." + "fsg").replaceAll(" ", "_");
    }

    private void autoSaveGame() {
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return;
        }
        ClientOptions options = this.freeColClient.getClientOptions();
        String prefix = options.getText("model.option.autoSavePrefix");
        String lastTurnName = prefix + "-" + options.getText("model.option.lastTurnName") + "." + "fsg";
        String beforeLastTurnName = prefix + "-" + options.getText("model.option.beforeLastTurnName") + "." + "fsg";
        File autoSaveDir = FreeColDirectories.getAutosaveDirectory();
        File lastTurnFile = new File(autoSaveDir, lastTurnName);
        File beforeLastTurnFile = new File(autoSaveDir, beforeLastTurnName);
        if (lastTurnFile.exists()) {
            beforeLastTurnFile.delete();
            lastTurnFile.renameTo(beforeLastTurnFile);
        }
        this.saveGame(lastTurnFile);
        int saveGamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (saveGamePeriod >= 1 && turnNumber % saveGamePeriod == 0) {
            String fileName = prefix + "-" + this.getSaveGameString(game);
            this.saveGame(new File(autoSaveDir, fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveGame(File file) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        boolean result = false;
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        try {
            server.setActiveUnit(this.gui.getActiveUnit());
            server.saveGame(file, this.freeColClient.getClientOptions());
            result = true;
        }
        catch (IOException e) {
            this.gui.showErrorMessage(FreeCol.badSave(file));
        }
        finally {
            this.gui.closeStatusPanel();
        }
        return result;
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        BooleanOption option = this.freeColClient.getClientOptions().getBooleanOption(message);
        return option == null ? true : option.getValue();
    }

    private synchronized void startIgnoringMessage(String key, Turn turn) {
        this.messagesToIgnore.put(key, turn.getNumber());
        logger.finer("Ignore message start: " + key);
    }

    private synchronized void stopIgnoringMessage(String key) {
        this.messagesToIgnore.remove(key);
        logger.finer("Ignore message stop: " + key);
    }

    private synchronized void reapIgnoredMessages(Turn turn) {
        Iterator<String> keys = this.messagesToIgnore.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            if (this.messagesToIgnore.get(key) >= turn.getNumber()) continue;
            keys.remove();
            logger.finer("Ignore message reap: " + key);
        }
    }

    private synchronized boolean continueIgnoreMessage(String key, Turn turn) {
        Integer value;
        if (key != null && (value = this.messagesToIgnore.get(key)) != null && value + 1 == turn.getNumber()) {
            this.messagesToIgnore.put(key, value + 1);
            logger.finer("Ignore message continue: " + key);
            return true;
        }
        return false;
    }

    public void displayTurnReportMessages() {
        this.gui.showReportTurnPanel(this.turnReportMessages);
    }

    public boolean displayModelMessages(boolean allMessages, boolean endOfTurn) {
        Player player = this.freeColClient.getMyPlayer();
        Turn thisTurn = this.freeColClient.getGame().getTurn();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (ModelMessage m : allMessages ? player.getModelMessages() : player.getNewModelMessages()) {
            if (this.shouldAllowMessage(m) && !this.continueIgnoreMessage(m.getIgnoredMessageKey(), thisTurn)) {
                messages.add(m);
            }
            m.setBeenDisplayed(true);
        }
        this.reapIgnoredMessages(thisTurn);
        if (!messages.isEmpty()) {
            Runnable uiTask;
            if (endOfTurn) {
                this.turnReportMessages.addAll(messages);
                uiTask = () -> this.displayTurnReportMessages();
            } else {
                uiTask = () -> this.gui.showModelMessages(messages);
            }
            this.gui.invokeNowOrWait(uiTask);
        }
        return !messages.isEmpty();
    }

    private boolean doExecuteGotoOrders() {
        Object unit;
        if (this.gui.isShowingSubPanel()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit active = this.gui.getActiveUnit();
        Object stillActive = null;
        this.moveMode = this.moveMode.maximize(MoveMode.EXECUTE_GOTO_ORDERS);
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        while (player.hasNextTradeRouteUnit()) {
            unit = player.getNextTradeRouteUnit();
            this.gui.setActiveUnit((Unit)unit);
            if (!this.moveToDestination((Unit)unit, messages)) continue;
            stillActive = unit;
        }
        if (!messages.isEmpty()) {
            for (ModelMessage m : messages) {
                player.addModelMessage(m);
                this.turnReportMessages.add(m);
            }
            this.displayModelMessages(false, false);
            this.gui.setActiveUnit((Unit)(stillActive != null ? stillActive : active));
            return false;
        }
        if (active != null) {
            player.setNextGoingToUnit(active);
        }
        while (player.hasNextGoingToUnit()) {
            unit = player.getNextGoingToUnit();
            this.gui.setActiveUnit((Unit)unit);
            if (this.moveToDestination((Unit)unit, null)) {
                stillActive = unit;
            }
            this.displayModelMessages(false, false);
            if (!this.gui.isShowingSubPanel()) continue;
            this.gui.requestFocusForSubPanel();
            break;
        }
        this.gui.setActiveUnit((Unit)(stillActive != null ? stillActive : active));
        return stillActive == null;
    }

    private boolean doEndTurn(boolean showDialog) {
        List<Unit> units;
        if (showDialog && !(units = this.freeColClient.getMyPlayer().getUnits().stream().filter(Unit::couldMove).collect(Collectors.toList())).isEmpty()) {
            this.gui.showEndTurnDialog(units, value -> {
                if (value != null && value.booleanValue()) {
                    this.endTurn(false);
                }
            });
            return false;
        }
        this.moveMode = this.moveMode.maximize(MoveMode.END_TURN);
        if (!this.doExecuteGotoOrders()) {
            return false;
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.freeColClient)) {
            this.freeColClient.getConnectController().reconnect();
            return false;
        }
        this.gui.closeMenus();
        this.gui.setActiveUnit(null);
        for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
            if (unit.getState() != Unit.UnitState.SKIPPED) continue;
            unit.setState(Unit.UnitState.ACTIVE);
        }
        this.moveMode = MoveMode.NEXT_ACTIVE_UNIT;
        this.turnReportMessages.clear();
        return this.askServer().endTurn();
    }

    private boolean updateActiveUnit(Tile tile) {
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && unit.couldMove()) {
            return false;
        }
        if (this.moveMode != MoveMode.NEXT_ACTIVE_UNIT && !this.doExecuteGotoOrders()) {
            return false;
        }
        if (player.hasNextActiveUnit()) {
            this.gui.setActiveUnit(player.getNextActiveUnit());
            return true;
        }
        this.gui.setActiveUnit(null);
        if (!this.doExecuteGotoOrders()) {
            return true;
        }
        ClientOptions options = this.freeColClient.getClientOptions();
        if (tile != null) {
            this.gui.setSelectedTile(tile);
        } else if (options.getBoolean("model.option.autoEndTurn")) {
            this.doEndTurn(options.getBoolean("model.option.showEndTurnDialog"));
        }
        return true;
    }

    private boolean moveToDestination(Unit unit, List<ModelMessage> messages) {
        if (!this.requireOurTurn() || unit.isAtSea() || unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            return this.followTradeRoute(unit, messages);
        }
        Location destination = unit.getDestination();
        if (destination == null) {
            return unit.getMovesLeft() > 0;
        }
        Player player = this.freeColClient.getMyPlayer();
        PathNode path = unit.findPath(destination);
        if (path == null) {
            StringTemplate src = unit.getLocation().getLocationLabelFor(player);
            StringTemplate dst = destination.getLocationLabelFor(player);
            StringTemplate template = StringTemplate.template("info.moveToDestinationFailed").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%location%", src).addStringTemplate("%destination%", dst);
            this.gui.showInformationMessage(unit, template);
            return false;
        }
        this.gui.setActiveUnit(unit);
        if (this.movePath(unit, path) && unit.isAtLocation(destination)) {
            Colony colony;
            this.askClearGotoOrders(unit);
            Colony colony2 = colony = unit.hasTile() ? unit.getTile().getColony() : null;
            if (colony != null && !this.checkCashInTreasureTrain(unit)) {
                this.colonyPanel(colony, unit);
            }
            return unit.couldMove();
        }
        return false;
    }

    public boolean moveDirection(Unit unit, Direction direction, boolean interactive) {
        Unit.MoveType mt = unit.getMoveType(direction);
        Location destination = unit.getDestination();
        Tile oldTile = unit.getTile();
        boolean clearDestination = destination != null && oldTile != null && Map.isSameLocation(oldTile.getNeighbourOrNull(direction), destination);
        boolean result = mt.isLegal();
        switch (mt) {
            case MOVE_HIGH_SEAS: {
                if (this.freeColClient.getMyPlayer().getEurope() != null) {
                    if (destination == null) {
                        result = this.moveHighSeas(unit, direction);
                        break;
                    }
                    if (destination instanceof Europe) {
                        result = this.moveTo(unit, destination);
                        break;
                    }
                }
            }
            case MOVE: {
                result = this.moveMove(unit, direction);
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                result = this.moveExplore(unit, direction);
                break;
            }
            case ATTACK_UNIT: {
                result = this.moveAttack(unit, direction);
                break;
            }
            case ATTACK_SETTLEMENT: {
                result = this.moveAttackSettlement(unit, direction);
                break;
            }
            case EMBARK: {
                result = this.moveEmbark(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                result = this.moveLearnSkill(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                result = this.moveScoutIndianSettlement(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                result = this.moveUseMissionary(unit, direction);
                break;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                result = this.moveScoutColony(unit, direction);
                break;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                result = this.moveTrade(unit, direction);
                break;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_GOODS: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessGoods").addStringTemplate("%nation%", nation).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (this.moveDisembark(unit, direction) || !interactive) break;
                this.sound("sound.event.illegalMove");
                break;
            }
            case MOVE_NO_ACCESS_MISSION_BAN: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessMissionBan").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            case MOVE_NO_MOVES: {
                clearDestination = false;
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            case MOVE_NO_TILE: {
                if (!interactive && !clearDestination) break;
                this.sound("sound.event.illegalMove");
                this.gui.showInformationMessage(unit, StringTemplate.template("move.noTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
                break;
            }
            default: {
                if (interactive || clearDestination) {
                    this.sound("sound.event.illegalMove");
                }
                result = false;
            }
        }
        if (clearDestination && !unit.isDisposed()) {
            this.askClearGotoOrders(unit);
        }
        return result;
    }

    private boolean movePath(Unit unit, PathNode path) {
        while (path != null) {
            if (!unit.isAtLocation(path.getLocation())) {
                if (path.getLocation() instanceof Europe) {
                    if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                        this.moveTo(unit, path.getLocation());
                    } else {
                        logger.warning("Can not move to Europe from " + unit.getLocation() + " on path: " + path.fullPathToString());
                    }
                    return false;
                }
                if (path.getLocation() instanceof Tile) {
                    if (path.getDirection() == null) {
                        if (unit.isInEurope()) {
                            this.moveTo(unit, unit.getGame().getMap());
                        } else {
                            logger.warning("Null direction on path: " + path.fullPathToString());
                        }
                        return false;
                    }
                    if (!this.moveDirection(unit, path.getDirection(), false)) {
                        return false;
                    }
                    if (unit.hasTile() && unit.getTile().getDiscoverableRegion() != null) {
                        return false;
                    }
                } else {
                    if (path.getLocation() instanceof Unit) {
                        return this.moveEmbark(unit, path.getDirection());
                    }
                    logger.warning("Bad path: " + path.fullPathToString());
                }
            }
            path = path.next;
        }
        return true;
    }

    private boolean moveAttack(Unit unit, Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Unit u = target.getFirstUnit();
        if (u == null || unit.getOwner().owns(u)) {
            return false;
        }
        this.askClearGotoOrders(unit);
        if (this.gui.confirmHostileAction(unit, target) && this.gui.confirmPreCombat(unit, target)) {
            this.askServer().attack(unit, direction);
        }
        return false;
    }

    private boolean moveAttackSettlement(Unit unit, Direction direction) {
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        if (settlement == null || unit.getOwner().owns(settlement)) {
            return false;
        }
        ArmedUnitSettlementAction act = this.gui.getArmedUnitSettlementChoice(settlement);
        if (act == null) {
            return true;
        }
        switch (act) {
            case SETTLEMENT_ATTACK: {
                if (!this.gui.confirmHostileAction(unit, target) || !this.gui.confirmPreCombat(unit, target)) break;
                this.askServer().attack(unit, direction);
                Colony col = target.getColony();
                if (col != null && unit.getOwner().owns(col)) {
                    this.colonyPanel(col, unit);
                }
                return false;
            }
            case SETTLEMENT_TRIBUTE: {
                int amount;
                int n = settlement instanceof Colony ? this.gui.confirmEuropeanTribute(unit, (Colony)settlement, this.getNationSummary(settlement.getOwner())) : (amount = settlement instanceof IndianSettlement ? this.gui.confirmNativeTribute(unit, (IndianSettlement)settlement) : -1);
                if (amount <= 0) {
                    return true;
                }
                return this.moveTribute(unit, amount, direction);
            }
            default: {
                logger.warning("showArmedUnitSettlementDialog fail: " + (Object)((Object)act));
            }
        }
        return true;
    }

    private boolean moveDiplomacy(Unit unit, Direction direction, DiplomaticTrade dt) {
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement == null || !(settlement instanceof Colony)) {
            return false;
        }
        Colony colony = (Colony)settlement;
        Game game = this.freeColClient.getGame();
        Player player = unit.getOwner();
        Player other = colony.getOwner();
        if (other == player.getREFPlayer()) {
            return false;
        }
        StringTemplate nation = other.getNationLabel();
        while (dt != null) {
            dt = this.askServer().diplomacy(game, unit, colony, dt);
            if (dt == null) continue;
            dt = this.gui.showNegotiationDialog(unit, colony, dt, dt.getSendMessage(player, colony));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDisembark(Unit unit, Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        List disembarkable = unit.getUnitList().stream().filter(u -> u.getMoveType(tile).isProgress()).collect(Collectors.toList());
        if (disembarkable.isEmpty()) {
            return false;
        }
        if (disembarkable.size() == 1) {
            if (this.gui.confirm(tile, StringTemplate.key("disembark.text"), (Unit)disembarkable.get(0), "ok", "cancel")) {
                this.moveDirection((Unit)disembarkable.get(0), direction, false);
            }
        } else {
            ArrayList choices = new ArrayList();
            for (Unit dUnit : disembarkable) {
                choices.add(new ChoiceItem<Unit>(dUnit.getDescription(Unit.UnitLabelType.NATIONAL), dUnit));
            }
            choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            Unit u2 = (Unit)this.gui.getChoice(unit.getTile(), (Object)Messages.message("disembark.text"), unit, "none", choices);
            if (u2 != null) {
                if (u2 == unit) {
                    for (Unit dUnit : disembarkable) {
                        try {
                            this.moveDirection(dUnit, direction, false);
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    this.moveDirection(u2, direction, false);
                }
            }
        }
        return true;
    }

    private boolean moveEmbark(Unit unit, Direction direction) {
        if (unit.getColony() != null && !this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        ArrayList choices = new ArrayList();
        for (Unit u : destinationTile.getUnitList()) {
            if (!u.canAdd(unit)) continue;
            String m = u.getDescription(Unit.UnitLabelType.NATIONAL);
            choices.add(new ChoiceItem<Unit>(m, u));
            carrier = u;
        }
        if (choices.isEmpty()) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() != 1 && (carrier = (Unit)this.gui.getChoice(unit.getTile(), (Object)Messages.message("embark.text"), unit, "none", choices)) == null) {
            return true;
        }
        this.askClearGotoOrders(unit);
        if (!this.askServer().embark(unit, carrier, direction) || unit.getLocation() != carrier) {
            unit.setState(Unit.UnitState.SKIPPED);
            return false;
        }
        unit.getOwner().invalidateCanSeeTiles();
        return false;
    }

    private boolean moveExplore(Unit unit, Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (!this.gui.confirm(unit.getTile(), StringTemplate.key("exploreLostCityRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            return true;
        }
        if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !this.gui.confirm(unit.getTile(), StringTemplate.key("exploreMoundsRumour.text"), unit, "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            this.askServer().declineMounds(unit, direction);
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveHighSeas(Unit unit, Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if (newTile == null || !oldTile.isDirectlyHighSeasConnected() && newTile.isDirectlyHighSeasConnected()) {
            if (unit.getTradeRoute() != null) {
                TradeRouteStop stop = unit.getStop();
                if (stop != null && TradeRoute.isStopValid(unit, stop) && stop.getLocation() instanceof Europe) {
                    this.moveTo(unit, stop.getLocation());
                    return false;
                }
            } else {
                if (unit.getDestination() instanceof Europe) {
                    this.moveTo(unit, unit.getDestination());
                    return false;
                }
                if (this.gui.confirm(oldTile, StringTemplate.template("highseas.text").addAmount("%number%", unit.getSailTurns()), unit, "highseas.yes", "highseas.no")) {
                    this.moveTo(unit, unit.getOwner().getEurope());
                    return false;
                }
            }
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveLearnSkill(Unit unit, Direction direction) {
        this.askClearGotoOrders(unit);
        if (!this.askServer().askSkill(unit, direction)) {
            return false;
        }
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            this.gui.showInformationMessage((Settlement)settlement, "info.noMoreSkill");
        } else if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            this.gui.showInformationMessage((Settlement)settlement, StringTemplate.template("info.cantLearnSkill").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addNamed("%skill%", skill));
        } else if (this.gui.confirm(unit.getTile(), StringTemplate.template("learnSkill.text").addNamed("%skill%", skill), unit, "learnSkill.yes", "learnSkill.no") && this.askServer().learnSkill(unit, direction)) {
            if (unit.isDisposed()) {
                this.gui.showInformationMessage((Settlement)settlement, "learnSkill.die");
                return false;
            }
            if (unit.getType() != skill) {
                this.gui.showInformationMessage((Settlement)settlement, "learnSkill.leave");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveMove(Unit unit, Direction direction) {
        boolean ret;
        ClientOptions options = this.freeColClient.getClientOptions();
        if (unit.canCarryUnits() && unit.hasSpaceLeft() && options.getBoolean("model.option.autoloadSentries")) {
            List<Unit> waiting = unit.getColony() != null ? unit.getTile().getUnitList() : Collections.emptyList();
            for (Unit u : waiting) {
                if (u.getState() != Unit.UnitState.SENTRY || !unit.couldCarry(u)) continue;
                try {
                    this.askEmbark(u, unit);
                }
                finally {
                    if (u.getLocation() == unit) continue;
                    u.setState(Unit.UnitState.SKIPPED);
                }
            }
            if (unit.getMovesLeft() <= 0) {
                return false;
            }
        }
        if (!this.askServer().move(unit, direction)) {
            unit.setState(Unit.UnitState.SKIPPED);
            return false;
        }
        unit.getOwner().invalidateCanSeeTiles();
        Tile tile = unit.getTile();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            this.gui.paintImmediatelyCanvasInItsBounds();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean bl = ret = !unit.isDisposed() && !this.checkCashInTreasureTrain(unit);
        if (ret) {
            if (tile.getColony() != null && unit.isCarrier()) {
                Colony colony = tile.getColony();
                if (unit.getTradeRoute() == null && Map.isSameLocation(tile, unit.getDestination())) {
                    this.colonyPanel(colony, unit);
                }
            }
            ret = unit.getMovesLeft() > 0;
        }
        return ret;
    }

    private boolean moveScoutColony(Unit unit, Direction direction) {
        Game game = this.freeColClient.getGame();
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        this.askClearGotoOrders(unit);
        ScoutColonyAction act = this.gui.getScoutForeignColonyChoice(colony, unit, canNeg);
        if (act == null) {
            return true;
        }
        switch (act) {
            case FOREIGN_COLONY_ATTACK: {
                return this.moveAttackSettlement(unit, direction);
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                Player player = unit.getOwner();
                DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.DIPLOMATIC, player, colony.getOwner(), null, 0);
                agreement = this.gui.showNegotiationDialog(unit, colony, agreement, agreement.getSendMessage(player, colony));
                return agreement == null || agreement.getStatus() == DiplomaticTrade.TradeStatus.REJECT_TRADE ? true : this.moveDiplomacy(unit, direction, agreement);
            }
            case FOREIGN_COLONY_SPY: {
                return this.moveSpy(unit, direction);
            }
        }
        logger.warning("showScoutForeignColonyDialog fail: " + (Object)((Object)act));
        return true;
    }

    private boolean moveScoutIndianSettlement(Unit unit, Direction direction) {
        ScoutIndianSettlementAction act;
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        IndianSettlement settlement = tile.getIndianSettlement();
        Player player = unit.getOwner();
        this.askClearGotoOrders(unit);
        String number = this.askServer().scoutSettlement(unit, direction);
        if (number == null) {
            number = Messages.message("many");
        }
        if ((act = this.gui.getScoutIndianSettlementChoice(settlement, number)) == null) {
            return true;
        }
        switch (act) {
            case INDIAN_SETTLEMENT_ATTACK: {
                if (!this.gui.confirmPreCombat(unit, tile)) {
                    return true;
                }
                this.askServer().attack(unit, direction);
                return false;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                int oldGold = player.getGold();
                String result = this.askServer().scoutSpeakToChief(unit, direction);
                if (result == null) {
                    return false;
                }
                if ("die".equals(result)) {
                    this.gui.showInformationMessage((Settlement)settlement, "scoutSettlement.speakDie");
                    return false;
                }
                if ("expert".equals(result)) {
                    this.gui.showInformationMessage((Settlement)settlement, StringTemplate.template("scoutSettlement.expertScout").addNamed("%unit%", unit.getType()));
                } else if ("tales".equals(result)) {
                    this.gui.showInformationMessage((Settlement)settlement, "scoutSettlement.speakTales");
                } else if ("beads".equals(result)) {
                    this.gui.showInformationMessage((Settlement)settlement, StringTemplate.template("scoutSettlement.speakBeads").addAmount("%amount%", player.getGold() - oldGold));
                } else if ("nothing".equals(result)) {
                    this.gui.showInformationMessage((Settlement)settlement, StringTemplate.template("scoutSettlement.speakNothing").addStringTemplate("%nation%", player.getNationLabel()));
                } else {
                    logger.warning("Invalid result from askScoutSpeak: " + result);
                }
                return false;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                return this.moveTribute(unit, 1, direction);
            }
        }
        logger.warning("showScoutIndianSettlementDialog fail: " + (Object)((Object)act));
        return true;
    }

    private boolean moveSpy(Unit unit, Direction direction) {
        this.askServer().spy(unit, direction);
        return false;
    }

    private boolean moveTrade(Unit unit, Direction direction) {
        this.askClearGotoOrders(unit);
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            Game game = this.freeColClient.getGame();
            Player player = unit.getOwner();
            DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.TRADE, player, settlement.getOwner(), null, 0);
            return (agreement = this.gui.showNegotiationDialog(unit, settlement, agreement, agreement.getSendMessage(player, settlement))) == null || agreement.getStatus() == DiplomaticTrade.TradeStatus.REJECT_TRADE ? true : this.moveDiplomacy(unit, direction, agreement);
        }
        if (settlement instanceof IndianSettlement) {
            return this.moveTradeIndianSettlement(unit, direction);
        }
        throw new RuntimeException("Bogus settlement: " + settlement.getId());
    }

    private boolean moveTradeIndianSettlement(Unit unit, Direction direction) {
        StringTemplate baseTemplate;
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        StringTemplate template = baseTemplate = StringTemplate.template("tradeProposition.welcome").addStringTemplate("%nation%", settlement.getOwner().getNationLabel()).addName("%settlement%", settlement.getName());
        boolean[] results = this.askServer().openTransactionSession(unit, settlement);
        while (results != null) {
            TradeAction act;
            boolean gif;
            boolean buy = results[0] && unit.hasSpaceLeft();
            boolean sel = results[1] && unit.hasGoodsCargo();
            boolean bl = gif = results[2] && unit.hasGoodsCargo();
            if (!buy && !sel && !gif || (act = this.gui.getIndianSettlementTradeChoice(settlement, template, buy, sel, gif)) == null) break;
            StringTemplate t = null;
            switch (act) {
                case BUY: {
                    t = this.attemptBuyFromSettlement(unit, settlement);
                    if (t == null) {
                        results[0] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                case SELL: {
                    t = this.attemptSellToSettlement(unit, settlement);
                    if (t == null) {
                        results[1] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                case GIFT: {
                    t = this.attemptGiftToSettlement(unit, settlement);
                    if (t == null) {
                        results[2] = false;
                        template = baseTemplate;
                        break;
                    }
                    template = t;
                    break;
                }
                default: {
                    logger.warning("showIndianSettlementTradeDialog fail: " + (Object)((Object)act));
                    results = null;
                }
            }
            if (template != abortTrade) continue;
            template = baseTemplate;
        }
        this.askServer().closeTransactionSession(unit, settlement);
        if (unit.getMovesLeft() > 0) {
            this.gui.setActiveUnit(unit);
        }
        return false;
    }

    private StringTemplate tradeFailMessage(int fail, Settlement settlement, Goods goods) {
        switch (fail) {
            case 0: {
                return StringTemplate.template("trade.noTradeGoods").addNamed("%goods%", goods);
            }
            case -2: {
                return StringTemplate.template("trade.noTradeHaggle");
            }
            case -3: {
                return StringTemplate.template("trade.noTradeHostile");
            }
        }
        return StringTemplate.template("trade.noTrade").addName("%settlement%", settlement.getLocationLabelFor(this.freeColClient.getMyPlayer()));
    }

    private StringTemplate attemptBuyFromSettlement(Unit unit, Settlement settlement) {
        block9: {
            BuyAction act;
            Game game = this.freeColClient.getGame();
            Player player = this.freeColClient.getMyPlayer();
            Goods goods = null;
            List<Goods> forSale = this.askServer().getGoodsForSaleInSettlement(game, unit, settlement);
            block4: while (true) {
                if (forSale.isEmpty()) {
                    return StringTemplate.template("trade.nothingToSell");
                }
                ArrayList choices = new ArrayList();
                for (Goods g : forSale) {
                    String label = Messages.message(g.getLabel(true));
                    choices.add(new ChoiceItem<Goods>(label, g));
                }
                goods = (Goods)this.gui.getChoice(unit.getTile(), (Object)Messages.message("buyProposition.text"), settlement, "nothing", choices);
                if (goods == null) break block9;
                int gold = -1;
                block6: while (true) {
                    if ((gold = this.askServer().buyProposition(unit, settlement, goods, gold)) <= 0) {
                        return this.tradeFailMessage(gold, settlement, goods);
                    }
                    boolean canBuy = player.checkGold(gold);
                    act = this.gui.getBuyChoice(unit, settlement, goods, gold, canBuy);
                    if (act == null) continue block4;
                    switch (act) {
                        case BUY: {
                            return this.askServer().buyFromSettlement(unit, settlement, goods, gold) ? null : abortTrade;
                        }
                        case HAGGLE: {
                            gold = gold * 9 / 10;
                            continue block6;
                        }
                    }
                    break;
                }
                break;
            }
            logger.warning("showBuyDialog fail: " + (Object)((Object)act));
            return null;
        }
        return abortTrade;
    }

    /*
     * Exception decompiling
     */
    private StringTemplate attemptSellToSettlement(Unit unit, Settlement settlement) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StringTemplate attemptGiftToSettlement(Unit unit, Settlement settlement) {
        ArrayList choices = new ArrayList();
        for (Goods g : unit.getGoodsList()) {
            String label = Messages.message(g.getLabel(true));
            choices.add(new ChoiceItem<Goods>(label, g));
        }
        Goods goods = (Goods)this.gui.getChoice(unit.getTile(), (Object)Messages.message("gift.text"), settlement, "cancel", choices);
        return goods != null && this.askServer().deliverGiftToSettlement(unit, settlement, goods) ? null : abortTrade;
    }

    private boolean moveTribute(Unit unit, int amount, Direction direction) {
        Game game = this.freeColClient.getGame();
        Player player = unit.getOwner();
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        Settlement settlement = target.getSettlement();
        Player other = settlement.getOwner();
        if (settlement.getOwner().isIndian()) {
            this.askServer().demandTribute(unit, direction);
            return false;
        }
        DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.TRIBUTE, player, other, null, 0);
        agreement.add(new StanceTradeItem(game, player, other, Stance.PEACE));
        agreement.add(new GoldTradeItem(game, other, player, amount));
        return this.moveDiplomacy(unit, direction, agreement);
    }

    private boolean moveUseMissionary(Unit unit, Direction direction) {
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        Player player = unit.getOwner();
        boolean canEstablish = !settlement.hasMissionary();
        boolean canDenounce = !canEstablish && !settlement.hasMissionary(player);
        this.askClearGotoOrders(unit);
        MissionaryAction act = this.gui.getMissionaryChoice(unit, settlement, canEstablish, canDenounce);
        if (act == null) {
            return true;
        }
        switch (act) {
            case ESTABLISH_MISSION: 
            case DENOUNCE_HERESY: {
                if (!this.askServer().missionary(unit, direction, act == MissionaryAction.DENOUNCE_HERESY) || !settlement.hasMissionary(player)) break;
                this.sound("sound.event.missionEstablished");
                player.invalidateCanSeeTiles();
                break;
            }
            case INCITE_INDIANS: {
                ArrayList choices = new ArrayList();
                for (Player p : this.freeColClient.getGame().getLiveEuropeanPlayers(player)) {
                    String label = Messages.message(p.getCountryLabel());
                    choices.add(new ChoiceItem<Player>(label, p));
                }
                Player enemy = (Player)this.gui.getChoice(unit.getTile(), (Object)Messages.message("missionarySettlement.inciteQuestion"), unit, "missionarySettlement.cancel", choices);
                if (enemy == null) {
                    return true;
                }
                int gold = this.askServer().incite(unit, direction, enemy, -1);
                if (gold < 0) break;
                if (!player.checkGold(gold)) {
                    this.gui.showInformationMessage((Settlement)settlement, StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName()).addAmount("%amount%", gold));
                    break;
                }
                if (!this.gui.confirm(unit.getTile(), StringTemplate.template("missionarySettlement.inciteConfirm").add("%player%", enemy.getName()).addAmount("%amount%", gold), unit, "yes", "no")) break;
                this.askServer().incite(unit, direction, enemy, gold);
                break;
            }
            default: {
                logger.warning("showUseMissionaryDialog fail");
            }
        }
        return false;
    }

    private boolean followTradeRoute(Unit unit, List<ModelMessage> messages) {
        Player player = unit.getOwner();
        TradeRoute tr = unit.getTradeRoute();
        boolean detailed = this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGoodsMovement");
        boolean checkProduction = this.freeColClient.getClientOptions().getBoolean("model.option.stockAccountsForProduction");
        List<TradeRouteStop> stops = unit.getCurrentStops();
        boolean result = false;
        LogBuilder lb = new LogBuilder(detailed && !tr.isSilent() ? 256 : -1);
        lb.mark();
        boolean valid = true;
        for (TradeRouteStop trs : stops) {
            if (TradeRoute.isStopValid(unit, trs)) continue;
            lb.add(" ", Messages.message(trs.invalidStopLabel(player)));
            valid = false;
        }
        if (!valid) {
            this.clearOrders(unit);
            stops.clear();
            boolean bl = result = unit.getMovesLeft() > 0;
        }
        while (!stops.isEmpty()) {
            TradeRouteStop stop = stops.remove(0);
            if (!unit.atStop(stop)) {
                if (unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
                    lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.toStop", player)));
                    break;
                }
                Location destination = stop.getLocation();
                PathNode path = unit.findPath(destination);
                if (path == null) {
                    lb.add(" ", Messages.message(stop.getLabelFor("tradeRoute.pathStop", player)));
                    unit.setState(Unit.UnitState.SKIPPED);
                    break;
                }
                this.movePath(unit, path);
                if (!unit.atStop(stop)) {
                    unit.setState(Unit.UnitState.SKIPPED);
                    break;
                }
            }
            lb.mark();
            this.unloadUnitAtStop(unit, lb);
            this.loadUnitAtStop(unit, lb);
            lb.grew(" ", Messages.message(stop.getLabelFor("tradeRoute.atStop", player)));
            if (unit.getMovesLeft() <= 0) break;
            TradeRouteStop next = null;
            List<TradeRouteStop> moreStops = unit.getCurrentStops();
            if (unit.atStop(moreStops.get(0))) {
                moreStops.remove(0);
            }
            for (TradeRouteStop trs : moreStops) {
                if (!trs.hasWork(unit, !checkProduction ? 0 : unit.getTurnsToReach(trs.getLocation()))) continue;
                next = trs;
                break;
            }
            if (next == null) {
                lb.add(" ", Messages.message("tradeRoute.wait"));
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            List<TradeRouteStop> skipped = tr.getStopSublist(stops.get(0), next);
            if (!skipped.isEmpty()) {
                StringTemplate t = StringTemplate.label("").add("tradeRoute.skipped");
                String sep = " ";
                for (TradeRouteStop trs : skipped) {
                    t.addName(sep).addStringTemplate(trs.getLocation().getLocationLabelFor(player));
                    sep = ", ";
                }
                t.addName(".");
                lb.add(" ", Messages.message(t));
            }
            while (!stops.isEmpty() && stops.get(0) != next) {
                stops.remove(0);
            }
            if (this.askServer().setCurrentStop(unit, tr.getIndex(next))) continue;
            unit.setState(Unit.UnitState.SKIPPED);
            break;
        }
        if (lb.grew(new Object[0])) {
            ModelMessage m = new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "tradeRoute.prefix", unit).addName("%route%", tr.getName()).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%data%", lb.toString());
            if (messages != null) {
                messages.add(m);
            } else {
                player.addModelMessage(m);
                this.turnReportMessages.add(m);
            }
        }
        return result;
    }

    private boolean loadUnitAtStop(Unit unit, LogBuilder lb) {
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        boolean ret = false;
        List<AbstractGoods> toLoad = stop.getCompactCargo();
        for (Goods g : unit.getCompactGoods()) {
            AbstractGoods ag = AbstractGoods.findByType(g.getType(), toLoad);
            if (ag != null) {
                int goodsAmount = g.getAmount();
                int amount = ag.getAmount() - goodsAmount;
                if (amount <= 0) {
                    toLoad.remove(ag);
                    continue;
                }
                ag.setAmount(amount);
                continue;
            }
            lb.add(" ", Messages.message(StringTemplate.template("tradeRoute.loadStopBlocked").addStringTemplate("%goods%", g.getLabel())));
        }
        Iterator<AbstractGoods> iterator = toLoad.iterator();
        while (iterator.hasNext()) {
            AbstractGoods ag = iterator.next();
            int amount = stop.getExportAmount(ag.getType(), 0);
            if (amount <= 0) {
                if (stop.getCargo().contains(ag.getType())) {
                    int present = stop.getGoodsCount(ag.getType());
                    lb.add(" ", this.getLoadGoodsMessage(ag.getType(), 0, present, 0, -1));
                }
                iterator.remove();
                continue;
            }
            ag.setAmount(Math.min(amount, ag.getAmount()));
        }
        for (AbstractGoods ag : toLoad) {
            GoodsType type = ag.getType();
            int demand = ag.getAmount();
            ret = this.askLoadGoods(stop.getLocation(), type, demand, unit);
            if (!ret) break;
            int present = stop.getGoodsCount(type);
            int export = stop.getExportAmount(type, 0);
            lb.add(" ", this.getLoadGoodsMessage(type, demand, present, export, demand));
        }
        return ret;
    }

    private String getLoadGoodsMessage(GoodsType type, int amount, int present, int export, int toLoad) {
        int more;
        String key;
        if (amount == 0) {
            key = present == 0 ? "tradeRoute.loadStopNone" : "tradeRoute.loadStopNoExport";
            more = present;
        } else if (toLoad < export) {
            key = "tradeRoute.loadStopImport";
            more = export - toLoad;
        } else if (present > export && toLoad > export) {
            key = "tradeRoute.loadStopExport";
            more = present - export;
        } else {
            key = "tradeRoute.loadStop";
            more = -1;
        }
        return Messages.message(StringTemplate.template(key).addAmount("%amount%", amount).addNamed("%goods%", type).addAmount("%more%", more));
    }

    private boolean unloadUnitAtStop(Unit unit, LogBuilder lb) {
        TradeLocation trl = unit.getTradeLocation();
        if (trl == null) {
            return false;
        }
        TradeRouteStop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        boolean ret = false;
        Game game = this.freeColClient.getGame();
        for (Goods goods : unit.getCompactGoodsList()) {
            int atStop;
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int present = goods.getAmount();
            int toUnload = present;
            int amount = toUnload;
            if (amount > (atStop = trl.getImportAmount(type, 0))) {
                StringTemplate locName = ((Location)((Object)trl)).getLocationLabel();
                int option = this.freeColClient.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        StringTemplate template = StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%colony%", locName).addAmount("%amount%", toUnload - atStop).addNamed("%goods%", goods);
                        if (this.gui.confirm(unit.getTile(), template, unit, "yes", "no")) break;
                        amount = atStop;
                        break;
                    }
                    case 1: {
                        amount = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (!(ret = amount == 0 ? false : this.askUnloadGoods(type, amount, unit))) continue;
            lb.add(" ", this.getUnloadGoodsMessage(unit, type, amount, present, atStop, toUnload));
        }
        return ret;
    }

    private String getUnloadGoodsMessage(Unit unit, GoodsType type, int amount, int present, int atStop, int toUnload) {
        String key = null;
        int onBoard = unit.getGoodsCount(type);
        int unloaded = present - onBoard;
        int more = 0;
        if (unloaded < amount) {
            key = "tradeRoute.unloadStopFail";
            more = unloaded;
        } else if (amount > atStop) {
            if (amount == toUnload) {
                key = "tradeRoute.unloadStopImport";
                more = toUnload - atStop;
            } else {
                key = amount == 0 ? "tradeRoute.unloadStopNoExport" : "tradeRoute.unloadStopExport";
                more = onBoard;
            }
        } else {
            key = "tradeRoute.unloadStop";
        }
        return Messages.message(StringTemplate.template(key).addAmount("%amount%", amount).addAmount("%more%", more).addNamed("%goods%", type));
    }

    public boolean abandonColony(Colony colony) {
        boolean ret;
        Player player = this.freeColClient.getMyPlayer();
        if (!this.requireOurTurn() || colony == null || !player.owns(colony) || colony.getUnitCount() > 0) {
            return false;
        }
        Tile tile = colony.getTile();
        boolean bl = ret = this.askServer().abandonColony(colony) && !tile.hasSettlement();
        if (ret) {
            player.invalidateCanSeeTiles();
            this.updateGUI(null);
        }
        return ret;
    }

    public void animateAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        if (this.freeColClient.getAnimationSpeed(attacker.getOwner()) > 0) {
            this.gui.animateUnitAttack(attacker, defender, attackerTile, defenderTile, success);
        }
        this.gui.refresh();
    }

    public void animateMove(Unit unit, Tile oldTile, Tile newTile) {
        if (this.freeColClient.getAnimationSpeed(unit.getOwner()) > 0) {
            this.gui.animateUnitMove(unit, oldTile, newTile);
        } else if (this.freeColClient.getMyPlayer().owns(unit)) {
            this.gui.requireFocus(newTile);
        }
        this.gui.refresh();
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        boolean ret;
        Player player = this.freeColClient.getMyPlayer();
        if (!(this.requireOurTurn() && student != null && player.owns(student) && student.getColony() != null && student.isInColony() && teacher != null && player.owns(teacher) && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher))) {
            return false;
        }
        UnitWas unitWas = new UnitWas(student);
        boolean bl = ret = this.askServer().assignTeacher(student, teacher) && student.getTeacher() == teacher;
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askAssignTradeRoute(unit, tradeRoute);
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (!this.requireOurTurn() || unit == null || unit.isCarrier() || carrier == null || !carrier.canCarryUnits() || !unit.isAtLocation(carrier.getLocation())) {
            return false;
        }
        boolean ret = this.askEmbark(unit, carrier);
        if (ret) {
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean buildColony(Unit unit) {
        StringTemplate warnings;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit == null) {
            return false;
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return false;
        }
        if (!unit.canBuildColony()) {
            this.gui.showInformationMessage(unit, StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return false;
        }
        Colony colony = tile.getColony();
        if (colony != null) {
            this.askServer().joinColony(unit, colony);
            this.updateGUI(null);
            this.colonyPanel(colony, unit);
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Player.NoClaimReason reason = player.canClaimToFoundSettlementReason(tile);
        switch (reason) {
            case NONE: 
            case NATIVES: {
                break;
            }
            default: {
                this.gui.showInformationMessage(reason.getDescriptionKey());
                return false;
            }
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !(warnings = tile.getBuildColonyWarnings(unit)).getReplacements().isEmpty() && !this.gui.confirm(tile, warnings, unit, "buildColony.yes", "buildColony.no")) {
            return false;
        }
        String name = this.gui.getNewColonyName(player, tile);
        if (name == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = player.owns(tile);
        if (!ret && !(ret = this.askClaimTile(player, tile, unit, player.getLandPrice(tile)))) {
            NameCache.putSettlementName(player, name);
        }
        if (ret) {
            boolean bl = ret = this.askServer().buildColony(name, unit) && tile.hasSettlement();
            if (ret) {
                this.sound("sound.event.buildingComplete");
                player.invalidateCanSeeTiles();
                unitWas.fireChanges();
                for (Unit u : tile.getUnitList()) {
                    this.checkCashInTreasureTrain(u);
                }
                this.colonyPanel((Colony)tile.getSettlement(), unit);
            }
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        if (!(this.requireOurTurn() && type != null && amount > 0 && carrier != null && carrier.isInEurope() && this.freeColClient.getMyPlayer().owns(carrier))) {
            return false;
        }
        Europe europe = carrier.getOwner().getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askLoadGoods(europe, type, amount, carrier);
        if (ret) {
            this.sound("sound.event.loadCargo");
            europeWas.fireChanges();
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void chat(Player player, String message, boolean pri) {
        this.gui.displayChatMessage(player, message, pri);
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        boolean ret;
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getState() == state) {
            return true;
        }
        if (!unit.checkSetState(state)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Stance.ALLIANCE && !this.gui.confirmHostileAction(unit, tile)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().changeState(unit, state) && unit.getState() == state;
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || improvementType == null || !unit.hasTile() || !unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType.isNatural()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Tile tile = unit.getTile();
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = player.owns(tile) || this.askClaimTile(player, tile, unit, player.getLandPrice(tile));
        if (ret) {
            boolean bl2 = ret = this.askServer().changeWorkImprovementType(unit, improvementType) && unit.getWorkImprovement() != null && unit.getWorkImprovement().getType() == improvementType;
            if (ret) {
                unitWas.fireChanges();
            }
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().changeWorkType(unit, workType) && unit.getWorkType() == workType;
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean ret;
        if (!(this.requireOurTurn() && unit != null && unit.canCarryTreasure() && unit.canCashInTreasureTrain())) {
            return false;
        }
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe != null && !unit.isInEurope()) {
            StringTemplate template;
            int fee = unit.getTransportFee();
            if (fee == 0) {
                template = StringTemplate.template("cashInTreasureTrain.free");
            } else {
                int percent = this.getSpecification().getInteger("model.option.treasureTransportFee");
                template = StringTemplate.template("cashInTreasureTrain.pay").addAmount("%fee%", percent);
            }
            if (!this.gui.confirm(unit.getTile(), template, unit, "accept", "reject")) {
                return false;
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().cashInTreasureTrain(unit) && unit.isDisposed();
        if (ret) {
            this.sound("sound.event.cashInTreasureTrain");
            unitWas.fireChanges();
            this.updateGUI(tile);
        }
        return ret;
    }

    public boolean chooseFoundingFather(List<FoundingFather> ffs, FoundingFather ff) {
        if (ffs == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        player.setCurrentFather(ff);
        return this.askServer().chooseFoundingFather(ffs, ff);
    }

    public void chooseFoundingFather(List<FoundingFather> ffs) {
        if (ffs == null) {
            return;
        }
        this.gui.showChooseFoundingFatherDialog(ffs, ff -> this.chooseFoundingFather(ffs, (FoundingFather)ff));
    }

    public boolean claimTile(Tile tile, FreeColGameObject claimant) {
        if (!this.requireOurTurn() || tile == null || claimant == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int price = (claimant instanceof Settlement ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        UnitWas unitWas = claimant instanceof Unit ? new UnitWas((Unit)claimant) : null;
        boolean ret = this.askClaimTile(player, tile, claimant, price);
        if (ret) {
            if (unitWas != null) {
                unitWas.fireChanges();
            }
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean clearGotoOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askClearGotoOrders(unit);
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean clearOrders(Unit unit) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING && !this.gui.confirm(unit.getTile(), StringTemplate.template("clearOrders.text").addAmount("%turns%", unit.getWorkTurnsLeft()), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askClearGotoOrders(unit) && (unit.getState() == Unit.UnitState.ACTIVE || this.askServer().changeState(unit, Unit.UnitState.ACTIVE));
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean clearSpeciality(Unit unit) {
        boolean ret;
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        UnitType oldType = unit.getType();
        UnitType newType = oldType.getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newType == null) {
            this.gui.showInformationMessage(unit, StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)));
            return false;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.confirm(tile, StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addNamed("%unit%", newType), unit, "ok", "cancel")) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().clearSpeciality(unit) && unit.getType() == newType;
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void closeMenus() {
        this.gui.closeMenus();
    }

    public boolean declareIndependence() {
        boolean ret;
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (player.getNewLandName() == null) {
            return false;
        }
        StringTemplate declare = player.checkDeclareIndependence();
        if (declare != null) {
            this.gui.showInformationMessage(declare);
            return false;
        }
        List<String> names = this.gui.confirmDeclaration();
        if (names == null || names.get(0) == null || names.get(0).isEmpty() || names.get(1) == null || names.get(1).isEmpty()) {
            return false;
        }
        boolean bl = ret = this.askServer().declareIndependence(names.get(0), names.get(1)) && player.isRebel();
        if (ret) {
            this.gui.showDeclarationPanel();
            this.updateGUI(null);
        }
        return ret;
    }

    public DiplomaticTrade diplomacy(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        Player player = this.freeColClient.getMyPlayer();
        Player otherPlayer = agreement.getOtherPlayer(player);
        StringTemplate nation = otherPlayer.getNationLabel();
        switch (agreement.getStatus()) {
            case ACCEPT_TRADE: {
                boolean visibilityChange = false;
                for (Colony c : agreement.getColoniesGivenBy(player)) {
                    player.removeSettlement(c);
                    visibilityChange = true;
                }
                for (Unit u : agreement.getUnitsGivenBy(player)) {
                    player.removeUnit(u);
                    visibilityChange = true;
                }
                if (visibilityChange) {
                    player.invalidateCanSeeTiles();
                }
                ModelMessage mm = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "diplomacy.offerAccepted", otherPlayer).addStringTemplate("%nation%", nation);
                player.addModelMessage(mm);
                this.updateGUI(null);
                break;
            }
            case REJECT_TRADE: {
                StringTemplate t = StringTemplate.template("diplomacy.offerRejected").addStringTemplate("%nation%", nation);
                this.gui.showInformationMessage(t);
                break;
            }
            case PROPOSE_TRADE: {
                StringTemplate t = agreement.getReceiveMessage(otherPlayer);
                DiplomaticTrade ourAgreement = this.gui.showNegotiationDialog(our, other, agreement, t);
                if (ourAgreement == null) {
                    agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                } else {
                    agreement = ourAgreement;
                }
                return agreement;
            }
            default: {
                logger.warning("Bogus trade status: " + (Object)((Object)agreement.getStatus()));
            }
        }
        return null;
    }

    public boolean disbandUnit(Unit unit) {
        boolean ret;
        Tile tile;
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (unit.getColony() != null && !this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.confirm(tile, StringTemplate.key("disbandUnit.text"), unit, "disbandUnit.yes", "cancel")) {
            return false;
        }
        boolean bl = ret = this.askServer().disbandUnit(unit) && unit.isDisposed();
        if (ret) {
            this.updateGUI(tile);
        }
        return ret;
    }

    public boolean displayHighScores(Boolean high) {
        List<HighScore> scores = this.askServer().getHighScores();
        this.gui.showHighScoresPanel(high == null ? null : (high != false ? "highscores.yes" : "highscores.no"), scores);
        return true;
    }

    public boolean displayModelMessages(boolean allMessages) {
        return this.displayModelMessages(allMessages, false);
    }

    public void emigrate(Player player, int slot, int n, boolean foY) {
        if (player == null || !player.isColonial() || !Europe.MigrationType.validMigrantSlot(slot)) {
            return;
        }
        if (this.askEmigrate(player.getEurope(), slot) != null) {
            this.emigration(player, n, foY);
        }
    }

    public boolean endTurn(boolean showDialog) {
        if (!this.requireOurTurn()) {
            return false;
        }
        return this.doEndTurn(showDialog && this.freeColClient.getClientOptions().getBoolean("model.option.showEndTurnDialog"));
    }

    public boolean equipUnitForRole(Unit unit, Role role, int roleCount) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || role == null || 0 > roleCount || roleCount > role.getMaximumCount()) {
            return false;
        }
        if (role == unit.getRole() && roleCount == unit.getRoleCount()) {
            return true;
        }
        Player player = this.freeColClient.getMyPlayer();
        Colony colony = unit.getColony();
        ColonyWas colonyWas = colony != null ? new ColonyWas(colony) : null;
        Europe europe = player.getEurope();
        EuropeWas europeWas = europe != null ? new EuropeWas(europe) : null;
        Market market = europe != null ? player.getMarket() : null;
        MarketWas marketWas = market != null ? new MarketWas(player) : null;
        int price = -1;
        List<AbstractGoods> req = unit.getGoodsDifference(role, roleCount);
        if (unit.isInEurope()) {
            for (AbstractGoods ag : req) {
                GoodsType goodsType = ag.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return false;
            }
            price = player.getEurope().priceGoods(req);
            if (price < 0 || !player.checkGold(price)) {
                return false;
            }
        } else if (colony != null) {
            for (AbstractGoods ag : req) {
                if (colony.getGoodsCount(ag.getType()) >= ag.getAmount()) continue;
                StringTemplate template = StringTemplate.template("equipUnit.impossible").addName("%colony%", colony.getName()).addNamed("%equipment%", ag.getType()).addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
                this.gui.showInformationMessage(unit, template);
                return false;
            }
        } else {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().equipUnitForRole(unit, role, roleCount) && unit.getRole() == role;
        if (ret) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            if (europeWas != null) {
                europeWas.fireChanges();
            }
            if (marketWas != null) {
                marketWas.fireChanges(req);
            }
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void error(String messageId, String message) {
        this.gui.showErrorMessage(messageId, message);
    }

    public boolean executeGotoOrders() {
        if (!this.requireOurTurn()) {
            return false;
        }
        return this.doExecuteGotoOrders();
    }

    public boolean firstContact(Player player, Player other, Tile tile, boolean result) {
        if (player == null || player == null || player == other || tile == null) {
            return false;
        }
        boolean ret = this.askServer().firstContact(player, other, tile, result);
        if (ret) {
            this.updateGUI(null);
        }
        return ret;
    }

    public void firstContact(Player player, Player other, Tile tile, int n) {
        this.gui.showFirstContactDialog(player, other, tile, n, b -> this.firstContact(player, other, tile, (boolean)b));
    }

    public void fountainOfYouth(int n) {
        Player player = this.freeColClient.getMyPlayer();
        boolean fountainOfYouth = true;
        this.gui.showEmigrationDialog(player, true, value -> this.emigrate(player, Europe.MigrationType.convertToMigrantSlot(value), n - 1, true));
    }

    public NationSummary getNationSummary(Player player) {
        if (player == null) {
            return null;
        }
        return this.askServer().getNationSummary(player);
    }

    public TradeRoute getNewTradeRoute(Player player) {
        if (player == null) {
            return null;
        }
        int n = player.getTradeRoutes().size();
        return this.askServer().getNewTradeRoute() && player.getTradeRoutes().size() == n + 1 ? player.getTradeRoutes().get(n) : null;
    }

    public List<AbstractUnit> getREFUnits() {
        return !this.requireOurTurn() ? Collections.emptyList() : this.askServer().getREFUnits();
    }

    public java.util.Map<String, String> getServerStatistics() {
        return this.askServer().getStatistics();
    }

    public boolean goToTile(Unit unit, Tile tile) {
        if (!this.requireOurTurn() || unit == null || !this.freeColClient.getMyPlayer().owns(unit)) {
            return false;
        }
        if (!this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, tile);
        if (ret) {
            this.moveToDestination(unit, null);
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean ignoreMessage(ModelMessage message, boolean flag) {
        String key;
        if (message == null || (key = message.getIgnoredMessageKey()) == null) {
            return false;
        }
        if (flag) {
            Turn turn = this.freeColClient.getGame().getTurn();
            if (!this.continueIgnoreMessage(key, turn)) {
                this.startIgnoringMessage(key, turn);
            }
        } else {
            this.stopIgnoringMessage(key);
        }
        return true;
    }

    public boolean indianDemand(Unit unit, Colony colony, GoodsType type, int amount) {
        boolean accepted;
        ModelMessage m;
        Player player;
        block14: {
            String nation;
            int opt;
            block13: {
                if (unit == null || colony == null) {
                    return false;
                }
                player = this.freeColClient.getMyPlayer();
                opt = this.freeColClient.getClientOptions().getInteger("model.option.indianDemandResponse");
                m = null;
                nation = Messages.message(unit.getOwner().getNationLabel());
                if (type != null) break block13;
                switch (opt) {
                    case 0: {
                        accepted = this.gui.confirm(colony.getTile(), StringTemplate.template("indianDemand.gold.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount), unit, "accept", "indianDemand.gold.no");
                        break block14;
                    }
                    case 1: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount);
                        accepted = true;
                        break block14;
                    }
                    case 2: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount);
                        accepted = false;
                        break block14;
                    }
                    default: {
                        throw new RuntimeException("Impossible option value.");
                    }
                }
            }
            switch (opt) {
                case 0: {
                    if (type.isFoodType()) {
                        accepted = this.gui.confirm(colony.getTile(), StringTemplate.template("indianDemand.food.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount), unit, "indianDemand.food.yes", "indianDemand.food.no");
                        break;
                    }
                    accepted = this.gui.confirm(colony.getTile(), StringTemplate.template("indianDemand.other.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).addNamed("%goods%", type), unit, "accept", "indianDemand.other.no");
                    break;
                }
                case 1: {
                    m = type.isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).addNamed("%goods%", type);
                    accepted = true;
                    break;
                }
                case 2: {
                    m = type.isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, (FreeColObject)unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", amount).addNamed("%goods%", type);
                    accepted = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible option value.");
                }
            }
        }
        if (m != null) {
            player.addModelMessage(m);
            this.displayModelMessages(false);
        }
        return accepted;
    }

    public boolean leaveShip(Unit unit) {
        boolean ret;
        Unit carrier;
        if (!this.requireOurTurn() || unit == null || (carrier = unit.getCarrier()) == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().disembark(unit) && unit.getLocation() != carrier;
        if (ret) {
            this.checkCashInTreasureTrain(unit);
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean loadCargo(Goods goods, Unit carrier) {
        if (!this.requireOurTurn() || goods == null || goods.getAmount() <= 0 || goods.getLocation() == null || carrier == null || !carrier.isCarrier()) {
            return false;
        }
        if (goods.getLocation() instanceof Europe) {
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        UnitWas carrierWas = new UnitWas(carrier);
        UnitWas sourceWas = null;
        ColonyWas colonyWas = null;
        if (goods.getLocation() instanceof Unit) {
            Unit source = (Unit)goods.getLocation();
            sourceWas = new UnitWas(source);
        } else {
            Colony colony = carrier.getColony();
            if (colony == null) {
                return false;
            }
            colonyWas = new ColonyWas(colony);
        }
        boolean ret = this.askLoadGoods(goods.getLocation(), goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            this.sound("sound.event.loadCargo");
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            if (sourceWas != null) {
                sourceWas.fireChanges();
            }
            carrierWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void loadGame() {
        File file = this.gui.showLoadSaveFileDialog();
        if (file == null) {
            return;
        }
        if (this.freeColClient.isInGame() && !this.gui.confirmStopGame()) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        this.turnReportMessages.clear();
        this.gui.setActiveUnit(null);
        this.gui.removeInGameComponents();
        FreeColDirectories.setSavegameFile(file.getPath());
        this.freeColClient.getConnectController().startSavedGame(file, null);
    }

    public boolean lootCargo(Unit unit, List<Goods> goods, String defenderId) {
        if (unit == null || goods == null || goods.isEmpty() || defenderId == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().loot(unit, defenderId, goods);
        if (ret) {
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void loot(Unit unit, List<Goods> goods, String defenderId) {
        this.gui.showCaptureGoodsDialog(unit, goods, gl -> this.lootCargo(unit, (List<Goods>)gl, defenderId));
    }

    public boolean monarchAction(Monarch.MonarchAction action, boolean accept) {
        if (action == null) {
            return false;
        }
        boolean ret = false;
        switch (action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: 
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                ret = this.askServer().answerMonarch(action, accept);
                break;
            }
        }
        if (ret) {
            this.updateGUI(null);
        }
        return ret;
    }

    public void monarch(Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        this.gui.showMonarchDialog(action, template, monarchKey, b -> this.monarchAction(action, (boolean)b));
    }

    public boolean moveTo(Unit unit, Location destination) {
        if (!this.requireOurTurn() || unit == null || destination == null) {
            return false;
        }
        if (destination instanceof Europe) {
            if (unit.isInEurope()) {
                this.sound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Map) {
            if (unit.hasTile() && unit.getTile().getMap() == destination) {
                this.sound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Settlement) {
            if (unit.hasTile()) {
                this.sound("sound.event.illegalMove");
                return false;
            }
        } else {
            return false;
        }
        boolean update = false;
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autoloadEmigrants") && unit.isInEurope()) {
            for (Unit u : unit.getOwner().getEurope().getUnitList()) {
                if (u.isNaval() || u.getState() != Unit.UnitState.SENTRY || !unit.canAdd(u) || !this.askEmbark(u, unit)) continue;
                update = true;
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askServer().moveTo(unit, destination);
        if (ret) {
            unitWas.fireChanges();
            update = true;
        }
        if (update) {
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean moveUnit(Unit unit, Direction direction) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || direction == null || !unit.hasTile()) {
            return false;
        }
        if (!this.askClearGotoOrders(unit)) {
            return false;
        }
        int unitCount = unit.getUnitCount();
        int goodsCount = unit.getGoodsList().size();
        Tile oldTile = unit.getTile();
        UnitWas unitWas = new UnitWas(unit);
        ColonyWas colonyWas = unit.getColony() == null ? null : new ColonyWas(unit.getColony());
        unit.setState(Unit.UnitState.ACTIVE);
        this.moveDirection(unit, direction, true);
        boolean bl = ret = unit.getTile() != oldTile || unitWas.fireChanges();
        if (ret) {
            Colony colony;
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            this.updateGUI(null);
            if (!unit.couldMove() && unit.hasTile() && (colony = unit.getTile().getColony()) != null) {
                this.colonyPanel(colony, unit);
            }
        }
        return ret;
    }

    public boolean moveTileCursor(Direction direction) {
        if (direction == null) {
            return false;
        }
        Tile tile = this.gui.getSelectedTile();
        if (tile == null) {
            return false;
        }
        Tile newTile = tile.getNeighbourOrNull(direction);
        if (newTile == null) {
            return false;
        }
        this.gui.setSelectedTile(newTile);
        return true;
    }

    public boolean nameNewLand(Unit unit, String name) {
        if (unit == null || name == null) {
            return false;
        }
        if (!this.askServer().newLandName(unit, name)) {
            return false;
        }
        Player player = unit.getOwner();
        StringTemplate t = StringTemplate.template("event.firstLanding").addName("%name%", name);
        this.gui.showEventPanel(Messages.message(t), "image.flavor.event.firstLanding", null);
        String key = FreeColActionUI.getHumanKeyStrokeText(this.freeColClient.getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
        player.addModelMessage(new ModelMessage(ModelMessage.MessageType.TUTORIAL, "buildColony.tutorial", player).addName("%colonyKey%", key).add("%colonyMenuItem%", "buildColonyAction.name").add("%ordersMenuItem%", "menuBar.orders"));
        this.displayModelMessages(false);
        return true;
    }

    public boolean nameNewRegion(Tile tile, Unit unit, Region region, String name) {
        if (tile == null || unit == null || region == null) {
            return false;
        }
        return this.askServer().newRegionName(region, tile, unit, name);
    }

    public void newLandName(String defaultName, Unit unit) {
        this.gui.showNamingDialog(StringTemplate.key("newLand.text"), defaultName, unit, name -> {
            if (name == null || name.isEmpty()) {
                name = defaultName;
            }
            this.nameNewLand(unit, (String)name);
        });
    }

    public void newRegionName(Region region, String defaultName, Tile tile, Unit unit) {
        if (region.hasName()) {
            if (region.isPacific()) {
                this.gui.showEventPanel(Messages.message("event.discoverPacific"), "image.flavor.event.discoverPacific", null);
            }
            this.nameNewRegion(tile, unit, region, defaultName);
        } else {
            this.gui.showNamingDialog(StringTemplate.template("nameRegion.text").addStringTemplate("%type%", region.getLabel()), defaultName, unit, name -> {
                if (name == null || name.isEmpty()) {
                    name = defaultName;
                }
                this.nameNewRegion(tile, unit, region, (String)name);
            });
        }
    }

    public boolean newTurn(int turn) {
        Turn currTurn;
        Game game = this.freeColClient.getGame();
        Player player = this.freeColClient.getMyPlayer();
        if (turn < 0) {
            logger.warning("Bad turn in newTurn: " + turn);
            return false;
        }
        Turn newTurn = new Turn(turn);
        game.setTurn(newTurn);
        logger.info("New turn: " + newTurn + "/" + turn);
        boolean alert = this.freeColClient.getClientOptions().getBoolean("model.option.audioAlerts");
        if (alert) {
            this.sound("sound.event.alertSound");
        }
        if ((currTurn = game.getTurn()).isFirstSeasonTurn()) {
            player.addModelMessage(new ModelMessage(ModelMessage.MessageType.WARNING, "twoTurnsPerYear", player).addStringTemplate("%year%", currTurn.getLabel()).addAmount("%amount%", currTurn.getSeasonNumber()));
        }
        return true;
    }

    public boolean nextActiveUnit() {
        if (!this.requireOurTurn()) {
            return false;
        }
        this.updateGUI(null);
        return true;
    }

    public boolean nextModelMessage() {
        return this.displayModelMessages(false, false);
    }

    public boolean payArrears(GoodsType type) {
        boolean ret;
        if (!this.requireOurTurn() || type == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            this.gui.showInformationMessage(StringTemplate.template("payArrears.noGold").addAmount("%amount%", arrears));
            return false;
        }
        StringTemplate t = StringTemplate.template("payArrears.text").addAmount("%amount%", arrears);
        if (!this.gui.confirm(null, t, type, "ok", "cancel")) {
            return false;
        }
        boolean bl = ret = this.askServer().payArrears(type) && player.canTrade(type);
        if (ret) {
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean payForBuilding(Colony colony) {
        boolean ret;
        if (!this.requireOurTurn() || colony == null) {
            return false;
        }
        if (!this.getSpecification().getBoolean("model.option.payForBuilding")) {
            this.gui.showInformationMessage("payForBuilding.disabled");
            return false;
        }
        if (!colony.canPayToFinishBuilding()) {
            this.gui.showInformationMessage("info.notEnoughGold");
            return false;
        }
        int price = colony.getPriceForBuilding();
        StringTemplate t = StringTemplate.template("payForBuilding.text").addAmount("%amount%", price);
        if (!this.gui.confirm(null, t, colony, "yes", "no")) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean bl = ret = this.askServer().payForBuilding(colony) && colony.getPriceForBuilding() == 0;
        if (ret) {
            colonyWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean putOutsideColony(Unit unit) {
        boolean ret;
        Colony colony;
        if (!this.requireOurTurn() || unit == null || (colony = unit.getColony()) == null) {
            return false;
        }
        if (!this.gui.confirmLeaveColony(unit)) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().putOutsideColony(unit) && unit.getLocation() == colony.getTile();
        if (ret) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public void reconnect() {
        if (this.gui.confirm("reconnect.text", "reconnect.no", "reconnect.yes")) {
            logger.finest("Reconnect quit.");
            this.freeColClient.quit();
        } else {
            logger.finest("Reconnect accepted.");
            this.freeColClient.getConnectController().reconnect();
        }
    }

    public boolean recruitUnitInEurope(int index) {
        if (!this.requireOurTurn() || !Europe.MigrationType.validMigrantIndex(index)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.isColonial()) {
            return false;
        }
        if (!player.checkGold(player.getRecruitPrice())) {
            this.gui.showInformationMessage("info.notEnoughGold");
            return false;
        }
        Unit newUnit = this.askEmigrate(player.getEurope(), Europe.MigrationType.migrantIndexToSlot(index));
        if (newUnit != null) {
            player.setNextActiveUnit(newUnit);
            this.gui.setActiveUnit(newUnit);
            this.updateGUI(null);
        }
        return newUnit != null;
    }

    public void remove(List<FreeColGameObject> objects, FreeColGameObject divert) {
        Player player = this.freeColClient.getMyPlayer();
        boolean visibilityChange = false;
        for (FreeColGameObject fcgo : objects) {
            if (divert != null) {
                player.divertModelMessages(fcgo, divert);
            }
            if (fcgo instanceof Settlement) {
                Settlement settlement = (Settlement)fcgo;
                if (settlement != null && settlement.getOwner() != null) {
                    settlement.getOwner().removeSettlement(settlement);
                }
                visibilityChange = true;
            } else if (fcgo instanceof Unit) {
                Unit u = (Unit)fcgo;
                if (u == this.gui.getActiveUnit()) {
                    this.gui.setActiveUnit(null);
                }
                if (u != null && u.getOwner() != null) {
                    u.getOwner().removeUnit(u);
                }
                visibilityChange = true;
            }
            fcgo.disposeResources();
        }
        if (visibilityChange) {
            player.invalidateCanSeeTiles();
        }
        this.gui.refresh();
    }

    public boolean rename(Nameable object) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(object instanceof Ownable) || !player.owns((Ownable)((Object)object))) {
            return false;
        }
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = this.gui.getInput(colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "rename", "cancel");
            if (name == null) {
                return false;
            }
            if (name.isEmpty()) {
                this.gui.showInformationMessage("info.enterSomeText");
                return false;
            }
            if (colony.getName().equals(name)) {
                return false;
            }
            if (player.getSettlementByName(name) != null) {
                this.gui.showInformationMessage((Settlement)((Colony)object), StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return false;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = this.gui.getInput(unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "rename", "cancel");
            if (name == null) {
                return false;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object);
            return false;
        }
        return this.askServer().rename((FreeColGameObject)((Object)object), name);
    }

    public boolean saveGame() {
        if (!this.freeColClient.canSaveCurrentGame()) {
            return false;
        }
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return false;
        }
        String fileName = this.getSaveGameString(game);
        File file = this.gui.showSaveDialog(FreeColDirectories.getSaveDirectory(), fileName);
        if (file == null) {
            return false;
        }
        boolean confirm = this.freeColClient.getClientOptions().getBoolean("model.option.confirmSaveOverwrite");
        if (!confirm || !file.exists() || this.gui.confirm("saveConfirmationDialog.areYouSure.text", "ok", "cancel")) {
            FreeColDirectories.setSavegameFile(file.getPath());
            return this.saveGame(file);
        }
        return false;
    }

    public boolean selectDestination(Unit unit) {
        if (!this.requireOurTurn() || unit == null) {
            return false;
        }
        if (!this.gui.confirmClearTradeRoute(unit)) {
            return false;
        }
        Location destination = this.gui.showSelectDestinationDialog(unit);
        if (destination == null) {
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        boolean ret = this.askSetDestination(unit, destination);
        if (ret) {
            if (destination instanceof Europe) {
                if (unit.hasTile() && unit.getTile().isDirectlyHighSeasConnected()) {
                    this.moveTo(unit, destination);
                } else {
                    this.moveToDestination(unit, null);
                }
            } else if (unit.isInEurope()) {
                this.moveTo(unit, destination);
            } else {
                this.moveToDestination(unit, null);
            }
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean sellGoods(Goods goods) {
        if (!this.requireOurTurn() || goods == null || !(goods.getLocation() instanceof Unit)) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit carrier = (Unit)goods.getLocation();
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            this.sound("sound.event.sellCargo");
            europeWas.fireChanges();
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean sendChat(String chat) {
        if (chat == null) {
            return false;
        }
        return this.askServer().chat(this.freeColClient.getMyPlayer(), chat);
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (!this.requireOurTurn() || colony == null || buildQueue == null) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        boolean ret = this.askServer().setBuildQueue(colony, buildQueue);
        if (ret) {
            colonyWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean setCurrentPlayer(Player player) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && this.freeColClient.currentPlayerIsMyPlayer()) {
            this.gui.closeMenus();
        }
        FreeColDebugger.finishDebugRun(this.freeColClient, false);
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(player);
        if (this.freeColClient.getMyPlayer().equals(player)) {
            if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.DESYNC) && DebugUtils.checkDesyncAction(this.freeColClient)) {
                this.freeColClient.getConnectController().reconnect();
                return false;
            }
            if (this.freeColClient.getFreeColServer() != null && game.getTurn().getNumber() > 0) {
                this.autoSaveGame();
            }
            player.removeDisplayedModelMessages();
            this.displayModelMessages(true, true);
            player.invalidateCanSeeTiles();
            Europe europe = player.getEurope();
            if (player.hasAbility("model.ability.selectRecruit")) {
                this.emigration(player, 0, false);
            } else {
                while (player.checkEmigrate()) {
                    this.askEmigrate(europe, Europe.MigrationType.getUnspecificSlot());
                }
            }
            if (!this.freeColClient.isSinglePlayer()) {
                this.sound("sound.anthem." + player.getNationId());
            }
            player.resetIterators();
            this.updateGUI(player.getFallbackTile());
        }
        return true;
    }

    public boolean setDead(Player dead) {
        if (dead == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (player == dead) {
            FreeColDebugger.finishDebugRun(this.freeColClient, true);
            if (this.freeColClient.isSinglePlayer()) {
                if (player.getPlayerType() != Player.PlayerType.RETIRED) {
                    if (player.getPlayerType() != Player.PlayerType.UNDEAD && this.gui.confirm("defeatedSinglePlayer.text", "defeatedSinglePlayer.yes", "quit")) {
                        this.freeColClient.askServer().enterRevengeMode();
                    } else {
                        this.freeColClient.quit();
                    }
                }
            } else if (!this.gui.confirm("defeated.text", "defeated.yes", "quit")) {
                this.freeColClient.quit();
            }
        } else {
            player.setStance(dead, null);
        }
        return true;
    }

    public void setGameConnected() {
        Player player = this.freeColClient.getMyPlayer();
        if (player != null) {
            player.refilterModelMessages(this.freeColClient.getClientOptions());
        }
    }

    public boolean setGoodsLevels(Colony colony, GoodsType goodsType) {
        if (colony == null || goodsType == null) {
            return false;
        }
        return this.askServer().setGoodsLevels(colony, colony.getExportData(goodsType));
    }

    public boolean setInDebugMode() {
        FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
        this.updateGUI(null);
        return true;
    }

    public boolean setStance(Stance stance, Player first, Player second) {
        if (stance == null || first == null || second == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        Stance old = first.getStance(second);
        try {
            first.setStance(second, stance);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Illegal stance transition", e);
            return false;
        }
        if (player == first && old == Stance.UNCONTACTED) {
            this.sound("sound.event.meet." + second.getNationId());
        }
        return true;
    }

    public boolean setTradeRoutes(List<TradeRoute> routes) {
        if (routes == null) {
            return false;
        }
        return this.askServer().setTradeRoutes(routes);
    }

    public void spyColony(Tile tile, Runnable recover) {
        this.gui.showSpyColonyPanel(tile, recover);
    }

    public boolean trainUnitInEurope(UnitType unitType) {
        boolean ret;
        Europe europe;
        if (!this.requireOurTurn() || unitType == null) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            this.gui.showInformationMessage("info.notEnoughGold");
            return false;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        Unit newUnit = null;
        boolean bl = ret = this.askServer().trainUnitInEurope(unitType) && (newUnit = europeWas.getNewUnit()) != null;
        if (ret) {
            europeWas.fireChanges();
            player.setNextActiveUnit(newUnit);
            this.gui.setActiveUnit(newUnit);
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean unload(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.isCarrier()) {
            return false;
        }
        boolean ret = true;
        Colony colony = unit.getColony();
        if (colony != null) {
            for (Unit u : unit.getUnitList()) {
                ret = this.leaveShip(u) && ret;
            }
            for (Goods goods : unit.getGoodsList()) {
                ret = this.unloadCargo(goods, false) && ret;
            }
        } else if (unit.isInEurope()) {
            Player player = this.freeColClient.getMyPlayer();
            for (Goods goods : unit.getCompactGoodsList()) {
                if (!player.canTrade(goods.getType())) continue;
                ret = this.sellGoods(goods) && ret;
            }
            if (unit.hasGoodsCargo()) {
                this.gui.showDumpCargoDialog(unit, goodsList -> {
                    for (Goods g : goodsList) {
                        this.unloadCargo(g, true);
                    }
                });
                return false;
            }
        } else {
            for (Goods goods : unit.getGoodsList()) {
                ret = this.unloadCargo(goods, false) && ret;
            }
        }
        return ret;
    }

    public boolean unloadCargo(Goods goods, boolean dump) {
        if (!this.requireOurTurn() || goods == null || goods.getAmount() <= 0 || !(goods.getLocation() instanceof Unit)) {
            return false;
        }
        Unit carrier = (Unit)goods.getLocation();
        if (carrier.isInEurope()) {
            return this.sellGoods(goods);
        }
        Colony colony = carrier.getColony();
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        boolean ret = this.askUnloadGoods(goods.getType(), goods.getAmount(), carrier);
        if (ret) {
            if (!dump) {
                this.sound("sound.event.unloadCargo");
            }
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    public boolean updateTradeRoute(TradeRoute route) {
        if (route == null) {
            return false;
        }
        return this.askServer().updateTradeRoute(route);
    }

    public void victory(String score) {
        this.displayHighScores("true".equalsIgnoreCase(score));
        this.gui.showVictoryDialog(result -> this.victory((Boolean)result));
    }

    public boolean victory(Boolean quit) {
        if (quit.booleanValue()) {
            this.freeColClient.newGame(false);
        } else {
            this.askServer().continuePlaying();
        }
        return true;
    }

    public boolean waitUnit() {
        if (!this.requireOurTurn()) {
            return false;
        }
        this.gui.setActiveUnit(null);
        this.updateGUI(null);
        return true;
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        boolean ret;
        if (!this.requireOurTurn() || unit == null || workLocation == null) {
            return false;
        }
        if (unit.getStudent() != null && !this.gui.confirmAbandonEducation(unit, false)) {
            return false;
        }
        Colony colony = workLocation.getColony();
        if (workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)workLocation).getWorkTile();
            if (tile.hasLostCityRumour()) {
                this.gui.showInformationMessage("tileHasRumour");
                return false;
            }
            if (!unit.getOwner().owns(tile) && !this.claimTile(tile, colony)) {
                return false;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        boolean bl = ret = this.askServer().work(unit, workLocation) && unit.getLocation() == workLocation;
        if (ret) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
            this.updateGUI(null);
        }
        return ret;
    }

    private static enum MoveMode {
        NEXT_ACTIVE_UNIT,
        EXECUTE_GOTO_ORDERS,
        END_TURN;


        public MoveMode maximize(MoveMode m) {
            return this.ordinal() < m.ordinal() ? m : this;
        }
    }

    public static enum TradeAction {
        BUY,
        SELL,
        GIFT;

    }

    public static enum SellAction {
        SELL,
        HAGGLE,
        GIFT;

    }

    public static enum ScoutIndianSettlementAction {
        INDIAN_SETTLEMENT_SPEAK,
        INDIAN_SETTLEMENT_TRIBUTE,
        INDIAN_SETTLEMENT_ATTACK;

    }

    public static enum ScoutColonyAction {
        FOREIGN_COLONY_NEGOTIATE,
        FOREIGN_COLONY_SPY,
        FOREIGN_COLONY_ATTACK;

    }

    public static enum MissionaryAction {
        ESTABLISH_MISSION,
        DENOUNCE_HERESY,
        INCITE_INDIANS;

    }

    public static enum ClaimAction {
        ACCEPT,
        STEAL;

    }

    public static enum BuyAction {
        BUY,
        HAGGLE;

    }

    public static enum BoycottAction {
        PAY_ARREARS,
        DUMP_CARGO;

    }

    public static enum ArmedUnitSettlementAction {
        SETTLEMENT_ATTACK,
        SETTLEMENT_TRIBUTE;

    }
}

