/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "transaction.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_TRANSACTION_TRANSACTION_H
#define AB_TRANSACTION_TRANSACTION_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_TRANSACTION Structure AB_TRANSACTION
<p>This page describes the properties of AB_TRANSACTION.</p>



<h1>AB_TRANSACTION</h1>

This type contains all important information about transactions. All text fields are in UTF-8.


@anchor AB_TRANSACTION_memo
<h2>memo</h2>

User-defined memo.
<p>Set this property with @ref AB_Transaction_SetMemo(), get it with @ref AB_Transaction_GetMemo().</p>


@anchor AB_TRANSACTION_hash
<h2>hash</h2>

<p>Set this property with @ref AB_Transaction_SetHash(), get it with @ref AB_Transaction_GetHash().</p>


<h2>Type, Command, Status</h2>



@anchor AB_TRANSACTION_type
<h3>type</h3>

<p>Set this property with @ref AB_Transaction_SetType(), get it with @ref AB_Transaction_GetType().</p>


@anchor AB_TRANSACTION_subType
<h3>subType</h3>

<p>Set this property with @ref AB_Transaction_SetSubType(), get it with @ref AB_Transaction_GetSubType().</p>


@anchor AB_TRANSACTION_command
<h3>command</h3>

<p>Set this property with @ref AB_Transaction_SetCommand(), get it with @ref AB_Transaction_GetCommand().</p>


@anchor AB_TRANSACTION_status
<h3>status</h3>

<p>Set this property with @ref AB_Transaction_SetStatus(), get it with @ref AB_Transaction_GetStatus().</p>


@anchor AB_TRANSACTION_uniqueAccountId
<h3>uniqueAccountId</h3>

This is a unique id of the local account for banking commands.
<p>Set this property with @ref AB_Transaction_SetUniqueAccountId(), get it with @ref AB_Transaction_GetUniqueAccountId().</p>


<h2>Identifiers</h2>



@anchor AB_TRANSACTION_uniqueId
<h3>uniqueId</h3>

This is a unique id assigned by the application. However, when adding a transaction to a job (like JobTransfer) this id is assigned by AqBanking to make sure that this id is unique across all applications.
<p>Set this property with @ref AB_Transaction_SetUniqueId(), get it with @ref AB_Transaction_GetUniqueId().</p>


@anchor AB_TRANSACTION_refUniqueId
<h3>refUniqueId</h3>

This id is used in splits to refer to the transaction id the split belongs to. It is also used internally by backends when on job is linked to another one.
<p>Set this property with @ref AB_Transaction_SetRefUniqueId(), get it with @ref AB_Transaction_GetRefUniqueId().</p>


@anchor AB_TRANSACTION_idForApplication
<h3>idForApplication</h3>

This is an id assigned by the application only. This id is never changed by AqBanking.
<p>Set this property with @ref AB_Transaction_SetIdForApplication(), get it with @ref AB_Transaction_GetIdForApplication().</p>


@anchor AB_TRANSACTION_stringIdForApplication
<h3>stringIdForApplication</h3>

This is an id assigned by the application only. This id is never changed by AqBanking.
<p>Set this property with @ref AB_Transaction_SetStringIdForApplication(), get it with @ref AB_Transaction_GetStringIdForApplication().</p>


@anchor AB_TRANSACTION_sessionId
<h3>sessionId</h3>

This id can be used by applications, e.g. to group jobs into sessions.
<p>Set this property with @ref AB_Transaction_SetSessionId(), get it with @ref AB_Transaction_GetSessionId().</p>


@anchor AB_TRANSACTION_groupId
<h3>groupId</h3>

This id is assigned by a backend when sending multiple transfer jobs in one backend request (e.g. AqHBCI uses DTAUS files when sending multi-transfer requests; in this case every transfer which goes into the same DTAUS file receives the same group id).
<p>Set this property with @ref AB_Transaction_SetGroupId(), get it with @ref AB_Transaction_GetGroupId().</p>


@anchor AB_TRANSACTION_fiId
<h3>fiId</h3>

<p>This id is assigned by the bank. As for the moment only OFX servers actually do assign unique ids to statements.</p>

<p>However, HBCI servers at least assign unique ids to standing orders and dated transfers.</p>

<p>Set this property with @ref AB_Transaction_SetFiId(), get it with @ref AB_Transaction_GetFiId().</p>


<h2>Local Account Specification</h2>

<p>Properties of this group specify the local account to be used for this transaction.</p>

<p>Accounts are usually specified in one of two ways:</p>

<ul>
<li>SEPA: IBAN and BIC</li>
<li>non-SEPA: Bank account and Account number</li>
</ul>



@anchor AB_TRANSACTION_localName
<h3>localName</h3>

<p>Set this property with @ref AB_Transaction_SetLocalName(), get it with @ref AB_Transaction_GetLocalName().</p>


<h3>SEPA</h3>



@anchor AB_TRANSACTION_localIban
<h4>localIban</h4>

<p>Set this property with @ref AB_Transaction_SetLocalIban(), get it with @ref AB_Transaction_GetLocalIban().</p>


@anchor AB_TRANSACTION_localBic
<h4>localBic</h4>

<p>Set this property with @ref AB_Transaction_SetLocalBic(), get it with @ref AB_Transaction_GetLocalBic().</p>


<h3>Non-SEPA</h3>



@anchor AB_TRANSACTION_localCountry
<h4>localCountry</h4>

<p>Set this property with @ref AB_Transaction_SetLocalCountry(), get it with @ref AB_Transaction_GetLocalCountry().</p>


@anchor AB_TRANSACTION_localBankCode
<h4>localBankCode</h4>

<p>Set this property with @ref AB_Transaction_SetLocalBankCode(), get it with @ref AB_Transaction_GetLocalBankCode().</p>


@anchor AB_TRANSACTION_localBranchId
<h4>localBranchId</h4>

This is the branch id of the local bank (OFX only)
<p>Set this property with @ref AB_Transaction_SetLocalBranchId(), get it with @ref AB_Transaction_GetLocalBranchId().</p>


@anchor AB_TRANSACTION_localAccountNumber
<h4>localAccountNumber</h4>

<p>Set this property with @ref AB_Transaction_SetLocalAccountNumber(), get it with @ref AB_Transaction_GetLocalAccountNumber().</p>


@anchor AB_TRANSACTION_localSuffix
<h4>localSuffix</h4>

If your account has subaccounts which are distinguished by different suffixes, then this is that suffix. Otherwise it's empty. (HBCI only)
<p>Set this property with @ref AB_Transaction_SetLocalSuffix(), get it with @ref AB_Transaction_GetLocalSuffix().</p>


<h2>Remote Account Specification</h2>

<p>Properties of this group specify the remote account to be used for this transaction.</p>



@anchor AB_TRANSACTION_remoteCountry
<h3>remoteCountry</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteCountry(), get it with @ref AB_Transaction_GetRemoteCountry().</p>


@anchor AB_TRANSACTION_remoteBankCode
<h3>remoteBankCode</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteBankCode(), get it with @ref AB_Transaction_GetRemoteBankCode().</p>


@anchor AB_TRANSACTION_remoteBranchId
<h3>remoteBranchId</h3>

This is the branch id of the remote bank (OFX only)
<p>Set this property with @ref AB_Transaction_SetRemoteBranchId(), get it with @ref AB_Transaction_GetRemoteBranchId().</p>


@anchor AB_TRANSACTION_remoteAccountNumber
<h3>remoteAccountNumber</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteAccountNumber(), get it with @ref AB_Transaction_GetRemoteAccountNumber().</p>


@anchor AB_TRANSACTION_remoteSuffix
<h3>remoteSuffix</h3>

Same as localSuffix, except for remote account (HBCI only).
<p>Set this property with @ref AB_Transaction_SetRemoteSuffix(), get it with @ref AB_Transaction_GetRemoteSuffix().</p>


@anchor AB_TRANSACTION_remoteIban
<h3>remoteIban</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteIban(), get it with @ref AB_Transaction_GetRemoteIban().</p>


@anchor AB_TRANSACTION_remoteBic
<h3>remoteBic</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteBic(), get it with @ref AB_Transaction_GetRemoteBic().</p>


@anchor AB_TRANSACTION_remoteName
<h3>remoteName</h3>

<p>Set this property with @ref AB_Transaction_SetRemoteName(), get it with @ref AB_Transaction_GetRemoteName().</p>


<h2>Dates</h2>



@anchor AB_TRANSACTION_date
<h3>date</h3>

<p>Set this property with @ref AB_Transaction_SetDate(), get it with @ref AB_Transaction_GetDate().</p>


@anchor AB_TRANSACTION_valutaDate
<h3>valutaDate</h3>

<p>Set this property with @ref AB_Transaction_SetValutaDate(), get it with @ref AB_Transaction_GetValutaDate().</p>


<h2>Amount</h2>



@anchor AB_TRANSACTION_value
<h3>value</h3>

<p>Set this property with @ref AB_Transaction_SetValue(), get it with @ref AB_Transaction_GetValue().</p>


@anchor AB_TRANSACTION_fees
<h3>fees</h3>

<p>Set this property with @ref AB_Transaction_SetFees(), get it with @ref AB_Transaction_GetFees().</p>


<h2>Info Texts and Codes</h2>



@anchor AB_TRANSACTION_transactionCode
<h3>transactionCode</h3>

A 3 digit numerical transaction code, defined for all kinds of different actions. (Geschaeftsvorfallcode)
<p>Set this property with @ref AB_Transaction_SetTransactionCode(), get it with @ref AB_Transaction_GetTransactionCode().</p>


@anchor AB_TRANSACTION_transactionText
<h3>transactionText</h3>

Transaction text (e.g. STANDING ORDER) (Buchungstext)
<p>Set this property with @ref AB_Transaction_SetTransactionText(), get it with @ref AB_Transaction_GetTransactionText().</p>


@anchor AB_TRANSACTION_transactionKey
<h3>transactionKey</h3>

this is the transaction id that tells you more about the type of transaction (3 character code) (Buchungsschluessel) (HBCI only)
<p>Set this property with @ref AB_Transaction_SetTransactionKey(), get it with @ref AB_Transaction_GetTransactionKey().</p>


@anchor AB_TRANSACTION_textKey
<h3>textKey</h3>

<p>A numerical transaction code, defined for all kinds of different actions. (Textschluessel)</p>

<p>For a normal transfer you should set it to 51. For debit notes the values 04 or 05 may be used. For other values please refer to your credit institute. (HBCI only)</p>

<p>Set this property with @ref AB_Transaction_SetTextKey(), get it with @ref AB_Transaction_GetTextKey().</p>


@anchor AB_TRANSACTION_primanota
<h3>primanota</h3>

Used for SEPA transfers.
<p>Set this property with @ref AB_Transaction_SetPrimanota(), get it with @ref AB_Transaction_GetPrimanota().</p>


@anchor AB_TRANSACTION_purpose
<h3>purpose</h3>

A list of purpose lines, separated by newline characters.
<p>Set this property with @ref AB_Transaction_SetPurpose(), get it with @ref AB_Transaction_GetPurpose().</p>


@anchor AB_TRANSACTION_category
<h3>category</h3>

A list of categories assigned to this transaction, separated by newline characters.
<p>Set this property with @ref AB_Transaction_SetCategory(), get it with @ref AB_Transaction_GetCategory().</p>


<h2>References</h2>



@anchor AB_TRANSACTION_customerReference
<h3>customerReference</h3>

Reference string, if the customer (you) has specified one. (E.g. the cheque number.) Otherwise "NONREF" or empty (Kundenreferenz)
<p>Set this property with @ref AB_Transaction_SetCustomerReference(), get it with @ref AB_Transaction_GetCustomerReference().</p>


@anchor AB_TRANSACTION_bankReference
<h3>bankReference</h3>

Reference string for this transaction given by the bank, if it has given one. Otherwise empty. (Bankreferenz)
<p>Set this property with @ref AB_Transaction_SetBankReference(), get it with @ref AB_Transaction_GetBankReference().</p>


<h2>Additional Data for SEPA Transactions</h2>

<p>These properties are only used in SEPA statements or transactions.</p>



@anchor AB_TRANSACTION_endToEndReference
<h3>endToEndReference</h3>

This is a reference provided by the issuer of a SEPA transfer.
<p>Set this property with @ref AB_Transaction_SetEndToEndReference(), get it with @ref AB_Transaction_GetEndToEndReference().</p>


@anchor AB_TRANSACTION_ultimateCreditor
<h3>ultimateCreditor</h3>

"Abweichender Empfaenger" (ABWE+).
<p>Set this property with @ref AB_Transaction_SetUltimateCreditor(), get it with @ref AB_Transaction_GetUltimateCreditor().</p>


@anchor AB_TRANSACTION_ultimateDebtor
<h3>ultimateDebtor</h3>

"Abweichender Auftraggeber" (ABWA+).
<p>Set this property with @ref AB_Transaction_SetUltimateDebtor(), get it with @ref AB_Transaction_GetUltimateDebtor().</p>


@anchor AB_TRANSACTION_charge
<h3>charge</h3>

<p>Set this property with @ref AB_Transaction_SetCharge(), get it with @ref AB_Transaction_GetCharge().</p>


<h3>Additional Data for SEPA Debit Notes</h3>

<p>These properties are only used in SEPA statements or transactions.</p>



@anchor AB_TRANSACTION_creditorSchemeId
<h4>creditorSchemeId</h4>

Creditor Scheme Identification" ("Glaeubiger-ID", assigned by Deutsche Bundesbank).
<p>Set this property with @ref AB_Transaction_SetCreditorSchemeId(), get it with @ref AB_Transaction_GetCreditorSchemeId().</p>


@anchor AB_TRANSACTION_originatorId
<h4>originatorId</h4>

<p>Set this property with @ref AB_Transaction_SetOriginatorId(), get it with @ref AB_Transaction_GetOriginatorId().</p>


@anchor AB_TRANSACTION_mandateId
<h4>mandateId</h4>

SEPA Direct debit mandate id.
<p>Set this property with @ref AB_Transaction_SetMandateId(), get it with @ref AB_Transaction_GetMandateId().</p>


@anchor AB_TRANSACTION_mandateDate
<h4>mandateDate</h4>

Issue date of the direct debit mandate.
<p>Set this property with @ref AB_Transaction_SetMandateDate(), get it with @ref AB_Transaction_GetMandateDate().</p>


@anchor AB_TRANSACTION_mandateDebitorName
<h4>mandateDebitorName</h4>

Debitor name for direct debit mandate if given by the debitor.
<p>Set this property with @ref AB_Transaction_SetMandateDebitorName(), get it with @ref AB_Transaction_GetMandateDebitorName().</p>


@anchor AB_TRANSACTION_originalCreditorSchemeId
<h4>originalCreditorSchemeId</h4>

Original value for "Creditor Scheme Identification", in case that value changed over time.
<p>Set this property with @ref AB_Transaction_SetOriginalCreditorSchemeId(), get it with @ref AB_Transaction_GetOriginalCreditorSchemeId().</p>


@anchor AB_TRANSACTION_originalMandateId
<h4>originalMandateId</h4>

Original SEPA Direct debit mandate id, in case that changed over time.
<p>Set this property with @ref AB_Transaction_SetOriginalMandateId(), get it with @ref AB_Transaction_GetOriginalMandateId().</p>


@anchor AB_TRANSACTION_originalCreditorName
<h4>originalCreditorName</h4>

Original SEPA Direct debit creditor name, in case that changed over time.
<p>Set this property with @ref AB_Transaction_SetOriginalCreditorName(), get it with @ref AB_Transaction_GetOriginalCreditorName().</p>


@anchor AB_TRANSACTION_sequence
<h4>sequence</h4>

<p>Set this property with @ref AB_Transaction_SetSequence(), get it with @ref AB_Transaction_GetSequence().</p>


<h2>Additional Information for Foreign Transfers</h2>

<p>This group contains information which is used with transfers to other countries in the world. It is used by backends and applications but not by AqBanking itself.</p>



@anchor AB_TRANSACTION_remoteAddrStreet
<h3>remoteAddrStreet</h3>

Street and number.
<p>Set this property with @ref AB_Transaction_SetRemoteAddrStreet(), get it with @ref AB_Transaction_GetRemoteAddrStreet().</p>


@anchor AB_TRANSACTION_remoteAddrZipcode
<h3>remoteAddrZipcode</h3>

Zipcode.
<p>Set this property with @ref AB_Transaction_SetRemoteAddrZipcode(), get it with @ref AB_Transaction_GetRemoteAddrZipcode().</p>


@anchor AB_TRANSACTION_remoteAddrCity
<h3>remoteAddrCity</h3>

City.
<p>Set this property with @ref AB_Transaction_SetRemoteAddrCity(), get it with @ref AB_Transaction_GetRemoteAddrCity().</p>


@anchor AB_TRANSACTION_remoteAddrPhone
<h3>remoteAddrPhone</h3>

Phone number.
<p>Set this property with @ref AB_Transaction_SetRemoteAddrPhone(), get it with @ref AB_Transaction_GetRemoteAddrPhone().</p>


<h2>Additional Data for Standing Orders</h2>

<p>These properties are used with standing orders, i.e. orders which are regularily repeated by the bank.</p>



@anchor AB_TRANSACTION_period
<h3>period</h3>

<p>Set this property with @ref AB_Transaction_SetPeriod(), get it with @ref AB_Transaction_GetPeriod().</p>


@anchor AB_TRANSACTION_cycle
<h3>cycle</h3>

The standing order is executed every
<i>cycle</i>

x
<i>period</i>

. So if
<i>period</i>

is
<i>weekly</i>

and
<i>cycle</i>

is
<i>2</i>

then the standing order is executed every 2 weeks.
<p>Set this property with @ref AB_Transaction_SetCycle(), get it with @ref AB_Transaction_GetCycle().</p>


@anchor AB_TRANSACTION_executionDay
<h3>executionDay</h3>

The execution day. The meaning of this variable depends on the content of
<i>period</i>

:
<ul>
<li>
monthly: day of the month (starting with<i>1</i>
)</li>
<li>
weekly: day of the week (starting with<i>1</i>
=Monday)</li>
</ul>

<p>Set this property with @ref AB_Transaction_SetExecutionDay(), get it with @ref AB_Transaction_GetExecutionDay().</p>


@anchor AB_TRANSACTION_firstDate
<h3>firstDate</h3>

For standing orders this is the first date the transaction is to be executed. For jobs which use date span parameters this is the first date (e.g. "get statements from FIRSTDATE to LASTDATE)"
<p>Set this property with @ref AB_Transaction_SetFirstDate(), get it with @ref AB_Transaction_GetFirstDate().</p>


@anchor AB_TRANSACTION_lastDate
<h3>lastDate</h3>

For standing orders this is the last date the transaction is to be executed. For jobs which use date span parameters this is the last date (e.g. "get statements from FIRSTDATE to LASTDATE)"
<p>Set this property with @ref AB_Transaction_SetLastDate(), get it with @ref AB_Transaction_GetLastDate().</p>


@anchor AB_TRANSACTION_nextDate
<h3>nextDate</h3>

For standing orders this is the next date the transaction is executed.
<p>Set this property with @ref AB_Transaction_SetNextDate(), get it with @ref AB_Transaction_GetNextDate().</p>


<h2>Additional Data for Securites</h2>

<p>These properties are used with securities.</p>



@anchor AB_TRANSACTION_unitId
<h3>unitId</h3>

Unique id of the security within the namespace. This field is also used with accounts.
<p>Set this property with @ref AB_Transaction_SetUnitId(), get it with @ref AB_Transaction_GetUnitId().</p>


@anchor AB_TRANSACTION_unitIdNameSpace
<h3>unitIdNameSpace</h3>

Namespace for name (e.g. CUSIP for North America)
<p>Set this property with @ref AB_Transaction_SetUnitIdNameSpace(), get it with @ref AB_Transaction_GetUnitIdNameSpace().</p>


@anchor AB_TRANSACTION_tickerSymbol
<h3>tickerSymbol</h3>

Unique id of the security within the namespace.
<p>Set this property with @ref AB_Transaction_SetTickerSymbol(), get it with @ref AB_Transaction_GetTickerSymbol().</p>


@anchor AB_TRANSACTION_units
<h3>units</h3>

<p>Set this property with @ref AB_Transaction_SetUnits(), get it with @ref AB_Transaction_GetUnits().</p>


@anchor AB_TRANSACTION_unitPriceValue
<h3>unitPriceValue</h3>

<p>Set this property with @ref AB_Transaction_SetUnitPriceValue(), get it with @ref AB_Transaction_GetUnitPriceValue().</p>


@anchor AB_TRANSACTION_unitPriceDate
<h3>unitPriceDate</h3>

Date of the unit price.
<p>Set this property with @ref AB_Transaction_SetUnitPriceDate(), get it with @ref AB_Transaction_GetUnitPriceDate().</p>


@anchor AB_TRANSACTION_commissionValue
<h3>commissionValue</h3>

<p>Set this property with @ref AB_Transaction_SetCommissionValue(), get it with @ref AB_Transaction_GetCommissionValue().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/list2.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <aqbanking/types/value.h>
#include <gwenhywfar/gwendate.h>
#include <gwenhywfar/mdigest.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/debug.h>

typedef struct AB_TRANSACTION AB_TRANSACTION;
GWEN_LIST_FUNCTION_LIB_DEFS(AB_TRANSACTION, AB_Transaction, AQBANKING_API)
GWEN_LIST2_FUNCTION_LIB_DEFS(AB_TRANSACTION, AB_Transaction, AQBANKING_API)
GWEN_CONSTLIST2_FUNCTION_LIB_DEFS(AB_TRANSACTION, AB_Transaction, AQBANKING_API)



typedef enum {
  AB_Transaction_TypeUnknown = -1,
  AB_Transaction_TypeNone = 0,
  AB_Transaction_TypeStatement = 128,
  AB_Transaction_TypeNotedStatement,
  AB_Transaction_TypeTransfer = 256,
  AB_Transaction_TypeDebitNote,
  AB_Transaction_TypeStandingOrder,
  AB_Transaction_TypeInternalTransfer,
  AB_Transaction_TypeTransaction = 2048,
  AB_Transaction_TypeSplit
} AB_TRANSACTION_TYPE;


typedef enum {
  AB_Transaction_SubTypeUnknown = -1,
  AB_Transaction_SubTypeNone = 0,
  AB_Transaction_SubTypeStandard,
  AB_Transaction_SubTypeCheck,
  AB_Transaction_SubTypeBookedDebitNote,
  AB_Transaction_SubTypeDrawnDebitNote,
  AB_Transaction_SubTypeStandingOrder,
  AB_Transaction_SubTypeLoan,
  AB_Transaction_SubTypeEuStandard,
  AB_Transaction_SubTypeEuASAP,
  AB_Transaction_SubTypeBuy,
  AB_Transaction_SubTypeSell,
  AB_Transaction_SubTypeReinvest,
  AB_Transaction_SubTypeDividend
} AB_TRANSACTION_SUBTYPE;


typedef enum {
  AB_Transaction_CommandUnknown = -1,
  AB_Transaction_CommandNone = 0,
  AB_Transaction_CommandGetBalance,
  AB_Transaction_CommandGetTransactions,
  AB_Transaction_CommandGetStandingOrders,
  AB_Transaction_CommandGetDatedTransfers,
  AB_Transaction_CommandSepaGetStandingOrders,
  AB_Transaction_CommandLoadCellPhone,
  AB_Transaction_CommandGetEStatements,
  AB_Transaction_CommandTransfer = 512,
  AB_Transaction_CommandDebitNote,
  AB_Transaction_CommandCreateStandingOrder,
  AB_Transaction_CommandModifyStandingOrder,
  AB_Transaction_CommandDeleteStandingOrder,
  AB_Transaction_CommandCreateDatedTransfer,
  AB_Transaction_CommandModifyDatedTransfer,
  AB_Transaction_CommandDeleteDatedTransfer,
  AB_Transaction_CommandInternalTransfer,
  AB_Transaction_CommandSepaTransfer = 1536,
  AB_Transaction_CommandSepaDebitNote,
  AB_Transaction_CommandSepaFlashDebitNote,
  AB_Transaction_CommandSepaCreateStandingOrder,
  AB_Transaction_CommandSepaModifyStandingOrder,
  AB_Transaction_CommandSepaDeleteStandingOrder,
  AB_Transaction_CommandSepaCreateDatedTransfer,
  AB_Transaction_CommandSepaModifyDatedTransfer,
  AB_Transaction_CommandSepaDeleteDatedTransfer,
  AB_Transaction_CommandSepaInternalTransfer
} AB_TRANSACTION_COMMAND;


typedef enum {
  AB_Transaction_StatusUnknown = -1,
  AB_Transaction_StatusNone = 0,
  AB_Transaction_StatusEnqueued,
  AB_Transaction_StatusSending,
  AB_Transaction_StatusSent,
  AB_Transaction_StatusAccepted,
  AB_Transaction_StatusRejected,
  AB_Transaction_StatusPending,
  AB_Transaction_StatusAutoReconciled,
  AB_Transaction_StatusManuallyReconciled,
  AB_Transaction_StatusRevoked,
  AB_Transaction_StatusAborted,
  AB_Transaction_StatusError
} AB_TRANSACTION_STATUS;


typedef enum {
  AB_Transaction_PeriodUnknown = -1,
  AB_Transaction_PeriodNone = 0,
  AB_Transaction_PeriodMonthly,
  AB_Transaction_PeriodWeekly
} AB_TRANSACTION_PERIOD;


typedef enum {
  AB_Transaction_ChargeUnknown = -1,
  AB_Transaction_ChargeNobody = 0,
  AB_Transaction_ChargeLocal,
  AB_Transaction_ChargeRemote,
  AB_Transaction_ChargeShare
} AB_TRANSACTION_CHARGE;


typedef enum {
  AB_Transaction_SequenceUnknown = -1,
  AB_Transaction_SequenceOnce = 0,
  AB_Transaction_SequenceFirst,
  AB_Transaction_SequenceFollowing,
  AB_Transaction_SequenceFinal
} AB_TRANSACTION_SEQUENCE;


/* post-headers */


AQBANKING_API AB_TRANSACTION_TYPE AB_Transaction_Type_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_SUBTYPE AB_Transaction_SubType_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_COMMAND AB_Transaction_Command_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_STATUS AB_Transaction_Status_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_PERIOD AB_Transaction_Period_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_CHARGE AB_Transaction_Charge_fromString(const char *p_s);

AQBANKING_API AB_TRANSACTION_SEQUENCE AB_Transaction_Sequence_fromString(const char *p_s);

AQBANKING_API const char *AB_Transaction_Type_toString(AB_TRANSACTION_TYPE p_i);

AQBANKING_API const char *AB_Transaction_SubType_toString(AB_TRANSACTION_SUBTYPE p_i);

AQBANKING_API const char *AB_Transaction_Command_toString(AB_TRANSACTION_COMMAND p_i);

AQBANKING_API const char *AB_Transaction_Status_toString(AB_TRANSACTION_STATUS p_i);

AQBANKING_API const char *AB_Transaction_Period_toString(AB_TRANSACTION_PERIOD p_i);

AQBANKING_API const char *AB_Transaction_Charge_toString(AB_TRANSACTION_CHARGE p_i);

AQBANKING_API const char *AB_Transaction_Sequence_toString(AB_TRANSACTION_SEQUENCE p_i);

/** Constructor. */
AQBANKING_API AB_TRANSACTION *AB_Transaction_new(void);

/** Destructor. */
AQBANKING_API void AB_Transaction_free(AB_TRANSACTION *p_struct);

AQBANKING_API void AB_Transaction_Attach(AB_TRANSACTION *p_struct);

AQBANKING_API AB_TRANSACTION *AB_Transaction_dup(const AB_TRANSACTION *p_struct);

AQBANKING_API AB_TRANSACTION *AB_Transaction_copy(AB_TRANSACTION *p_struct, const AB_TRANSACTION *p_src);

/** Getter.
 * Use this function to get the member "type" (see @ref AB_TRANSACTION_type)
*/
AQBANKING_API AB_TRANSACTION_TYPE AB_Transaction_GetType(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "subType" (see @ref AB_TRANSACTION_subType)
*/
AQBANKING_API AB_TRANSACTION_SUBTYPE AB_Transaction_GetSubType(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "command" (see @ref AB_TRANSACTION_command)
*/
AQBANKING_API AB_TRANSACTION_COMMAND AB_Transaction_GetCommand(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "status" (see @ref AB_TRANSACTION_status)
*/
AQBANKING_API AB_TRANSACTION_STATUS AB_Transaction_GetStatus(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "uniqueAccountId" (see @ref AB_TRANSACTION_uniqueAccountId)
*/
AQBANKING_API uint32_t AB_Transaction_GetUniqueAccountId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "uniqueId" (see @ref AB_TRANSACTION_uniqueId)
*/
AQBANKING_API uint32_t AB_Transaction_GetUniqueId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "refUniqueId" (see @ref AB_TRANSACTION_refUniqueId)
*/
AQBANKING_API uint32_t AB_Transaction_GetRefUniqueId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "idForApplication" (see @ref AB_TRANSACTION_idForApplication)
*/
AQBANKING_API uint32_t AB_Transaction_GetIdForApplication(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "stringIdForApplication" (see @ref AB_TRANSACTION_stringIdForApplication)
*/
AQBANKING_API const char *AB_Transaction_GetStringIdForApplication(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "sessionId" (see @ref AB_TRANSACTION_sessionId)
*/
AQBANKING_API uint32_t AB_Transaction_GetSessionId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "groupId" (see @ref AB_TRANSACTION_groupId)
*/
AQBANKING_API uint32_t AB_Transaction_GetGroupId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "fiId" (see @ref AB_TRANSACTION_fiId)
*/
AQBANKING_API const char *AB_Transaction_GetFiId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localIban" (see @ref AB_TRANSACTION_localIban)
*/
AQBANKING_API const char *AB_Transaction_GetLocalIban(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localBic" (see @ref AB_TRANSACTION_localBic)
*/
AQBANKING_API const char *AB_Transaction_GetLocalBic(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localCountry" (see @ref AB_TRANSACTION_localCountry)
*/
AQBANKING_API const char *AB_Transaction_GetLocalCountry(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localBankCode" (see @ref AB_TRANSACTION_localBankCode)
*/
AQBANKING_API const char *AB_Transaction_GetLocalBankCode(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localBranchId" (see @ref AB_TRANSACTION_localBranchId)
*/
AQBANKING_API const char *AB_Transaction_GetLocalBranchId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localAccountNumber" (see @ref AB_TRANSACTION_localAccountNumber)
*/
AQBANKING_API const char *AB_Transaction_GetLocalAccountNumber(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localSuffix" (see @ref AB_TRANSACTION_localSuffix)
*/
AQBANKING_API const char *AB_Transaction_GetLocalSuffix(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "localName" (see @ref AB_TRANSACTION_localName)
*/
AQBANKING_API const char *AB_Transaction_GetLocalName(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteCountry" (see @ref AB_TRANSACTION_remoteCountry)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteCountry(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteBankCode" (see @ref AB_TRANSACTION_remoteBankCode)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBankCode(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteBranchId" (see @ref AB_TRANSACTION_remoteBranchId)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBranchId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteAccountNumber" (see @ref AB_TRANSACTION_remoteAccountNumber)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAccountNumber(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteSuffix" (see @ref AB_TRANSACTION_remoteSuffix)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteSuffix(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteIban" (see @ref AB_TRANSACTION_remoteIban)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteIban(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteBic" (see @ref AB_TRANSACTION_remoteBic)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBic(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteName" (see @ref AB_TRANSACTION_remoteName)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteName(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "date" (see @ref AB_TRANSACTION_date)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "valutaDate" (see @ref AB_TRANSACTION_valutaDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetValutaDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "value" (see @ref AB_TRANSACTION_value)
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetValue(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "fees" (see @ref AB_TRANSACTION_fees)
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetFees(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "transactionCode" (see @ref AB_TRANSACTION_transactionCode)
*/
AQBANKING_API int AB_Transaction_GetTransactionCode(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "transactionText" (see @ref AB_TRANSACTION_transactionText)
*/
AQBANKING_API const char *AB_Transaction_GetTransactionText(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "transactionKey" (see @ref AB_TRANSACTION_transactionKey)
*/
AQBANKING_API const char *AB_Transaction_GetTransactionKey(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "textKey" (see @ref AB_TRANSACTION_textKey)
*/
AQBANKING_API int AB_Transaction_GetTextKey(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "primanota" (see @ref AB_TRANSACTION_primanota)
*/
AQBANKING_API const char *AB_Transaction_GetPrimanota(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "purpose" (see @ref AB_TRANSACTION_purpose)
*/
AQBANKING_API const char *AB_Transaction_GetPurpose(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "category" (see @ref AB_TRANSACTION_category)
*/
AQBANKING_API const char *AB_Transaction_GetCategory(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "customerReference" (see @ref AB_TRANSACTION_customerReference)
*/
AQBANKING_API const char *AB_Transaction_GetCustomerReference(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "bankReference" (see @ref AB_TRANSACTION_bankReference)
*/
AQBANKING_API const char *AB_Transaction_GetBankReference(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "endToEndReference" (see @ref AB_TRANSACTION_endToEndReference)
*/
AQBANKING_API const char *AB_Transaction_GetEndToEndReference(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "ultimateCreditor" (see @ref AB_TRANSACTION_ultimateCreditor)
*/
AQBANKING_API const char *AB_Transaction_GetUltimateCreditor(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "ultimateDebtor" (see @ref AB_TRANSACTION_ultimateDebtor)
*/
AQBANKING_API const char *AB_Transaction_GetUltimateDebtor(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "creditorSchemeId" (see @ref AB_TRANSACTION_creditorSchemeId)
*/
AQBANKING_API const char *AB_Transaction_GetCreditorSchemeId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "originatorId" (see @ref AB_TRANSACTION_originatorId)
*/
AQBANKING_API const char *AB_Transaction_GetOriginatorId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "mandateId" (see @ref AB_TRANSACTION_mandateId)
*/
AQBANKING_API const char *AB_Transaction_GetMandateId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "mandateDate" (see @ref AB_TRANSACTION_mandateDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetMandateDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "mandateDebitorName" (see @ref AB_TRANSACTION_mandateDebitorName)
*/
AQBANKING_API const char *AB_Transaction_GetMandateDebitorName(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "originalCreditorSchemeId" (see @ref AB_TRANSACTION_originalCreditorSchemeId)
*/
AQBANKING_API const char *AB_Transaction_GetOriginalCreditorSchemeId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "originalMandateId" (see @ref AB_TRANSACTION_originalMandateId)
*/
AQBANKING_API const char *AB_Transaction_GetOriginalMandateId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "originalCreditorName" (see @ref AB_TRANSACTION_originalCreditorName)
*/
AQBANKING_API const char *AB_Transaction_GetOriginalCreditorName(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "sequence" (see @ref AB_TRANSACTION_sequence)
*/
AQBANKING_API AB_TRANSACTION_SEQUENCE AB_Transaction_GetSequence(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "charge" (see @ref AB_TRANSACTION_charge)
*/
AQBANKING_API AB_TRANSACTION_CHARGE AB_Transaction_GetCharge(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteAddrStreet" (see @ref AB_TRANSACTION_remoteAddrStreet)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrStreet(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteAddrZipcode" (see @ref AB_TRANSACTION_remoteAddrZipcode)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrZipcode(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteAddrCity" (see @ref AB_TRANSACTION_remoteAddrCity)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrCity(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "remoteAddrPhone" (see @ref AB_TRANSACTION_remoteAddrPhone)
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrPhone(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "period" (see @ref AB_TRANSACTION_period)
*/
AQBANKING_API AB_TRANSACTION_PERIOD AB_Transaction_GetPeriod(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "cycle" (see @ref AB_TRANSACTION_cycle)
*/
AQBANKING_API uint32_t AB_Transaction_GetCycle(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "executionDay" (see @ref AB_TRANSACTION_executionDay)
*/
AQBANKING_API uint32_t AB_Transaction_GetExecutionDay(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "firstDate" (see @ref AB_TRANSACTION_firstDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetFirstDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "lastDate" (see @ref AB_TRANSACTION_lastDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetLastDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "nextDate" (see @ref AB_TRANSACTION_nextDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetNextDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "unitId" (see @ref AB_TRANSACTION_unitId)
*/
AQBANKING_API const char *AB_Transaction_GetUnitId(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "unitIdNameSpace" (see @ref AB_TRANSACTION_unitIdNameSpace)
*/
AQBANKING_API const char *AB_Transaction_GetUnitIdNameSpace(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "tickerSymbol" (see @ref AB_TRANSACTION_tickerSymbol)
*/
AQBANKING_API const char *AB_Transaction_GetTickerSymbol(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "units" (see @ref AB_TRANSACTION_units)
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetUnits(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "unitPriceValue" (see @ref AB_TRANSACTION_unitPriceValue)
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetUnitPriceValue(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "unitPriceDate" (see @ref AB_TRANSACTION_unitPriceDate)
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetUnitPriceDate(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "commissionValue" (see @ref AB_TRANSACTION_commissionValue)
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetCommissionValue(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "memo" (see @ref AB_TRANSACTION_memo)
*/
AQBANKING_API const char *AB_Transaction_GetMemo(const AB_TRANSACTION *p_struct);

/** Getter.
 * Use this function to get the member "hash" (see @ref AB_TRANSACTION_hash)
*/
AQBANKING_API const char *AB_Transaction_GetHash(const AB_TRANSACTION *p_struct);

/** Setter.
 * Use this function to set the member "type" (see @ref AB_TRANSACTION_type)
*/
AQBANKING_API void AB_Transaction_SetType(AB_TRANSACTION *p_struct, AB_TRANSACTION_TYPE  p_src);

/** Setter.
 * Use this function to set the member "subType" (see @ref AB_TRANSACTION_subType)
*/
AQBANKING_API void AB_Transaction_SetSubType(AB_TRANSACTION *p_struct, AB_TRANSACTION_SUBTYPE  p_src);

/** Setter.
 * Use this function to set the member "command" (see @ref AB_TRANSACTION_command)
*/
AQBANKING_API void AB_Transaction_SetCommand(AB_TRANSACTION *p_struct, AB_TRANSACTION_COMMAND  p_src);

/** Setter.
 * Use this function to set the member "status" (see @ref AB_TRANSACTION_status)
*/
AQBANKING_API void AB_Transaction_SetStatus(AB_TRANSACTION *p_struct, AB_TRANSACTION_STATUS  p_src);

/** Setter.
 * Use this function to set the member "uniqueAccountId" (see @ref AB_TRANSACTION_uniqueAccountId)
*/
AQBANKING_API void AB_Transaction_SetUniqueAccountId(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "uniqueId" (see @ref AB_TRANSACTION_uniqueId)
*/
AQBANKING_API void AB_Transaction_SetUniqueId(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "refUniqueId" (see @ref AB_TRANSACTION_refUniqueId)
*/
AQBANKING_API void AB_Transaction_SetRefUniqueId(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "idForApplication" (see @ref AB_TRANSACTION_idForApplication)
*/
AQBANKING_API void AB_Transaction_SetIdForApplication(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "stringIdForApplication" (see @ref AB_TRANSACTION_stringIdForApplication)
*/
AQBANKING_API void AB_Transaction_SetStringIdForApplication(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "sessionId" (see @ref AB_TRANSACTION_sessionId)
*/
AQBANKING_API void AB_Transaction_SetSessionId(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "groupId" (see @ref AB_TRANSACTION_groupId)
*/
AQBANKING_API void AB_Transaction_SetGroupId(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "fiId" (see @ref AB_TRANSACTION_fiId)
*/
AQBANKING_API void AB_Transaction_SetFiId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localIban" (see @ref AB_TRANSACTION_localIban)
*/
AQBANKING_API void AB_Transaction_SetLocalIban(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localBic" (see @ref AB_TRANSACTION_localBic)
*/
AQBANKING_API void AB_Transaction_SetLocalBic(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localCountry" (see @ref AB_TRANSACTION_localCountry)
*/
AQBANKING_API void AB_Transaction_SetLocalCountry(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localBankCode" (see @ref AB_TRANSACTION_localBankCode)
*/
AQBANKING_API void AB_Transaction_SetLocalBankCode(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localBranchId" (see @ref AB_TRANSACTION_localBranchId)
*/
AQBANKING_API void AB_Transaction_SetLocalBranchId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localAccountNumber" (see @ref AB_TRANSACTION_localAccountNumber)
*/
AQBANKING_API void AB_Transaction_SetLocalAccountNumber(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localSuffix" (see @ref AB_TRANSACTION_localSuffix)
*/
AQBANKING_API void AB_Transaction_SetLocalSuffix(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "localName" (see @ref AB_TRANSACTION_localName)
*/
AQBANKING_API void AB_Transaction_SetLocalName(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteCountry" (see @ref AB_TRANSACTION_remoteCountry)
*/
AQBANKING_API void AB_Transaction_SetRemoteCountry(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteBankCode" (see @ref AB_TRANSACTION_remoteBankCode)
*/
AQBANKING_API void AB_Transaction_SetRemoteBankCode(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteBranchId" (see @ref AB_TRANSACTION_remoteBranchId)
*/
AQBANKING_API void AB_Transaction_SetRemoteBranchId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteAccountNumber" (see @ref AB_TRANSACTION_remoteAccountNumber)
*/
AQBANKING_API void AB_Transaction_SetRemoteAccountNumber(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteSuffix" (see @ref AB_TRANSACTION_remoteSuffix)
*/
AQBANKING_API void AB_Transaction_SetRemoteSuffix(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteIban" (see @ref AB_TRANSACTION_remoteIban)
*/
AQBANKING_API void AB_Transaction_SetRemoteIban(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteBic" (see @ref AB_TRANSACTION_remoteBic)
*/
AQBANKING_API void AB_Transaction_SetRemoteBic(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteName" (see @ref AB_TRANSACTION_remoteName)
*/
AQBANKING_API void AB_Transaction_SetRemoteName(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "date" (see @ref AB_TRANSACTION_date)
*/
AQBANKING_API void AB_Transaction_SetDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "valutaDate" (see @ref AB_TRANSACTION_valutaDate)
*/
AQBANKING_API void AB_Transaction_SetValutaDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "value" (see @ref AB_TRANSACTION_value)
*/
AQBANKING_API void AB_Transaction_SetValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src);

/** Setter.
 * Use this function to set the member "fees" (see @ref AB_TRANSACTION_fees)
*/
AQBANKING_API void AB_Transaction_SetFees(AB_TRANSACTION *p_struct, const AB_VALUE *p_src);

/** Setter.
 * Use this function to set the member "transactionCode" (see @ref AB_TRANSACTION_transactionCode)
*/
AQBANKING_API void AB_Transaction_SetTransactionCode(AB_TRANSACTION *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "transactionText" (see @ref AB_TRANSACTION_transactionText)
*/
AQBANKING_API void AB_Transaction_SetTransactionText(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "transactionKey" (see @ref AB_TRANSACTION_transactionKey)
*/
AQBANKING_API void AB_Transaction_SetTransactionKey(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "textKey" (see @ref AB_TRANSACTION_textKey)
*/
AQBANKING_API void AB_Transaction_SetTextKey(AB_TRANSACTION *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "primanota" (see @ref AB_TRANSACTION_primanota)
*/
AQBANKING_API void AB_Transaction_SetPrimanota(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "purpose" (see @ref AB_TRANSACTION_purpose)
*/
AQBANKING_API void AB_Transaction_SetPurpose(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "category" (see @ref AB_TRANSACTION_category)
*/
AQBANKING_API void AB_Transaction_SetCategory(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "customerReference" (see @ref AB_TRANSACTION_customerReference)
*/
AQBANKING_API void AB_Transaction_SetCustomerReference(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankReference" (see @ref AB_TRANSACTION_bankReference)
*/
AQBANKING_API void AB_Transaction_SetBankReference(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "endToEndReference" (see @ref AB_TRANSACTION_endToEndReference)
*/
AQBANKING_API void AB_Transaction_SetEndToEndReference(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ultimateCreditor" (see @ref AB_TRANSACTION_ultimateCreditor)
*/
AQBANKING_API void AB_Transaction_SetUltimateCreditor(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ultimateDebtor" (see @ref AB_TRANSACTION_ultimateDebtor)
*/
AQBANKING_API void AB_Transaction_SetUltimateDebtor(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "creditorSchemeId" (see @ref AB_TRANSACTION_creditorSchemeId)
*/
AQBANKING_API void AB_Transaction_SetCreditorSchemeId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "originatorId" (see @ref AB_TRANSACTION_originatorId)
*/
AQBANKING_API void AB_Transaction_SetOriginatorId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "mandateId" (see @ref AB_TRANSACTION_mandateId)
*/
AQBANKING_API void AB_Transaction_SetMandateId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "mandateDate" (see @ref AB_TRANSACTION_mandateDate)
*/
AQBANKING_API void AB_Transaction_SetMandateDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "mandateDebitorName" (see @ref AB_TRANSACTION_mandateDebitorName)
*/
AQBANKING_API void AB_Transaction_SetMandateDebitorName(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "originalCreditorSchemeId" (see @ref AB_TRANSACTION_originalCreditorSchemeId)
*/
AQBANKING_API void AB_Transaction_SetOriginalCreditorSchemeId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "originalMandateId" (see @ref AB_TRANSACTION_originalMandateId)
*/
AQBANKING_API void AB_Transaction_SetOriginalMandateId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "originalCreditorName" (see @ref AB_TRANSACTION_originalCreditorName)
*/
AQBANKING_API void AB_Transaction_SetOriginalCreditorName(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "sequence" (see @ref AB_TRANSACTION_sequence)
*/
AQBANKING_API void AB_Transaction_SetSequence(AB_TRANSACTION *p_struct, AB_TRANSACTION_SEQUENCE  p_src);

/** Setter.
 * Use this function to set the member "charge" (see @ref AB_TRANSACTION_charge)
*/
AQBANKING_API void AB_Transaction_SetCharge(AB_TRANSACTION *p_struct, AB_TRANSACTION_CHARGE  p_src);

/** Setter.
 * Use this function to set the member "remoteAddrStreet" (see @ref AB_TRANSACTION_remoteAddrStreet)
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrStreet(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteAddrZipcode" (see @ref AB_TRANSACTION_remoteAddrZipcode)
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrZipcode(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteAddrCity" (see @ref AB_TRANSACTION_remoteAddrCity)
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrCity(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "remoteAddrPhone" (see @ref AB_TRANSACTION_remoteAddrPhone)
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrPhone(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "period" (see @ref AB_TRANSACTION_period)
*/
AQBANKING_API void AB_Transaction_SetPeriod(AB_TRANSACTION *p_struct, AB_TRANSACTION_PERIOD  p_src);

/** Setter.
 * Use this function to set the member "cycle" (see @ref AB_TRANSACTION_cycle)
*/
AQBANKING_API void AB_Transaction_SetCycle(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "executionDay" (see @ref AB_TRANSACTION_executionDay)
*/
AQBANKING_API void AB_Transaction_SetExecutionDay(AB_TRANSACTION *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "firstDate" (see @ref AB_TRANSACTION_firstDate)
*/
AQBANKING_API void AB_Transaction_SetFirstDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "lastDate" (see @ref AB_TRANSACTION_lastDate)
*/
AQBANKING_API void AB_Transaction_SetLastDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "nextDate" (see @ref AB_TRANSACTION_nextDate)
*/
AQBANKING_API void AB_Transaction_SetNextDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "unitId" (see @ref AB_TRANSACTION_unitId)
*/
AQBANKING_API void AB_Transaction_SetUnitId(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "unitIdNameSpace" (see @ref AB_TRANSACTION_unitIdNameSpace)
*/
AQBANKING_API void AB_Transaction_SetUnitIdNameSpace(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "tickerSymbol" (see @ref AB_TRANSACTION_tickerSymbol)
*/
AQBANKING_API void AB_Transaction_SetTickerSymbol(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "units" (see @ref AB_TRANSACTION_units)
*/
AQBANKING_API void AB_Transaction_SetUnits(AB_TRANSACTION *p_struct, const AB_VALUE *p_src);

/** Setter.
 * Use this function to set the member "unitPriceValue" (see @ref AB_TRANSACTION_unitPriceValue)
*/
AQBANKING_API void AB_Transaction_SetUnitPriceValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src);

/** Setter.
 * Use this function to set the member "unitPriceDate" (see @ref AB_TRANSACTION_unitPriceDate)
*/
AQBANKING_API void AB_Transaction_SetUnitPriceDate(AB_TRANSACTION *p_struct, const GWEN_DATE *p_src);

/** Setter.
 * Use this function to set the member "commissionValue" (see @ref AB_TRANSACTION_commissionValue)
*/
AQBANKING_API void AB_Transaction_SetCommissionValue(AB_TRANSACTION *p_struct, const AB_VALUE *p_src);

/** Setter.
 * Use this function to set the member "memo" (see @ref AB_TRANSACTION_memo)
*/
AQBANKING_API void AB_Transaction_SetMemo(AB_TRANSACTION *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "hash" (see @ref AB_TRANSACTION_hash)
*/
AQBANKING_API void AB_Transaction_SetHash(AB_TRANSACTION *p_struct, const char *p_src);

/* list1 functions */
AQBANKING_API AB_TRANSACTION_LIST *AB_Transaction_List_dup(const AB_TRANSACTION_LIST *p_src);

AQBANKING_API void AB_Transaction_ReadDb(AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API int AB_Transaction_WriteDb(const AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API AB_TRANSACTION *AB_Transaction_fromDb(GWEN_DB_NODE *p_db);

AQBANKING_API int AB_Transaction_toDb(const AB_TRANSACTION *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API void AB_Transaction_ReadXml(AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_Transaction_WriteXml(const AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_Transaction_toXml(const AB_TRANSACTION *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API AB_TRANSACTION *AB_Transaction_fromXml(GWEN_XMLNODE *p_db);

AQBANKING_API AB_TRANSACTION *AB_Transaction_List_GetByUniqueId(const AB_TRANSACTION_LIST *p_list, uint32_t p_cmp);

AQBANKING_API AB_TRANSACTION *AB_Transaction_List_GetByIdForApplication(const AB_TRANSACTION_LIST *p_list,
                                                                        uint32_t p_cmp);

AQBANKING_API AB_TRANSACTION *AB_Transaction_List_GetByStringIdForApplication(const AB_TRANSACTION_LIST *p_list,
                                                                              const char *p_cmp);

AQBANKING_API void AB_Transaction_toHashString(const AB_TRANSACTION *p_struct, GWEN_BUFFER *p_buffer);

AQBANKING_API int AB_Transaction_GenerateHash(AB_TRANSACTION *st);
/**
 * Check whether a transaction matches the given type and command.
 *
 * @return 1 if match, 0 otherwise
 * @param tl pointer to the list to search
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API int AB_Transaction_MatchTypeAndCommand(const AB_TRANSACTION *t, int ty, int cmd);
/**
 * Find first transaction in a list which matches the given type and command.
 *
 * @return Entry matching the description (or NULL if none)
 * @param tl pointer to the list to search
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API AB_TRANSACTION *AB_Transaction_List_FindFirstByType(const AB_TRANSACTION_LIST *tl, int ty, int cmd);
/**
 * Find next transaction in a list which matches the given type and command.
 *
 * @return Entry matching the description (or NULL if none)
 * @param t pointer to the previous match (as returned by AB_Transaction_List_FindFirstByType)
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API AB_TRANSACTION *AB_Transaction_List_FindNextByType(const AB_TRANSACTION *t, int ty, int cmd);
/**
 * Remove matching transactions from the given list
 *
 * @return Number of transactions removed from the list
 * @param tl pointer to the list to search
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API int AB_Transaction_List_RemoveByType(AB_TRANSACTION_LIST *tl, int ty, int cmd);
/**
 * Keep matching transactions in the given list and delete others.
 *
 * @return Number of transactions removed from the list
 * @param tl pointer to the list to search
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API int AB_Transaction_List_KeepByType(AB_TRANSACTION_LIST *tl, int ty, int cmd);
AQBANKING_API int AB_Transaction_List_CountByType(const AB_TRANSACTION_LIST *tl, int ty, int cmd);
/**
 * Definition of the callback function for @ref AB_Transaction_List_ForEachByType().
 */
typedef const AB_TRANSACTION *(AB_TRANSACTION_LIST_FOREACHBYTYPE_CB)(const AB_TRANSACTION *element, void *user_data);
/**
 * Call the given callback function for every entry of the list which matches the given type and command.
 *
 * @return Entry matching the description (or NULL if none)
 * @param fn callback function to be called for every element of the given list
 * @param user_data user data forwarded to the callback function
 * @param tl pointer to the list to search
 * @param ty transaction type, if 0 then this is not checked
 * @param cmd command, if -1 then any non-zero command matches, if 0 then this is not checked
 */
AQBANKING_API const AB_TRANSACTION *AB_Transaction_List_ForEachByType(const AB_TRANSACTION_LIST *tl,
                                                                      AB_TRANSACTION_LIST_FOREACHBYTYPE_CB fn, void *user_data, int ty, int cmd);
AQBANKING_API AB_TRANSACTION *AB_Transaction_List_FindName(const AB_TRANSACTION_LIST *tl, int ty, const char *ns,
                                                           const char *n);
AQBANKING_API int AB_Transaction_List_WriteDb(const AB_TRANSACTION_LIST *tl, GWEN_DB_NODE *db);
AQBANKING_API int AB_Transaction_List_ReadDb(AB_TRANSACTION_LIST *tl, GWEN_DB_NODE *db);
AQBANKING_API void AB_Transaction_AddPurposeLine(AB_TRANSACTION *t, const char *s);
AQBANKING_API void AB_Transaction_SetPurposeFromStringList(AB_TRANSACTION *t, const GWEN_STRINGLIST *sl);
/**
 * The purpose fields may contain multiple purpose lines separated by a NEWLINE character (10).
 * If you need the old behaviour of previous versions you can use this function to get a string list
 * representation of the purpose lines.
 *
 * If the purpose field is empty NULL is returned (no empty list is ever returned).
 *
 * The caller is responsible for freeing the object returned, if any.
 *
 * @return stringlist (NULL if empty)
 * @param t transaction object
 */
AQBANKING_API GWEN_STRINGLIST *AB_Transaction_GetPurposeAsStringList(const AB_TRANSACTION *t);
AQBANKING_API void AB_Transaction_AddCategory(AB_TRANSACTION *t, const char *s);
AQBANKING_API void AB_Transaction_SetCategoryFromStringList(AB_TRANSACTION *t, const GWEN_STRINGLIST *sl);
AQBANKING_API int AB_Transaction_List2_freeAll(AB_TRANSACTION_LIST2 *tl);
/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

