/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.autodetect.FontFinder;
import org.apache.fop.fonts.autodetect.MacFontDirFinder;
import org.apache.fop.fonts.autodetect.UnixFontDirFinder;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;

public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    private final Log log = LogFactory.getLog(class$org$apache$fop$fonts$autodetect$FontFileFinder == null ? (class$org$apache$fop$fonts$autodetect$FontFileFinder = FontFileFinder.class$("org.apache.fop.fonts.autodetect.FontFileFinder")) : class$org$apache$fop$fonts$autodetect$FontFileFinder);
    public static final int DEFAULT_DEPTH_LIMIT = -1;
    static /* synthetic */ Class class$org$apache$fop$fonts$autodetect$FontFileFinder;

    public FontFileFinder() {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), -1);
    }

    public FontFileFinder(int depthLimit) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), depthLimit);
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)new SuffixFileFilter(new String[]{".ttf", ".otf", ".pfb"}));
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        return true;
    }

    protected void handleFile(File file, int depth, Collection results) {
        results.add(file);
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(directory + ": found " + results.size() + " font" + (results.size() == 1 ? "" : "s"));
        }
    }

    public List find() throws IOException {
        String osName = System.getProperty("os.name");
        FontFinder fontDirFinder = osName.startsWith("Windows") ? new WindowsFontDirFinder() : (osName.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List fontDirs = fontDirFinder.find();
        ArrayList results = new ArrayList();
        Iterator iter = fontDirs.iterator();
        while (iter.hasNext()) {
            super.walk((File)iter.next(), results);
        }
        return results;
    }

    public List find(String dir) throws IOException {
        ArrayList results = new ArrayList();
        super.walk(new File(dir), results);
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

