/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class NumberUtils {
    public static final double EPS = 1.0E-5;

    public static <T extends Number> T parseNumber(String str, Class<T> type) throws UnsupportedOperationException {
        try {
            Method m = type.getMethod("valueOf", String.class);
            Object o = m.invoke(type, str);
            return (T)((Number)type.cast(o));
        }
        catch (NoSuchMethodException e1) {
            try {
                Constructor<T> ctor = type.getConstructor(String.class);
                return (T)((Number)ctor.newInstance(str));
            }
            catch (ReflectiveOperationException e2) {
                throw new UnsupportedOperationException("Cannot convert string to " + type.getName());
            }
        }
        catch (ReflectiveOperationException e2) {
            throw new UnsupportedOperationException("Cannot convert string to " + type.getName());
        }
    }

    public static boolean equalsEpsilon(double a, double b) {
        return NumberUtils.equals(a, b, 1.0E-5);
    }

    public static boolean equals(double a, double b, double epsilon) {
        return a == b ? true : Math.abs(a - b) < epsilon;
    }
}

