/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PalettePopup;
import net.java.dev.colorchooser.RecentColors;

public abstract class ColorChooserUI
extends ComponentUI {
    static boolean MAC = false;

    protected ColorChooserUI() {
    }

    public final void installUI(JComponent jc) {
        this.installListeners((ColorChooser)jc);
        this.init((ColorChooser)jc);
    }

    public final void uninstallUI(JComponent jc) {
        this.uninstallListeners((ColorChooser)jc);
        this.uninit((ColorChooser)jc);
    }

    protected void init(ColorChooser c) {
    }

    protected void uninit(ColorChooser c) {
    }

    protected void installListeners(ColorChooser c) {
        L l = new L();
        c.addMouseListener(l);
        c.addFocusListener(l);
        c.addKeyListener(l);
        c.putClientProperty("uiListener", l);
    }

    protected void uninstallListeners(ColorChooser c) {
        Object o = c.getClientProperty("uiListener");
        if (o instanceof L) {
            L l = (L)o;
            c.removeMouseListener(l);
            c.removeFocusListener(l);
            c.removeKeyListener(l);
        }
    }

    protected int paletteIndexFromKeyCode(KeyEvent ke) {
        int result;
        int keyCode = ke.getKeyCode();
        int n = result = keyCode == 16 ? 1 : 0;
        result = MAC ? (result += keyCode == 157 ? 2 : 0) : (result += keyCode == 17 ? 2 : 0);
        return result += keyCode == 18 ? 4 : 0;
    }

    protected int paletteIndexFromModifiers(InputEvent me) {
        int mods = me.getModifiersEx();
        int result = (mods & 0x40) != 0 ? 1 : 0;
        result += (mods & 0x80) != 0 ? 2 : 0;
        return result += (mods & 0x200) != 0 ? 4 : 0;
    }

    protected void keyboardInvoke(ColorChooser colorChooser) {
        if (!colorChooser.isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Container top = colorChooser.getTopLevelAncestor();
        Color result = ColorPicker.showDialog(top, colorChooser.getColor());
        if (result != null) {
            colorChooser.setColor(result);
        }
    }

    protected void fireColorChanged(ColorChooser chooser) {
        chooser.fireActionPerformed(new ActionEvent(chooser, 1001, "color"));
    }

    public Dimension getMaximumSize(JComponent c) {
        if (!c.isMaximumSizeSet()) {
            return this.getPreferredSize(c);
        }
        return super.getMaximumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!c.isMinimumSizeSet()) {
            return this.getPreferredSize(c);
        }
        return super.getMinimumSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (!c.isPreferredSizeSet()) {
            return new Dimension(24, 24);
        }
        return super.getPreferredSize(c);
    }

    static {
        try {
            MAC = System.getProperty("mrj.version") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private class L
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private int paletteIndex = 0;
        private transient Point nextFocusPopupLocation = null;

        private L() {
        }

        int getPaletteIndex() {
            return this.paletteIndex;
        }

        void initPaletteIndex(ColorChooser c, MouseEvent me) {
            this.paletteIndex = ColorChooserUI.this.paletteIndexFromModifiers(me);
            this.checkRange(c);
        }

        private void checkRange(ColorChooser chooser) {
            Palette[] p = chooser.getPalettes();
            if (this.paletteIndex >= p.length) {
                this.paletteIndex = p.length - 1;
            }
        }

        private void updatePaletteIndex(ColorChooser chooser, int value, boolean pressed) {
            int oldIndex = this.paletteIndex;
            int result = this.paletteIndex;
            result = pressed ? (result |= value) : (result ^= value);
            if (oldIndex != result && PalettePopup.getDefault().isPopupVisible(chooser)) {
                this.paletteIndex = result;
                this.checkRange(chooser);
                PalettePopup.getDefault().setPalette(chooser.getPalettes()[this.paletteIndex]);
            }
        }

        public void mouseClicked(MouseEvent e) {
            Object o;
            int mask;
            int n = mask = MAC ? 128 : 256;
            if ((e.getModifiersEx() & mask) != 0 && (o = e.getSource()) instanceof ColorChooser) {
                ColorChooser chooser = (ColorChooser)e.getSource();
                ColorChooserUI.this.keyboardInvoke(chooser);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, chooser);
            this.initPaletteIndex(chooser, me);
            PalettePopup.getDefault().setPalette(chooser.getPalettes()[this.getPaletteIndex()]);
            if (!chooser.hasFocus()) {
                this.nextFocusPopupLocation = p;
                chooser.requestFocus();
                return;
            }
            PalettePopup.getDefault().showPopup(chooser, p);
            me.consume();
            this.nextFocusPopupLocation = null;
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.nextFocusPopupLocation = null;
            if (PalettePopup.getDefault().isPopupVisible(chooser)) {
                PalettePopup.getDefault().hidePopup(chooser);
                Color transientColor = chooser.transientColor();
                if (transientColor != null) {
                    RecentColors.getDefault().add(transientColor);
                    Color old = new Color(transientColor.getRed(), transientColor.getGreen(), transientColor.getBlue());
                    chooser.setTransientColor(null);
                    chooser.setColor(old);
                    ColorChooserUI.this.fireColorChanged(chooser);
                    me.consume();
                }
            }
        }

        public void focusGained(FocusEvent e) {
            ColorChooser chooser = (ColorChooser)e.getSource();
            if (this.nextFocusPopupLocation != null && chooser.isEnabled()) {
                PalettePopup.getDefault().showPopup(chooser, this.nextFocusPopupLocation);
            }
            this.nextFocusPopupLocation = null;
            chooser.repaint();
        }

        public void focusLost(FocusEvent e) {
            ColorChooser chooser = (ColorChooser)e.getSource();
            chooser.repaint();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.processKeyEvent(e, true);
        }

        public void keyReleased(KeyEvent e) {
            this.processKeyEvent(e, false);
        }

        protected void processKeyEvent(KeyEvent ke, boolean pressed) {
            ColorChooser chooser = (ColorChooser)ke.getSource();
            this.updatePaletteIndex(chooser, ColorChooserUI.this.paletteIndexFromKeyCode(ke), pressed);
            if (ke.getKeyCode() == 18 || ke.getKeyCode() == 17 || ke.getKeyCode() == 16) {
                ke.consume();
            } else if ((ke.getKeyCode() == 32 || ke.getKeyCode() == 10) && ke.getID() == 402) {
                ColorChooserUI.this.keyboardInvoke(chooser);
            }
        }
    }
}

