/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;

public class TextureUnitStateState
extends NodeComponentState {
    private int texCoordGeneration;
    private int texture;
    private int textureAttributes;

    public TextureUnitStateState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            TextureUnitState textureUnitState = (TextureUnitState)this.node;
            this.texCoordGeneration = controller.getSymbolTable().addReference((SceneGraphObject)textureUnitState.getTexCoordGeneration());
            this.texture = controller.getSymbolTable().addReference((SceneGraphObject)textureUnitState.getTexture());
            this.textureAttributes = controller.getSymbolTable().addReference((SceneGraphObject)textureUnitState.getTextureAttributes());
        }
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.texCoordGeneration);
        dataOutput.writeInt(this.texture);
        dataOutput.writeInt(this.textureAttributes);
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        TextureUnitState textureUnitState = (TextureUnitState)this.node;
        this.texCoordGeneration = dataInput.readInt();
        this.texture = dataInput.readInt();
        this.textureAttributes = dataInput.readInt();
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.texCoordGeneration);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texture);
        this.control.getSymbolTable().incNodeComponentRefCount(this.textureAttributes);
    }

    @Override
    public void buildGraph() {
        TextureUnitState textureUnitState = (TextureUnitState)this.node;
        textureUnitState.setTexCoordGeneration((TexCoordGeneration)this.control.getSymbolTable().getJ3dNode(this.texCoordGeneration));
        textureUnitState.setTexture((Texture)this.control.getSymbolTable().getJ3dNode(this.texture));
        textureUnitState.setTextureAttributes((TextureAttributes)this.control.getSymbolTable().getJ3dNode(this.textureAttributes));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureUnitState();
    }
}

