/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class AjpProcessor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(AjpProcessor.class);
    private static final StringManager sm = StringManager.getManager(AjpProcessor.class);
    private static final byte[] endMessageArray;
    private static final byte[] endAndCloseMessageArray;
    private static final byte[] flushMessageArray;
    private static final byte[] pongMessageArray;
    private static final Set<String> javaxAttributes;
    private static final Set<String> iisTlsAttributes;
    private final byte[] getBodyMessageArray;
    private final int outputMaxChunkSize;
    private final AjpMessage requestHeaderMessage;
    private final AjpMessage responseMessage;
    private int responseMsgPos = -1;
    private final AjpMessage bodyMessage;
    private final MessageBytes bodyBytes = MessageBytes.newInstance();
    private final MessageBytes tmpMB = MessageBytes.newInstance();
    private final MessageBytes certificates = MessageBytes.newInstance();
    private boolean endOfStream = false;
    private boolean empty = true;
    private boolean first = true;
    private boolean waitingForBodyMessage = false;
    private boolean replay = false;
    private boolean swallowResponse = false;
    private boolean responseFinished = false;
    private long bytesWritten = 0L;
    protected boolean ajpFlush = true;
    private int keepAliveTimeout = -1;
    private boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    private String secret = null;
    private String clientCertProvider = null;
    @Deprecated
    private boolean sendReasonPhrase = false;
    private Pattern allowedRequestAttributesPattern;

    public AjpProcessor(int n, AbstractEndpoint<?> abstractEndpoint) {
        super(abstractEndpoint);
        this.outputMaxChunkSize = 8184 + n - 8192;
        this.request.setInputBuffer(new SocketInputBuffer());
        this.requestHeaderMessage = new AjpMessage(n);
        this.responseMessage = new AjpMessage(n);
        this.bodyMessage = new AjpMessage(n);
        AjpMessage ajpMessage = new AjpMessage(16);
        ajpMessage.reset();
        ajpMessage.appendByte(6);
        ajpMessage.appendInt(8186 + n - 8192);
        ajpMessage.end();
        this.getBodyMessageArray = new byte[ajpMessage.getLen()];
        System.arraycopy(ajpMessage.getBuffer(), 0, this.getBodyMessageArray, 0, ajpMessage.getLen());
        this.response.setOutputBuffer(new SocketOutputBuffer());
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean bl) {
        this.ajpFlush = bl;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean bl) {
        this.tomcatAuthentication = bl;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean bl) {
        this.tomcatAuthorization = bl;
    }

    @Deprecated
    public void setRequiredSecret(String string) {
        this.setSecret(string);
    }

    public void setSecret(String string) {
        this.secret = string;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String string) {
        this.clientCertProvider = string;
    }

    @Deprecated
    void setSendReasonPhrase(boolean bl) {
        this.sendReasonPhrase = bl;
    }

    public void setAllowedRequestAttributesPattern(Pattern pattern) {
        this.allowedRequestAttributesPattern = pattern;
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (this.hasDataToWrite()) {
            this.socketWrapper.flush(false);
            if (this.hasDataToWrite()) {
                this.response.checkRegisterForWrite();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void dispatchNonBlockingRead() {
        if (this.available(true) > 0) {
            super.dispatchNonBlockingRead();
        }
    }

    @Override
    protected AbstractEndpoint.Handler.SocketState dispatchEndRequest() {
        if (this.keepAliveTimeout > 0) {
            this.socketWrapper.setReadTimeout(this.keepAliveTimeout);
        }
        this.recycle();
        if (this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socketWrapperBase) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.socketWrapper = socketWrapperBase;
        int n = this.endpoint.getConnectionTimeout();
        boolean bl = false;
        boolean bl2 = true;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                byte by;
                if (!this.readMessage(this.requestHeaderMessage, bl2)) break;
                bl2 = false;
                if (this.keepAliveTimeout > 0) {
                    this.socketWrapper.setReadTimeout(n);
                }
                if ((by = this.requestHeaderMessage.getByte()) == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle();
                        break;
                    }
                    bl = true;
                    try {
                        this.socketWrapper.write(true, pongMessageArray, 0, pongMessageArray.length);
                        this.socketWrapper.flush(true);
                    }
                    catch (IOException iOException) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Pong message failed", (Throwable)iOException);
                        }
                        this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                    }
                    this.recycle();
                    continue;
                }
                if (by != 2) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Unexpected message: " + by));
                    }
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, null);
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.getLog().debug((Object)sm.getString("ajpprocessor.header.error"), throwable);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
            }
            if (this.getErrorState().isIoAllowed()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.getLog().debug((Object)sm.getString("ajpprocessor.request.prepare"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                }
            }
            if (this.getErrorState().isIoAllowed() && !bl && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
            bl = false;
            if (this.getErrorState().isIoAllowed()) {
                try {
                    requestInfo.setStage(3);
                    this.getAdapter().service(this.request, this.response);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, interruptedIOException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.getLog().error((Object)sm.getString("ajpprocessor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.responseFinished && this.getErrorState().isIoAllowed()) {
                try {
                    this.action(ActionCode.COMMIT, null);
                    this.finishResponse();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            requestInfo.setStage(6);
            if (this.keepAliveTimeout > 0) {
                this.socketWrapper.setReadTimeout(this.keepAliveTimeout);
            }
            this.recycle();
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError() || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public void recycle() {
        this.getAdapter().checkRecycled(this.request, this.response);
        super.recycle();
        this.request.recycle();
        this.response.recycle();
        this.first = true;
        this.endOfStream = false;
        this.waitingForBodyMessage = false;
        this.empty = true;
        this.replay = false;
        this.responseFinished = false;
        this.certificates.recycle();
        this.swallowResponse = false;
        this.bytesWritten = 0L;
    }

    @Override
    public void pause() {
    }

    private boolean receive(boolean bl) throws IOException {
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage, bl)) {
            return false;
        }
        this.waitingForBodyMessage = false;
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int n = this.bodyMessage.peekInt();
        if (n == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    private boolean readMessage(AjpMessage ajpMessage, boolean bl) throws IOException {
        byte[] byArray = ajpMessage.getBuffer();
        if (!this.read(byArray, 0, 4, bl)) {
            return false;
        }
        int n = ajpMessage.processHeader(true);
        if (n < 0) {
            throw new IOException(sm.getString("ajpmessage.invalidLength", new Object[]{n}));
        }
        if (n == 0) {
            return true;
        }
        if (n > ajpMessage.getBuffer().length) {
            String string = sm.getString("ajpprocessor.header.tooLong", new Object[]{n, byArray.length});
            log.error((Object)string);
            throw new IllegalArgumentException(string);
        }
        this.read(byArray, 4, n, true);
        return true;
    }

    protected boolean refillReadBuffer(boolean bl) throws IOException {
        boolean bl2;
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        if (this.first) {
            this.first = false;
            long l = this.request.getContentLengthLong();
            if (l > 0L) {
                this.waitingForBodyMessage = true;
            } else if (l == 0L) {
                this.endOfStream = true;
                return false;
            }
        }
        if (!this.waitingForBodyMessage) {
            this.socketWrapper.write(true, this.getBodyMessageArray, 0, this.getBodyMessageArray.length);
            this.socketWrapper.flush(true);
            this.waitingForBodyMessage = true;
        }
        if (!(bl2 = this.receive(bl)) && !this.waitingForBodyMessage) {
            this.endOfStream = true;
        }
        return bl2;
    }

    private void prepareRequest() {
        ByteChunk byteChunk;
        byte by;
        int n;
        boolean bl;
        byte by2 = this.requestHeaderMessage.getByte();
        if (by2 != -1) {
            String string = org.apache.coyote.ajp.Constants.getMethodForCode(by2 - 1);
            this.request.method().setString(string);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        if (this.socketWrapper != null) {
            this.request.peerAddr().setString(this.socketWrapper.getRemoteAddr());
        }
        boolean bl2 = bl = this.requestHeaderMessage.getByte() != 0;
        if (bl) {
            this.request.scheme().setString("https");
        }
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        mimeHeaders.setLimit(this.endpoint.getMaxHeaderCount());
        boolean bl3 = false;
        int n2 = this.requestHeaderMessage.getInt();
        for (n = 0; n < n2; ++n) {
            ByteChunk byteChunk2;
            String string = null;
            int n3 = this.requestHeaderMessage.peekInt();
            int n4 = n3 & 0xFF;
            MessageBytes messageBytes = null;
            if (40960 == (n3 &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                string = org.apache.coyote.ajp.Constants.getHeaderForCode(n4 - 1);
                messageBytes = mimeHeaders.addValue(string);
            } else {
                n4 = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                byteChunk2 = this.tmpMB.getByteChunk();
                messageBytes = mimeHeaders.addValue(byteChunk2.getBuffer(), byteChunk2.getStart(), byteChunk2.getLength());
            }
            this.requestHeaderMessage.getBytes(messageBytes);
            if (n4 == 8 || n4 == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long l = messageBytes.getLong();
                if (bl3) {
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue;
                }
                bl3 = true;
                this.request.setContentLength(l);
                continue;
            }
            if (n4 != 7 && (n4 != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            byteChunk2 = messageBytes.getByteChunk();
            this.request.contentType().setBytes(byteChunk2.getBytes(), byteChunk2.getOffset(), byteChunk2.getLength());
        }
        n = 0;
        block18: while ((by = this.requestHeaderMessage.getByte()) != -1) {
            switch (by) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String string = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String string2 = this.tmpMB.toString();
                    if (string.equals("AJP_LOCAL_ADDR")) {
                        this.request.localAddr().setString(string2);
                        continue block18;
                    }
                    if (string.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(string2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block18;
                    }
                    if (string.equals("AJP_SSL_PROTOCOL")) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", string2);
                        continue block18;
                    }
                    if (string.equals("JK_LB_ACTIVATION")) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (javaxAttributes.contains(string)) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (iisTlsAttributes.contains(string)) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    if (this.allowedRequestAttributesPattern != null && this.allowedRequestAttributesPattern.matcher(string).matches()) {
                        this.request.setAttribute(string, string2);
                        continue block18;
                    }
                    log.warn((Object)sm.getString("ajpprocessor.unknownAttribute", new Object[]{string}));
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue block18;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 3: {
                    if (this.tomcatAuthorization || !this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                        this.request.setRemoteUserNeedsAuthorization(this.tomcatAuthorization);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    continue block18;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    continue block18;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 7: {
                    this.requestHeaderMessage.getBytes(this.certificates);
                    continue block18;
                }
                case 8: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    continue block18;
                }
                case 9: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", this.tmpMB.toString());
                    continue block18;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", this.requestHeaderMessage.getInt());
                    continue block18;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    continue block18;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.secret == null || this.secret.length() <= 0) continue block18;
                    n = 1;
                    if (this.tmpMB.equals(this.secret)) continue block18;
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue block18;
                }
            }
        }
        if (this.secret != null && this.secret.length() > 0 && n == 0) {
            this.response.setStatus(403);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        }
        if ((byteChunk = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int n5 = byteChunk.indexOf("://", 0, 3, 4);
            int n6 = byteChunk.getStart();
            int n7 = -1;
            if (n5 != -1) {
                byte[] byArray = byteChunk.getBytes();
                n7 = byteChunk.indexOf('/', n5 + 3);
                if (n7 == -1) {
                    n7 = byteChunk.getLength();
                    this.request.requestURI().setBytes(byArray, n6 + n5 + 1, 1);
                } else {
                    this.request.requestURI().setBytes(byArray, n6 + n7, byteChunk.getLength() - n7);
                }
                MessageBytes messageBytes = mimeHeaders.setValue("host");
                messageBytes.setBytes(byArray, n6 + n5 + 3, n7 - n5 - 3);
            }
        }
        MessageBytes messageBytes = this.request.getMimeHeaders().getValue("host");
        this.parseHost(messageBytes);
        if (!this.getErrorState().isIoAllowed()) {
            this.getAdapter().log(this.request, this.response, 0L);
        }
    }

    @Override
    protected void populateHost() {
        try {
            this.request.serverName().duplicate(this.request.localName());
        }
        catch (IOException iOException) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, iOException);
        }
    }

    @Override
    protected void populatePort() {
        this.request.setServerPort(this.request.getLocalPort());
    }

    @Override
    protected final void prepareResponse() throws IOException {
        long l;
        String string;
        Object object;
        MessageBytes messageBytes;
        this.response.setCommitted(true);
        this.tmpMB.recycle();
        this.responseMsgPos = -1;
        this.responseMessage.reset();
        this.responseMessage.appendByte(4);
        int n = this.response.getStatus();
        if (n < 200 || n == 204 || n == 205 || n == 304) {
            this.swallowResponse = true;
        }
        if ((messageBytes = this.request.method()).equals("HEAD")) {
            this.swallowResponse = true;
        }
        this.responseMessage.appendInt(n);
        if (this.sendReasonPhrase) {
            object = null;
            if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
                object = this.response.getMessage();
            }
            if (object == null) {
                object = HttpMessages.getInstance(this.response.getLocale()).getMessage(this.response.getStatus());
            }
            if (object == null) {
                object = Integer.toString(this.response.getStatus());
            }
            this.tmpMB.setString(object);
        } else {
            this.tmpMB.setString(Integer.toString(this.response.getStatus()));
        }
        this.responseMessage.appendBytes(this.tmpMB);
        object = this.response.getMimeHeaders();
        String string2 = this.response.getContentType();
        if (string2 != null) {
            ((MimeHeaders)object).setValue("Content-Type").setString(string2);
        }
        if ((string = this.response.getContentLanguage()) != null) {
            ((MimeHeaders)object).setValue("Content-Language").setString(string);
        }
        if ((l = this.response.getContentLengthLong()) >= 0L) {
            ((MimeHeaders)object).setValue("Content-Length").setLong(l);
        }
        int n2 = ((MimeHeaders)object).size();
        this.responseMessage.appendInt(n2);
        for (int i = 0; i < n2; ++i) {
            MessageBytes messageBytes2 = ((MimeHeaders)object).getName(i);
            int n3 = org.apache.coyote.ajp.Constants.getResponseAjpIndex(messageBytes2.toString());
            if (n3 > 0) {
                this.responseMessage.appendInt(n3);
            } else {
                this.responseMessage.appendBytes(messageBytes2);
            }
            MessageBytes messageBytes3 = ((MimeHeaders)object).getValue(i);
            this.responseMessage.appendBytes(messageBytes3);
        }
        this.responseMessage.end();
        this.socketWrapper.write(true, this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
        this.socketWrapper.flush(true);
    }

    @Override
    protected final void flush() throws IOException {
        if (!this.responseFinished) {
            if (this.ajpFlush) {
                this.socketWrapper.write(true, flushMessageArray, 0, flushMessageArray.length);
            }
            this.socketWrapper.flush(true);
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        if (this.responseFinished) {
            return;
        }
        this.responseFinished = true;
        if (this.waitingForBodyMessage || this.first && this.request.getContentLengthLong() > 0L) {
            this.refillReadBuffer(true);
        }
        if (this.getErrorState().isError()) {
            this.socketWrapper.write(true, endAndCloseMessageArray, 0, endAndCloseMessageArray.length);
        } else {
            this.socketWrapper.write(true, endMessageArray, 0, endMessageArray.length);
        }
        this.socketWrapper.flush(true);
    }

    @Override
    protected final void ack(ContinueResponseTiming continueResponseTiming) {
    }

    @Override
    protected final int available(boolean bl) {
        if (this.endOfStream) {
            return 0;
        }
        if (this.empty && bl) {
            try {
                this.refillReadBuffer(false);
            }
            catch (IOException iOException) {
                return 1;
            }
        }
        if (this.empty) {
            return 0;
        }
        return this.request.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk byteChunk) {
        int n = byteChunk.getLength();
        this.bodyBytes.setBytes(byteChunk.getBytes(), byteChunk.getStart(), n);
        this.request.setContentLength(n);
        this.first = false;
        this.empty = false;
        this.replay = true;
        this.endOfStream = false;
    }

    @Override
    protected final void setSwallowResponse() {
        this.swallowResponse = true;
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected final boolean getPopulateRequestAttributesFromSocket() {
        return false;
    }

    @Override
    protected final void populateRequestAttributeRemoteHost() {
        if (this.request.remoteHost().isNull()) {
            try {
                this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected final void populateSslRequestAttributes() {
        if (!this.certificates.isNull()) {
            ByteChunk byteChunk = this.certificates.getByteChunk();
            X509Certificate[] x509CertificateArray = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
            try {
                String string = this.getClientCertProvider();
                CertificateFactory certificateFactory = string == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string);
                while (byteArrayInputStream.available() > 0) {
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    if (x509CertificateArray == null) {
                        x509CertificateArray = new X509Certificate[]{x509Certificate};
                        continue;
                    }
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
                    System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
                    x509CertificateArray2[x509CertificateArray.length] = x509Certificate;
                    x509CertificateArray = x509CertificateArray2;
                }
            }
            catch (NoSuchProviderException | CertificateException generalSecurityException) {
                this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)generalSecurityException);
                return;
            }
            this.request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
        }
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.endOfStream;
    }

    @Override
    protected final void registerReadInterest() {
        this.socketWrapper.registerReadInterest();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.responseMsgPos == -1 && this.socketWrapper.isReadyForWrite();
    }

    private boolean read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3 = this.socketWrapper.read(bl, byArray, n, n2);
        if (n3 > 0 && n3 < n2) {
            int n4 = n2 - n3;
            int n5 = n + n3;
            while (n4 > 0) {
                n3 = this.socketWrapper.read(true, byArray, n5, n4);
                if (n3 == -1) {
                    throw new EOFException();
                }
                n4 -= n3;
                n5 += n3;
            }
        } else if (n3 == -1) {
            throw new EOFException();
        }
        return n3 > 0;
    }

    @Deprecated
    private void writeData(ByteChunk byteChunk) throws IOException {
        boolean bl = this.response.getWriteListener() == null;
        int n = byteChunk.getLength();
        int n2 = 0;
        while (n > 0) {
            int n3 = Math.min(n, this.outputMaxChunkSize);
            this.responseMessage.reset();
            this.responseMessage.appendByte(3);
            this.responseMessage.appendBytes(byteChunk.getBytes(), byteChunk.getOffset() + n2, n3);
            this.responseMessage.end();
            this.socketWrapper.write(bl, this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
            this.socketWrapper.flush(bl);
            n -= n3;
            n2 += n3;
        }
        this.bytesWritten += (long)n2;
    }

    private void writeData(ByteBuffer byteBuffer) throws IOException {
        boolean bl = this.response.getWriteListener() == null;
        int n = byteBuffer.remaining();
        int n2 = 0;
        while (n > 0) {
            int n3 = Math.min(n, this.outputMaxChunkSize);
            this.responseMessage.reset();
            this.responseMessage.appendByte(3);
            byteBuffer.limit(byteBuffer.position() + n3);
            this.responseMessage.appendBytes(byteBuffer);
            this.responseMessage.end();
            this.socketWrapper.write(bl, this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
            this.socketWrapper.flush(bl);
            n -= n3;
            n2 += n3;
        }
        this.bytesWritten += (long)n2;
    }

    private boolean hasDataToWrite() {
        return this.responseMsgPos != -1 || this.socketWrapper.hasDataToWrite();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    static {
        AjpMessage ajpMessage = new AjpMessage(16);
        ajpMessage.reset();
        ajpMessage.appendByte(5);
        ajpMessage.appendByte(1);
        ajpMessage.end();
        endMessageArray = new byte[ajpMessage.getLen()];
        System.arraycopy(ajpMessage.getBuffer(), 0, endMessageArray, 0, ajpMessage.getLen());
        AjpMessage ajpMessage2 = new AjpMessage(16);
        ajpMessage2.reset();
        ajpMessage2.appendByte(5);
        ajpMessage2.appendByte(0);
        ajpMessage2.end();
        endAndCloseMessageArray = new byte[ajpMessage2.getLen()];
        System.arraycopy(ajpMessage2.getBuffer(), 0, endAndCloseMessageArray, 0, ajpMessage2.getLen());
        AjpMessage ajpMessage3 = new AjpMessage(16);
        ajpMessage3.reset();
        ajpMessage3.appendByte(3);
        ajpMessage3.appendInt(0);
        ajpMessage3.appendByte(0);
        ajpMessage3.end();
        flushMessageArray = new byte[ajpMessage3.getLen()];
        System.arraycopy(ajpMessage3.getBuffer(), 0, flushMessageArray, 0, ajpMessage3.getLen());
        AjpMessage ajpMessage4 = new AjpMessage(16);
        ajpMessage4.reset();
        ajpMessage4.appendByte(9);
        ajpMessage4.end();
        pongMessageArray = new byte[ajpMessage4.getLen()];
        System.arraycopy(ajpMessage4.getBuffer(), 0, pongMessageArray, 0, ajpMessage4.getLen());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.servlet.request.cipher_suite");
        hashSet.add("javax.servlet.request.key_size");
        hashSet.add("javax.servlet.request.ssl_session");
        hashSet.add("javax.servlet.request.X509Certificate");
        javaxAttributes = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("CERT_ISSUER");
        hashSet2.add("CERT_SUBJECT");
        hashSet2.add("CERT_COOKIE");
        hashSet2.add("HTTPS_SERVER_SUBJECT");
        hashSet2.add("CERT_FLAGS");
        hashSet2.add("HTTPS_SECRETKEYSIZE");
        hashSet2.add("CERT_SERIALNUMBER");
        hashSet2.add("HTTPS_SERVER_ISSUER");
        hashSet2.add("HTTPS_KEYSIZE");
        iisTlsAttributes = Collections.unmodifiableSet(hashSet2);
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        @Deprecated
        public int doWrite(ByteChunk byteChunk) throws IOException {
            if (!AjpProcessor.this.response.isCommitted()) {
                try {
                    AjpProcessor.this.prepareResponse();
                }
                catch (IOException iOException) {
                    AjpProcessor.this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                }
            }
            if (!AjpProcessor.this.swallowResponse) {
                AjpProcessor.this.writeData(byteChunk);
            }
            return byteChunk.getLength();
        }

        @Override
        public int doWrite(ByteBuffer byteBuffer) throws IOException {
            if (!AjpProcessor.this.response.isCommitted()) {
                try {
                    AjpProcessor.this.prepareResponse();
                }
                catch (IOException iOException) {
                    AjpProcessor.this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                }
            }
            int n = 0;
            if (!AjpProcessor.this.swallowResponse) {
                try {
                    n = byteBuffer.remaining();
                    AjpProcessor.this.writeData(byteBuffer);
                    n -= byteBuffer.remaining();
                }
                catch (IOException iOException) {
                    AjpProcessor.this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                    throw iOException;
                }
            }
            return n;
        }

        @Override
        public long getBytesWritten() {
            return AjpProcessor.this.bytesWritten;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        @Deprecated
        public int doRead(ByteChunk byteChunk) throws IOException {
            if (AjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AjpProcessor.this.empty && !AjpProcessor.this.refillReadBuffer(true)) {
                return -1;
            }
            ByteChunk byteChunk2 = AjpProcessor.this.bodyBytes.getByteChunk();
            byteChunk.setBytes(byteChunk2.getBuffer(), byteChunk2.getStart(), byteChunk2.getLength());
            AjpProcessor.this.empty = true;
            return byteChunk.getLength();
        }

        @Override
        public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            if (AjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AjpProcessor.this.empty && !AjpProcessor.this.refillReadBuffer(true)) {
                return -1;
            }
            ByteChunk byteChunk = AjpProcessor.this.bodyBytes.getByteChunk();
            applicationBufferHandler.setByteBuffer(ByteBuffer.wrap(byteChunk.getBuffer(), byteChunk.getStart(), byteChunk.getLength()));
            AjpProcessor.this.empty = true;
            return applicationBufferHandler.getByteBuffer().remaining();
        }

        @Override
        public int available() {
            if (AjpProcessor.this.empty) {
                return 0;
            }
            return AjpProcessor.this.bodyBytes.getByteChunk().getLength();
        }
    }
}

