/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import org.apache.coyote.http2.HPackHuffman;
import org.apache.coyote.http2.Hpack;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.res.StringManager;

public class HpackDecoder {
    protected static final StringManager sm = StringManager.getManager(HpackDecoder.class);
    private static final int DEFAULT_RING_BUFFER_SIZE = 10;
    private HeaderEmitter headerEmitter;
    private Hpack.HeaderField[] headerTable;
    private int firstSlotPosition = 0;
    private int filledTableSlots = 0;
    private int currentMemorySize = 0;
    private int maxMemorySizeHard;
    private int maxMemorySizeSoft;
    private int maxHeaderCount = 100;
    private int maxHeaderSize = 8192;
    private volatile int headerCount = 0;
    private volatile boolean countedCookie;
    private volatile int headerSize = 0;

    HpackDecoder(int n) {
        this.maxMemorySizeHard = n;
        this.maxMemorySizeSoft = n;
        this.headerTable = new Hpack.HeaderField[10];
    }

    HpackDecoder() {
        this(4096);
    }

    void decode(ByteBuffer byteBuffer) throws HpackException {
        while (byteBuffer.hasRemaining()) {
            String string;
            int n = byteBuffer.position();
            byte by = byteBuffer.get();
            if ((by & 0x80) != 0) {
                byteBuffer.position(byteBuffer.position() - 1);
                int n2 = Hpack.decodeInteger(byteBuffer, 7);
                if (n2 == -1) {
                    byteBuffer.position(n);
                    return;
                }
                if (n2 == 0) {
                    throw new HpackException(sm.getString("hpackdecoder.zeroNotValidHeaderTableIndex"));
                }
                this.handleIndex(n2);
                continue;
            }
            if ((by & 0x40) != 0) {
                String string2 = this.readHeaderName(byteBuffer, 6);
                if (string2 == null) {
                    byteBuffer.position(n);
                    return;
                }
                string = this.readHpackString(byteBuffer);
                if (string == null) {
                    byteBuffer.position(n);
                    return;
                }
                this.emitHeader(string2, string);
                this.addEntryToHeaderTable(new Hpack.HeaderField(string2, string));
                continue;
            }
            if ((by & 0xF0) == 0) {
                String string3 = this.readHeaderName(byteBuffer, 4);
                if (string3 == null) {
                    byteBuffer.position(n);
                    return;
                }
                string = this.readHpackString(byteBuffer);
                if (string == null) {
                    byteBuffer.position(n);
                    return;
                }
                this.emitHeader(string3, string);
                continue;
            }
            if ((by & 0xF0) == 16) {
                String string4 = this.readHeaderName(byteBuffer, 4);
                if (string4 == null) {
                    byteBuffer.position(n);
                    return;
                }
                string = this.readHpackString(byteBuffer);
                if (string == null) {
                    byteBuffer.position(n);
                    return;
                }
                this.emitHeader(string4, string);
                continue;
            }
            if ((by & 0xE0) == 32) {
                if (this.handleMaxMemorySizeChange(byteBuffer, n)) continue;
                return;
            }
            throw new RuntimeException(sm.getString("hpackdecoder.notImplemented"));
        }
    }

    private boolean handleMaxMemorySizeChange(ByteBuffer byteBuffer, int n) throws HpackException {
        if (this.headerCount != 0) {
            throw new HpackException(sm.getString("hpackdecoder.tableSizeUpdateNotAtStart"));
        }
        byteBuffer.position(byteBuffer.position() - 1);
        int n2 = Hpack.decodeInteger(byteBuffer, 5);
        if (n2 == -1) {
            byteBuffer.position(n);
            return false;
        }
        if (n2 > this.maxMemorySizeHard) {
            throw new HpackException(sm.getString("hpackdecoder.maxMemorySizeExceeded", new Object[]{n2, this.maxMemorySizeHard}));
        }
        this.maxMemorySizeSoft = n2;
        if (this.currentMemorySize > this.maxMemorySizeSoft) {
            int n3 = this.filledTableSlots;
            int n4 = this.headerTable.length;
            int n5 = this.currentMemorySize;
            while (n5 > this.maxMemorySizeSoft) {
                int n6 = this.firstSlotPosition++;
                if (this.firstSlotPosition == n4) {
                    this.firstSlotPosition = 0;
                }
                Hpack.HeaderField headerField = this.headerTable[n6];
                this.headerTable[n6] = null;
                n5 -= headerField.size;
                --n3;
            }
            this.filledTableSlots = n3;
            this.currentMemorySize = n5;
        }
        return true;
    }

    private String readHeaderName(ByteBuffer byteBuffer, int n) throws HpackException {
        byteBuffer.position(byteBuffer.position() - 1);
        int n2 = Hpack.decodeInteger(byteBuffer, n);
        if (n2 == -1) {
            return null;
        }
        if (n2 != 0) {
            return this.handleIndexedHeaderName(n2);
        }
        return this.readHpackString(byteBuffer);
    }

    private String readHpackString(ByteBuffer byteBuffer) throws HpackException {
        boolean bl;
        if (!byteBuffer.hasRemaining()) {
            return null;
        }
        byte by = byteBuffer.get(byteBuffer.position());
        int n = Hpack.decodeInteger(byteBuffer, 7);
        if (byteBuffer.remaining() < n) {
            return null;
        }
        boolean bl2 = bl = (by & 0x80) != 0;
        if (bl) {
            return this.readHuffmanString(n, byteBuffer);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)byteBuffer.get());
        }
        return stringBuilder.toString();
    }

    private String readHuffmanString(int n, ByteBuffer byteBuffer) throws HpackException {
        StringBuilder stringBuilder = new StringBuilder(n);
        HPackHuffman.decode(byteBuffer, n, stringBuilder);
        return stringBuilder.toString();
    }

    private String handleIndexedHeaderName(int n) throws HpackException {
        if (n <= Hpack.STATIC_TABLE_LENGTH) {
            return Hpack.STATIC_TABLE[n].name;
        }
        if (n > Hpack.STATIC_TABLE_LENGTH + this.filledTableSlots) {
            throw new HpackException(sm.getString("hpackdecoder.headerTableIndexInvalid", new Object[]{n, Hpack.STATIC_TABLE_LENGTH, this.filledTableSlots}));
        }
        int n2 = this.getRealIndex(n - Hpack.STATIC_TABLE_LENGTH);
        Hpack.HeaderField headerField = this.headerTable[n2];
        if (headerField == null) {
            throw new HpackException(sm.getString("hpackdecoder.nullHeader", new Object[]{n}));
        }
        return headerField.name;
    }

    private void handleIndex(int n) throws HpackException {
        if (n <= Hpack.STATIC_TABLE_LENGTH) {
            this.addStaticTableEntry(n);
        } else {
            int n2 = this.getRealIndex(n - Hpack.STATIC_TABLE_LENGTH);
            Hpack.HeaderField headerField = this.headerTable[n2];
            this.emitHeader(headerField.name, headerField.value);
        }
    }

    int getRealIndex(int n) throws HpackException {
        int n2 = (this.firstSlotPosition + (this.filledTableSlots - n)) % this.headerTable.length;
        if (n2 < 0) {
            throw new HpackException(sm.getString("hpackdecoder.headerTableIndexInvalid", new Object[]{n, Hpack.STATIC_TABLE_LENGTH, this.filledTableSlots}));
        }
        return n2;
    }

    private void addStaticTableEntry(int n) throws HpackException {
        Hpack.HeaderField headerField = Hpack.STATIC_TABLE[n];
        this.emitHeader(headerField.name, headerField.value == null ? "" : headerField.value);
    }

    private void addEntryToHeaderTable(Hpack.HeaderField headerField) {
        if (headerField.size > this.maxMemorySizeSoft) {
            while (this.filledTableSlots > 0) {
                this.headerTable[this.firstSlotPosition] = null;
                ++this.firstSlotPosition;
                if (this.firstSlotPosition == this.headerTable.length) {
                    this.firstSlotPosition = 0;
                }
                --this.filledTableSlots;
            }
            this.currentMemorySize = 0;
            return;
        }
        this.resizeIfRequired();
        int n = this.filledTableSlots + 1;
        int n2 = this.headerTable.length;
        int n3 = (this.firstSlotPosition + this.filledTableSlots) % n2;
        this.headerTable[n3] = headerField;
        int n4 = this.currentMemorySize + headerField.size;
        while (n4 > this.maxMemorySizeSoft) {
            int n5 = this.firstSlotPosition++;
            if (this.firstSlotPosition == n2) {
                this.firstSlotPosition = 0;
            }
            Hpack.HeaderField headerField2 = this.headerTable[n5];
            this.headerTable[n5] = null;
            n4 -= headerField2.size;
            --n;
        }
        this.filledTableSlots = n;
        this.currentMemorySize = n4;
    }

    private void resizeIfRequired() {
        if (this.filledTableSlots == this.headerTable.length) {
            Hpack.HeaderField[] headerFieldArray = new Hpack.HeaderField[this.headerTable.length + 10];
            for (int i = 0; i < this.headerTable.length; ++i) {
                headerFieldArray[i] = this.headerTable[(this.firstSlotPosition + i) % this.headerTable.length];
            }
            this.firstSlotPosition = 0;
            this.headerTable = headerFieldArray;
        }
    }

    HeaderEmitter getHeaderEmitter() {
        return this.headerEmitter;
    }

    void setHeaderEmitter(HeaderEmitter headerEmitter) {
        this.headerEmitter = headerEmitter;
        this.headerCount = 0;
        this.countedCookie = false;
        this.headerSize = 0;
    }

    void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    void setMaxHeaderSize(int n) {
        this.maxHeaderSize = n;
    }

    private void emitHeader(String string, String string2) throws HpackException {
        if ("cookie".equals(string)) {
            if (!this.countedCookie) {
                ++this.headerCount;
                this.countedCookie = true;
            }
        } else {
            ++this.headerCount;
        }
        int n = 3 + string.length() + string2.length();
        this.headerSize += n;
        if (!this.isHeaderCountExceeded() && !this.isHeaderSizeExceeded(0)) {
            this.headerEmitter.emitHeader(string, string2);
        }
    }

    boolean isHeaderCountExceeded() {
        if (this.maxHeaderCount < 0) {
            return false;
        }
        return this.headerCount > this.maxHeaderCount;
    }

    boolean isHeaderSizeExceeded(int n) {
        if (this.maxHeaderSize < 0) {
            return false;
        }
        return this.headerSize + n > this.maxHeaderSize;
    }

    boolean isHeaderSwallowSizeExceeded(int n) {
        if (this.maxHeaderSize < 0) {
            return false;
        }
        return this.headerSize + n > 2 * this.maxHeaderSize;
    }

    int getFirstSlotPosition() {
        return this.firstSlotPosition;
    }

    Hpack.HeaderField[] getHeaderTable() {
        return this.headerTable;
    }

    int getFilledTableSlots() {
        return this.filledTableSlots;
    }

    int getCurrentMemorySize() {
        return this.currentMemorySize;
    }

    int getMaxMemorySizeSoft() {
        return this.maxMemorySizeSoft;
    }

    static interface HeaderEmitter {
        public void emitHeader(String var1, String var2) throws HpackException;

        public void setHeaderException(StreamException var1);

        public void validateHeaders() throws StreamException;
    }
}

