/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEUtil;
import org.apache.tomcat.util.res.StringManager;
import sun.rmi.registry.RegistryImpl;

@Deprecated
public class JmxRemoteLifecycleListener
extends SSLHostConfig
implements LifecycleListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JmxRemoteLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(JmxRemoteLifecycleListener.class);
    protected String rmiBindAddress = null;
    protected int rmiRegistryPortPlatform = -1;
    protected int rmiServerPortPlatform = -1;
    protected boolean rmiRegistrySSL = true;
    protected boolean rmiServerSSL = true;
    protected boolean authenticate = true;
    protected String passwordFile = null;
    protected String loginModuleName = null;
    protected String accessFile = null;
    protected boolean useLocalPorts = false;
    protected transient JMXConnectorServer csPlatform = null;

    public String getRmiBindAddress() {
        return this.rmiBindAddress;
    }

    public void setRmiBindAddress(String string) {
        this.rmiBindAddress = string;
    }

    public int getRmiServerPortPlatform() {
        return this.rmiServerPortPlatform;
    }

    public void setRmiServerPortPlatform(int n) {
        this.rmiServerPortPlatform = n;
    }

    public int getRmiRegistryPortPlatform() {
        return this.rmiRegistryPortPlatform;
    }

    public void setRmiRegistryPortPlatform(int n) {
        this.rmiRegistryPortPlatform = n;
    }

    public boolean getUseLocalPorts() {
        return this.useLocalPorts;
    }

    public void setUseLocalPorts(boolean bl) {
        this.useLocalPorts = bl;
    }

    public boolean isRmiRegistrySSL() {
        return this.rmiRegistrySSL;
    }

    public void setRmiRegistrySSL(boolean bl) {
        this.rmiRegistrySSL = bl;
    }

    public boolean isRmiServerSSL() {
        return this.rmiServerSSL;
    }

    public void setRmiServerSSL(boolean bl) {
        this.rmiServerSSL = bl;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean bl) {
        this.authenticate = bl;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String string) {
        this.passwordFile = string;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public void setLoginModuleName(String string) {
        this.loginModuleName = string;
    }

    public String getAccessFile() {
        return this.accessFile;
    }

    public void setAccessFile(String string) {
        this.accessFile = string;
    }

    protected void init() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9 = System.getProperty("com.sun.management.jmxremote.registry.ssl");
        if (string9 != null) {
            this.setRmiRegistrySSL(Boolean.parseBoolean(string9));
        }
        if ((string8 = System.getProperty("com.sun.management.jmxremote.ssl")) != null) {
            this.setRmiServerSSL(Boolean.parseBoolean(string8));
        }
        if ((string7 = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols")) != null) {
            this.setEnabledProtocols(string7.split(","));
        }
        if ((string6 = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites")) != null) {
            this.setCiphers(string6);
        }
        if ((string5 = System.getProperty("com.sun.management.jmxremote.ssl.need.client.auth")) != null) {
            this.setCertificateVerification(string5);
        }
        if ((string4 = System.getProperty("com.sun.management.jmxremote.authenticate")) != null) {
            this.setAuthenticate(Boolean.parseBoolean(string4));
        }
        if ((string3 = System.getProperty("com.sun.management.jmxremote.password.file")) != null) {
            this.setPasswordFile(string3);
        }
        if ((string2 = System.getProperty("com.sun.management.jmxremote.access.file")) != null) {
            this.setAccessFile(string2);
        }
        if ((string = System.getProperty("com.sun.management.jmxremote.login.config")) != null) {
            this.setLoginModuleName(string);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_init".equals(lifecycleEvent.getType())) {
            log.warn((Object)sm.getString("jmxRemoteLifecycleListener.deprecated"));
        } else if ("start".equals(lifecycleEvent.getType())) {
            Object object;
            Object object2;
            Object object3;
            this.init();
            SSLContext sSLContext = null;
            if (this.getCertificates().size() > 0) {
                object3 = (SSLHostConfigCertificate)this.getCertificates().iterator().next();
                object2 = new JSSEUtil((SSLHostConfigCertificate)object3);
                try {
                    sSLContext = SSLContext.getInstance(this.getSslProtocol());
                    this.setEnabledProtocols(object2.getEnabledProtocols());
                    this.setEnabledCiphers(object2.getEnabledCiphers());
                    sSLContext.init(object2.getKeyManagers(), object2.getTrustManagers(), null);
                    object = sSLContext.getServerSessionContext();
                    if (object != null) {
                        object2.configureSessionContext((SSLSessionContext)object);
                    }
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidSSLConfiguration"), (Throwable)exception);
                }
            }
            System.setProperty("java.rmi.server.randomIDs", "true");
            object3 = new HashMap();
            object2 = null;
            object = null;
            RMIClientSocketFactory rMIClientSocketFactory = null;
            RMIServerSocketFactory rMIServerSocketFactory = null;
            if (this.rmiRegistrySSL) {
                object2 = new SslRMIClientSocketFactory();
                object = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(sSLContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) : new SslRmiServerBindSocketFactory(sSLContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                object = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiServerSSL) {
                rMIClientSocketFactory = new SslRMIClientSocketFactory();
                rMIServerSocketFactory = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(sSLContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) : new SslRmiServerBindSocketFactory(sSLContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                rMIServerSocketFactory = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiBindAddress != null) {
                System.setProperty("java.rmi.server.hostname", this.rmiBindAddress);
            }
            if (this.useLocalPorts) {
                object2 = new RmiClientLocalhostSocketFactory((RMIClientSocketFactory)object2);
                rMIClientSocketFactory = new RmiClientLocalhostSocketFactory(rMIClientSocketFactory);
            }
            object3.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
            if (rMIClientSocketFactory != null) {
                object3.put("jmx.remote.rmi.client.socket.factory", rMIClientSocketFactory);
                object3.put("com.sun.jndi.rmi.factory.socket", object2);
            }
            if (rMIServerSocketFactory != null) {
                object3.put("jmx.remote.rmi.server.socket.factory", rMIServerSocketFactory);
            }
            if (this.authenticate) {
                object3.put("jmx.remote.x.password.file", this.passwordFile);
                object3.put("jmx.remote.x.access.file", this.accessFile);
                object3.put("jmx.remote.x.login.config", this.loginModuleName);
            }
            this.csPlatform = this.createServer("Platform", this.rmiBindAddress, this.rmiRegistryPortPlatform, this.rmiServerPortPlatform, (Map<String, Object>)object3, (RMIClientSocketFactory)object2, (RMIServerSocketFactory)object, rMIClientSocketFactory, rMIServerSocketFactory);
        } else if ("stop".equals(lifecycleEvent.getType())) {
            this.destroyServer("Platform", this.csPlatform);
        }
    }

    private JMXConnectorServer createServer(String string, String string2, int n, int n2, Map<String, Object> map, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, RMIClientSocketFactory rMIClientSocketFactory2, RMIServerSocketFactory rMIServerSocketFactory2) {
        JMXServiceURL jMXServiceURL;
        if (string2 == null) {
            string2 = "localhost";
        }
        String string3 = "service:jmx:rmi://" + string2;
        try {
            jMXServiceURL = new JMXServiceURL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidURL", new Object[]{string, string3}), (Throwable)malformedURLException);
            return null;
        }
        RMIConnectorServer rMIConnectorServer = null;
        try {
            RMIJRMPServerImpl rMIJRMPServerImpl = new RMIJRMPServerImpl(this.rmiServerPortPlatform, rMIClientSocketFactory2, rMIServerSocketFactory2, map);
            rMIConnectorServer = new RMIConnectorServer(jMXServiceURL, map, rMIJRMPServerImpl, ManagementFactory.getPlatformMBeanServer());
            rMIConnectorServer.start();
            Remote remote = rMIJRMPServerImpl.toStub();
            try {
                JmxRegistry jmxRegistry = new JmxRegistry(n, rMIClientSocketFactory, rMIServerSocketFactory, "jmxrmi", remote);
            }
            catch (RemoteException remoteException) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.createRegistryFailed", new Object[]{string, Integer.toString(n)}), (Throwable)remoteException);
                return null;
            }
            log.info((Object)sm.getString("jmxRemoteLifecycleListener.start", new Object[]{Integer.toString(n), Integer.toString(n2), string}));
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createServerFailed", new Object[]{string}), (Throwable)iOException);
        }
        return rMIConnectorServer;
    }

    private void destroyServer(String string, JMXConnectorServer jMXConnectorServer) {
        if (jMXConnectorServer != null) {
            try {
                jMXConnectorServer.stop();
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.destroyServerFailed", new Object[]{string}), (Throwable)iOException);
            }
        }
    }

    private static class JmxRegistry
    extends RegistryImpl {
        private static final long serialVersionUID = -3772054804656428217L;
        private final String jmxName;
        private final Remote jmxServer;

        public JmxRegistry(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, String string, Remote remote) throws RemoteException {
            super(n, rMIClientSocketFactory, rMIServerSocketFactory);
            this.jmxName = string;
            this.jmxServer = remote;
        }

        @Override
        public Remote lookup(String string) throws RemoteException, NotBoundException {
            return this.jmxName.equals(string) ? this.jmxServer : null;
        }

        @Override
        public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        }

        @Override
        public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        }

        @Override
        public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        }

        @Override
        public String[] list() throws RemoteException {
            return new String[]{this.jmxName};
        }
    }

    public static class SslRmiServerBindSocketFactory
    extends SslRMIServerSocketFactory {
        private final InetAddress bindAddress;
        private final SSLContext sslContext;

        public SslRmiServerBindSocketFactory(SSLContext sSLContext, String[] stringArray, String[] stringArray2, boolean bl, String string) {
            super(sSLContext, stringArray, stringArray2, bl);
            this.sslContext = sSLContext;
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{string}), (Throwable)unknownHostException);
            }
            this.bindAddress = inetAddress;
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            SSLServerSocketFactory sSLServerSocketFactory = this.sslContext == null ? (SSLServerSocketFactory)SSLServerSocketFactory.getDefault() : this.sslContext.getServerSocketFactory();
            SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n, 0, this.bindAddress);
            if (this.getEnabledCipherSuites() != null) {
                sSLServerSocket.setEnabledCipherSuites(this.getEnabledCipherSuites());
            }
            if (this.getEnabledProtocols() != null) {
                sSLServerSocket.setEnabledProtocols(this.getEnabledProtocols());
            }
            sSLServerSocket.setNeedClientAuth(this.getNeedClientAuth());
            return sSLServerSocket;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.bindAddress == null ? 0 : this.bindAddress.hashCode());
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SslRmiServerBindSocketFactory sslRmiServerBindSocketFactory = (SslRmiServerBindSocketFactory)object;
            return !(this.bindAddress == null ? sslRmiServerBindSocketFactory.bindAddress != null : !this.bindAddress.equals(sslRmiServerBindSocketFactory.bindAddress));
        }
    }

    public static class RmiServerBindSocketFactory
    implements RMIServerSocketFactory {
        private final InetAddress bindAddress;

        public RmiServerBindSocketFactory(String string) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{string}), (Throwable)unknownHostException);
            }
            this.bindAddress = inetAddress;
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            return new ServerSocket(n, 0, this.bindAddress);
        }
    }

    public static class RmiClientLocalhostSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FORCED_HOST = "localhost";
        private final RMIClientSocketFactory factory;

        public RmiClientLocalhostSocketFactory(RMIClientSocketFactory rMIClientSocketFactory) {
            this.factory = rMIClientSocketFactory;
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException {
            if (this.factory == null) {
                return new Socket(FORCED_HOST, n);
            }
            return this.factory.createSocket(FORCED_HOST, n);
        }
    }
}

