/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

class WrapperInplaceEditor
extends JPanel
implements InplaceEditor,
ActionListener,
FocusListener {
    private EnhancedPropertyEditor enh;
    private PropertyModel mdl;
    private Component legacy = null;
    private transient List<ActionListener> actionListenerList;
    private boolean listenerAdded = false;
    private boolean suspendEvents = false;
    private EventListenerList listenerList = null;

    WrapperInplaceEditor(EnhancedPropertyEditor enhancedPropertyEditor) {
        this.enh = enhancedPropertyEditor;
        this.setLayout(new BorderLayout());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getActionMap().put("enter", new EnterKbdAction());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        focusEvent.setSource(this);
        this.fireFocusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        focusEvent.setSource(this);
        this.fireFocusLost(focusEvent);
    }

    @Override
    public void clear() {
        if (this.legacy != null) {
            this.removeAll();
            if (this.listenerAdded) {
                this.tryRemoveActionListener(this.legacy);
            }
            this.legacy.removeFocusListener(this);
            this.legacy = null;
        }
        this.enh = null;
        this.listenerAdded = false;
    }

    private boolean tryAddActionListener(Component component) {
        try {
            Method method = component.getClass().getMethod("addActionListener", ActionListener.class);
            if (method != null) {
                method.invoke((Object)component, this);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean tryRemoveActionListener(Component component) {
        try {
            Method method = component.getClass().getMethod("removeActionListener", ActionListener.class);
            if (method != null) {
                method.invoke((Object)component, this);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireAction(new ActionEvent(this, 1001, "success"));
    }

    @Override
    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        if (this.legacy != null) {
            this.clear();
        }
        if (propertyEditor != this.enh) {
            this.enh = (EnhancedPropertyEditor)propertyEditor;
        }
        Component component = this.getLegacyInplaceEditor();
        this.add(component, "Center");
        this.listenerAdded = this.tryAddActionListener(component);
        component.addFocusListener(this);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public KeyStroke[] getKeyStrokes() {
        if (this.getLegacyInplaceEditor() instanceof JComboBox) {
            return ComboInplaceEditor.cbKeyStrokes;
        }
        return null;
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return this.enh;
    }

    @Override
    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    @Override
    public Object getValue() {
        return this.enh.getValue();
    }

    public void handleInitialInputEvent(InputEvent inputEvent) {
    }

    @Override
    public boolean isKnownComponent(Component component) {
        return this.isAncestorOf(component);
    }

    @Override
    public void reset() {
        this.suspendEvents = true;
        try {
            if (this.legacy instanceof JTextComponent) {
                ((JTextComponent)this.legacy).setText(this.enh.getAsText());
            } else if (this.legacy instanceof JComboBox) {
                if (((JComboBox)this.legacy).isEditable()) {
                    if (((JComboBox)this.legacy).getEditor().getEditorComponent().isShowing()) {
                        ((JComboBox)this.legacy).getEditor().setItem(this.enh.getValue());
                    }
                } else {
                    ((JComboBox)this.legacy).setSelectedItem(this.enh.getValue());
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(WrapperInplaceEditor.class.getName()).log(Level.WARNING, "Failure resetting legacy editor", exception);
        }
        finally {
            this.suspendEvents = false;
        }
    }

    @Override
    public void setPropertyModel(PropertyModel propertyModel) {
        this.mdl = propertyModel;
    }

    @Override
    public void setValue(Object object) {
        this.suspendEvents = true;
        try {
            if (this.legacy instanceof JTextComponent) {
                ((JTextComponent)this.legacy).setText(object.toString());
            } else if (this.legacy instanceof JComboBox) {
                if (((JComboBox)this.legacy).isEditable()) {
                    if (((JComboBox)this.legacy).getEditor().getEditorComponent().isShowing()) {
                        ((JComboBox)this.legacy).getEditor().setItem(object.toString());
                    }
                } else {
                    ((JComboBox)this.legacy).setSelectedItem(object);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(WrapperInplaceEditor.class.getName()).log(Level.WARNING, "Failure resetting legacy editor", exception);
        }
        finally {
            this.suspendEvents = false;
        }
    }

    @Override
    public boolean supportsTextEntry() {
        if (this.legacy instanceof JTextComponent) {
            return true;
        }
        return this.legacy instanceof JComboBox && ((JComboBox)this.legacy).isEditable();
    }

    private Component getLegacyInplaceEditor() {
        if (this.legacy == null) {
            this.legacy = this.enh.getInPlaceCustomEditor();
        }
        return this.legacy;
    }

    @Override
    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList<ActionListener>();
        }
        this.actionListenerList.add(actionListener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAction(ActionEvent actionEvent) {
        List list;
        if (this.suspendEvents) {
            return;
        }
        WrapperInplaceEditor wrapperInplaceEditor = this;
        synchronized (wrapperInplaceEditor) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.actionListenerList).clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(actionEvent);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(FocusListener.class, focusListener);
        super.addFocusListener(focusListener);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.listenerList.remove(FocusListener.class, focusListener);
        super.removeFocusListener(focusListener);
    }

    private void fireFocusGained(FocusEvent focusEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FocusListener.class) continue;
            ((FocusListener)objectArray[i + 1]).focusGained(focusEvent);
        }
    }

    private void fireFocusLost(FocusEvent focusEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FocusListener.class) continue;
            ((FocusListener)objectArray[i + 1]).focusLost(focusEvent);
        }
    }

    private class EnterKbdAction
    extends AbstractAction {
        private EnterKbdAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WrapperInplaceEditor.this.fireAction(new ActionEvent(WrapperInplaceEditor.this, 1001, "success"));
        }
    }
}

