/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.printpreview;

import freemind.view.mindmapview.MapView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.JComponent;

class Preview
extends JComponent {
    private static final int DEFAULT_PREVIEW_SIZE = 300;
    private static final double MINIMUM_ZOOM_FACTOR = 0.1;
    private BufferedImage previewPageImage = null;
    private Graphics2D imageGraphics;
    protected MapView view;
    protected int index = 0;
    protected double zoom = 0.0;

    public Preview(MapView view, double zoom) {
        this.view = view;
        PageFormat format = this.getPageFormat();
        this.zoom = zoom == 0.0 ? (format.getOrientation() == 1 ? 300.0 / format.getHeight() : 300.0 / format.getWidth()) : zoom;
        this.resize();
    }

    protected void paintPaper(Graphics g, PageFormat format) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getPageWidth(format), this.getPageHeight(format));
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getPageWidth(format) - 1, this.getPageHeight(format) - 1);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        PageFormat format = this.getPageFormat();
        this.paintPaper(g, format);
        if (this.previewPageImage == null) {
            this.previewPageImage = (BufferedImage)this.createImage(this.getPageWidth(format) - 1, this.getPageHeight(format) - 1);
            this.imageGraphics = this.previewPageImage.createGraphics();
            this.imageGraphics.scale(this.zoom, this.zoom);
            while (1 == this.view.print(this.imageGraphics, format, this.index) && this.index > 0) {
                --this.index;
            }
        }
        g2d.drawImage((Image)this.previewPageImage, 0, 0, this);
    }

    private int getPageHeight(PageFormat format) {
        return (int)(format.getHeight() * this.zoom);
    }

    private int getPageWidth(PageFormat format) {
        return (int)(format.getWidth() * this.zoom);
    }

    public void moveIndex(int indexStep) {
        int newIndex = this.index + indexStep;
        if (newIndex >= 0) {
            this.index = newIndex;
            this.previewPageImage = null;
        }
    }

    public void changeZoom(double zoom) {
        this.zoom = Math.max(0.1, this.zoom + zoom);
        this.resize();
    }

    public void resize() {
        int size = (int)Math.max(this.getPageFormat().getWidth() * this.zoom, this.getPageFormat().getHeight() * this.zoom);
        this.setPreferredSize(new Dimension(size, size));
        this.previewPageImage = null;
        this.revalidate();
    }

    private PageFormat getPageFormat() {
        return this.view.getController().getPageFormat();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPageIndex() {
        return this.index;
    }
}

