/*
 * Decompiled with CFR 0.152.
 */
package plugins.svg;

import freemind.controller.Controller;
import freemind.main.Tools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ExportPdfDialog
extends JDialog {
    private static final String PORTRAIT = "portrait";
    private static final String LANDSCAPE = "landscape";
    private static final String PROP_PDF_PAGE_FORMAT = "pdf_page_format";
    private static final String PROP_PDF_PAGE_ORIENTATION = "pdf_page_orientation";
    private String format;
    private String[] formatsCollection;
    private Controller controller;
    private int orientation;
    private JComboBox listBox;
    private JRadioButton birdButtonLandscape;
    private JRadioButton birdButtonPortrait;
    private ButtonGroup group;
    private boolean mResult = true;

    public String getFormat() {
        return this.format;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public ExportPdfDialog(Frame owner, String[] formats, Controller controller) {
        super(owner);
        this.formatsCollection = formats;
        this.controller = controller;
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.setTitle(this.controller.getResourceString("ExportPdfDialog.PDF_Export_Settings"));
        this.setPreferredSize(new Dimension(400, 150));
        JLabel labelPaper = new JLabel(this.controller.getResourceString("ExportPdfDialog.Size_"));
        Arrays.sort(this.formatsCollection);
        this.listBox = new JComboBox<String>(this.formatsCollection);
        this.listBox.setEditable(false);
        this.listBox.setPreferredSize(new Dimension(100, 25));
        this.birdButtonLandscape = new JRadioButton(this.controller.getResourceString("ExportPdfDialog.Landscape"));
        this.birdButtonLandscape.setMnemonic(76);
        this.birdButtonLandscape.setSelected(true);
        this.birdButtonPortrait = new JRadioButton(this.controller.getResourceString("ExportPdfDialog.Portrait"));
        this.birdButtonPortrait.setMnemonic(80);
        this.group = new ButtonGroup();
        this.group.add(this.birdButtonLandscape);
        this.group.add(this.birdButtonPortrait);
        JButton jOKButton = new JButton();
        jOKButton.setPreferredSize(new Dimension(100, 20));
        jOKButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPdfDialog.this.okPressed();
            }
        });
        jOKButton.setText(this.controller.getResourceString("ExportPdfDialog.OK"));
        JPanel panel1 = new JPanel();
        panel1.setBorder(BorderFactory.createTitledBorder(this.controller.getResourceString("ExportPdfDialog.Paper")));
        GridBagLayout gridbag1 = new GridBagLayout();
        panel1.setLayout(gridbag1);
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createTitledBorder(this.controller.getResourceString("ExportPdfDialog.Orientation")));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        panel1.add((Component)labelPaper, c);
        c.gridx = 1;
        panel1.add((Component)this.listBox, c);
        panel2.add(this.birdButtonLandscape);
        panel2.add(this.birdButtonPortrait);
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)panel1, c);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)panel2, c);
        c.fill = 10;
        c.anchor = 20;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)jOKButton, c);
        this.initDefaults();
        Tools.addEscapeActionToDialog((JDialog)this);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(panel);
        this.getRootPane().setDefaultButton(jOKButton);
        this.pack();
    }

    private void initDefaults() {
        String storedFormat;
        String storedOrientation = this.controller.getProperty(PROP_PDF_PAGE_ORIENTATION);
        if (storedOrientation != null) {
            if (Tools.safeEquals((String)storedOrientation, (String)LANDSCAPE)) {
                this.birdButtonLandscape.setSelected(true);
            } else {
                this.birdButtonPortrait.setSelected(true);
            }
        }
        if ((storedFormat = this.controller.getProperty(PROP_PDF_PAGE_FORMAT)) != null) {
            this.listBox.setSelectedItem(storedFormat);
        }
    }

    private void storeDefaults() {
        if (this.orientation == 0) {
            this.controller.setProperty(PROP_PDF_PAGE_ORIENTATION, LANDSCAPE);
        } else if (this.orientation == 1) {
            this.controller.setProperty(PROP_PDF_PAGE_ORIENTATION, PORTRAIT);
        }
        this.controller.setProperty(PROP_PDF_PAGE_FORMAT, this.format);
    }

    private void okPressed() {
        this.format = (String)this.listBox.getSelectedItem();
        this.orientation = this.birdButtonLandscape.isSelected() ? 0 : 1;
        this.storeDefaults();
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        this.mResult = false;
        super.dispose();
    }

    public boolean getResult() {
        return this.mResult;
    }
}

