/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.ListDirectoryBrowserTask;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

class BrowserView
extends JPanel {
    private final VFSBrowser browser;
    private final JSplitPane splitPane;
    private final JList parentDirectories;
    private final VFSDirectoryEntryTable table;
    private final Set<String> tmpExpanded;
    private BrowserCommandsMenu popup;
    private boolean showIcons;

    BrowserView(VFSBrowser vFSBrowser) {
        this.browser = vFSBrowser;
        this.tmpExpanded = new HashSet<String>();
        DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
        KeyListener keyListener = dockableWindowManager.closeListener("vfs.browser");
        this.parentDirectories = new ParentDirectoryList();
        this.parentDirectories.addKeyListener(keyListener);
        this.parentDirectories.setName("parent");
        this.parentDirectories.getSelectionModel().setSelectionMode(0);
        this.parentDirectories.setCellRenderer(new ParentDirectoryRenderer());
        this.parentDirectories.setVisibleRowCount(5);
        this.parentDirectories.addMouseListener(new ParentMouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.parentDirectories);
        jScrollPane.setMinimumSize(new Dimension(0, 0));
        this.table = new VFSDirectoryEntryTable(this);
        this.table.addMouseListener(new TableMouseHandler());
        this.table.addKeyListener(new TableKeyListener());
        this.table.setName("file");
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setMinimumSize(new Dimension(0, 0));
        jScrollPane2.getViewport().setBackground(this.table.getBackground());
        jScrollPane2.getViewport().addMouseListener(new TableMouseHandler());
        this.splitPane = new JSplitPane(vFSBrowser.isHorizontalLayout() ? 1 : 0, jScrollPane, jScrollPane2);
        this.splitPane.setOneTouchExpandable(true);
        EventQueue.invokeLater(() -> this.parentDirectories.ensureIndexIsVisible(this.parentDirectories.getModel().getSize()));
        if (vFSBrowser.isMultipleSelectionEnabled()) {
            this.table.getSelectionModel().setSelectionMode(2);
        } else {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
        this.propertiesChanged();
    }

    public void focusOnFileView() {
        this.table.requestFocus();
    }

    public VFSFile[] getSelectedFiles() {
        return this.table.getSelectedFiles();
    }

    public void selectNone() {
        this.table.clearSelection();
    }

    public void saveExpansionState() {
        this.tmpExpanded.clear();
        this.table.getExpandedDirectories(this.tmpExpanded);
    }

    public void clearExpansionState() {
        this.tmpExpanded.clear();
    }

    public void loadDirectory(Object object, String string, boolean bl) {
        this.loadDirectory(object, string, bl, null);
    }

    public void loadDirectory(Object object, String string, boolean bl, Runnable runnable) {
        string = MiscUtilities.constructPath(this.browser.getDirectory(), string);
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object2 = vFS.createVFSSession(string, this);
        if (object2 == null) {
            if (runnable != null) {
                ThreadUtilities.runInDispatchThread(runnable);
            }
            return;
        }
        if (object == null) {
            this.parentDirectories.setListData(new Object[]{new LoadingPlaceholder()});
        }
        Object[] objectArray = new Object[2];
        Runnable runnable2 = () -> {
            this.browser.directoryLoaded(object, objectArray, bl);
            if (runnable != null) {
                runnable.run();
            }
            this.splitPane.setDividerLocation(-1);
        };
        ThreadUtilities.runInBackground(new ListDirectoryBrowserTask(this.browser, object2, vFS, string, objectArray, runnable2));
    }

    public void directoryLoaded(Object object, String string, List<VFSFile> list) {
        if (object == null) {
            DefaultListModel<VFSFile> defaultListModel = new DefaultListModel<VFSFile>();
            Object object2 = string;
            while (true) {
                Object object3;
                VFS vFS = VFSManager.getVFSForPath((String)object2);
                VFSFile vFSFile = null;
                if (vFS instanceof FileVFS) {
                    object3 = vFS.createVFSSession(string, this.browser);
                    try {
                        vFSFile = vFS._getFile(object3, (String)object2, this.browser);
                        if (vFSFile != null) {
                            vFSFile.setName(vFS.getFileName((String)object2));
                        }
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException, iOException);
                    }
                }
                if (vFSFile == null) {
                    vFSFile = new VFSFile(vFS.getFileName((String)object2), (String)object2, (String)object2, 1, 0L, false);
                }
                defaultListModel.insertElementAt(vFSFile, 0);
                object3 = vFS.getParentOfPath((String)object2);
                if (MiscUtilities.pathsEqual((String)object2, (String)object3)) break;
                object2 = object3;
            }
            this.parentDirectories.setModel(defaultListModel);
            int n = defaultListModel.getSize() - 1;
            this.parentDirectories.setSelectedIndex(n);
            this.parentDirectories.ensureIndexIsVisible(n);
        }
        this.table.setDirectory(VFSManager.getVFSForPath(string), object, list, this.tmpExpanded);
    }

    public void updateFileView() {
        this.table.repaint();
    }

    public void maybeReloadDirectory(String string) {
        String string2 = this.browser.getDirectory();
        String string3 = MiscUtilities.isURL(string2) ? string2 : MiscUtilities.resolveSymlinks(string2);
        if (MiscUtilities.pathsEqual(string, string3)) {
            this.saveExpansionState();
            this.loadDirectory(null, string2, false);
        }
        if (!(string2.startsWith("favorites") || string2.startsWith("roots") || string.startsWith(string3))) {
            return;
        }
        if (string2.startsWith("roots") && MiscUtilities.isURL(string) && !"file".equals(MiscUtilities.getProtocolOfURL(string))) {
            return;
        }
        this.table.maybeReloadDirectory(string);
    }

    public void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        this.table.propertiesChanged();
        this.splitPane.setBorder(null);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    public VFSDirectoryEntryTable getTable() {
        return this.table;
    }

    public JList getParentDirectoryList() {
        return this.parentDirectories;
    }

    private void showFilePopup(VFSFile[] vFSFileArray, Component component, Point point) {
        this.popup = new BrowserCommandsMenu(this.browser, vFSFileArray);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = BrowserView.this.parentDirectories.getModel().getSize() - 1;
                        BrowserView.this.parentDirectories.setSelectedIndex(n);
                    }
                });
            }
        });
        GenericGUIUtilities.showPopupMenu(this.popup, component, point.x, point.y);
    }

    class ParentDirectoryList
    extends JList {
        ParentDirectoryList() {
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                ActionContext actionContext = VFSBrowser.getActionContext();
                int n = BrowserView.this.parentDirectories.getSelectedIndex();
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        keyEvent.consume();
                        if (n >= BrowserView.this.parentDirectories.getSize().height - 1) break;
                        BrowserView.this.parentDirectories.setSelectedIndex(++n);
                        break;
                    }
                    case 37: {
                        if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                            keyEvent.consume();
                            BrowserView.this.browser.previousDirectory();
                            break;
                        }
                        super.processEvent(keyEvent);
                        break;
                    }
                    case 39: {
                        if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                            keyEvent.consume();
                            BrowserView.this.browser.nextDirectory();
                            break;
                        }
                        super.processEvent(keyEvent);
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if ((keyEvent.getModifiersEx() & 0x40) == 64) {
                            BrowserView.this.browser.focusOnDefaultComponent();
                            break;
                        }
                        BrowserView.this.table.requestFocus();
                        break;
                    }
                    case 38: {
                        keyEvent.consume();
                        if (n <= 0) break;
                        BrowserView.this.parentDirectories.setSelectedIndex(--n);
                        break;
                    }
                    case 8: {
                        keyEvent.consume();
                        EditAction editAction = actionContext.getAction("vfs.browser.up");
                        actionContext.invokeAction(keyEvent, editAction);
                        break;
                    }
                    case 116: {
                        keyEvent.consume();
                        EditAction editAction = actionContext.getAction("vfs.browser.reload");
                        actionContext.invokeAction(keyEvent, editAction);
                        break;
                    }
                    case 10: {
                        Object e;
                        keyEvent.consume();
                        if (n == -1 || !((e = BrowserView.this.parentDirectories.getModel().getElementAt(n)) instanceof VFSFile)) break;
                        VFSFile vFSFile = (VFSFile)e;
                        BrowserView.this.browser.setDirectory(vFSFile.getPath());
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.focusOnFileView();
                    }
                }
            } else if (keyEvent.getID() == 400) {
                if (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown()) {
                    keyEvent.consume();
                    return;
                }
                switch (keyEvent.getKeyChar()) {
                    case '~': {
                        keyEvent.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.setDirectory(System.getProperty("user.home"));
                        break;
                    }
                    case '/': {
                        keyEvent.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.rootDirectory();
                        break;
                    }
                    case '-': {
                        keyEvent.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.setDirectory(BrowserView.this.browser.getView().getBuffer().getDirectory());
                    }
                }
            }
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    private static class LoadingPlaceholder {
        private LoadingPlaceholder() {
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = BrowserView.this.table.rowAtPoint(point);
            int n2 = BrowserView.this.table.columnAtPoint(point);
            if (n == -1) {
                return;
            }
            if (n2 == 0) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(n, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, point.x)) {
                    return;
                }
            }
            if (GenericGUIUtilities.isLeftButton(mouseEvent) && mouseEvent.getClickCount() % 2 == 0) {
                BrowserView.this.browser.filesActivated(mouseEvent.isShiftDown() ? 1 : 0, true);
            } else if (GenericGUIUtilities.isMiddleButton(mouseEvent)) {
                if (mouseEvent.isShiftDown()) {
                    BrowserView.this.table.getSelectionModel().addSelectionInterval(n, n);
                } else {
                    BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
                BrowserView.this.browser.filesActivated(mouseEvent.isShiftDown() ? 1 : 0, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() != BrowserView.this.table) {
                point.x -= BrowserView.this.table.getX();
                point.y -= BrowserView.this.table.getY();
            }
            int n = BrowserView.this.table.rowAtPoint(point);
            int n2 = BrowserView.this.table.columnAtPoint(point);
            if (n2 == 0 && n != -1) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(n, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, point.x)) {
                    BrowserView.this.table.toggleExpanded(n);
                    return;
                }
            }
            if (GenericGUIUtilities.isMiddleButton(mouseEvent)) {
                if (n == -1) {
                    return;
                }
                if (mouseEvent.isShiftDown()) {
                    BrowserView.this.table.getSelectionModel().addSelectionInterval(n, n);
                } else {
                    BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            } else if (GenericGUIUtilities.isPopupTrigger(mouseEvent)) {
                if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                    BrowserView.this.popup.setVisible(false);
                    BrowserView.this.popup = null;
                    return;
                }
                if (n == -1) {
                    BrowserView.this.showFilePopup(null, BrowserView.this.table, mouseEvent.getPoint());
                } else {
                    if (!BrowserView.this.table.getSelectionModel().isSelectedIndex(n)) {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    BrowserView.this.showFilePopup(BrowserView.this.getSelectedFiles(), BrowserView.this.table, mouseEvent.getPoint());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!GenericGUIUtilities.isPopupTrigger(mouseEvent) && BrowserView.this.table.getSelectedRow() != -1) {
                BrowserView.this.browser.filesSelected();
            }
        }
    }

    private class TableKeyListener
    extends KeyAdapter {
        private TableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 525: {
                    if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                        BrowserView.this.popup.setVisible(false);
                        BrowserView.this.popup = null;
                        return;
                    }
                    int n = BrowserView.this.table.getSelectedRow();
                    Point point = new Point(0, n * BrowserView.this.table.getRowHeight());
                    if (n == -1) {
                        BrowserView.this.showFilePopup(null, BrowserView.this.table, point);
                        break;
                    }
                    if (!BrowserView.this.table.getSelectionModel().isSelectedIndex(n)) {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    BrowserView.this.showFilePopup(BrowserView.this.getSelectedFiles(), BrowserView.this.table, point);
                }
            }
        }
    }

    private class ParentMouseHandler
    extends MouseAdapter {
        private ParentMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object e;
            int n = BrowserView.this.parentDirectories.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && (e = BrowserView.this.parentDirectories.getModel().getElementAt(n)) instanceof VFSFile) {
                VFSFile vFSFile = (VFSFile)e;
                if (GenericGUIUtilities.isPopupTrigger(mouseEvent)) {
                    if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                        BrowserView.this.popup.setVisible(false);
                        BrowserView.this.popup = null;
                    } else {
                        BrowserView.this.parentDirectories.setSelectedIndex(n);
                        BrowserView.this.showFilePopup(new VFSFile[]{vFSFile}, BrowserView.this.parentDirectories, mouseEvent.getPoint());
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() % 2 != 0 && !GenericGUIUtilities.isMiddleButton(mouseEvent)) {
                return;
            }
            int n = BrowserView.this.parentDirectories.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && (e = BrowserView.this.parentDirectories.getModel().getElementAt(n)) instanceof VFSFile) {
                VFSFile vFSFile = (VFSFile)e;
                if (!GenericGUIUtilities.isPopupTrigger(mouseEvent)) {
                    BrowserView.this.browser.setDirectory(vFSFile.getPath());
                    if (BrowserView.this.browser.getMode() == 2) {
                        BrowserView.this.focusOnFileView();
                    }
                }
            }
        }
    }

    class ParentDirectoryRenderer
    extends DefaultListCellRenderer {
        private Font plainFont = UIManager.getFont("Tree.font");
        private final Font boldFont;

        ParentDirectoryRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setBorder(new EmptyBorder(1, n * 5 + 1, 1, 1));
            if (object instanceof LoadingPlaceholder) {
                this.setFont(this.plainFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.loadingIcon : null);
                this.setText(jEdit.getProperty("vfs.browser.tree.loading"));
            } else if (object instanceof VFSFile) {
                VFSFile vFSFile = (VFSFile)object;
                this.setFont(this.boldFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.getIconForFile(vFSFile, true) : null);
                this.setText(vFSFile.getName());
            } else if (object == null) {
                this.setText("VFS does not follow VFS API");
            }
            return this;
        }
    }
}

