/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Token;

public class ParseException
extends EvalError {
    String sourceFile = "<unknown>";
    protected boolean specialConstructor = false;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public void setErrorSourceFile(String string) {
        this.sourceFile = string;
    }

    @Override
    public String getErrorSourceFile() {
        return this.sourceFile;
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        this();
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this("");
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string, null, null);
    }

    @Override
    public String getMessage() {
        return this.getMessage(false);
    }

    public String getMessage(boolean bl) {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        Object object = "";
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n < this.expectedTokenSequences[i].length) {
                n = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                object = (String)object + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                object = (String)object + "...";
            }
            object = (String)object + this.eol + "    ";
        }
        String string = "In file: " + this.sourceFile + " Encountered \"";
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
        }
        string = string + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn + "." + this.eol;
        if (bl) {
            string = this.expectedTokenSequences.length == 1 ? string + "Was expecting:" + this.eol + "    " : string + "Was expecting one of:" + this.eol + "    ";
            string = string + (String)object;
        }
        return string;
    }

    protected String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getErrorLineNumber() {
        return this.currentToken.next.beginLine;
    }

    @Override
    public String getErrorText() {
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n >= this.expectedTokenSequences[i].length) continue;
            n = this.expectedTokenSequences[i].length;
        }
        Object object = "";
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                object = (String)object + " ";
            }
            if (token.kind == 0) {
                object = (String)object + this.tokenImage[0];
                break;
            }
            object = (String)object + this.add_escapes(token.image);
            token = token.next;
        }
        return object;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

