/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.CachePluginList;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.RemotePluginList;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.io.HttpException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class PluginList
extends Task {
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private String id;
    private final Runnable dispatchThreadTask;

    PluginList(Runnable runnable) {
        this.dispatchThreadTask = runnable;
    }

    @Override
    public void _run() {
        this.id = jEdit.getProperty("plugin-manager.mirror.id");
        CachePluginList cachePluginList = new CachePluginList(this.id);
        RemotePluginList remotePluginList = new RemotePluginList(this, this.id);
        this.setStatus(jEdit.getProperty("plugin-manager.list-download-connect"));
        try {
            String string = cachePluginList.getPluginList();
            if (string != null) {
                try {
                    this.loadPluginList(string);
                }
                catch (IOException | ParserConfigurationException | SAXException exception) {
                    cachePluginList.deleteCache();
                    String string2 = remotePluginList.getPluginList();
                    this.loadPluginList(string2);
                    cachePluginList.saveCache(string2);
                }
            } else {
                String string3 = remotePluginList.getPluginList();
                this.loadPluginList(string3);
                cachePluginList.saveCache(string3);
            }
        }
        catch (HttpException httpException) {
            int n = httpException.getResponseCode();
            if (n == 407) {
                Log.log(9, this, "CacheRemotePluginList: proxy requires authentication");
                ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.need-password", new Object[0]));
            } else {
                String string = httpException.getMessage();
                Log.log(9, this, "CacheRemotePluginList: HTTP error: " + n + " " + string);
                ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.generic-error", new Object[]{n, string}));
            }
        }
        catch (Exception exception) {
            Log.log(9, this, "CacheRemotePluginList: error", exception);
            ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.disconnected", new Object[]{exception.getMessage()}));
        }
        ThreadUtilities.runInDispatchThread(this.dispatchThreadTask);
    }

    private void loadPluginList(String string) throws IOException, SAXException, ParserConfigurationException {
        PluginListHandler pluginListHandler = new PluginListHandler(this);
        XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        InputSource inputSource = new InputSource(new StringReader(string));
        inputSource.setSystemId("jedit.jar");
        xMLReader.setContentHandler(pluginListHandler);
        xMLReader.setDTDHandler(pluginListHandler);
        xMLReader.setEntityResolver(pluginListHandler);
        xMLReader.setErrorHandler(pluginListHandler);
        xMLReader.parse(inputSource);
    }

    void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet pluginSet) {
        this.pluginSets.add(pluginSet);
    }

    void finished() {
        for (Plugin plugin : this.plugins) {
            for (int i = 0; i < plugin.branches.size(); ++i) {
                Branch branch = plugin.branches.get(i);
                for (int j = 0; j < branch.deps.size(); ++j) {
                    Dependency dependency = branch.deps.get(j);
                    if (!dependency.what.equals("plugin")) continue;
                    dependency.plugin = this.pluginHash.get(dependency.pluginName);
                }
            }
        }
    }

    void dump() {
        for (Plugin plugin : this.plugins) {
            System.err.println(plugin);
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    private static String getAutoSelectedMirror() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("http://sourceforge.net/projects/jedit/files/latest/download").openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        int n = httpURLConnection.getResponseCode();
        if (n != 302) {
            throw new RuntimeException("Unexpected response: " + n + ": from http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String string = httpURLConnection.getHeaderField("Location");
        if (string == null) {
            throw new RuntimeException("Missing Location header: http://sourceforge.net/projects/jedit/files/latest/download");
        }
        int n2 = string.lastIndexOf("use_mirror=");
        if (n2 == -1) {
            throw new RuntimeException("Mirror prefix \"use_mirror\" was not found in redirected URL: " + string);
        }
        int n3 = n2 + "use_mirror=".length();
        int n4 = string.indexOf(38, n3);
        return n4 != -1 ? string.substring(n3, n4) : string.substring(n3);
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String string, String string2, String string3, String string4) {
            this.what = string;
            this.from = string2;
            this.to = string3;
            this.pluginName = string4;
        }

        boolean isSatisfied() {
            switch (this.what) {
                case "plugin": {
                    return this.isSatisfiedByPlugin();
                }
                case "jdk": {
                    return this.isSatisfiedByJdk();
                }
                case "jedit": {
                    return this.isSatisfiedByJEdit();
                }
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        private boolean isSatisfiedByJEdit() {
            String string = jEdit.getBuild();
            return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
        }

        private boolean isSatisfiedByJdk() {
            String string = System.getProperty("java.version");
            string = string.length() >= 3 ? string.substring(0, 3) : string;
            return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
        }

        private boolean isSatisfiedByPlugin() {
            for (int i = 0; i < this.plugin.branches.size(); ++i) {
                String string = this.plugin.getInstalledVersion();
                if (string == null || this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0) continue;
                return true;
            }
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String string, boolean bl) {
            if ("plugin".equals(this.what)) {
                String string2 = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (string2 != null && StandardUtilities.compareStrings(string2, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, string, bl, false);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + "]";
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (Dependency dependency : this.deps) {
                if (dependency.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String string, boolean bl) {
            this.deps.forEach(dependency -> dependency.satisfy(roster, string, bl));
        }

        public String depsToString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Dependency dependency : this.deps) {
                if (!"plugin".equals(dependency.what) || dependency.pluginName == null) continue;
                stringBuilder.append(dependency.pluginName).append('\n');
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + "]";
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();
        String installedVersion = null;
        String installedPath = null;
        boolean loaded = false;

        String getInstalledVersion() {
            String[] stringArray;
            this.loaded = false;
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String object = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(object).equals(this.jar)) continue;
                EditPlugin editPlugin = pluginJARArray[i].getPlugin();
                if (editPlugin != null) {
                    this.installedVersion = jEdit.getProperty("plugin." + editPlugin.getClassName() + ".version");
                    this.loaded = true;
                    return this.installedVersion;
                }
                return null;
            }
            for (String string : stringArray = jEdit.getNotLoadedPluginJARs()) {
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                try {
                    PluginJAR.PluginCacheEntry iOException = PluginJAR.getPluginCacheEntry(string);
                    if (iOException == null) continue;
                    String string2 = "plugin." + iOException.pluginClass + ".version";
                    this.installedVersion = iOException.cachedProperties.getProperty(string2);
                    Log.log(1, PluginList.class, "found installed but not loaded " + this.jar + " version=" + this.installedVersion);
                    this.installedPath = string;
                    return this.installedVersion;
                }
                catch (IOException iOException) {
                    Log.log(7, "Unable to access cache for " + this.jar, iOException);
                }
            }
            return null;
        }

        String getInstalledPath() {
            if (this.installedPath != null) {
                if (new File(this.installedPath).exists()) {
                    return this.installedPath;
                }
                this.installedPath = null;
            }
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                return string;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (Branch branch : this.branches) {
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String string, boolean bl, boolean bl2) {
            String string2 = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (string2 != null) {
                    roster.addRemove(string2);
                }
                return;
            }
            if (this.installedVersion != null && this.installedPath != null && !this.loaded && bl2) {
                roster.addLoad(this.installedPath);
                return;
            }
            if (string2 != null) {
                string = MiscUtilities.getParentOfPath(string2);
            }
            roster.addInstall(string2, bl ? branch.downloadSource : branch.download, string, bl ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

