/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeHeaderWeekly
extends TimeHeader {
    private final LoadPlanable defaultPlan;
    private final Map<Day, HColor> colorDays;
    private final Map<DayOfWeek, HColor> colorDaysOfWeek;

    @Override
    protected double getTimeHeaderHeight() {
        return 29.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 16.0;
    }

    public TimeHeaderWeekly(Day calendar, Day min, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, Map<Day, String> nameDays) {
        super(min, max, new TimeScaleCompressed(calendar, PrintScale.WEEKLY.getCompress()));
        this.defaultPlan = defaultPlan;
        this.colorDays = colorDays;
        this.colorDaysOfWeek = colorDaysOfWeek;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawCalendar(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.Y_POS_ROW16());
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawHline(ug, 0.0);
        this.printMonths(ug);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawCalendar(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTexts(ug, totalHeightWithoutFooter);
        this.printDaysOfMonth(ug);
        this.printSmallVbars(ug, totalHeightWithoutFooter);
        this.printMonths(ug);
    }

    private void drawTexts(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight();
        Day firstDay = null;
        HColor lastColor = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            HColor back = this.colorDays.get(wink);
            HColor backDoW = this.colorDaysOfWeek.get((Object)wink.getDayOfWeek());
            if (backDoW != null) {
                back = backDoW;
            }
            if (back == null && this.defaultPlan.getLoadAt(wink) == 0) {
                back = this.veryLightGray;
            }
            if (back == null) {
                if (lastColor != null) {
                    this.drawBack(ug.apply(lastColor.bg()), firstDay, wink, height);
                }
                firstDay = null;
                lastColor = null;
            } else {
                assert (back != null);
                if (lastColor != null && !lastColor.equals(back)) {
                    this.drawBack(ug.apply(lastColor.bg()), firstDay, wink, height);
                }
                if (firstDay == null) {
                    firstDay = wink;
                }
                lastColor = back;
            }
            wink = wink.increment();
        }
    }

    private void drawBack(UGraphic ug, Day start, Day end, double height) {
        double x1 = this.getTimeScale().getStartingPosition(start);
        double x2 = this.getTimeScale().getStartingPosition(end);
        this.drawRectangle(ug, height, x1, x2);
    }

    private void printMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVbar(ug, x1, 0.0, this.Y_POS_ROW16());
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, this.Y_POS_ROW16());
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printSmallVbars(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            if (wink.getDayOfWeek() == DayOfWeek.MONDAY) {
                this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), this.Y_POS_ROW16(), totalHeightWithoutFooter);
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), this.Y_POS_ROW16(), totalHeightWithoutFooter);
    }

    private void printDaysOfMonth(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            if (wink.getDayOfWeek() == DayOfWeek.MONDAY) {
                this.printLeft(ug.apply(UTranslate.dy(this.Y_POS_ROW16())), this.getTextBlock("" + wink.getDayOfMonth(), 10, false, HColorUtils.BLACK), this.getTimeScale().getStartingPosition(wink) + 5.0);
            }
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(monthYear.shortName(), 12, true, HColorUtils.BLACK);
        TextBlock big = this.getTextBlock(monthYear.shortNameYYYY(), 12, true, HColorUtils.BLACK);
        this.printCentered(ug, start, end, small, big);
    }

    private void drawVbar(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(HColorUtils.LIGHT_GRAY).apply(new UTranslate(x, y1)).draw(vbar);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

