/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.media.j3d.Utils;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;

public final class PickCylinderSegment
extends PickCylinder {
    Point3d end;

    public PickCylinderSegment() {
        this.end = new Point3d();
    }

    public PickCylinderSegment(Point3d point3d, Point3d point3d2, double d) {
        this.origin = new Point3d(point3d);
        this.end = new Point3d(point3d2);
        this.radius = d;
        this.calcDirection();
    }

    public void set(Point3d point3d, Point3d point3d2, double d) {
        this.origin.set((Tuple3d)point3d);
        this.end.set((Tuple3d)point3d2);
        this.radius = d;
        this.calcDirection();
    }

    private void calcDirection() {
        this.direction.x = this.end.x - this.origin.x;
        this.direction.y = this.end.y - this.origin.y;
        this.direction.z = this.end.z - this.origin.z;
    }

    public void getEnd(Point3d point3d) {
        point3d.set((Tuple3d)this.end);
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d = ((BoundingSphere)bounds).getCenter();
            double d = ((BoundingSphere)bounds).getRadius();
            double d2 = Utils.ptToSegSquare(point3d, this.origin, this.end, null);
            return d2 <= (d + this.radius) * (d + this.radius);
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d = new Point3d();
            ((BoundingBox)bounds).getLower(point3d);
            Point3d point3d2 = ((BoundingBox)bounds).getCenter();
            double d = point3d2.x - point3d.x + this.radius;
            double d3 = d * d;
            d = point3d2.y - point3d.y + this.radius;
            d3 += d * d;
            d = point3d2.z - point3d.z + this.radius;
            d3 += d * d;
            double d4 = Utils.ptToSegSquare(point3d2, this.origin, this.end, null);
            if (d4 > d3) {
                return false;
            }
            if (d4 < this.radius * this.radius) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.end, point4d2)) {
                return true;
            }
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d3);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d3, new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d3.z), new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d.y, point3d3.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d3.z), point3d3}, {point3d, new Point3d(point3d.x, point3d3.y, point3d.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), point3d}, {point3d, new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}};
            for (int i = 0; i < point3dArrayArray.length; ++i) {
                double d5 = Utils.segmentToSegment(this.origin, this.end, point3dArrayArray[i][0], point3dArrayArray[i][1], null, null, null);
                if (!(d5 <= this.radius * this.radius)) continue;
                return true;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d);
            double d = boundingSphere.getRadius();
            double d6 = Utils.ptToSegSquare(point3d, this.origin, this.end, null);
            if (d6 > (d + this.radius) * (d + this.radius)) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d4 = new Point3d();
            for (int i = 0; i < boundingPolytope.nVerts; ++i) {
                int n = i;
                while (i < boundingPolytope.nVerts) {
                    double d7;
                    point3d4.x = (boundingPolytope.verts[i].x + boundingPolytope.verts[n].x) * 0.5;
                    point3d4.y = (boundingPolytope.verts[i].y + boundingPolytope.verts[n].y) * 0.5;
                    point3d4.z = (boundingPolytope.verts[i].z + boundingPolytope.verts[n].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d4.x, point3d4.y, point3d4.z) && (d7 = Utils.segmentToSegment(this.origin, this.end, boundingPolytope.verts[i], boundingPolytope.verts[n], null, null, null)) <= this.radius * this.radius) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    PickShape transform(Transform3D transform3D) {
        PickCylinderSegment pickCylinderSegment = new PickCylinderSegment();
        pickCylinderSegment.origin.x = this.origin.x;
        pickCylinderSegment.origin.y = this.origin.y;
        pickCylinderSegment.origin.z = this.origin.z;
        pickCylinderSegment.radius = this.radius * transform3D.getScale();
        pickCylinderSegment.end.x = this.end.x;
        pickCylinderSegment.end.y = this.end.y;
        pickCylinderSegment.end.z = this.end.z;
        transform3D.transform(pickCylinderSegment.origin);
        transform3D.transform(pickCylinderSegment.end);
        pickCylinderSegment.direction.x = pickCylinderSegment.end.x - pickCylinderSegment.origin.x;
        pickCylinderSegment.direction.y = pickCylinderSegment.end.y - pickCylinderSegment.origin.y;
        pickCylinderSegment.direction.z = pickCylinderSegment.end.z - pickCylinderSegment.origin.z;
        pickCylinderSegment.direction.normalize();
        return pickCylinderSegment;
    }
}

